from django.contrib import admin
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from models import News

_('News')

class NewsAdmin(admin.ModelAdmin):
    list_display = ('preview', 'title', 'pub_date')
    list_display_links = list_display

if 'tinymce' in settings.INSTALLED_APPS:
    from django.db import models
    from tinymce.widgets import TinyMCE
    NewsAdmin.formfield_overrides = {
        models.TextField: {'widget': TinyMCE()}
    }

admin.site.register(News, NewsAdmin)
