from django.db import models
from datetime import datetime
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from djlime.utils import get_file_path
from imagekit.models import ImageSpecField
from imagekit.processors.resize import ResizeToFill

NEWS_IMAGES_DIR = \
getattr(settings, 'NEWS_IMAGES_DIR', 'news/images')
NEWS_THUMBNAIL_SIZE = \
getattr(settings, 'NEWS_THUMBNAIL_SIZE', (140, 140))
NEWS_SIDEBAR_THUMBNAIL_SIZE = \
getattr(settings, 'NEWS_SIDEBAR_THUMBNAIL_SIZE', (66, 66))
NEWS_ADMIN_THUMBNAIL_SIZE = \
getattr(settings, 'NEWS_ADMIN_THUMBNAIL_SIZE', (60, 60))
NEWS_THUMBNAIL_FORMAT = \
getattr(settings, 'NEWS_THUMBNAIL_FORMAT', 'PNG')

class News(models.Model):
    title = models.CharField(_('title'), max_length=255)
    pub_date = models.DateTimeField(_('date of publication'),
        default=datetime.now)
    image = models.ImageField(_('image'), upload_to=get_file_path)
    description = models.TextField(_('description'))
    content = models.TextField(_('content'))

    thumbnail = ImageSpecField(
        [ResizeToFill(*NEWS_THUMBNAIL_SIZE)],
        image_field='image',
        format=NEWS_THUMBNAIL_FORMAT,
        options={'quality': 100}
    )

    sidebar_thumbnail = ImageSpecField(
        [ResizeToFill(*NEWS_SIDEBAR_THUMBNAIL_SIZE)],
        image_field='image',
        format=NEWS_THUMBNAIL_FORMAT,
        options={'quality': 100}
    )

    admin_thumbnail = ImageSpecField(
        [ResizeToFill(*NEWS_ADMIN_THUMBNAIL_SIZE)],
        image_field='image',
        format=NEWS_THUMBNAIL_FORMAT,
        options={'quality': 100}
    )

    class Meta:
        ordering = ('-pub_date',)
        db_table = 'news'
        verbose_name = _('news')
        verbose_name_plural = _('news')

    @property
    def upload_dir(self):
        return NEWS_IMAGES_DIR

    def __unicode__(self):
        return self.title

    def preview(self):
        print self.admin_thumbnail.url
        return '<img src="%s">' % self.admin_thumbnail.url

    preview.short_description = (_('preview'))
    preview.allow_tags = True
