from django.conf import settings
from  django.shortcuts import render, get_object_or_404

from djlime.utils.pagination import paginator_factory

from models import News

NEWS_LIST_TEMPLATE = \
getattr(settings, 'NEWS_LIST_TEMPLATE', 'news/news_list.html')
NEWS_DETAIL_TEMPLATE = \
getattr(settings, 'NEWS_DETAIL_TEMPLATE', 'news/news_detail.html')
NEWS_PER_PAGE = \
getattr(settings, 'NEWS_PER_PAGE', 4)

def news_list(request):
    news_objects = paginator_factory(request, News.objects.all(), NEWS_PER_PAGE)
    return render(request, NEWS_LIST_TEMPLATE, {'news_list': news_objects})

def news_detail(request, news_id):
    news = get_object_or_404(News, id=news_id)
    return render(request, NEWS_DETAIL_TEMPLATE, {'news': news})
