from django.conf import settings
from django.template import Library

from banners.models import Banner
from banners import LOCATION_HEADER, LOCATION_CONTENT, LOCATION_SIDEBAR

register = Library()

BANNER_HEADER_TEMPLATE = \
getattr(settings, 'BANNER_HEADER_TEMPLATE', 'banners/includes/single_banner.html')

BANNER_CONTENT_TEMPLATE = \
getattr(settings, 'BANNER_CONTENT_TEMPLATE', 'banners/includes/single_banner.html')

BANNER_SIDEBAR_TEMPLATE = \
getattr(settings, 'BANNER_SIDEBAR_TEMPLATE', 'banners/includes/banners_block.html')

BANNER_COUNT_PER_SIDEBAR = getattr(settings, 'BANNER_COUNT_PER_SIDEBAR', False)


@register.inclusion_tag(BANNER_HEADER_TEMPLATE)
def include_header_banner():
    try:
        banner = Banner.objects.filter(location=LOCATION_HEADER).order_by('?')[0]
    except IndexError:
        banner = None

    return {'banner': banner}

@register.inclusion_tag(BANNER_HEADER_TEMPLATE)
def include_content_banner():
    try:
        banner = Banner.objects.filter(location=LOCATION_CONTENT).order_by('?')[0]
    except IndexError:
        banner = None

    return {'banner': banner}

@register.inclusion_tag(BANNER_SIDEBAR_TEMPLATE)
def include_sidebar_banners():
    banners = Banner.objects.filter(location=LOCATION_SIDEBAR)

    if BANNER_COUNT_PER_SIDEBAR:
        banners = banners[:int(BANNER_COUNT_PER_SIDEBAR)]

    return {'banners': banners}
