/** @license Hyphenator X.Y.Z - client side hyphenation for webbrowsers
 *  Copyright (C) 2010  Mathias Nater, Zürich (mathias at mnn dot ch)
 *  Project and Source hosted on http://code.google.com/p/hyphenator/
 * 
 *  This JavaScript code is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU Lesser
 *  General Public License (GNU LGPL) as published by the Free Software
 *  Foundation, either version 3 of the License, or (at your option)
 *  any later version.  The code is distributed WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.
 *
 *  As additional permission under GNU GPL version 3 section 7, you
 *  may distribute non-source (e.g., minimized or compacted) forms of
 *  that code without the copy of the GNU GPL normally required by
 *  section 4, provided you include this license notice and a URL
 *  through which recipients can access the Corresponding Source.
 *
 * 
 *  Hyphenator.js contains code from Bram Steins hypher.js-Project:
 *  https://github.com/bramstein/Hypher
 *  
 *  Code from this project is marked in the source and belongs 
 *  to the following license:
 *  
 *  Copyright (c) 2011, Bram Stein
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *   
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer. 
 *   2. Redistributions in binary form must reproduce the above copyright 
 *      notice, this list of conditions and the following disclaimer in the 
 *      documentation and/or other materials provided with the distribution. 
 *   3. The name of the author may not be used to endorse or promote products 
 *      derived from this software without specific prior written permission. 
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO 
 *  EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 *  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 *  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 *//* 
 *  Comments are jsdoctoolkit formatted. See http://code.google.com/p/jsdoc-toolkit/
 *//* The following comment is for JSLint: *//*global window, ActiveXObject, unescape *//*jslint plusplus: true, white: true, browser: true, onevar: true, undef: true, nomen: true, eqeqeq: false, regexp: true, sub: true, newcap: true, immed: true, evil: true, eqeqeq: false *//**
 * @constructor
 * @description Provides all functionality to do hyphenation, except the patterns that are loaded
 * externally.
 * @author Mathias Nater, <a href = "mailto:mathias@mnn.ch">mathias@mnn.ch</a>
 * @version X.Y.Z
 * @namespace Holds all methods and properties
 * @example
 * &lt;script src = "Hyphenator.js" type = "text/javascript"&gt;&lt;/script&gt;
 * &lt;script type = "text/javascript"&gt;
 *   Hyphenator.run();
 * &lt;/script&gt;
 */var Hyphenator=function(e){"use strict";var t=function(){var e={},t=function(t,n,r,i){e[t]={file:n,script:r,prompt:i}};return t("be","be.js",1,"Мова гэтага сайта не можа быць вызначаны аўтаматычна. Калі ласка пакажыце мову:"),t("ca","ca.js",0,""),t("cs","cs.js",0,"Jazyk této internetové stránky nebyl automaticky rozpoznán. Určete prosím její jazyk:"),t("da","da.js",0,"Denne websides sprog kunne ikke bestemmes. Angiv venligst sprog:"),t("bn","bn.js",4,""),t("de","de.js",0,"Die Sprache dieser Webseite konnte nicht automatisch bestimmt werden. Bitte Sprache angeben:"),t("el","el-monoton.js",6,""),t("el-monoton","el-monoton.js",6,""),t("el-polyton","el-polyton.js",6,""),t("en","en-us.js",0,"The language of this website could not be determined automatically. Please indicate the main language:"),t("en-gb","en-gb.js",0,"The language of this website could not be determined automatically. Please indicate the main language:"),t("en-us","en-us.js",0,"The language of this website could not be determined automatically. Please indicate the main language:"),t("eo","eo.js",0,"La lingvo de ĉi tiu retpaĝo ne rekoneblas aŭtomate. Bonvolu indiki ĝian ĉeflingvon:"),t("es","es.js",0,"El idioma del sitio no pudo determinarse autom%E1ticamente. Por favor, indique el idioma principal:"),t("et","et.js",0,"Veebilehe keele tuvastamine ebaõnnestus, palun valige kasutatud keel:"),t("fi","fi.js",0,"Sivun kielt%E4 ei tunnistettu automaattisesti. M%E4%E4rit%E4 sivun p%E4%E4kieli:"),t("fr","fr.js",0,"La langue de ce site n%u2019a pas pu %EAtre d%E9termin%E9e automatiquement. Veuillez indiquer une langue, s.v.p.%A0:"),t("grc","grc.js",6,""),t("gu","gu.js",7,""),t("hi","hi.js",5,""),t("hu","hu.js",0,"A weboldal nyelvét nem sikerült automatikusan megállapítani. Kérem adja meg a nyelvet:"),t("hy","hy.js",3,"Չհաջողվեց հայտնաբերել այս կայքի լեզուն։ Խնդրում ենք նշեք հիմնական լեզուն՝"),t("it","it.js",0,"Lingua del sito sconosciuta. Indicare una lingua, per favore:"),t("kn","kn.js",8,"ಜಾಲ ತಾಣದ ಭಾಷೆಯನ್ನು ನಿರ್ಧರಿಸಲು ಸಾಧ್ಯವಾಗುತ್ತಿಲ್ಲ. ದಯವಿಟ್ಟು ಮುಖ್ಯ ಭಾಷೆಯನ್ನು ಸೂಚಿಸಿ:"),t("la","la.js",0,""),t("lt","lt.js",0,"Nepavyko automatiškai nustatyti šios svetainės kalbos. Prašome įvesti kalbą:"),t("lv","lv.js",0,"Šīs lapas valodu nevarēja noteikt automātiski. Lūdzu norādiet pamata valodu:"),t("ml","ml.js",10,"ഈ വെ%u0D2C%u0D4D%u200Cസൈറ്റിന്റെ ഭാഷ കണ്ടുപിടിയ്ക്കാ%u0D28%u0D4D%u200D കഴിഞ്ഞില്ല. ഭാഷ ഏതാണെന്നു തിരഞ്ഞെടുക്കുക:"),t("nb","nb-no.js",0,"Nettstedets språk kunne ikke finnes automatisk. Vennligst oppgi språk:"),t("no","nb-no.js",0,"Nettstedets språk kunne ikke finnes automatisk. Vennligst oppgi språk:"),t("nb-no","nb-no.js",0,"Nettstedets språk kunne ikke finnes automatisk. Vennligst oppgi språk:"),t("nl","nl.js",0,"De taal van deze website kan niet automatisch worden bepaald. Geef de hoofdtaal op:"),t("or","or.js",11,""),t("pa","pa.js",13,""),t("pl","pl.js",0,""),t("pt","pt.js",0,"A língua deste site não pôde ser determinada automaticamente. Por favor indique a língua principal:"),t("ru","ru.js",1,"Язык этого сайта не может быть определен автоматически. Пожалуйста укажите язык:"),t("sk","sk.js",0,""),t("sl","sl.js",0,"Jezika te spletne strani ni bilo mogoče samodejno določiti. Prosim navedite jezik:"),t("sr-latn","sr-latn.js",0,"Jezika te spletne strani ni bilo mogoče samodejno določiti. Prosim navedite jezik:"),t("sv","sv.js",0,"Spr%E5ket p%E5 den h%E4r webbplatsen kunde inte avg%F6ras automatiskt. V%E4nligen ange:"),t("ta","ta.js",14,""),t("te","te.js",15,""),t("tr","tr.js",0,"Bu web sitesinin dili otomatik olarak tespit edilememiştir. Lütfen dökümanın dilini seçiniz%A0:"),t("uk","uk.js",1,"Мова цього веб-сайту не може бути визначена автоматично. Будь ласка, вкажіть головну мову:"),e}(),n=function(){var e,n="";for(e in t)t.hasOwnProperty(e)&&(n+=e+", ");return n=n.substring(0,n.length-2),n}(),r=function(){var e=document.getElementsByTagName("script"),t=0,n,r,i;while(!!(i=e[t++]))if(!!i.src){r=i.src,n=r.indexOf("Hyphenator.js");if(n!==-1)return r.substring(0,n)}return"http://hyphenator.googlecode.com/svn/trunk/"}(),i=function(){var t=!1;return e.location.href.indexOf(r)!==-1&&(t=!0),t}(),s=!1,o=0,u=!1,a=e,f=!1,l={script:!0,code:!0,pre:!0,img:!0,br:!0,samp:!0,kbd:!0,"var":!0,abbr:!0,acronym:!0,sub:!0,sup:!0,button:!0,option:!0,label:!0,textarea:!0,input:!0,math:!0,svg:!0},c=!0,h="local",p,d=!1,v=!0,m=!1,g=function(t){e.alert("Hyphenator.js says:\n\nAn Error occurred:\n"+t.message)},y=function(e,t){t=t||a;if(document.createElementNS)return t.document.createElementNS("http://www.w3.org/1999/xhtml",e);if(document.createElement)return t.document.createElement(e)},b=!1,w,E=function(){var n,r=navigator.userAgent,i=function(n){var r=["abcdefghijklmnopqrstuvwxyz","абвгдеёжзийклмнопрстуфхцчшщъыьэюя","أبتثجحخدذرزسشصضطظعغفقكلمنهوي","աբգդեզէըթժիլխծկհձղճմյնշոչպջռսվտրցւփքօֆ","ঁংঃঅআইঈউঊঋঌএঐওঔকখগঘঙচছজঝঞটঠডঢণতথদধনপফবভমযরলশষসহ়ঽািীুূৃৄেৈোৌ্ৎৗড়ঢ়য়ৠৡৢৣ","ँंःअआइईउऊऋऌएऐओऔकखगघङचछजझञटठडढणतथदधनपफबभमयरलळवशषसहऽािीुूृॄेैोौ्॒॑ॠॡॢॣ","αβγδεζηθικλμνξοπρσςτυφχψω","બહઅઆઇઈઉઊઋૠએઐઓઔાિીુૂૃૄૢૣેૈોૌકખગઘઙચછજઝઞટઠડઢણતથદધનપફસભમયરલળવશષ","ಂಃಅಆಇಈಉಊಋಌಎಏಐಒಓಔಕಖಗಘಙಚಛಜಝಞಟಠಡಢಣತಥದಧನಪಫಬಭಮಯರಱಲಳವಶಷಸಹಽಾಿೀುೂೃೄೆೇೈೊೋೌ್ೕೖೞೠೡ","ກຂຄງຈຊຍດຕຖທນບປຜຝພຟມຢຣລວສຫອຮະັາິີຶືຸູົຼເແໂໃໄ່້໊໋ໜໝ","ംഃഅആഇഈഉഊഋഌഎഏഐഒഓഔകഖഗഘങചഛജഝഞടഠഡഢണതഥദധനപഫബഭമയരറലളഴവശഷസഹാിീുൂൃെേൈൊോൌ്ൗൠൡൺൻർൽൾൿ","ଁଂଃଅଆଇଈଉଊଋଌଏଐଓଔକଖଗଘଙଚଛଜଝଞଟଠଡଢଣତଥଦଧନପଫବଭମଯରଲଳଵଶଷସହାିୀୁୂୃେୈୋୌ୍ୗୠୡ","أبتثجحخدذرزسشصضطظعغفقكلمنهوي","ਁਂਃਅਆਇਈਉਊਏਐਓਔਕਖਗਘਙਚਛਜਝਞਟਠਡਢਣਤਥਦਧਨਪਫਬਭਮਯਰਲਲ਼ਵਸ਼ਸਹਾਿੀੁੂੇੈੋੌ੍ੰੱ","ஃஅஆஇஈஉஊஎஏஐஒஓஔகஙசஜஞடணதநனபமயரறலளழவஷஸஹாிீுூெேைொோௌ்ௗ","ఁంఃఅఆఇఈఉఊఋఌఎఏఐఒఓఔకఖగఘఙచఛజఝఞటఠడఢణతథదధనపఫబభమయరఱలళవశషసహాిీుూృౄెేైొోౌ్ౕౖౠౡ"],i=function(i){var s,o,u=e.document.getElementsByTagName("body")[0];return s=y("div",e),s.id="Hyphenator_LanguageChecker",s.style.width="5em",s.style[n]="auto",s.style.hyphens="auto",s.style.fontSize="12px",s.style.lineHeight="12px",s.style.visibility="hidden",t.hasOwnProperty(i)?(s.lang=i,s.style["-webkit-locale"]="'"+i+"'",s.innerHTML=r[t[i].script],u.appendChild(s),o=s.offsetHeight,u.removeChild(s),o>12?!0:!1):!1};return i},s={support:!1,property:"",checkLangSupport:function(){}};if(!e.getComputedStyle){w=s;return}n=a.getComputedStyle(a.document.getElementsByTagName("body")[0],null),n["-webkit-hyphens"]!==undefined?(s.support=!0,s.property="-webkit-hyphens",s.checkLangSupport=i("-webkit-hyphens")):n.MozHyphens!==undefined?(s.support=!0,s.property="MozHyphens",s.checkLangSupport=i("MozHyphens")):n["-ms-hyphens"]!==undefined&&(s.support=!0,s.property="-ms-hyphens",s.checkLangSupport=i("-ms-hyphens")),w=s},S="hyphenate",x="donthyphenate",T=6,N=1,C=function(){var e=null,t=!1,n=document.getElementsByTagName("script"),r,i;for(r=0,i=n.length;r<i;r++)!n[r].getAttribute("src")||(e=n[r].getAttribute("src")),!!e&&e.indexOf("Hyphenator.js?bm=true")!==-1&&(t=!0);return t}(),k=null,L="",A=function(){var e=function(e,t){this.element=e,this.hyphenated=!1,this.treated=!1,this.data=t},t=function(){this.count=0,this.hyCount=0,this.list={}};return t.prototype={add:function(t,n,r){this.list.hasOwnProperty(n)||(this.list[n]=[]),this.list[n].push(new e(t,r)),this.count+=1},each:function(e){var t;for(t in this.list)this.list.hasOwnProperty(t)&&e(t,this.list[t])}},new t}(),O={},M={},_=0,D="(\\w*://)?((\\w*:)?(\\w*)@)?((([\\d]{1,3}\\.){3}([\\d]{1,3}))|((www\\.|[a-zA-Z]\\.)?[a-zA-Z0-9\\-\\.]+\\.([a-z]{2,4})))(:\\d*)?(/[\\w#!:\\.?\\+=&%@!\\-]*)*",P="[\\w-\\.]+@[\\w\\.]+",H=new RegExp("("+D+")|("+P+")","i"),B=function(){var e,t=navigator.userAgent.toLowerCase();return e=String.fromCharCode(8203),t.indexOf("msie 6")!==-1&&(e=""),t.indexOf("opera")!==-1&&t.indexOf("version/10.00")!==-1&&(e=""),e}(),j=function(){},F=function(){var e,t=[],n,r;if(document.getElementsByClassName)t=a.document.getElementsByClassName(S);else if(document.querySelectorAll)t=a.document.querySelectorAll("."+S);else{e=a.document.getElementsByTagName("*"),r=e.length;for(n=0;n<r;n++)e[n].className.indexOf(S)!==-1&&e[n].className.indexOf(x)===-1&&t.push(e[n])}return t},I="hidden",q="wait",R=[],U=function(t){t=t||e;var n=t.document,r=n.styleSheets[n.styleSheets.length-1],i=[],s=function(t){var n,r,i=e.document.styleSheets,s,o,u;for(o=0;o<i.length;o++){n=i[o],n.cssRules?s=n.cssRules:!n.rules||(s=n.rules);if(!!s&&!!s.length)for(u=0;u<s.length;u++){r=s[u];if(r.selectorText===t)return{index:u,rule:r}}}return!1},o=function(e,t){var n;if(!!r.insertRule)return r.cssRules?n=r.cssRules.length:n=0,r.insertRule(e+"{"+t+"}",n);if(!!r.addRule)return r.rules?n=r.rules.length:n=0,r.addRule(e,t,n),n},u=function(e,t){e.deleteRule?e.deleteRule(t):e.removeRule(t)};return{setRule:function(e,t){var n,u,a;u=s(e),u?(u.rule.cssText?a=u.rule.cssText:a=u.rule.style.cssText.toLowerCase(),a==="."+S+" { visibility: hidden; }"?i.push({sheet:u.rule.parentStyleSheet,index:u.index}):a.indexOf("visibility: hidden")!==-1&&(n=o(e,t),i.push({sheet:r,index:n}),u.rule.style.visibility="")):(n=o(e,t),i.push({sheet:r,index:n}))},clearChanges:function(){var e;while(!!(e=i.pop()))u(e.sheet,e.index)}}},z=String.fromCharCode(173),W=B,X=!0,V=function(t,n){function h(t){a=t||e,!o[a.location.href]&&(!s||!!a.frameElement)&&(s=!0,n(),o[a.location.href]=!0)}function p(){try{document.documentElement.doScroll("left")}catch(t){setTimeout(p,1);return}h(e)}function d(){var t,r,i=e.frames.length;if(f&&i>0){for(t=0;t<i;t++){r=undefined;try{r=e.frames[t].document.toString()}catch(s){r=undefined}!r||e.frames[t].location.href!=="about:blank"&&h(e.frames[t])}a=e,n(),o[e.location.href]=!0}else h(e)}var r=function(){},i,o={},u=document.addEventListener?"addEventListener":"attachEvent",l=document.addEventListener?"removeEventListener":"detachEvent",c=document.addEventListener?"":"on";if(s&&!o[t.location.href]){n(),o[t.location.href]=!0;return}r=function(t){if(t.type==="readystatechange"&&document.readyState!=="complete")return;document[l](c+t.type,r,!1);if(f&&e.frames.length>0)return;h(e)};if(document.readyState==="complete"||document.readyState==="interactive")setTimeout(d,1);else{document[u](c+"DOMContentLoaded",r,!1),document[u](c+"readystatechange",r,!1),e[u](c+"load",d,!1),i=!1;try{i=!e.frameElement}catch(v){}document.documentElement.doScroll&&i&&p()}},$=function(e,t){if(!e.getAttribute("lang")){try{if(!!e.getAttribute("xml:lang"))return e.getAttribute("xml:lang").toLowerCase()}catch(n){}return e.tagName!=="HTML"?$(e.parentNode,!0):t?k:null}return e.getAttribute("lang").toLowerCase()},J=function(r){r=r||a;var i=r.document.getElementsByTagName("html")[0],s=r.document.getElementsByTagName("meta"),o,u,l,c;k=$(i,!1);if(!k)for(o=0;o<s.length;o++)!!s[o].getAttribute("http-equiv")&&s[o].getAttribute("http-equiv").toLowerCase()==="content-language"&&(k=s[o].getAttribute("content").toLowerCase()),!!s[o].getAttribute("name")&&s[o].getAttribute("name").toLowerCase()==="dc.language"&&(k=s[o].getAttribute("content").toLowerCase()),!!s[o].getAttribute("name")&&s[o].getAttribute("name").toLowerCase()==="language"&&(k=s[o].getAttribute("content").toLowerCase());!k&&f&&!!a.frameElement&&J(e.parent),!k&&L!==""&&(k=L),k||(u="",c=navigator.language||navigator.userLanguage,c=c.substring(0,2),!t[c]||t[c].prompt===""?u=t.en.prompt:u=t[c].prompt,u+=" (ISO 639-1)\n\n"+n,k=e.prompt(unescape(u),c).toLowerCase());if(!t.hasOwnProperty(k)){if(!t.hasOwnProperty(k.split("-")[0]))throw l=new Error('The language "'+k+'" is not yet supported.'),l;k=k.split("-")[0]}},K=function(){var e,n,r=0,i=function(n,r,s){var o,u=0,a={};n.lang&&typeof n.lang=="string"?s=n.lang.toLowerCase():s?s=s.toLowerCase():s=$(n,!0),b&&w.support&&!!w.checkLangSupport(s)?(n.style[w.property]="auto",n.style["-webkit-locale"]="'"+s+"'"):(I==="hidden"&&q==="progressive"&&(n.getAttribute("style")?a.hasOwnStyle=!0:a.hasOwnStyle=!1,a.isHidden=!0,n.style.visibility="hidden"),t.hasOwnProperty(s)?M[s]=!0:t.hasOwnProperty(s.split("-")[0])?(s=s.split("-")[0],a.language=s):C||g(new Error("Language "+s+" is not yet supported.")),A.add(n,s,a));while(!!(o=n.childNodes[u++]))o.nodeType===1&&!l[o.nodeName.toLowerCase()]&&o.className.indexOf(x)===-1&&!e[o]&&i(o,!1,s)};b&&E();if(C)e=a.document.getElementsByTagName("body")[0],i(e,!1,k);else{!b&&q==="wait"&&(R.push(new U(a)),R[R.length-1].setRule("."+S,"visibility: hidden;")),e=F();while(!!(n=e[r++]))i(n,!0,"")}A.count===0&&(_=3,j())},Q=function(e){var t=0,n={tpoints:[]},r,i,s,o,u,a=Hyphenator.languages[e].patterns,f,l,c,h,p,d,v="in3se",m=function(){return v.split(/\D/).length===1?function(e){return e=e.replace(/\D/gi," "),e.split(" ")}:function(e){return e.split(/\D/)}}();for(t in a)if(a.hasOwnProperty(t)){r=a[t].match(new RegExp(".{1,"+ +t+"}","g")),s=0;while(!!(i=r[s++])){l=i.replace(/[\d]/g,"").split(""),c=m(i),h=n,o=0;while(!!(f=l[o++]))d=f.charCodeAt(0),h[d]||(h[d]={}),h=h[d];h.tpoints=[];for(u=0;u<c.length;u++)p=c[u],h.tpoints.push(p===""?0:p)}}Hyphenator.languages[e].patterns=n},G=function(e,t){var n=[],r=e.split(""),i;for(i=0;i<t.length;i++)t[i]!==0&&n.push(t[i]),r[i]&&n.push(r[i]);return n.join("")},Y=function(e){var t=e.split(", "),n={},r,i,s;for(r=0,i=t.length;r<i;r++)s=t[r].replace(/-/g,""),n.hasOwnProperty(s)||(n[s]=t[r]);return n},Z=function(n){var s,o,u,a;if(!t.hasOwnProperty(n)||!!Hyphenator.languages[n])return;s=r+"patterns/"+t[n].file;if(i&&!C){o=null,typeof XMLHttpRequest!="undefined"&&(o=new XMLHttpRequest);if(!o)try{o=new ActiveXObject("Msxml2.XMLHTTP")}catch(f){o=null}o&&(o.open("HEAD",s,!0),o.setRequestHeader("Cache-Control","no-cache"),o.onreadystatechange=function(e){if(o.readyState===4&&o.status===404){g(new Error("Could not load\n"+s)),delete M[n];return}},o.send(null))}y&&(u=e.document.getElementsByTagName("head").item(0),a=y("script",e),a.src=s,a.type="text/javascript",u.appendChild(a))},et=function(t){var n=Hyphenator.languages[t],r;n.prepared||(c&&(n.cache={}),d&&(n.redPatSet={}),n.hasOwnProperty("exceptions")&&(Hyphenator.addExceptions(t,n.exceptions),delete n.exceptions),O.hasOwnProperty("global")&&(O.hasOwnProperty(t)?O[t]+=", "+O.global:O[t]=O.global),O.hasOwnProperty(t)?(n.exceptions=Y(O[t]),delete O[t]):n.exceptions={},Q(t),r="[\\w"+n.specialChars+"@"+String.fromCharCode(173)+String.fromCharCode(8204)+"-]{"+T+",}",n.genRegExp=new RegExp("("+D+")|("+P+")|("+r+")","gi"),n.prepared=!0);if(!!p)try{p.setItem("Hyphenator_"+t,e.JSON.stringify(n))}catch(i){}},tt=function(t){var n,r,i,s;if(!v){for(n in Hyphenator.languages)Hyphenator.languages.hasOwnProperty(n)&&et(n);_=2,t("*");return}_=1;for(n in M)if(M.hasOwnProperty(n))if(!!p&&p.getItem("Hyphenator_"+n)){Hyphenator.languages[n]=e.JSON.parse(p.getItem("Hyphenator_"+n));if(O.hasOwnProperty("global")){i=Y(O.global);for(s in i)i.hasOwnProperty(s)&&(Hyphenator.languages[n].exceptions[s]=i[s])}if(O.hasOwnProperty(n)){i=Y(O[n]);for(s in i)i.hasOwnProperty(s)&&(Hyphenator.languages[n].exceptions[s]=i[s]);delete O[n]}i="[\\w"+Hyphenator.languages[n].specialChars+"@"+String.fromCharCode(173)+String.fromCharCode(8204)+"-]{"+T+",}",Hyphenator.languages[n].genRegExp=new RegExp("("+D+")|("+P+")|("+i+")","gi"),delete M[n],t(n)}else Z(n);r=e.setInterval(function(){var n=!0,i;for(i in M)M.hasOwnProperty(i)&&(n=!1,!Hyphenator.languages[i]||(delete M[i],et(i),t(i)));n&&(e.clearInterval(r),_=2)},100)},nt=function(){var e,t,n,r,i,s=Hyphenator.doHyphenation?"Hy-phen-a-tion":"Hyphenation";(e=a.document.getElementById("HyphenatorToggleBox"))?e.firstChild.data=s:(t=a.document.getElementsByTagName("body")[0],e=y("div",a),n=a.document.createAttribute("id"),n.nodeValue="HyphenatorToggleBox",i=a.document.createAttribute("class"),i.nodeValue=x,r=a.document.createTextNode(s),e.appendChild(r),e.setAttributeNode(n),e.setAttributeNode(i),e.onclick=Hyphenator.toggleHyphenation,e.style.position="absolute",e.style.top="0px",e.style.right="0px",e.style.margin="0",e.style.backgroundColor="#AAAAAA",e.style.color="#FFFFFF",e.style.font="6pt Arial",e.style.letterSpacing="0.2em",e.style.padding="3px",e.style.cursor="pointer",e.style.WebkitBorderBottomLeftRadius="4px",e.style.MozBorderRadiusBottomleft="4px",t.appendChild(e))},rt=function(e,t){var n=Hyphenator.languages[e],r,i,s,o,u,a,f,l,h,p,v,m=[],g=[],y,b,w=Math.max,E,S=[""],x;if(t==="")return"";if(t.indexOf(z)!==-1)return t;if(c&&n.cache.hasOwnProperty(t))return n.cache[t];if(n.exceptions.hasOwnProperty(t))return n.exceptions[t].replace(/-/g,z);if(t.indexOf("-")!==-1){r=t.split("-");for(l=0,i=r.length;l<i;l++)r[l]=rt(e,r[l]);return r.join("-")}o=t="_"+t+"_";if(!!n.charSubstitution)for(s in n.charSubstitution)n.charSubstitution.hasOwnProperty(s)&&(o=o.replace(new RegExp(s,"g"),n.charSubstitution[s]));t.indexOf("'")!==-1&&(o=o.replace("'","’")),u=o.toLowerCase().split(""),a=t.split(""),f=u.length,E=n.patterns;for(l=0;l<f;l+=1)m[l]=0,g[l]=u[l].charCodeAt(0);for(l=0;l<f;l+=1){x="",v=E;for(h=l;h<f;h+=1){v=v[g[h]];if(!v)break;d&&(x+=String.fromCharCode(g[h])),y=v.tpoints;if(y){d&&(n.redPatSet||(n.redPatSet={}),n.redPatSet[x]=G(x,y));for(p=0,b=y.length;p<b;p+=1)m[l+p]=w(m[l+p],y[p])}}}for(l=1;l<f-1;l+=1)l>n.leftmin&&l<f-n.rightmin&&m[l]%2?S.push(a[l]):S[S.length-1]+=a[l];return S.join(z)},it=function(e){return e.replace(/([:\/\.\?#&_,;!@]+)/gi,"$&"+W)},st=function(e){var t,n=0,r;switch(z){case"|":t="\\|";break;case"+":t="\\+";break;case"*":t="\\*";break;default:t=z}while(!!(r=e.childNodes[n++]))r.nodeType===3?(r.data=r.data.replace(new RegExp(t,"g"),""),r.data=r.data.replace(new RegExp(B,"g"),"")):r.nodeType===1&&st(r)},ot=function(t){var n=t.ownerDocument.getElementsByTagName("body")[0],r,i,s,o,u,a=function(t){t=t||e.event;var n=t.target||t.srcElement,a=n.ownerDocument,f=a.getElementsByTagName("body")[0],c=a.defaultView||a.parentWindow;if(n.tagName&&l[n.tagName.toLowerCase()])return;r=a.createElement("div"),r.style.color=e.getComputedStyle?c.getComputedStyle(f,null).backgroundColor:"#FFFFFF",r.style.fontSize="0px",f.appendChild(r),e.getSelection?(t.stopPropagation(),i=c.getSelection(),s=i.getRangeAt(0),r.appendChild(s.cloneContents()),st(r),i.selectAllChildren(r),u=function(){r.parentNode.removeChild(r),i.removeAllRanges(),i.addRange(s)}):(t.cancelBubble=!0,i=c.document.selection,s=i.createRange(),r.innerHTML=s.htmlText,st(r),o=f.createTextRange(),o.moveToElementText(r),o.select(),u=function(){r.parentNode.removeChild(r),s.text!==""&&s.select()}),e.setTimeout(u,0)};if(!n)return;t=t||n,e.addEventListener?t.addEventListener("copy",a,!0):t.attachEvent("oncopy",a)},ut=function(e){var t=e.element,n=e.data;t.style.visibility="visible",e.data.isHidden=!1,n.hasOwnStyle?t.style.removeProperty?t.style.removeProperty("visibility"):t.style.removeAttribute&&t.style.removeAttribute("visibility"):(t.setAttribute("style",""),t.removeAttribute("style"))},at=function(){var e=!0,t;A.each(function(t,n){var r,i=n.length;for(r=0;r<i;r++)e=e&&n[r].hyphenated});if(e){for(t=0;t<R.length;t++)R[t].clearChanges();_=3,j()}},ft=function(e,t){var n=t.data,r=t.element,i,s,o,u=function(e){var t,n;switch(z){case"|":t="\\|";break;case"+":t="\\+";break;case"*":t="\\*";break;default:t=z}return N>=2&&(n=e.split(" "),n[1]=n[1].replace(new RegExp(t,"g"),""),n[1]=n[1].replace(new RegExp(B,"g"),""),n=n.join(" ")),N===3&&(n=n.replace(/[ ]+/g,String.fromCharCode(160))),n};if(Hyphenator.languages.hasOwnProperty(e)){i=function(t){return Hyphenator.doHyphenation?H.test(t)?it(t):rt(e,t):t},X&&r.tagName.toLowerCase()!=="body"&&ot(r),o=0;while(!!(s=r.childNodes[o++]))s.nodeType===3&&s.data.length>=T&&(s.data=s.data.replace(Hyphenator.languages[e].genRegExp,i),N!==1&&(s.data=s.data.replace(/[\S]+ [\S]+$/,u)))}n.isHidden&&I==="hidden"&&q==="progressive"&&ut(t),t.hyphenated=!0,A.hyCount+=1,A.count<=A.hyCount&&at()},lt=function(t){function n(e,t,n){return function(){return e(t,n)}}var r,i,s;if(t==="*")A.each(function(t,r){var i,s=r.length;for(i=0;i<s;i++)e.setTimeout(n(ft,t,r[i]),0)});else if(A.list.hasOwnProperty(t)){s=A.list[t].length;for(i=0;i<s;i++)e.setTimeout(n(ft,t,A.list[t][i]),0)}},ct=function(){A.each(function(e,t){var n,r=t.length,i;for(n=0;n<r;n++)st(t[n].element),t[n].hyphenated=!1}),_=4},ht=function(){try{if(h!=="none"&&typeof e.localStorage!="undefined"&&typeof e.sessionStorage!="undefined"&&typeof e.JSON.stringify!="undefined"&&typeof e.JSON.parse!="undefined")switch(h){case"session":p=e.sessionStorage;break;case"local":p=e.localStorage;break;default:p=undefined}}catch(t){}},pt=function(){if(!p)return;var t={STORED:!0,classname:S,donthyphenateclassname:x,minwordlength:T,hyphenchar:z,urlhyphenchar:W,togglebox:nt,displaytogglebox:m,remoteloading:v,enablecache:c,onhyphenationdonecallback:j,onerrorhandler:g,intermediatestate:I,selectorfunction:F,safecopy:X,doframes:f,storagetype:h,orphancontrol:N,dohyphenation:Hyphenator.doHyphenation,persistentconfig:u,defaultlanguage:L};p.setItem("Hyphenator_config",e.JSON.stringify(t))},dt=function(){var t;p.getItem("Hyphenator_config")&&(t=e.JSON.parse(p.getItem("Hyphenator_config")),Hyphenator.config(t))};return{version:"X.Y.Z",doHyphenation:!0,languages:{},config:function(e){var t=function(t,n){return typeof e[t]===n?!0:(g(new Error("Config onError: "+t+" must be of type "+n)),!1)},n;e.hasOwnProperty("storagetype")&&(t("storagetype","string")&&(h=e.storagetype),p||ht()),!e.hasOwnProperty("STORED")&&p&&e.hasOwnProperty("persistentconfig")&&e.persistentconfig===!0&&dt();for(n in e)if(e.hasOwnProperty(n))switch(n){case"STORED":break;case"classname":t("classname","string")&&(S=e[n]);break;case"donthyphenateclassname":t("donthyphenateclassname","string")&&(x=e[n]);break;case"minwordlength":t("minwordlength","number")&&(T=e[n]);break;case"hyphenchar":t("hyphenchar","string")&&(e.hyphenchar==="&shy;"&&(e.hyphenchar=String.fromCharCode(173)),z=e[n]);break;case"urlhyphenchar":e.hasOwnProperty("urlhyphenchar")&&t("urlhyphenchar","string")&&(W=e[n]);break;case"togglebox":t("togglebox","function")&&(nt=e[n]);break;case"displaytogglebox":t("displaytogglebox","boolean")&&(m=e[n]);break;case"remoteloading":t("remoteloading","boolean")&&(v=e[n]);break;case"enablecache":t("enablecache","boolean")&&(c=e[n]);break;case"enablereducedpatternset":t("enablereducedpatternset","boolean")&&(d=e[n]);break;case"onhyphenationdonecallback":t("onhyphenationdonecallback","function")&&(j=e[n]);break;case"onerrorhandler":t("onerrorhandler","function")&&(g=e[n]);break;case"intermediatestate":t("intermediatestate","string")&&(I=e[n]);break;case"selectorfunction":t("selectorfunction","function")&&(F=e[n]);break;case"safecopy":t("safecopy","boolean")&&(X=e[n]);break;case"doframes":t("doframes","boolean")&&(f=e[n]);break;case"storagetype":t("storagetype","string")&&(h=e[n]);break;case"orphancontrol":t("orphancontrol","number")&&(N=e[n]);break;case"dohyphenation":t("dohyphenation","boolean")&&(Hyphenator.doHyphenation=e[n]);break;case"persistentconfig":t("persistentconfig","boolean")&&(u=e[n]);break;case"defaultlanguage":t("defaultlanguage","string")&&(L=e[n]);break;case"useCSS3hyphenation":t("useCSS3hyphenation","boolean")&&(b=e[n]);break;case"unhide":t("unhide","string")&&(q=e[n]);break;default:g(new Error("Hyphenator.config: property "+n+" not known."))}p&&u&&pt()},run:function(){o=0;var t=function(){try{if(a.document.getElementsByTagName("frameset").length>0)return;o++,J(undefined),K(),tt(lt),m&&nt()}catch(e){g(e)}},n,r,i=e.frames.length;p||ht(),!s&&!C&&V(e,t);if(C||s){if(f&&i>0)for(n=0;n<i;n++){r=undefined;try{r=e.frames[n].document.toString()}catch(u){r=undefined}!r||(a=e.frames[n],t())}a=e,t()}},addExceptions:function(e,t){e===""&&(e="global"),O.hasOwnProperty(e)?O[e]+=", "+t:O[e]=t},hyphenate:function(e,t){var n,r,i;if(Hyphenator.languages.hasOwnProperty(t)){Hyphenator.languages[t].prepared||et(t),n=function(e){return H.test(e)?it(e):rt(t,e)};if(typeof e=="string"||e.constructor===String)return e.replace(Hyphenator.languages[t].genRegExp,n);if(typeof e=="object"){i=0;while(!!(r=e.childNodes[i++]))r.nodeType===3&&r.data.length>=T?r.data=r.data.replace(Hyphenator.languages[t].genRegExp,n):r.nodeType===1&&(r.lang!==""?Hyphenator.hyphenate(r,r.lang):Hyphenator.hyphenate(r,t))}}else g(new Error('Language "'+t+'" is not loaded.'))},getRedPatternSet:function(e){return Hyphenator.languages[e].redPatSet},isBookmarklet:function(){return C},getConfigFromURI:function(){var e=null,t={},n=document.getElementsByTagName("script"),r,i,s,o,u,a;for(r=0,s=n.length;r<s;r++){!n[r].getAttribute("src")||(e=n[r].getAttribute("src"));if(e&&e.indexOf("Hyphenator.js?")!==-1){o=e.indexOf("Hyphenator.js?"),u=e.substring(o+14).split("&");for(i=0;i<u.length;i++)a=u[i].split("="),a[0]!=="bm"&&(a[1]==="true"?a[1]=!0:a[1]==="false"?a[1]=!1:isFinite(a[1])&&(a[1]=parseInt(a[1],10)),a[0]==="onhyphenationdonecallback"&&(a[1]=new Function("",a[1])),t[a[0]]=a[1]);break}}return t},toggleHyphenation:function(){Hyphenator.doHyphenation?(ct(),Hyphenator.doHyphenation=!1,pt(),nt()):(lt("*"),Hyphenator.doHyphenation=!0,pt(),nt())}}}(window);Hyphenator.isBookmarklet()&&(Hyphenator.config({displaytogglebox:!0,intermediatestate:"visible",doframes:!0,useCSS3hyphenation:!0}),Hyphenator.config(Hyphenator.getConfigFromURI()),Hyphenator.run());