#!/usr/bin/env python

"""

gentoo-ebuild
=============

Creates an ebuild from DOAP

g-everything


"""

import logging

from Cheetah.Template import Template


__docformat__ = 'epytext'
__revision__ = '$Revision: $'[11:-1].strip()

#Cheetah template
EBUILD_TEMPLATE = '''
# Copyright 1999-$year Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# \$Header: \$
# Ebuild generated by doapfiend-ebuild $doapfiend_version
# Edit this ebuild! It's been automatically generated and is intended as a skel

#if $warnings
#for warn in $warnings:
\# Warning: $warn
#end for
#end if

#if $my_pn
MY_PN="$my_pn"
#end if
#if $my_pv
MY_PV="$my_pv"
#end if
#if $my_p
MY_P="$my_p"
#end if
#end if

DESCRIPTION="$description"
HOMEPAGE="$homepage"
SRC_URI="$src_uri"
LICENSE="$license"
KEYWORDS="$keywords"
SLOT="$slot"
IUSE="$use_f"
#if $s
S="$s"
#end if
#if $rdepend
RDEPEND="$rdepend_f"
#end if
#if $depend
DEPEND="$depend_f"
#end if

#if $src_unpack
src_unpack() {
$src_unpack
}

#end if
#if $src_compile
src_compile() {
$src_compile
}

#end if
#if $src_install
src_install() {
$src_install
}

#end if
#if $src_test
src_test() {
$src_test
}

#end if
'''

class Ebuild:

    """Contains ebuild"""
    
    def __init__(self):
        """Setup ebuild variables"""
        self.config = dict(keyword="x86")
        self.options = {}
        self.logger = logging.getLogger('doapfiend')
        self.ebuild_text = ""

        #Variables that will be passed to the Cheetah template
        self.vars = {
                'description': '',
                'homepage': '',
                'rdepend': [],
                'depend': [],
                'use': [],
                'slot': '0',
                's': '',
                'keywords': self.config['keyword'],
                }


    def get_ebuild(self):
        """Generate ebuild from template"""
        self.ebuild_text = \
                Template(EBUILD_TEMPLATE,
						searchList=[self.vars]).respond()
