import os
from setuptools import setup


repo_root = os.path.dirname(__file__)

if repo_root != '':
    os.chdir(repo_root)
project_root = 'dock'

packages = []

for root, dirs, files in os.walk(project_root):
    if '__init__.py' in files:
        head, package = os.path.split(root)
        packages.append(package)


setup(name='dock',
      version='0.1.1',
      description='A library for moving data between a file system and a data store. '
                  'Based on Python, Git, and good intentions.',
      url='https://github.com/pwalsh/dock',
      author='Paul Walsh',
      author_email='paulywalsh@gmail.com',
      license='BSD',
      packages=['dock'],
      zip_safe=False)
