from fabric.api import env, task, roles, local, lcd, puts, execute
from fabric.colors import green
from dock.core.incoming import Unload, Process, Store


def notify(msg):
    return puts(green(msg))


@roles('app')
@task
def clone():
    notify(u'Cloning the data repository.')
    with lcd(env.dataset_root):
        local('git clone ' + env.dataset_repository + ' dataset')


@roles('app')
@task
def fetch():
    notify(u'Fetching new commits from the data repository.')
    with lcd(env.dataset_root + '/dataset'):
        local('git fetch')


@roles('app')
@task
def merge():
    notify(u'Merging latest changes from the data repository.')
    with lcd(env.dataset_root + '/dataset'):
        local('git merge ' + env.dataset_branch + ' origin/' + env.dataset_branch)


@roles('app')
@task
def pull():
    notify(u'Pulling latest changes from the data repository.')
    execute(fetch)
    execute(merge)


@roles('app')
@task
def push():
    notify(u'Pushing latest local changes to the data repository.')
    with lcd(env.dataset_root + '/dataset'):
        local('git push origin ' + env.dataset_branch)


@roles('app')
@task
def commit(msg="Commit from deploy."):
    notify(u'Committing local changes.')
    with lcd(env.dataset_root + '/dataset'):
        local('git add -A')
        local('git commit -m "{msg}"'.format(msg=msg))


@roles('app')
@task
def load():
    notify(u'Loading data into the database.')

    storage_class = env.storage_class or Store
    dataset_processing_class = env.dataset_processing_class or None
    persist_objects = env.dock_persist_objects or False

    data_root = env.dataset_root + '/dataset/data'
    unload = Unload(data_root)
    Process(unload.map_inventory(), storage_class=storage_class,
            dataset_processing_class=dataset_processing_class,
            persist_objects=persist_objects)
