from fabric.api import env, task, roles, run, cd, puts, execute, prefix
from fabric.colors import green


def notify(msg):
    return puts(green(msg))


@roles('app')
@task
def clone():
    notify(u'Cloning the data repository.')
    with cd(env.dataset_root):
        run('git clone ' + env.dataset_repository + ' dataset')


@roles('app')
@task
def fetch():
    notify(u'Fetching new commits from the data repository.')
    with cd(env.dataset_root + '/dataset'):
        run('git fetch')


@roles('app')
@task
def merge():
    notify(u'Merging latest changes from the data repository.')
    with cd(env.dataset_root + '/dataset'):
        run('git merge ' + env.dataset_branch + ' origin/' + env.dataset_branch)


@roles('app')
@task
def pull():
    notify(u'Pulling latest changes from the data repository.')
    execute(fetch)
    execute(merge)


@roles('app')
@task
def push():
    notify(u'Pushing latest local changes to the data repository.')
    with cd(env.dataset_root + '/dataset'):
        run('git push origin/' + env.dataset_branch)


@roles('app')
@task
def load():
    notify(u'Loading data into the database.')

    with prefix(env.workon):
        run('fab dock.local.load')
