// Generated by CoffeeScript 1.6.2
/*
  This is the main script file. It can attach to the terminal
*/


(function() {
  var COMPLETE_URL, EVENT_TYPES, buildfunction, current_question, currentquestion, drawStatusMarker, err, f, logEvent, next, previous, progressIndicator, q, question, questionNumber, questions, results, staticDockerPs, statusMarker, _i, _len;

  COMPLETE_URL = "/whats-next/";

  /*
    Array of question objects
  */


  staticDockerPs = "ID                  IMAGE               COMMAND               CREATED             STATUS              PORTS";

  q = [];

  q.push({
    html: "<h3>Getting started</h3>\n<p>There are actually two programs: The Docker daemon, which is a server process and which manages all the\ncontainers, and the Docker client, which acts as a remote control on the daemon. On most systems, like in this\nemulator, both execute on the same host.</p>",
    assignment: "<h3>Assignment</h3>\n<p>Check which Docker versions are running</p>\n<p>This will help you verify the daemon is running and you can connect to it. If you see which version is running\nyou know you are all set.</p>",
    tip: "<p>Try typing <code>docker</code> to see the full list of accepted arguments</p>      <p>This emulator provides only a limited set of shell and Docker commands, so some commands may not work as expected</p>",
    command_expected: ['docker', 'version'],
    result: "<p>Well done! Let's move to the next assignment.</p>"
  });

  q.push({
    html: "<h3>Searching for images</h3>\n<p>The easiest way to get started is to use a container image from someone else. Container images are\navailable on the Docker index, a central place to store images. You can find them online at\n<a href=\"#1\" onClick=\"window.open('http://index.docker.io','Docker Index','width=1000,height=900,left=50,top=50,menubar=0')\";>index.docker.io</a>\nand by using the commandline</p>",
    assignment: "<h3>Assignment</h3>\n<p>Use the commandline to search for an image called tutorial</p>",
    command_expected: ['docker', 'search', 'tutorial'],
    result: "<p>You found it!</p>",
    tip: "the format is <code>docker search &lt;string&gt;</code>"
  });

  q.push({
    html: "<h3>Downloading container images</h3>\n<p>Container images can be downloaded just as easily, using <code>docker pull</code>.</p>\n<p>For images from the central index, the name you specify is constructed as &lt;username&gt;/&lt;repository&gt;</p>\n<p>A group of special, trusted images such as the ubuntu base image can be retrieved by just their name &lt;repository&gt;.</p>",
    assignment: "<h3>Assignment</h3>\n<p>Please download the tutorial image you have just found</p>",
    command_expected: ['docker', 'pull', 'learn/tutorial'],
    result: "<p>Cool. Look at the results. You'll see that Docker has downloaded a number of layers. In Docker all images (except the base image) are made up of several cumulative layers.</p>",
    tip: "<p>Don't forget to pull the full name of the repository e.g. 'learn/tutorial'</p>\n<p>Look under 'show expected command if you're stuck.</p>"
  });

  q.push({
    html: "<h3>Hello world from a container</h3>\n<p>You can think about containers as a process in a box. The box contains everything the process might need, so\nit has the filesystem, system libraries, shell and such, but by default none of it is started or run.<p>\n<p>You 'start' a container <em>by</em> running a process in it. This process is the only process run, so when\nit completes the container is fully stopped.",
    assignment: "<h3>Assignment</h3>\n<p>Make our freshly loaded container image output \"hello world\"</p>\n<p>To do so you should run 'echo' in the container and have that say \"hello world\"\n",
    command_expected: ["docker", "run", "learn/tutorial", "echo", "hello"],
    command_show: ["docker", "run", "learn/tutorial", 'echo "hello world"'],
    result: "<p>Great! Hellooooo World!</p><p>You have just started a container and executed a program inside of it, when\nthe program stopped, so did the container.",
    intermediateresults: [
      function() {
        return "<p>You seem to be almost there. Did you give the command `echo \"hello world\"` ";
      }, function() {
        return "<p>You've got the arguments right. Did you get the command? Try <em>/bin/bash </em>?</p>";
      }
    ],
    tip: "<p>The command <code>docker run</code> takes a minimum of two arguments. An image name, and the command you want to execute\nwithin that image.</p>\n<p>Check the expected command below if it does not work as expected</p>"
  });

  q.push({
    html: "<h3>Installing things in the container</h3>\n<p>Next we are going to install a simple program (ping) in the container. The image is based upon ubuntu, so you\ncan run the command <code>apt-get install -y ping</code> in the container. </p>\n<p>Note that even though the container stops right after a command completes, the changes are not forgotten.</p>",
    assignment: "<h3>Assignment</h3>\n<p>Install 'ping' on top of the learn/tutorial image.</p>",
    command_expected: ["docker", "run", "learn/tutorial", "apt-get", "install", "-y", "ping"],
    result: "<p>That worked! You have installed a program on top of a base image. Your changes to the filesystem have been\nkept, but are not yet saved.</p>",
    intermediateresults: [
      function() {
        return "<p>Not specifying -y on the apt-get install command will work for ping, because it has no other dependencies, but\nit will fail when apt-get wants to install dependencies. To get into the habit, please add -y after apt-get.</p>";
      }
    ],
    tip: "<p>Don't forget to use -y for noninteractive mode installation</p>\n<p>Not specifying -y on the apt-get install command will fail for most commands because it expects you to accept\n(y/n) but you cannot respond.\n</p>"
  });

  q.push({
    html: "<h3>Save your changes</h3>\n<p>After you make changes (by running a command inside a container), you probably want to save those changes.\nThis will enable you to later start from this point onwards.</p>\n<p>With Docker, the process of saving the state is called <em>committing</em>. Commit basically saves the difference\nbetween the old image and the new state. The result is a new layer.</p>",
    assignment: "<h3>Assignment</h3>\n<p>First use <code>docker ps -l</code> to find the ID of the container you created by installing ping.</p>\n<p>Then save (commit) this container with the repository name 'learn/ping' </p>",
    command_expected: ["docker", "commit", "698", "learn/ping"],
    command_show: ["docker", "commit", "698", 'learn/ping'],
    result: "<p>That worked! Please take note that Docker has returned a new ID. This id is the <em>image id</em>.</p>",
    intermediateresults: [
      function() {
        return "You have not specified the correct repository name to commit to (learn/ping). This works, but giving your images a name\nmakes them much easier to work with.";
      }
    ],
    tip: "<ul>\n<li>Giving just <code>docker commit</code> will show you the possible arguments.</li>\n<li>You will need to specify the container to commit by the ID you found</li>\n<li>You don't need to copy (type) the entire ID. Three or four characters are usually enough.</li>\n</ul>"
  });

  q.push({
    html: "<h3>Run your new image</h3>\n<p>Now you have basically setup a complete, self contained environment with the 'ping' program installed. </p>\n<p>Your image can now be run on any host that runs Docker.</p>\n<p>Lets run this image on this machine.</p>",
    assignment: "<h3>Assignment</h3>\n<p>Run the ping program to ping www.google.com</p>\n",
    command_expected: ["docker", "run", 'learn/ping', 'ping', 'google.com'],
    result: "<p>That worked! Note that normally you can use Ctrl-C to disconnect. The container will keep running. This\ncontainer will disconnect automatically.</p>",
    intermediateresults: [
      function() {
        return "You have not specified a repository name. This is not wrong, but giving your images a name\nmake them much easier to work with.";
      }
    ],
    tip: "<ul>\n<li>Make sure to use the repository name learn/ping to run ping with</li>\n</ul>"
  });

  q.push({
    html: "<h3>Check your running image</h3>\n<p>You now have a running container. Let's see what is going on.</p>\n<p>Using <code>docker ps</code> we can see a list of all running containers, and using <code>docker inspect</code>\nwe can see all sorts of useful information about this container.</p>",
    assignment: "<h3>Assignment</h3>\n<p><em>Find the container id</em> of the running container, and then inspect the container using <em>docker inspect</em>.</p>\n",
    command_expected: ["docker", "inspect", "efe"],
    result: "<p>Success! Have a look at the output. You can see the ip-address, status and other information.</p>",
    intermediateresults: [
      function() {
        return "You have not specified a repository name. This is not wrong, but giving your images a name\nmake them much easier to work with.";
      }
    ],
    tip: "<ul>\n<li>Remember you can use a partial match of the image id</li>\n</ul>",
    currentDockerPs: "ID                  IMAGE               COMMAND               CREATED             STATUS              PORTS\nefefdc74a1d5        learn/ping:latest   ping www.google.com   37 seconds ago      Up 36 seconds"
  });

  q.push({
    html: "<h3>Push your image to the index</h3>\n<p>Now you have verified that your application container works, you can share it.</p>\n<p>Remember you pulled (downloaded) the learn/tutorial image from the index? You can also share your built images\nto the index by pushing (uploading) them to there. That way you can easily retrieve them for re-use and share them\nwith others. </p>",
    assignment: "<h3>Assignment</h3>\n<p>Push your container image learn/ping to the index</p>\n",
    command_expected: ["will_never_be_valid"],
    command_show: ["docker", "push", "learn/ping"],
    result: "",
    intermediateresults: [
      function() {
        var data;

        $('#instructions .assignment').hide();
        $('#tips, #command').hide();
        $('#instructions .text').html("<div class=\"complete\">\n  <h3>Congratulations!</h3>\n  <p>You have mastered the basic docker commands!</p>\n  <p><strong>Did you enjoy this tutorial? Share it!</strong></p>\n  <p>\n    <a href=\"mailto:?Subject=Check%20out%20the%20Docker%20interactive%20tutorial!&Body=%20https://www.docker.io/gettingstarted/\"><img src=\"/static/img/email.png\"></a>\n    <a href=\"http://www.facebook.com/sharer.php?u=https://www.docker.io/gettingstarted/\"><img src=\"/static/img/facebook.png\"></a>\n    <a href=\"http://twitter.com/share?url=https://www.docker.io/gettingstarted/&text=%20Check+out+the+docker+tutorial!\"><img src=\"/static/img/twitter.png\"></a>\n  </p>\n  <h3>Your next steps</h3>\n  <ol>\n    <li><a href=\"/news_signup/\" target=\"_blank\" >Register</a> for news and updates on Docker (opens in new window)</li>\n    <li><a href=\"http://twitter.com/docker\" target=\"_blank\" >Follow</a> us on twitter (opens in new window)</li>\n    <li><a href=\"#\" onClick=\"leaveFullSizeMode()\">Close</a> this tutorial, and continue with the rest of the getting started.</li>\n  </ol>\n  <p> - Or - </p>\n  <p>Continue to learn about the way to automatically build your containers from a file. </p><p><a href=\"/learn/dockerfile/\" class='btn btn-primary secondary-action-button'>Start Dockerfile tutorial</a></p>\n\n</div>");
        data = {
          type: EVENT_TYPES.complete
        };
        logEvent(data);
        return "<p>All done!. You are now pushing a container image to the index. You can see that push, just like pull, happens layer by layer.</p>";
      }
    ],
    tip: "<ul>\n<li><code>docker images</code> will show you which images are currently on your host</li>\n<li><code>docker push</code>is the command to push images</li>\n<li>You can only push images to your own namespace, this emulator is logged in as user 'learn'</li>\n\n</ul>",
    finishedCallback: function() {
      webterm.clear();
      return webterm.echo(myTerminal());
    }
  });

  questions = [];

  /*
    Register the terminal
  */


  this.webterm = $('#terminal').terminal(interpreter, basesettings);

  EVENT_TYPES = {
    none: "none",
    start: "start",
    command: "command",
    next: "next",
    peek: "peek",
    feedback: "feedback",
    complete: "complete"
  };

  /*
    Sending events to the server
  */


  logEvent = function(data, feedback) {
    var ajax_load, callback, loadUrl;

    ajax_load = "loading......";
    loadUrl = "/tutorial/api/";
    if (!feedback) {
      callback = function(responseText) {
        return $("#ajax").html(responseText);
      };
    } else {
      callback = function(responseText) {
        results.set("Thank you for your feedback! We appreciate it!", true);
        $('#feedbackInput').val("");
        return $("#ajax").html(responseText);
      };
    }
    if (!data) {
      data = {
        type: EVENT_TYPES.none
      };
    }
    data.question = current_question;
    $("#ajax").html(ajax_load);
    return $.post(loadUrl, data, callback, "html");
  };

  /*
    Event handlers
  */


  $('#buttonNext').click(function(e) {
    this.setAttribute('disabled', 'disabled');
    console.log(e);
    return next();
  });

  $('#buttonFinish').click(function() {
    return window.open(COMPLETE_URL);
  });

  $('#buttonPrevious').click(function() {
    previous();
    return $('#results').hide();
  });

  $('#leftside').bind('mousewheel', function(event, delta, deltaX, deltaY) {
    this.scrollTop += deltaY * -30;
    return event.preventDefault();
  });

  $('#feedbackSubmit').click(function() {
    var data, feedback;

    feedback = $('#feedbackInput').val();
    data = {
      type: EVENT_TYPES.feedback,
      feedback: feedback
    };
    return logEvent(data, feedback = true);
  });

  $('#fullSizeOpen').click(function() {
    return goFullScreen();
  });

  this.goFullScreen = function() {
    console.debug("going to fullsize mode");
    $('.togglesize').removeClass('startsize').addClass('fullsize');
    $('.hide-when-small').css({
      display: 'inherit'
    });
    $('.hide-when-full').css({
      display: 'none'
    });
    next(0);
    webterm.resize();
    return setTimeout(function() {
      return logEvent({
        type: EVENT_TYPES.start
      });
    }, 3000);
  };

  $('#fullSizeClose').click(function() {
    return leaveFullSizeMode();
  });

  this.leaveFullSizeMode = function() {
    console.debug("leaving full-size mode");
    $('.togglesize').removeClass('fullsize').addClass('startsize');
    $('.hide-when-small').css({
      display: 'none'
    });
    $('.hide-when-full').css({
      display: 'inherit'
    });
    return webterm.resize();
  };

  $('#command').click(function() {
    var data;

    if (!$('#commandHiddenText').hasClass('hidden')) {
      $('#commandHiddenText').addClass("hidden").hide();
      $('#commandShownText').hide().removeClass("hidden").fadeIn();
    }
    data = {
      type: EVENT_TYPES.peek
    };
    return logEvent(data);
  });

  /*
    Navigation amongst the questions
  */


  current_question = 0;

  next = function(which) {
    var data;

    $('#marker-' + current_question).addClass("complete").removeClass("active");
    if (!which && which !== 0) {
      current_question++;
    } else {
      current_question = which;
    }
    questions[current_question]();
    results.clear();
    this.webterm.focus();
    if (!$('#commandShownText').hasClass('hidden')) {
      $('#commandShownText').addClass("hidden");
      $('#commandHiddenText').removeClass("hidden").show();
    }
    history.pushState({}, "", "#" + current_question);
    data = {
      'type': EVENT_TYPES.next
    };
    logEvent(data);
    $('#marker-' + current_question).removeClass("complete").addClass("active");
    $('#question-number').find('text').get(0).textContent = current_question;
    $('#instructions .assignment').show();
    $('#tips, #command').show();
  };

  previous = function() {
    current_question--;
    questions[current_question]();
    results.clear();
    this.webterm.focus();
  };

  results = {
    set: function(htmlText, intermediate) {
      if (intermediate) {
        console.debug("intermediate text received");
        $('#results').addClass('intermediate');
        $('#buttonNext').hide();
      } else {
        $('#buttonNext').show();
      }
      return window.setTimeout((function() {
        $('#resulttext').html(htmlText);
        $('#results').fadeIn();
        return $('#buttonNext').removeAttr('disabled');
      }), 300);
    },
    clear: function() {
      $('#resulttext').html("");
      return $('#results').fadeOut('slow');
    }
  };

  /*
    Transform question objects into functions
  */


  buildfunction = function(q) {
    var _q;

    _q = q;
    return function() {
      console.debug("function called");
      $('#instructions').hide().fadeIn();
      $('#instructions .text').html(_q.html);
      $('#instructions .assignment').html(_q.assignment);
      $('#tipShownText').html(_q.tip);
      if (_q.command_show) {
        $('#commandShownText').html(_q.command_show.join(' '));
      } else {
        $('#commandShownText').html(_q.command_expected.join(' '));
      }
      if (_q.currentDockerPs != null) {
        window.currentDockerPs = _q.currentDockerPs;
      } else {
        window.currentDockerPs = staticDockerPs;
      }
      if (_q.finishedCallback != null) {
        window.finishedCallback = q.finishedCallback;
      } else {
        window.finishedCallback = function() {
          return "";
        };
      }
      window.immediateCallback = function(input, stop) {
        var data, doNotExecute;

        if (stop === true) {
          doNotExecute = true;
        } else {
          doNotExecute = false;
        }
        if (doNotExecute !== true) {
          console.log(input);
          data = {
            'type': EVENT_TYPES.command,
            'command': input.join(' '),
            'result': 'fail'
          };
          if (input.containsAllOfTheseParts(_q.command_expected)) {
            data.result = 'success';
            setTimeout((function() {
              this.webterm.disable();
              return $('#buttonNext').focus();
            }), 1000);
            results.set(_q.result);
            console.debug("contains match");
          } else {
            console.debug("wrong command received");
          }
          logEvent(data);
        }
      };
      window.intermediateResults = function(input) {
        var intermediate;

        if (_q.intermediateresults) {
          return results.set(_q.intermediateresults[input](), intermediate = true);
        }
      };
    };
  };

  statusMarker = $('#progress-marker-0');

  progressIndicator = $('#progress-indicator');

  drawStatusMarker = function(i) {
    var marker;

    if (i === 0) {
      marker = statusMarker;
    } else {
      marker = statusMarker.clone();
      marker.appendTo(progressIndicator);
    }
    marker.attr("id", "marker-" + i);
    marker.find('text').get(0).textContent = i;
    return marker.click(function() {
      return next(i);
    });
  };

  questionNumber = 0;

  for (_i = 0, _len = q.length; _i < _len; _i++) {
    question = q[_i];
    f = buildfunction(question);
    questions.push(f);
    drawStatusMarker(questionNumber);
    questionNumber++;
  }

  /*
    Initialization of program
  */


  if (window.location.hash) {
    try {
      currentquestion = window.location.hash.split('#')[1].toNumber();
      next(currentquestion);
    } catch (_error) {
      err = _error;
      questions[0]();
    }
  } else {
    questions[0]();
  }

  $('#results').hide();

}).call(this);
