import logging

import yaml
import click

from docpipe.exc import DocpipeException
from docpipe.pipeline import Pipeline


log = logging.getLogger(__name__)


def execute_pipeline(ctx, fh, operation):
    try:
        config = yaml.load(fh.read())
        fh.close()
    except Exception, e:
        raise click.ClickException("Cannot parse pipeline: %s" % e)
    if 'config' not in config:
        config['config'] = {}
    config['config'].update(ctx)

    try:
        pipeline = Pipeline(fh.name, config=config)
        getattr(pipeline, operation)()
    except DocpipeException, de:
        raise click.ClickException(unicode(de))


@click.group()
@click.option('-s', '--stash', default=None, type=click.Path(),
              help='Location of the document stash')
@click.option('-d', '--debug', default=False, is_flag=True,
              help='Verbose output for debugging')
@click.pass_context
def cli(ctx, stash, debug):
    """ A configurable document processing tool. """
    ctx.obj = {
        'stash': stash,
        'debug': debug
    }
    if debug:
        logging.basicConfig(level=logging.DEBUG)
    else:
        logging.basicConfig(level=logging.INFO)


@cli.command()
@click.argument('pipeline', type=click.File('rb'))
@click.pass_obj
def run(ctx, pipeline):
    """ Execute the given PIPELINE. """
    execute_pipeline(ctx, pipeline, 'run')


@cli.command()
@click.argument('pipeline', type=click.File('rb'))
@click.pass_obj
def extract(ctx, pipeline):
    """ Execute the extractors in PIPELINE. """
    execute_pipeline(ctx, pipeline, 'extract')


@cli.command()
@click.argument('pipeline', type=click.File('rb'))
@click.pass_obj
def transform(ctx, pipeline):
    """ Execute the transformers in PIPELINE. """
    execute_pipeline(ctx, pipeline, 'transform')
