import logging

from stevedore.extension import ExtensionManager

NAMESPACE = 'docpipe.tasks'

log = logging.getLogger(__name__)


def load():
    manager = ExtensionManager(namespace=NAMESPACE,
                               propagate_map_exceptions=True,
                               invoke_on_load=False)
    log.info('Available tasks: %s', ', '.join(manager.names()))
    tasks = {}
    for ext in manager.extensions:
        tasks[ext.name] = ext
    return tasks
