from docpipe.exc import NotImplemented


class Task(object):

    def __init__(self, pipeline, name, config):
        self.pipeline = pipeline
        self.name = name
        self.config = config

    def extract(self):
        raise NotImplemented("%s uses an invalid task type." % self.name)

    def transform(self, document):
        raise NotImplemented("%s uses an invalid task type." % self.name)

    @property
    def type(self):
        return self.__class__.__name__

    def __repr__(self):
        return '<%s("%s")>' % (self.type, self.name)
