import logging

from docpipe import Task

log = logging.getLogger(__name__)


class IngestTask(Task):

    def extract(self):
        source = self.config.get('source')
        if source is None or not len(source.strip()):
            log.error('Invalid source for %s: %s', self.name, source)
        else:
            log.info('Ingesting content from %s...', source)
            meta = self.config.get('meta', {})
            self.pipeline.collection.ingest(source, **meta)
