from setuptools import setup, find_packages

setup(
    name='docpipe',
    version='0.1',
    description="Process a set of documents using an abtract pipeline",
    long_description="",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
    ],
    keywords='',
    author='Friedrich Lindenberg',
    author_email='friedrich@pudo.org',
    url='http://pudo.org',
    license='MIT',
    packages=find_packages(exclude=['ez_setup', 'examples', 'tests']),
    namespace_packages=[],
    include_package_data=True,
    zip_safe=False,
    install_requires=[
        "docstash>=0.2",
        "stevedore>=0.15",
        "click>=3.2"
    ],
    entry_points={
        'docpipe.tasks': [
            'file_size = docpipe.tasks.file_size:FileSizeTask',
            'ingest = docpipe.tasks.ingest:IngestTask'
        ],
        'console_scripts': [
            'docpipe = docpipe.cli:cli'
        ]
    },
    tests_require=[]
)
