# Author: Miroslav Vasko
# Contact: zemiak@zoznam.sk
# Revision: $Revision: 1.5 $
# Date: $Date: 2003/06/03 02:15:45 $
# Copyright: This module has been placed in the public domain.

"""
Slovak-language mappings for language-dependent features of
reStructuredText.
"""

__docformat__ = 'reStructuredText'


directives = {
      u'pozor': 'attention',
      u'opatrne': 'caution',
      u'nebezpe\xe8enstvo': 'danger',
      u'chyba': 'error',
      u'rada': 'hint',
      u'd\xf4le\x9eit\xe9': 'important',
      u'pozn\xe1mka': 'note',
      u'tip': 'tip',
      u'varovanie': 'warning',
      u'admonition (translation required)': 'admonition',
      u'sidebar (translation required)': 'sidebar',
      u't\xe9ma': 'topic',
      u'blok-riadkov': 'line-block',
      u'parsed-literal': 'parsed-literal',
      u'rubric (translation required)': 'rubric',
      u'epigraph (translation required)': 'epigraph',
      u'highlights (translation required)': 'highlights',
      u'pull-quote (translation required)': 'pull-quote',
      #u'questions': 'questions',
      #u'qa': 'questions',
      #u'faq': 'questions',
      u'meta': 'meta',
      #u'imagemap': 'imagemap',
      u'obr\xe1zok': 'image',
      u'tvar': 'figure',
      u'vlo\x9ei\x9d': 'include',
      u'raw': 'raw',
      u'nahradi\x9d': 'replace',
      u'unicode': 'unicode',
      u'class (translation required)': 'class',
      u'obsah': 'contents',
      u'\xe8as\x9d': 'sectnum',
      u'\xe8as\x9d-\xe8\xedslovanie': 'sectnum',
      u'cie\xbeov\xe9-pozn\xe1mky': 'target-notes',
      #u'footnotes': 'footnotes',
      #u'citations': 'citations',
      }
"""Slovak name to registered (in directives/__init__.py) directive name
mapping."""
