import os
import sys
import logging
import time
import signal
import logging
from optparse import OptionParser

import tornado.ioloop
import tornado.web
import tornado.options
import tornado.httpserver
import tornado.autoreload


def run(routes):
    parser = OptionParser()
    parser.add_option("-p", "--port", dest="port", default=9000, type="int",
                      help="port to run the server on")
    parser.add_option("-d", "--debug", action="store_true", dest="debug",
                      help="run the server in debug mode")
    (options, args) = parser.parse_args()

    options.debug = options.debug if options.debug else False

    def shutdown(sig, frame):
        logging.info('Stopping the server')
        server.stop()
        if not options.debug:
            # give current connection 2 seconds to finish up but no in debug
            time.sleep(2)
        tornado.ioloop.IOLoop.instance().stop()

    # start the server
    application = tornado.web.Application(routes, port=options.port, debug=options.debug)
    server = tornado.httpserver.HTTPServer(application, xheaders=True)
    server.listen(options.port)

    signal.signal(signal.SIGINT, shutdown)
    signal.signal(signal.SIGTERM, shutdown)
    signal.signal(signal.SIGQUIT, shutdown)

    logging.info('Starting server on port {0}'.format(options.port))
    tornado.ioloop.IOLoop.instance().start()
