import os

import logging

from dorothy.lib.util import parse_config, to_attr_dict, AttrDict
from dorothy.lib.exceptions import SettingsError


class _Settings(object):
    DATA = 1
    CONFIG = 2

    def __init__(self, data=None, is_config=False):
        self.__dict__['__data'] = data or AttrDict()
        self.__dict__['__config'] = None

        if is_config:
            self.__dict__['__is'] = self.CONFIG
        else:
            self.__dict__['__is'] = self.DATA

    def get(self, attr, default=None):
        try:
            return getattr(self, attr)
        except:
            return default

    def __getattr__(self, name):
        if name == 'config' and self.__dict__['__is'] == self.DATA:
            if self.__dict__['__config'] is None:
                self.__dict__['__config'] = self.__class__(parse_config(self.environment), is_config=True)
            val = self.__dict__['__config']
        else:
            val = self.__dict__['__data'][name]
        if isinstance(val, dict):
            val = to_attr_dict(val)
        return val

    def __setattr__(self, name, val):
        self.__dict__['__data'][name] = val

    @property
    def environment(self):
        return os.environ.get(self.get('env', 'DOROTHY_ENVIRONMENT'), 'development')

    @property
    def log_level(self):
        logging_level = self.config.get('logging_level', 'debug')
        if logging_level == 'debug':
            return logging.DEBUG
        elif logging_level == 'warning':
            return logging.WARNING
        elif logging_level == 'info':
            return logging.INFO
        elif logging_level == 'critical':
            return logging.CRITICAL
        elif logging_level == 'error':
            return logging.ERROR


settings = _Settings()
