import bson
import json


class CusEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, bson.ObjectId):
            return str(obj)
        return json.JSONEncoder.default(self, obj)


def dumps(data):
    return json.dumps(data, cls=CusEncoder)


def loads(data):
    return json.loads(data)
