import os
import sys
import logging
import time
import signal
import logging
from optparse import OptionParser

import tornado.ioloop
import tornado.web
import tornado.options
import tornado.httpserver
import tornado.autoreload

from dorothy.settings import settings


def watch_dir(dirname, include_subdirs=True):
    """Add a dir and all of its files to the watch list.
    Any file or subdirectory that begins with a period is ignored.
    """
    for _root, _dirs, _files in os.walk(dirname):
        for _file in _files:
            if not _file.startswith('.'):
                tornado.autoreload.watch('/'.join([_root, _file]))
        if include_subdirs:
            for _dir in _dirs:
                if not _dir.startswith('.'):
                    watch_dir('/'.join([_root, _dir]))


def run(routes, **kwargs):
    parser = OptionParser()
    parser.add_option("-p", "--port", dest="port", default=9000, type="int",
                      help="port to run the server on")
    parser.add_option("-d", "--debug", action="store_true", dest="debug",
                      help="run the server in debug mode")
    (options, args) = parser.parse_args()

    options.debug = options.debug if options.debug else False
    settings.debug = options.debug
    settings.port = options.port

    for k, v in kwargs.iteritems():
        setattr(settings, k, v)

    logging.root.setLevel(settings.log_level)
    logger = logging.getLogger('dorothy')
    sh = logging.StreamHandler(stream=sys.stderr)
    sh.setLevel(settings.log_level)
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    sh.setFormatter(formatter)
    logger.addHandler(sh)
    settings.log = logger

    def shutdown(sig, frame):
        settings.log.info('Stopping the server')
        server.stop()
        if not options.debug:
            # give current connection 2 seconds to finish up but no in debug
            time.sleep(2)
        tornado.ioloop.IOLoop.instance().stop()

    # start the server
    app_args = kwargs.get('app', {})
    application = tornado.web.Application(routes, port=options.port, debug=options.debug, **app_args)
    server = tornado.httpserver.HTTPServer(application, xheaders=True)
    server.listen(options.port)

    signal.signal(signal.SIGINT, shutdown)
    signal.signal(signal.SIGTERM, shutdown)
    signal.signal(signal.SIGQUIT, shutdown)

    settings.log.info('Starting server on port {0}'.format(options.port))
    tornado.ioloop.IOLoop.instance().start()
