import random

import yaml

from dorothy.lib.exceptions import SettingsError


def gen_hash(l=25):
    chars = 'abcdefghijklmnopqrstuvwxys0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    r = []
    for x in range(0,l):
        r.append(chars[random.randint(0, len(chars)-1)])
    return ''.join(r)


def parse_config(name):
    from dorothy.settings import settings
    
    if not settings.get('config_path'):
        raise SettingsError('Can not load config file. No config_path set.')

    if name.endswith('.yml'):
        name = name[:-4]

    f = settings.config_path.strip('/')
    f = open('/{0}/{1}.yml'.format(f, name))
    return yaml.load(f.read())
