import functools
import hashlib

from dorothy.lib.util import parse_config

def require_params(*args, **kwargs):
    required_params = args
    def wrapper_a(fn, *args):
        @functools.wraps(fn)
        def wrapper(self, *args):
            missing = []
            req_args = self.query if self.method == 'get' else self.body
            for param in required_params:
                if param not in req_args or req_args[param] is None:
                    missing.append(param)
            if missing:
                self._handle_missing_params(missing)
            return fn(self, *args)
        return wrapper
    return wrapper_a


def authorize(*args, **kwargs):
    def wrapper_a(fn, *args):
        @functools.wraps(fn)
        def wrapper(self, *args):
            if not self.current_user:
                self.error(401, 'User could not be authenticated')
            return fn(self, *args)
        return wrapper
    return wrapper_a