import os
import random
from copy import deepcopy

import yaml

from dorothy.lib.exceptions import SettingsError


class AttrDict(dict):
    def __init__(self, init={}):
        dict.__init__(self, init)

    def __getstate__(self):
        return self.__dict__.items()

    def __setstate__(self, items):
        for key, val in items:
            self.__dict__[key] = val

    def __setitem__(self, key, value):
        return super(AttrDict, self).__setitem__(key, value)

    def __getitem__(self, name):
        return super(AttrDict, self).__getitem__(name)

    __getattr__ = __getitem__
    __setattr__ = __setitem__

    def copy(self):
        ch = AttrDict(self)
        return ch


def to_attr_dict(d):
    result = AttrDict()
    for k, v in d.iteritems():
        if isinstance(v, dict):
            v = to_attr_dict(v)
        result[k] = v
    return result


def dict_merge(a, b):
    if not isinstance(b, dict):
        return b
    result = deepcopy(a) or dict()
    for k, v in b.iteritems():
        if k in result and isinstance(result[k], dict):
                result[k] = dict_merge(result[k], v)
        else:
            result[k] = deepcopy(v)
    return to_attr_dict(result)


def gen_hash(l=25):
    chars = 'abcdefghijklmnopqrstuvwxys0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    r = []
    for x in range(0,l):
        r.append(chars[random.randint(0, len(chars)-1)])
    return ''.join(r)


def parse_config(name):
    from dorothy.settings import settings
    
    if not settings.get('config_path'):
        raise SettingsError('Can not load config file. No config_path set.')

    if name.endswith('.yml'):
        name = name[:-4]

    pth = settings.config_path.strip('/')
    f = open('/{0}/{1}.yml'.format(pth, name))
    c = yaml.load(f.read())

    gconfig = '/{0}/global.yml'.format(pth)
    if os.path.isfile(gconfig):
        g = open(gconfig)
        g = yaml.load(g.read())
        c = dict_merge(g, c)
    else:
        c = to_attr_dict(c)

    return c
