import os
import sys
import logging
import time
import signal
import logging
from optparse import OptionParser

import tornado.ioloop
import tornado.web
import tornado.options
import tornado.httpserver
import tornado.autoreload

from dorothy.settings import settings


def watch_dir(dirname, include_subdirs=True):
    """Add a dir and all of its files to the watch list.
    Any file or subdirectory that begins with a period is ignored.
    """
    for _root, _dirs, _files in os.walk(dirname):
        for _file in _files:
            if not _file.startswith('.'):
                tornado.autoreload.watch('/'.join([_root, _file]))
        if include_subdirs:
            for _dir in _dirs:
                if not _dir.startswith('.'):
                    watch_dir('/'.join([_root, _dir]))


class Dorothy(object):
    def __init__(self, routes=None, prelaunch=None, **kwargs):
        self._routes = routes
        self._prelaunch = prelaunch

        parser = OptionParser()
        parser.add_option("-p", "--port", dest="port", default=9000, type="int",
                          help="port to run the server on")
        parser.add_option("-d", "--debug", action="store_true", dest="debug",
                          help="run the server in debug mode")
        (self.options, self.args) = parser.parse_args()

        self.options.debug = self.options.debug if self.options.debug else False
        settings.debug = self.options.debug
        settings.port = self.options.port

        for k, v in kwargs.iteritems():
            if k != 'dorothy':
                setattr(settings, k, v)

        logging.root.setLevel(settings.log_level)
        logger = logging.getLogger('dorothy')
        sh = logging.StreamHandler(stream=sys.stderr)
        sh.setLevel(settings.log_level)
        formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
        sh.setFormatter(formatter)
        logger.addHandler(sh)
        settings.log = logger

    @property
    def routes(self):
        return self._routes

    @routes.setter
    def routes(self, val):
        self._routes = val

    @property
    def prelaunch(self):
        return self._prelaunch

    @prelaunch.setter
    def prelaunch(self, val):
        self._prelaunch = val

    def shutdown(self, sig, frame):
        settings.log.info('Stopping the server')
        self.server.stop()
        if not self.options.debug:
            # give current connection 2 seconds to finish up but no in debug
            time.sleep(2)
        settings.io_loop.stop()

    def run(self, **kwargs):
        application = tornado.web.Application(self.routes, port=self.options.port, debug=self.options.debug, **kwargs)
        self.server = tornado.httpserver.HTTPServer(application, xheaders=True)
        self.server.listen(self.options.port)

        signal.signal(signal.SIGINT, self.shutdown)
        signal.signal(signal.SIGTERM, self.shutdown)
        signal.signal(signal.SIGQUIT, self.shutdown)

        settings.io_loop = tornado.ioloop.IOLoop.instance()

        if self.prelaunch:
            self.prelaunch()

        settings.log.info('Starting server on port {0}'.format(self.options.port))
        settings.io_loop.start()
