from setuptools import setup
setup(
    name='dst',
    version='0.1.5',
    author='Jeroen Janssens',
    author_email='jeroen@jeroenjanssens.com',
    packages=['dst'],
    url='http://datasciencetoolbox.org',
    license='BSD',
    description='Data Science Toolbox -- Start doing data science in minutes.',
    long_description=open('README.txt').read(),
    install_requires=[
        "ansible >= 1.5",
    ],
    entry_points={
        'console_scripts': ['dst = dst.dst:main']
    },
    classifiers=[ # https://pypi.python.org/pypi?:action=list_classifiers
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Intended Audience :: Science/Research',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: BSD License',
        'Operating System :: POSIX :: Linux',
        'Topic :: Scientific/Engineering',
        'Topic :: Utilities',
        'Topic :: System :: Software Distribution',
        'Topic :: System :: Systems Administration',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Unix Shell',
    ],
)
