# http://www.w3.org/TR/xml-entity-names/

entities = {
'AElig':                'Æ', # LATIN CAPITAL LETTER AE
'AMP':                  '&', # AMPERSAND
'Aacgr':                'Ά', # GREEK CAPITAL LETTER ALPHA WITH TONOS
'Aacute':               'Á', # LATIN CAPITAL LETTER A WITH ACUTE
'Abreve':               'Ă', # LATIN CAPITAL LETTER A WITH BREVE
'Acirc':                'Â', # LATIN CAPITAL LETTER A WITH CIRCUMFLEX
'Acy':                  'А', # CYRILLIC CAPITAL LETTER A
'Afr':                  '𝔄', # MATHEMATICAL FRAKTUR CAPITAL A
'Agr':                  'Α', # GREEK CAPITAL LETTER ALPHA
'Agrave':               'À', # LATIN CAPITAL LETTER A WITH GRAVE
'Alpha':                'Α', # GREEK CAPITAL LETTER ALPHA
'Amacr':                'Ā', # LATIN CAPITAL LETTER A WITH MACRON
'And':                  '⩓', # DOUBLE LOGICAL AND
'Aogon':                'Ą', # LATIN CAPITAL LETTER A WITH OGONEK
'Aopf':                 '𝔸', # MATHEMATICAL DOUBLE-STRUCK CAPITAL A
'ApplyFunction':        '⁡', # FUNCTION APPLICATION
'Aring':                'Å', # LATIN CAPITAL LETTER A WITH RING ABOVE
'Ascr':                 '𝒜', # MATHEMATICAL SCRIPT CAPITAL A
'Assign':               '≔', # COLON EQUALS
'Atilde':               'Ã', # LATIN CAPITAL LETTER A WITH TILDE
'Auml':                 'Ä', # LATIN CAPITAL LETTER A WITH DIAERESIS
'Backslash':            '∖', # SET MINUS
'Barv':                 '⫧', # SHORT DOWN TACK WITH OVERBAR
'Barwed':               '⌆', # PERSPECTIVE
'Bcy':                  'Б', # CYRILLIC CAPITAL LETTER BE
'Because':              '∵', # BECAUSE
'Bernoullis':           'ℬ', # SCRIPT CAPITAL B
'Beta':                 'Β', # GREEK CAPITAL LETTER BETA
'Bfr':                  '𝔅', # MATHEMATICAL FRAKTUR CAPITAL B
'Bgr':                  'Β', # GREEK CAPITAL LETTER BETA
'Bopf':                 '𝔹', # MATHEMATICAL DOUBLE-STRUCK CAPITAL B
'Breve':                '˘', # BREVE
'Bscr':                 'ℬ', # SCRIPT CAPITAL B
'Bumpeq':               '≎', # GEOMETRICALLY EQUIVALENT TO
'CHcy':                 'Ч', # CYRILLIC CAPITAL LETTER CHE
'COPY':                 '©', # COPYRIGHT SIGN
'Cacute':               'Ć', # LATIN CAPITAL LETTER C WITH ACUTE
'Cap':                  '⋒', # DOUBLE INTERSECTION
'CapitalDifferentialD': 'ⅅ', # DOUBLE-STRUCK ITALIC CAPITAL D
'Cayleys':              'ℭ', # BLACK-LETTER CAPITAL C
'Ccaron':               'Č', # LATIN CAPITAL LETTER C WITH CARON
'Ccedil':               'Ç', # LATIN CAPITAL LETTER C WITH CEDILLA
'Ccirc':                'Ĉ', # LATIN CAPITAL LETTER C WITH CIRCUMFLEX
'Cconint':              '∰', # VOLUME INTEGRAL
'Cdot':                 'Ċ', # LATIN CAPITAL LETTER C WITH DOT ABOVE
'Cedilla':              '¸', # CEDILLA
'CenterDot':            '·', # MIDDLE DOT
'Cfr':                  'ℭ', # BLACK-LETTER CAPITAL C
'Chi':                  'Χ', # GREEK CAPITAL LETTER CHI
'CircleDot':            '⊙', # CIRCLED DOT OPERATOR
'CircleMinus':          '⊖', # CIRCLED MINUS
'CirclePlus':           '⊕', # CIRCLED PLUS
'CircleTimes':          '⊗', # CIRCLED TIMES
'ClockwiseContourIntegral': '∲', # CLOCKWISE CONTOUR INTEGRAL
'CloseCurlyDoubleQuote': '”', # RIGHT DOUBLE QUOTATION MARK
'CloseCurlyQuote':      '’', # RIGHT SINGLE QUOTATION MARK
'Colon':                '∷', # PROPORTION
'Colone':               '⩴', # DOUBLE COLON EQUAL
'Congruent':            '≡', # IDENTICAL TO
'Conint':               '∯', # SURFACE INTEGRAL
'ContourIntegral':      '∮', # CONTOUR INTEGRAL
'Copf':                 'ℂ', # DOUBLE-STRUCK CAPITAL C
'Coproduct':            '∐', # N-ARY COPRODUCT
'CounterClockwiseContourIntegral': '∳', # ANTICLOCKWISE CONTOUR INTEGRAL
'Cross':                '⨯', # VECTOR OR CROSS PRODUCT
'Cscr':                 '𝒞', # MATHEMATICAL SCRIPT CAPITAL C
'Cup':                  '⋓', # DOUBLE UNION
'CupCap':               '≍', # EQUIVALENT TO
'DD':                   'ⅅ', # DOUBLE-STRUCK ITALIC CAPITAL D
'DDotrahd':             '⤑', # RIGHTWARDS ARROW WITH DOTTED STEM
'DJcy':                 'Ђ', # CYRILLIC CAPITAL LETTER DJE
'DScy':                 'Ѕ', # CYRILLIC CAPITAL LETTER DZE
'DZcy':                 'Џ', # CYRILLIC CAPITAL LETTER DZHE
'Dagger':               '‡', # DOUBLE DAGGER
'Darr':                 '↡', # DOWNWARDS TWO HEADED ARROW
'Dashv':                '⫤', # VERTICAL BAR DOUBLE LEFT TURNSTILE
'Dcaron':               'Ď', # LATIN CAPITAL LETTER D WITH CARON
'Dcy':                  'Д', # CYRILLIC CAPITAL LETTER DE
'Del':                  '∇', # NABLA
'Delta':                'Δ', # GREEK CAPITAL LETTER DELTA
'Dfr':                  '𝔇', # MATHEMATICAL FRAKTUR CAPITAL D
'Dgr':                  'Δ', # GREEK CAPITAL LETTER DELTA
'DiacriticalAcute':     '´', # ACUTE ACCENT
'DiacriticalDot':       '˙', # DOT ABOVE
'DiacriticalDoubleAcute': '˝', # DOUBLE ACUTE ACCENT
'DiacriticalGrave':     '`', # GRAVE ACCENT
'DiacriticalTilde':     '˜', # SMALL TILDE
'Diamond':              '⋄', # DIAMOND OPERATOR
'DifferentialD':        'ⅆ', # DOUBLE-STRUCK ITALIC SMALL D
'Dopf':                 '𝔻', # MATHEMATICAL DOUBLE-STRUCK CAPITAL D
'Dot':                  '¨', # DIAERESIS
'DotDot':               '\u20DC', # COMBINING FOUR DOTS ABOVE
'DotEqual':             '≐', # APPROACHES THE LIMIT
'DoubleContourIntegral': '∯', # SURFACE INTEGRAL
'DoubleDot':            '¨', # DIAERESIS
'DoubleDownArrow':      '⇓', # DOWNWARDS DOUBLE ARROW
'DoubleLeftArrow':      '⇐', # LEFTWARDS DOUBLE ARROW
'DoubleLeftRightArrow': '⇔', # LEFT RIGHT DOUBLE ARROW
'DoubleLeftTee':        '⫤', # VERTICAL BAR DOUBLE LEFT TURNSTILE
'DoubleLongLeftArrow':  '⟸', # LONG LEFTWARDS DOUBLE ARROW
'DoubleLongLeftRightArrow': '⟺', # LONG LEFT RIGHT DOUBLE ARROW
'DoubleLongRightArrow': '⟹', # LONG RIGHTWARDS DOUBLE ARROW
'DoubleRightArrow':     '⇒', # RIGHTWARDS DOUBLE ARROW
'DoubleRightTee':       '⊨', # TRUE
'DoubleUpArrow':        '⇑', # UPWARDS DOUBLE ARROW
'DoubleUpDownArrow':    '⇕', # UP DOWN DOUBLE ARROW
'DoubleVerticalBar':    '∥', # PARALLEL TO
'DownArrow':            '↓', # DOWNWARDS ARROW
'DownArrowBar':         '⤓', # DOWNWARDS ARROW TO BAR
'DownArrowUpArrow':     '⇵', # DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
'DownBreve':            '\u0311', # COMBINING INVERTED BREVE
'DownLeftRightVector':  '⥐', # LEFT BARB DOWN RIGHT BARB DOWN HARPOON
'DownLeftTeeVector':    '⥞', # LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
'DownLeftVector':       '↽', # LEFTWARDS HARPOON WITH BARB DOWNWARDS
'DownLeftVectorBar':    '⥖', # LEFTWARDS HARPOON WITH BARB DOWN TO BAR
'DownRightTeeVector':   '⥟', # RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
'DownRightVector':      '⇁', # RIGHTWARDS HARPOON WITH BARB DOWNWARDS
'DownRightVectorBar':   '⥗', # RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
'DownTee':              '⊤', # DOWN TACK
'DownTeeArrow':         '↧', # DOWNWARDS ARROW FROM BAR
'Downarrow':            '⇓', # DOWNWARDS DOUBLE ARROW
'Dscr':                 '𝒟', # MATHEMATICAL SCRIPT CAPITAL D
'Dstrok':               'Đ', # LATIN CAPITAL LETTER D WITH STROKE
'EEacgr':               'Ή', # GREEK CAPITAL LETTER ETA WITH TONOS
'EEgr':                 'Η', # GREEK CAPITAL LETTER ETA
'ENG':                  'Ŋ', # LATIN CAPITAL LETTER ENG
'ETH':                  'Ð', # LATIN CAPITAL LETTER ETH
'Eacgr':                'Έ', # GREEK CAPITAL LETTER EPSILON WITH TONOS
'Eacute':               'É', # LATIN CAPITAL LETTER E WITH ACUTE
'Ecaron':               'Ě', # LATIN CAPITAL LETTER E WITH CARON
'Ecirc':                'Ê', # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
'Ecy':                  'Э', # CYRILLIC CAPITAL LETTER E
'Edot':                 'Ė', # LATIN CAPITAL LETTER E WITH DOT ABOVE
'Efr':                  '𝔈', # MATHEMATICAL FRAKTUR CAPITAL E
'Egr':                  'Ε', # GREEK CAPITAL LETTER EPSILON
'Egrave':               'È', # LATIN CAPITAL LETTER E WITH GRAVE
'Element':              '∈', # ELEMENT OF
'Emacr':                'Ē', # LATIN CAPITAL LETTER E WITH MACRON
'EmptySmallSquare':     '◻', # WHITE MEDIUM SQUARE
'EmptyVerySmallSquare': '▫', # WHITE SMALL SQUARE
'Eogon':                'Ę', # LATIN CAPITAL LETTER E WITH OGONEK
'Eopf':                 '𝔼', # MATHEMATICAL DOUBLE-STRUCK CAPITAL E
'Epsilon':              'Ε', # GREEK CAPITAL LETTER EPSILON
'Equal':                '⩵', # TWO CONSECUTIVE EQUALS SIGNS
'EqualTilde':           '≂', # MINUS TILDE
'Equilibrium':          '⇌', # RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
'Escr':                 'ℰ', # SCRIPT CAPITAL E
'Esim':                 '⩳', # EQUALS SIGN ABOVE TILDE OPERATOR
'Eta':                  'Η', # GREEK CAPITAL LETTER ETA
'Euml':                 'Ë', # LATIN CAPITAL LETTER E WITH DIAERESIS
'Exists':               '∃', # THERE EXISTS
'ExponentialE':         'ⅇ', # DOUBLE-STRUCK ITALIC SMALL E
'Fcy':                  'Ф', # CYRILLIC CAPITAL LETTER EF
'Ffr':                  '𝔉', # MATHEMATICAL FRAKTUR CAPITAL F
'FilledSmallSquare':    '◼', # BLACK MEDIUM SQUARE
'FilledVerySmallSquare': '▪', # BLACK SMALL SQUARE
'Fopf':                 '𝔽', # MATHEMATICAL DOUBLE-STRUCK CAPITAL F
'ForAll':               '∀', # FOR ALL
'Fouriertrf':           'ℱ', # SCRIPT CAPITAL F
'Fscr':                 'ℱ', # SCRIPT CAPITAL F
'GJcy':                 'Ѓ', # CYRILLIC CAPITAL LETTER GJE
'GT':                   '>', # GREATER-THAN SIGN
'Gamma':                'Γ', # GREEK CAPITAL LETTER GAMMA
'Gammad':               'Ϝ', # GREEK LETTER DIGAMMA
'Gbreve':               'Ğ', # LATIN CAPITAL LETTER G WITH BREVE
'Gcedil':               'Ģ', # LATIN CAPITAL LETTER G WITH CEDILLA
'Gcirc':                'Ĝ', # LATIN CAPITAL LETTER G WITH CIRCUMFLEX
'Gcy':                  'Г', # CYRILLIC CAPITAL LETTER GHE
'Gdot':                 'Ġ', # LATIN CAPITAL LETTER G WITH DOT ABOVE
'Gfr':                  '𝔊', # MATHEMATICAL FRAKTUR CAPITAL G
'Gg':                   '⋙', # VERY MUCH GREATER-THAN
'Ggr':                  'Γ', # GREEK CAPITAL LETTER GAMMA
'Gopf':                 '𝔾', # MATHEMATICAL DOUBLE-STRUCK CAPITAL G
'GreaterEqual':         '≥', # GREATER-THAN OR EQUAL TO
'GreaterEqualLess':     '⋛', # GREATER-THAN EQUAL TO OR LESS-THAN
'GreaterFullEqual':     '≧', # GREATER-THAN OVER EQUAL TO
'GreaterGreater':       '⪢', # DOUBLE NESTED GREATER-THAN
'GreaterLess':          '≷', # GREATER-THAN OR LESS-THAN
'GreaterSlantEqual':    '⩾', # GREATER-THAN OR SLANTED EQUAL TO
'GreaterTilde':         '≳', # GREATER-THAN OR EQUIVALENT TO
'Gscr':                 '𝒢', # MATHEMATICAL SCRIPT CAPITAL G
'Gt':                   '≫', # MUCH GREATER-THAN
'HARDcy':               'Ъ', # CYRILLIC CAPITAL LETTER HARD SIGN
'Hacek':                'ˇ', # CARON
'Hat':                  '^', # CIRCUMFLEX ACCENT
'Hcirc':                'Ĥ', # LATIN CAPITAL LETTER H WITH CIRCUMFLEX
'Hfr':                  'ℌ', # BLACK-LETTER CAPITAL H
'HilbertSpace':         'ℋ', # SCRIPT CAPITAL H
'Hopf':                 'ℍ', # DOUBLE-STRUCK CAPITAL H
'HorizontalLine':       '─', # BOX DRAWINGS LIGHT HORIZONTAL
'Hscr':                 'ℋ', # SCRIPT CAPITAL H
'Hstrok':               'Ħ', # LATIN CAPITAL LETTER H WITH STROKE
'HumpDownHump':         '≎', # GEOMETRICALLY EQUIVALENT TO
'HumpEqual':            '≏', # DIFFERENCE BETWEEN
'IEcy':                 'Е', # CYRILLIC CAPITAL LETTER IE
'IJlig':                'Ĳ', # LATIN CAPITAL LIGATURE IJ
'IOcy':                 'Ё', # CYRILLIC CAPITAL LETTER IO
'Iacgr':                'Ί', # GREEK CAPITAL LETTER IOTA WITH TONOS
'Iacute':               'Í', # LATIN CAPITAL LETTER I WITH ACUTE
'Icirc':                'Î', # LATIN CAPITAL LETTER I WITH CIRCUMFLEX
'Icy':                  'И', # CYRILLIC CAPITAL LETTER I
'Idigr':                'Ϊ', # GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
'Idot':                 'İ', # LATIN CAPITAL LETTER I WITH DOT ABOVE
'Ifr':                  'ℑ', # BLACK-LETTER CAPITAL I
'Igr':                  'Ι', # GREEK CAPITAL LETTER IOTA
'Igrave':               'Ì', # LATIN CAPITAL LETTER I WITH GRAVE
'Im':                   'ℑ', # BLACK-LETTER CAPITAL I
'Imacr':                'Ī', # LATIN CAPITAL LETTER I WITH MACRON
'ImaginaryI':           'ⅈ', # DOUBLE-STRUCK ITALIC SMALL I
'Implies':              '⇒', # RIGHTWARDS DOUBLE ARROW
'Int':                  '∬', # DOUBLE INTEGRAL
'Integral':             '∫', # INTEGRAL
'Intersection':         '⋂', # N-ARY INTERSECTION
'InvisibleComma':       '⁣', # INVISIBLE SEPARATOR
'InvisibleTimes':       '⁢', # INVISIBLE TIMES
'Iogon':                'Į', # LATIN CAPITAL LETTER I WITH OGONEK
'Iopf':                 '𝕀', # MATHEMATICAL DOUBLE-STRUCK CAPITAL I
'Iota':                 'Ι', # GREEK CAPITAL LETTER IOTA
'Iscr':                 'ℐ', # SCRIPT CAPITAL I
'Itilde':               'Ĩ', # LATIN CAPITAL LETTER I WITH TILDE
'Iukcy':                'І', # CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
'Iuml':                 'Ï', # LATIN CAPITAL LETTER I WITH DIAERESIS
'Jcirc':                'Ĵ', # LATIN CAPITAL LETTER J WITH CIRCUMFLEX
'Jcy':                  'Й', # CYRILLIC CAPITAL LETTER SHORT I
'Jfr':                  '𝔍', # MATHEMATICAL FRAKTUR CAPITAL J
'Jopf':                 '𝕁', # MATHEMATICAL DOUBLE-STRUCK CAPITAL J
'Jscr':                 '𝒥', # MATHEMATICAL SCRIPT CAPITAL J
'Jsercy':               'Ј', # CYRILLIC CAPITAL LETTER JE
'Jukcy':                'Є', # CYRILLIC CAPITAL LETTER UKRAINIAN IE
'KHcy':                 'Х', # CYRILLIC CAPITAL LETTER HA
'KHgr':                 'Χ', # GREEK CAPITAL LETTER CHI
'KJcy':                 'Ќ', # CYRILLIC CAPITAL LETTER KJE
'Kappa':                'Κ', # GREEK CAPITAL LETTER KAPPA
'Kcedil':               'Ķ', # LATIN CAPITAL LETTER K WITH CEDILLA
'Kcy':                  'К', # CYRILLIC CAPITAL LETTER KA
'Kfr':                  '𝔎', # MATHEMATICAL FRAKTUR CAPITAL K
'Kgr':                  'Κ', # GREEK CAPITAL LETTER KAPPA
'Kopf':                 '𝕂', # MATHEMATICAL DOUBLE-STRUCK CAPITAL K
'Kscr':                 '𝒦', # MATHEMATICAL SCRIPT CAPITAL K
'LJcy':                 'Љ', # CYRILLIC CAPITAL LETTER LJE
'LT':                   '&', # LESS-THAN SIGN
'Lacute':               'Ĺ', # LATIN CAPITAL LETTER L WITH ACUTE
'Lambda':               'Λ', # GREEK CAPITAL LETTER LAMDA
'Lang':                 '⟪', # MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
'Laplacetrf':           'ℒ', # SCRIPT CAPITAL L
'Larr':                 '↞', # LEFTWARDS TWO HEADED ARROW
'Lcaron':               'Ľ', # LATIN CAPITAL LETTER L WITH CARON
'Lcedil':               'Ļ', # LATIN CAPITAL LETTER L WITH CEDILLA
'Lcy':                  'Л', # CYRILLIC CAPITAL LETTER EL
'LeftAngleBracket':     '⟨', # MATHEMATICAL LEFT ANGLE BRACKET
'LeftArrow':            '←', # LEFTWARDS ARROW
'LeftArrowBar':         '⇤', # LEFTWARDS ARROW TO BAR
'LeftArrowRightArrow':  '⇆', # LEFTWARDS ARROW OVER RIGHTWARDS ARROW
'LeftCeiling':          '⌈', # LEFT CEILING
'LeftDoubleBracket':    '⟦', # MATHEMATICAL LEFT WHITE SQUARE BRACKET
'LeftDownTeeVector':    '⥡', # DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
'LeftDownVector':       '⇃', # DOWNWARDS HARPOON WITH BARB LEFTWARDS
'LeftDownVectorBar':    '⥙', # DOWNWARDS HARPOON WITH BARB LEFT TO BAR
'LeftFloor':            '⌊', # LEFT FLOOR
'LeftRightArrow':       '↔', # LEFT RIGHT ARROW
'LeftRightVector':      '⥎', # LEFT BARB UP RIGHT BARB UP HARPOON
'LeftTee':              '⊣', # LEFT TACK
'LeftTeeArrow':         '↤', # LEFTWARDS ARROW FROM BAR
'LeftTeeVector':        '⥚', # LEFTWARDS HARPOON WITH BARB UP FROM BAR
'LeftTriangle':         '⊲', # NORMAL SUBGROUP OF
'LeftTriangleBar':      '⧏', # LEFT TRIANGLE BESIDE VERTICAL BAR
'LeftTriangleEqual':    '⊴', # NORMAL SUBGROUP OF OR EQUAL TO
'LeftUpDownVector':     '⥑', # UP BARB LEFT DOWN BARB LEFT HARPOON
'LeftUpTeeVector':      '⥠', # UPWARDS HARPOON WITH BARB LEFT FROM BAR
'LeftUpVector':         '↿', # UPWARDS HARPOON WITH BARB LEFTWARDS
'LeftUpVectorBar':      '⥘', # UPWARDS HARPOON WITH BARB LEFT TO BAR
'LeftVector':           '↼', # LEFTWARDS HARPOON WITH BARB UPWARDS
'LeftVectorBar':        '⥒', # LEFTWARDS HARPOON WITH BARB UP TO BAR
'Leftarrow':            '⇐', # LEFTWARDS DOUBLE ARROW
'Leftrightarrow':       '⇔', # LEFT RIGHT DOUBLE ARROW
'LessEqualGreater':     '⋚', # LESS-THAN EQUAL TO OR GREATER-THAN
'LessFullEqual':        '≦', # LESS-THAN OVER EQUAL TO
'LessGreater':          '≶', # LESS-THAN OR GREATER-THAN
'LessLess':             '⪡', # DOUBLE NESTED LESS-THAN
'LessSlantEqual':       '⩽', # LESS-THAN OR SLANTED EQUAL TO
'LessTilde':            '≲', # LESS-THAN OR EQUIVALENT TO
'Lfr':                  '𝔏', # MATHEMATICAL FRAKTUR CAPITAL L
'Lgr':                  'Λ', # GREEK CAPITAL LETTER LAMDA
'Ll':                   '⋘', # VERY MUCH LESS-THAN
'Lleftarrow':           '⇚', # LEFTWARDS TRIPLE ARROW
'Lmidot':               'Ŀ', # LATIN CAPITAL LETTER L WITH MIDDLE DOT
'LongLeftArrow':        '⟵', # LONG LEFTWARDS ARROW
'LongLeftRightArrow':   '⟷', # LONG LEFT RIGHT ARROW
'LongRightArrow':       '⟶', # LONG RIGHTWARDS ARROW
'Longleftarrow':        '⟸', # LONG LEFTWARDS DOUBLE ARROW
'Longleftrightarrow':   '⟺', # LONG LEFT RIGHT DOUBLE ARROW
'Longrightarrow':       '⟹', # LONG RIGHTWARDS DOUBLE ARROW
'Lopf':                 '𝕃', # MATHEMATICAL DOUBLE-STRUCK CAPITAL L
'LowerLeftArrow':       '↙', # SOUTH WEST ARROW
'LowerRightArrow':      '↘', # SOUTH EAST ARROW
'Lscr':                 'ℒ', # SCRIPT CAPITAL L
'Lsh':                  '↰', # UPWARDS ARROW WITH TIP LEFTWARDS
'Lstrok':               'Ł', # LATIN CAPITAL LETTER L WITH STROKE
'Lt':                   '≪', # MUCH LESS-THAN
'Map':                  '⤅', # RIGHTWARDS TWO-HEADED ARROW FROM BAR
'Mcy':                  'М', # CYRILLIC CAPITAL LETTER EM
'MediumSpace':          ' ', # MEDIUM MATHEMATICAL SPACE
'Mellintrf':            'ℳ', # SCRIPT CAPITAL M
'Mfr':                  '𝔐', # MATHEMATICAL FRAKTUR CAPITAL M
'Mgr':                  'Μ', # GREEK CAPITAL LETTER MU
'MinusPlus':            '∓', # MINUS-OR-PLUS SIGN
'Mopf':                 '𝕄', # MATHEMATICAL DOUBLE-STRUCK CAPITAL M
'Mscr':                 'ℳ', # SCRIPT CAPITAL M
'Mu':                   'Μ', # GREEK CAPITAL LETTER MU
'NJcy':                 'Њ', # CYRILLIC CAPITAL LETTER NJE
'Nacute':               'Ń', # LATIN CAPITAL LETTER N WITH ACUTE
'Ncaron':               'Ň', # LATIN CAPITAL LETTER N WITH CARON
'Ncedil':               'Ņ', # LATIN CAPITAL LETTER N WITH CEDILLA
'Ncy':                  'Н', # CYRILLIC CAPITAL LETTER EN
'NegativeMediumSpace':  '​', # ZERO WIDTH SPACE
'NegativeThickSpace':   '​', # ZERO WIDTH SPACE
'NegativeThinSpace':    '​', # ZERO WIDTH SPACE
'NegativeVeryThinSpace': '​', # ZERO WIDTH SPACE
'NestedGreaterGreater': '≫', # MUCH GREATER-THAN
'NestedLessLess':       '≪', # MUCH LESS-THAN
'NewLine':              '\u000A', # LINE FEED (LF)
'Nfr':                  '𝔑', # MATHEMATICAL FRAKTUR CAPITAL N
'Ngr':                  'Ν', # GREEK CAPITAL LETTER NU
'NoBreak':              '⁠', # WORD JOINER
'NonBreakingSpace':     ' ', # NO-BREAK SPACE
'Nopf':                 'ℕ', # DOUBLE-STRUCK CAPITAL N
'Not':                  '⫬', # DOUBLE STROKE NOT SIGN
'NotCongruent':         '≢', # NOT IDENTICAL TO
'NotCupCap':            '≭', # NOT EQUIVALENT TO
'NotDoubleVerticalBar': '∦', # NOT PARALLEL TO
'NotElement':           '∉', # NOT AN ELEMENT OF
'NotEqual':             '≠', # NOT EQUAL TO
'NotEqualTilde':        '≂̸', # MINUS TILDE with slash
'NotExists':            '∄', # THERE DOES NOT EXIST
'NotGreater':           '≯', # NOT GREATER-THAN
'NotGreaterEqual':      '≱', # NEITHER GREATER-THAN NOR EQUAL TO
'NotGreaterFullEqual':  '≧̸', # GREATER-THAN OVER EQUAL TO with slash
'NotGreaterGreater':    '≫̸', # MUCH GREATER THAN with slash
'NotGreaterLess':       '≹', # NEITHER GREATER-THAN NOR LESS-THAN
'NotGreaterSlantEqual': '⩾̸', # GREATER-THAN OR SLANTED EQUAL TO with slash
'NotGreaterTilde':      '≵', # NEITHER GREATER-THAN NOR EQUIVALENT TO
'NotHumpDownHump':      '≎̸', # GEOMETRICALLY EQUIVALENT TO with slash
'NotHumpEqual':         '≏̸', # DIFFERENCE BETWEEN with slash
'NotLeftTriangle':      '⋪', # NOT NORMAL SUBGROUP OF
'NotLeftTriangleBar':   '⧏̸', # LEFT TRIANGLE BESIDE VERTICAL BAR with slash
'NotLeftTriangleEqual': '⋬', # NOT NORMAL SUBGROUP OF OR EQUAL TO
'NotLess':              '≮', # NOT LESS-THAN
'NotLessEqual':         '≰', # NEITHER LESS-THAN NOR EQUAL TO
'NotLessGreater':       '≸', # NEITHER LESS-THAN NOR GREATER-THAN
'NotLessLess':          '≪̸', # MUCH LESS THAN with slash
'NotLessSlantEqual':    '⩽̸', # LESS-THAN OR SLANTED EQUAL TO with slash
'NotLessTilde':         '≴', # NEITHER LESS-THAN NOR EQUIVALENT TO
'NotNestedGreaterGreater': '⪢̸', # DOUBLE NESTED GREATER-THAN with slash
'NotNestedLessLess':    '⪡̸', # DOUBLE NESTED LESS-THAN with slash
'NotPrecedes':          '⊀', # DOES NOT PRECEDE
'NotPrecedesEqual':     '⪯̸', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash
'NotPrecedesSlantEqual': '⋠', # DOES NOT PRECEDE OR EQUAL
'NotReverseElement':    '∌', # DOES NOT CONTAIN AS MEMBER
'NotRightTriangle':     '⋫', # DOES NOT CONTAIN AS NORMAL SUBGROUP
'NotRightTriangleBar':  '⧐̸', # VERTICAL BAR BESIDE RIGHT TRIANGLE with slash
'NotRightTriangleEqual': '⋭', # DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
'NotSquareSubset':      '⊏̸', # SQUARE IMAGE OF with slash
'NotSquareSubsetEqual': '⋢', # NOT SQUARE IMAGE OF OR EQUAL TO
'NotSquareSuperset':    '⊐̸', # SQUARE ORIGINAL OF with slash
'NotSquareSupersetEqual': '⋣', # NOT SQUARE ORIGINAL OF OR EQUAL TO
'NotSubset':            '⊂⃒', # SUBSET OF with vertical line
'NotSubsetEqual':       '⊈', # NEITHER A SUBSET OF NOR EQUAL TO
'NotSucceeds':          '⊁', # DOES NOT SUCCEED
'NotSucceedsEqual':     '⪰̸', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash
'NotSucceedsSlantEqual': '⋡', # DOES NOT SUCCEED OR EQUAL
'NotSucceedsTilde':     '≿̸', # SUCCEEDS OR EQUIVALENT TO with slash
'NotSuperset':          '⊃⃒', # SUPERSET OF with vertical line
'NotSupersetEqual':     '⊉', # NEITHER A SUPERSET OF NOR EQUAL TO
'NotTilde':             '≁', # NOT TILDE
'NotTildeEqual':        '≄', # NOT ASYMPTOTICALLY EQUAL TO
'NotTildeFullEqual':    '≇', # NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
'NotTildeTilde':        '≉', # NOT ALMOST EQUAL TO
'NotVerticalBar':       '∤', # DOES NOT DIVIDE
'Nscr':                 '𝒩', # MATHEMATICAL SCRIPT CAPITAL N
'Ntilde':               'Ñ', # LATIN CAPITAL LETTER N WITH TILDE
'Nu':                   'Ν', # GREEK CAPITAL LETTER NU
'OElig':                'Œ', # LATIN CAPITAL LIGATURE OE
'OHacgr':               'Ώ', # GREEK CAPITAL LETTER OMEGA WITH TONOS
'OHgr':                 'Ω', # GREEK CAPITAL LETTER OMEGA
'Oacgr':                'Ό', # GREEK CAPITAL LETTER OMICRON WITH TONOS
'Oacute':               'Ó', # LATIN CAPITAL LETTER O WITH ACUTE
'Ocirc':                'Ô', # LATIN CAPITAL LETTER O WITH CIRCUMFLEX
'Ocy':                  'О', # CYRILLIC CAPITAL LETTER O
'Odblac':               'Ő', # LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
'Ofr':                  '𝔒', # MATHEMATICAL FRAKTUR CAPITAL O
'Ogr':                  'Ο', # GREEK CAPITAL LETTER OMICRON
'Ograve':               'Ò', # LATIN CAPITAL LETTER O WITH GRAVE
'Omacr':                'Ō', # LATIN CAPITAL LETTER O WITH MACRON
'Omega':                'Ω', # GREEK CAPITAL LETTER OMEGA
'Omicron':              'Ο', # GREEK CAPITAL LETTER OMICRON
'Oopf':                 '𝕆', # MATHEMATICAL DOUBLE-STRUCK CAPITAL O
'OpenCurlyDoubleQuote': '“', # LEFT DOUBLE QUOTATION MARK
'OpenCurlyQuote':       '‘', # LEFT SINGLE QUOTATION MARK
'Or':                   '⩔', # DOUBLE LOGICAL OR
'Oscr':                 '𝒪', # MATHEMATICAL SCRIPT CAPITAL O
'Oslash':               'Ø', # LATIN CAPITAL LETTER O WITH STROKE
'Otilde':               'Õ', # LATIN CAPITAL LETTER O WITH TILDE
'Otimes':               '⨷', # MULTIPLICATION SIGN IN DOUBLE CIRCLE
'Ouml':                 'Ö', # LATIN CAPITAL LETTER O WITH DIAERESIS
'OverBar':              '‾', # OVERLINE
'OverBrace':            '⏞', # TOP CURLY BRACKET
'OverBracket':          '⎴', # TOP SQUARE BRACKET
'OverParenthesis':      '⏜', # TOP PARENTHESIS
'PHgr':                 'Φ', # GREEK CAPITAL LETTER PHI
'PSgr':                 'Ψ', # GREEK CAPITAL LETTER PSI
'PartialD':             '∂', # PARTIAL DIFFERENTIAL
'Pcy':                  'П', # CYRILLIC CAPITAL LETTER PE
'Pfr':                  '𝔓', # MATHEMATICAL FRAKTUR CAPITAL P
'Pgr':                  'Π', # GREEK CAPITAL LETTER PI
'Phi':                  'Φ', # GREEK CAPITAL LETTER PHI
'Pi':                   'Π', # GREEK CAPITAL LETTER PI
'PlusMinus':            '±', # PLUS-MINUS SIGN
'Poincareplane':        'ℌ', # BLACK-LETTER CAPITAL H
'Popf':                 'ℙ', # DOUBLE-STRUCK CAPITAL P
'Pr':                   '⪻', # DOUBLE PRECEDES
'Precedes':             '≺', # PRECEDES
'PrecedesEqual':        '⪯', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
'PrecedesSlantEqual':   '≼', # PRECEDES OR EQUAL TO
'PrecedesTilde':        '≾', # PRECEDES OR EQUIVALENT TO
'Prime':                '″', # DOUBLE PRIME
'Product':              '∏', # N-ARY PRODUCT
'Proportion':           '∷', # PROPORTION
'Proportional':         '∝', # PROPORTIONAL TO
'Pscr':                 '𝒫', # MATHEMATICAL SCRIPT CAPITAL P
'Psi':                  'Ψ', # GREEK CAPITAL LETTER PSI
'QUOT':                 '"', # QUOTATION MARK
'Qfr':                  '𝔔', # MATHEMATICAL FRAKTUR CAPITAL Q
'Qopf':                 'ℚ', # DOUBLE-STRUCK CAPITAL Q
'Qscr':                 '𝒬', # MATHEMATICAL SCRIPT CAPITAL Q
'RBarr':                '⤐', # RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
'REG':                  '®', # REGISTERED SIGN
'Racute':               'Ŕ', # LATIN CAPITAL LETTER R WITH ACUTE
'Rang':                 '⟫', # MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
'Rarr':                 '↠', # RIGHTWARDS TWO HEADED ARROW
'Rarrtl':               '⤖', # RIGHTWARDS TWO-HEADED ARROW WITH TAIL
'Rcaron':               'Ř', # LATIN CAPITAL LETTER R WITH CARON
'Rcedil':               'Ŗ', # LATIN CAPITAL LETTER R WITH CEDILLA
'Rcy':                  'Р', # CYRILLIC CAPITAL LETTER ER
'Re':                   'ℜ', # BLACK-LETTER CAPITAL R
'ReverseElement':       '∋', # CONTAINS AS MEMBER
'ReverseEquilibrium':   '⇋', # LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
'ReverseUpEquilibrium': '⥯', # DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
'Rfr':                  'ℜ', # BLACK-LETTER CAPITAL R
'Rgr':                  'Ρ', # GREEK CAPITAL LETTER RHO
'Rho':                  'Ρ', # GREEK CAPITAL LETTER RHO
'RightAngleBracket':    '⟩', # MATHEMATICAL RIGHT ANGLE BRACKET
'RightArrow':           '→', # RIGHTWARDS ARROW
'RightArrowBar':        '⇥', # RIGHTWARDS ARROW TO BAR
'RightArrowLeftArrow':  '⇄', # RIGHTWARDS ARROW OVER LEFTWARDS ARROW
'RightCeiling':         '⌉', # RIGHT CEILING
'RightDoubleBracket':   '⟧', # MATHEMATICAL RIGHT WHITE SQUARE BRACKET
'RightDownTeeVector':   '⥝', # DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
'RightDownVector':      '⇂', # DOWNWARDS HARPOON WITH BARB RIGHTWARDS
'RightDownVectorBar':   '⥕', # DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
'RightFloor':           '⌋', # RIGHT FLOOR
'RightTee':             '⊢', # RIGHT TACK
'RightTeeArrow':        '↦', # RIGHTWARDS ARROW FROM BAR
'RightTeeVector':       '⥛', # RIGHTWARDS HARPOON WITH BARB UP FROM BAR
'RightTriangle':        '⊳', # CONTAINS AS NORMAL SUBGROUP
'RightTriangleBar':     '⧐', # VERTICAL BAR BESIDE RIGHT TRIANGLE
'RightTriangleEqual':   '⊵', # CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
'RightUpDownVector':    '⥏', # UP BARB RIGHT DOWN BARB RIGHT HARPOON
'RightUpTeeVector':     '⥜', # UPWARDS HARPOON WITH BARB RIGHT FROM BAR
'RightUpVector':        '↾', # UPWARDS HARPOON WITH BARB RIGHTWARDS
'RightUpVectorBar':     '⥔', # UPWARDS HARPOON WITH BARB RIGHT TO BAR
'RightVector':          '⇀', # RIGHTWARDS HARPOON WITH BARB UPWARDS
'RightVectorBar':       '⥓', # RIGHTWARDS HARPOON WITH BARB UP TO BAR
'Rightarrow':           '⇒', # RIGHTWARDS DOUBLE ARROW
'Ropf':                 'ℝ', # DOUBLE-STRUCK CAPITAL R
'RoundImplies':         '⥰', # RIGHT DOUBLE ARROW WITH ROUNDED HEAD
'Rrightarrow':          '⇛', # RIGHTWARDS TRIPLE ARROW
'Rscr':                 'ℛ', # SCRIPT CAPITAL R
'Rsh':                  '↱', # UPWARDS ARROW WITH TIP RIGHTWARDS
'RuleDelayed':          '⧴', # RULE-DELAYED
'SHCHcy':               'Щ', # CYRILLIC CAPITAL LETTER SHCHA
'SHcy':                 'Ш', # CYRILLIC CAPITAL LETTER SHA
'SOFTcy':               'Ь', # CYRILLIC CAPITAL LETTER SOFT SIGN
'Sacute':               'Ś', # LATIN CAPITAL LETTER S WITH ACUTE
'Sc':                   '⪼', # DOUBLE SUCCEEDS
'Scaron':               'Š', # LATIN CAPITAL LETTER S WITH CARON
'Scedil':               'Ş', # LATIN CAPITAL LETTER S WITH CEDILLA
'Scirc':                'Ŝ', # LATIN CAPITAL LETTER S WITH CIRCUMFLEX
'Scy':                  'С', # CYRILLIC CAPITAL LETTER ES
'Sfr':                  '𝔖', # MATHEMATICAL FRAKTUR CAPITAL S
'Sgr':                  'Σ', # GREEK CAPITAL LETTER SIGMA
'ShortDownArrow':       '↓', # DOWNWARDS ARROW
'ShortLeftArrow':       '←', # LEFTWARDS ARROW
'ShortRightArrow':      '→', # RIGHTWARDS ARROW
'ShortUpArrow':         '↑', # UPWARDS ARROW
'Sigma':                'Σ', # GREEK CAPITAL LETTER SIGMA
'SmallCircle':          '∘', # RING OPERATOR
'Sopf':                 '𝕊', # MATHEMATICAL DOUBLE-STRUCK CAPITAL S
'Sqrt':                 '√', # SQUARE ROOT
'Square':               '□', # WHITE SQUARE
'SquareIntersection':   '⊓', # SQUARE CAP
'SquareSubset':         '⊏', # SQUARE IMAGE OF
'SquareSubsetEqual':    '⊑', # SQUARE IMAGE OF OR EQUAL TO
'SquareSuperset':       '⊐', # SQUARE ORIGINAL OF
'SquareSupersetEqual':  '⊒', # SQUARE ORIGINAL OF OR EQUAL TO
'SquareUnion':          '⊔', # SQUARE CUP
'Sscr':                 '𝒮', # MATHEMATICAL SCRIPT CAPITAL S
'Star':                 '⋆', # STAR OPERATOR
'Sub':                  '⋐', # DOUBLE SUBSET
'Subset':               '⋐', # DOUBLE SUBSET
'SubsetEqual':          '⊆', # SUBSET OF OR EQUAL TO
'Succeeds':             '≻', # SUCCEEDS
'SucceedsEqual':        '⪰', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
'SucceedsSlantEqual':   '≽', # SUCCEEDS OR EQUAL TO
'SucceedsTilde':        '≿', # SUCCEEDS OR EQUIVALENT TO
'SuchThat':             '∋', # CONTAINS AS MEMBER
'Sum':                  '∑', # N-ARY SUMMATION
'Sup':                  '⋑', # DOUBLE SUPERSET
'Superset':             '⊃', # SUPERSET OF
'SupersetEqual':        '⊇', # SUPERSET OF OR EQUAL TO
'Supset':               '⋑', # DOUBLE SUPERSET
'THORN':                'Þ', # LATIN CAPITAL LETTER THORN
'THgr':                 'Θ', # GREEK CAPITAL LETTER THETA
'TRADE':                '™', # TRADE MARK SIGN
'TSHcy':                'Ћ', # CYRILLIC CAPITAL LETTER TSHE
'TScy':                 'Ц', # CYRILLIC CAPITAL LETTER TSE
'Tab':                  '	', # CHARACTER TABULATION
'Tau':                  'Τ', # GREEK CAPITAL LETTER TAU
'Tcaron':               'Ť', # LATIN CAPITAL LETTER T WITH CARON
'Tcedil':               'Ţ', # LATIN CAPITAL LETTER T WITH CEDILLA
'Tcy':                  'Т', # CYRILLIC CAPITAL LETTER TE
'Tfr':                  '𝔗', # MATHEMATICAL FRAKTUR CAPITAL T
'Tgr':                  'Τ', # GREEK CAPITAL LETTER TAU
'Therefore':            '∴', # THEREFORE
'Theta':                'Θ', # GREEK CAPITAL LETTER THETA
'ThickSpace':           '  ', # space of width 5/18 em
'ThinSpace':            ' ', # THIN SPACE
'Tilde':                '∼', # TILDE OPERATOR
'TildeEqual':           '≃', # ASYMPTOTICALLY EQUAL TO
'TildeFullEqual':       '≅', # APPROXIMATELY EQUAL TO
'TildeTilde':           '≈', # ALMOST EQUAL TO
'Topf':                 '𝕋', # MATHEMATICAL DOUBLE-STRUCK CAPITAL T
'TripleDot':            '\u20DB', # COMBINING THREE DOTS ABOVE
'Tscr':                 '𝒯', # MATHEMATICAL SCRIPT CAPITAL T
'Tstrok':               'Ŧ', # LATIN CAPITAL LETTER T WITH STROKE
'Uacgr':                'Ύ', # GREEK CAPITAL LETTER UPSILON WITH TONOS
'Uacute':               'Ú', # LATIN CAPITAL LETTER U WITH ACUTE
'Uarr':                 '↟', # UPWARDS TWO HEADED ARROW
'Uarrocir':             '⥉', # UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
'Ubrcy':                'Ў', # CYRILLIC CAPITAL LETTER SHORT U
'Ubreve':               'Ŭ', # LATIN CAPITAL LETTER U WITH BREVE
'Ucirc':                'Û', # LATIN CAPITAL LETTER U WITH CIRCUMFLEX
'Ucy':                  'У', # CYRILLIC CAPITAL LETTER U
'Udblac':               'Ű', # LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
'Udigr':                'Ϋ', # GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
'Ufr':                  '𝔘', # MATHEMATICAL FRAKTUR CAPITAL U
'Ugr':                  'Υ', # GREEK CAPITAL LETTER UPSILON
'Ugrave':               'Ù', # LATIN CAPITAL LETTER U WITH GRAVE
'Umacr':                'Ū', # LATIN CAPITAL LETTER U WITH MACRON
'UnderBar':             '_', # LOW LINE
'UnderBrace':           '⏟', # BOTTOM CURLY BRACKET
'UnderBracket':         '⎵', # BOTTOM SQUARE BRACKET
'UnderParenthesis':     '⏝', # BOTTOM PARENTHESIS
'Union':                '⋃', # N-ARY UNION
'UnionPlus':            '⊎', # MULTISET UNION
'Uogon':                'Ų', # LATIN CAPITAL LETTER U WITH OGONEK
'Uopf':                 '𝕌', # MATHEMATICAL DOUBLE-STRUCK CAPITAL U
'UpArrow':              '↑', # UPWARDS ARROW
'UpArrowBar':           '⤒', # UPWARDS ARROW TO BAR
'UpArrowDownArrow':     '⇅', # UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
'UpDownArrow':          '↕', # UP DOWN ARROW
'UpEquilibrium':        '⥮', # UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
'UpTee':                '⊥', # UP TACK
'UpTeeArrow':           '↥', # UPWARDS ARROW FROM BAR
'Uparrow':              '⇑', # UPWARDS DOUBLE ARROW
'Updownarrow':          '⇕', # UP DOWN DOUBLE ARROW
'UpperLeftArrow':       '↖', # NORTH WEST ARROW
'UpperRightArrow':      '↗', # NORTH EAST ARROW
'Upsi':                 'ϒ', # GREEK UPSILON WITH HOOK SYMBOL
'Upsilon':              'Υ', # GREEK CAPITAL LETTER UPSILON
'Uring':                'Ů', # LATIN CAPITAL LETTER U WITH RING ABOVE
'Uscr':                 '𝒰', # MATHEMATICAL SCRIPT CAPITAL U
'Utilde':               'Ũ', # LATIN CAPITAL LETTER U WITH TILDE
'Uuml':                 'Ü', # LATIN CAPITAL LETTER U WITH DIAERESIS
'VDash':                '⊫', # DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
'Vbar':                 '⫫', # DOUBLE UP TACK
'Vcy':                  'В', # CYRILLIC CAPITAL LETTER VE
'Vdash':                '⊩', # FORCES
'Vdashl':               '⫦', # LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL
'Vee':                  '⋁', # N-ARY LOGICAL OR
'Verbar':               '‖', # DOUBLE VERTICAL LINE
'Vert':                 '‖', # DOUBLE VERTICAL LINE
'VerticalBar':          '∣', # DIVIDES
'VerticalLine':         '|', # VERTICAL LINE
'VerticalSeparator':    '❘', # LIGHT VERTICAL BAR
'VerticalTilde':        '≀', # WREATH PRODUCT
'VeryThinSpace':        ' ', # HAIR SPACE
'Vfr':                  '𝔙', # MATHEMATICAL FRAKTUR CAPITAL V
'Vopf':                 '𝕍', # MATHEMATICAL DOUBLE-STRUCK CAPITAL V
'Vscr':                 '𝒱', # MATHEMATICAL SCRIPT CAPITAL V
'Vvdash':               '⊪', # TRIPLE VERTICAL BAR RIGHT TURNSTILE
'Wcirc':                'Ŵ', # LATIN CAPITAL LETTER W WITH CIRCUMFLEX
'Wedge':                '⋀', # N-ARY LOGICAL AND
'Wfr':                  '𝔚', # MATHEMATICAL FRAKTUR CAPITAL W
'Wopf':                 '𝕎', # MATHEMATICAL DOUBLE-STRUCK CAPITAL W
'Wscr':                 '𝒲', # MATHEMATICAL SCRIPT CAPITAL W
'Xfr':                  '𝔛', # MATHEMATICAL FRAKTUR CAPITAL X
'Xgr':                  'Ξ', # GREEK CAPITAL LETTER XI
'Xi':                   'Ξ', # GREEK CAPITAL LETTER XI
'Xopf':                 '𝕏', # MATHEMATICAL DOUBLE-STRUCK CAPITAL X
'Xscr':                 '𝒳', # MATHEMATICAL SCRIPT CAPITAL X
'YAcy':                 'Я', # CYRILLIC CAPITAL LETTER YA
'YIcy':                 'Ї', # CYRILLIC CAPITAL LETTER YI
'YUcy':                 'Ю', # CYRILLIC CAPITAL LETTER YU
'Yacute':               'Ý', # LATIN CAPITAL LETTER Y WITH ACUTE
'Ycirc':                'Ŷ', # LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
'Ycy':                  'Ы', # CYRILLIC CAPITAL LETTER YERU
'Yfr':                  '𝔜', # MATHEMATICAL FRAKTUR CAPITAL Y
'Yopf':                 '𝕐', # MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
'Yscr':                 '𝒴', # MATHEMATICAL SCRIPT CAPITAL Y
'Yuml':                 'Ÿ', # LATIN CAPITAL LETTER Y WITH DIAERESIS
'ZHcy':                 'Ж', # CYRILLIC CAPITAL LETTER ZHE
'Zacute':               'Ź', # LATIN CAPITAL LETTER Z WITH ACUTE
'Zcaron':               'Ž', # LATIN CAPITAL LETTER Z WITH CARON
'Zcy':                  'З', # CYRILLIC CAPITAL LETTER ZE
'Zdot':                 'Ż', # LATIN CAPITAL LETTER Z WITH DOT ABOVE
'ZeroWidthSpace':       '​', # ZERO WIDTH SPACE
'Zeta':                 'Ζ', # GREEK CAPITAL LETTER ZETA
'Zfr':                  'ℨ', # BLACK-LETTER CAPITAL Z
'Zgr':                  'Ζ', # GREEK CAPITAL LETTER ZETA
'Zopf':                 'ℤ', # DOUBLE-STRUCK CAPITAL Z
'Zscr':                 '𝒵', # MATHEMATICAL SCRIPT CAPITAL Z
'aacgr':                'ά', # GREEK SMALL LETTER ALPHA WITH TONOS
'aacute':               'á', # LATIN SMALL LETTER A WITH ACUTE
'abreve':               'ă', # LATIN SMALL LETTER A WITH BREVE
'ac':                   '∾', # INVERTED LAZY S
'acE':                  '∾̳', # INVERTED LAZY S with double underline
'acd':                  '∿', # SINE WAVE
'acirc':                'â', # LATIN SMALL LETTER A WITH CIRCUMFLEX
'acute':                '´', # ACUTE ACCENT
'acy':                  'а', # CYRILLIC SMALL LETTER A
'aelig':                'æ', # LATIN SMALL LETTER AE
'af':                   '⁡', # FUNCTION APPLICATION
'afr':                  '𝔞', # MATHEMATICAL FRAKTUR SMALL A
'agr':                  'α', # GREEK SMALL LETTER ALPHA
'agrave':               'à', # LATIN SMALL LETTER A WITH GRAVE
'alefsym':              'ℵ', # ALEF SYMBOL
'aleph':                'ℵ', # ALEF SYMBOL
'alpha':                'α', # GREEK SMALL LETTER ALPHA
'amacr':                'ā', # LATIN SMALL LETTER A WITH MACRON
'amalg':                '⨿', # AMALGAMATION OR COPRODUCT
'amp':                  '&', # AMPERSAND
'and':                  '∧', # LOGICAL AND
'andand':               '⩕', # TWO INTERSECTING LOGICAL AND
'andd':                 '⩜', # LOGICAL AND WITH HORIZONTAL DASH
'andslope':             '⩘', # SLOPING LARGE AND
'andv':                 '⩚', # LOGICAL AND WITH MIDDLE STEM
'ang':                  '∠', # ANGLE
'ange':                 '⦤', # ANGLE WITH UNDERBAR
'angle':                '∠', # ANGLE
'angmsd':               '∡', # MEASURED ANGLE
'angmsdaa':             '⦨', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
'angmsdab':             '⦩', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
'angmsdac':             '⦪', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
'angmsdad':             '⦫', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
'angmsdae':             '⦬', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
'angmsdaf':             '⦭', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
'angmsdag':             '⦮', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
'angmsdah':             '⦯', # MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
'angrt':                '∟', # RIGHT ANGLE
'angrtvb':              '⊾', # RIGHT ANGLE WITH ARC
'angrtvbd':             '⦝', # MEASURED RIGHT ANGLE WITH DOT
'angsph':               '∢', # SPHERICAL ANGLE
'angst':                'Å', # LATIN CAPITAL LETTER A WITH RING ABOVE
'angzarr':              '⍼', # RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
'aogon':                'ą', # LATIN SMALL LETTER A WITH OGONEK
'aopf':                 '𝕒', # MATHEMATICAL DOUBLE-STRUCK SMALL A
'ap':                   '≈', # ALMOST EQUAL TO
'apE':                  '⩰', # APPROXIMATELY EQUAL OR EQUAL TO
'apacir':               '⩯', # ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
'ape':                  '≊', # ALMOST EQUAL OR EQUAL TO
'apid':                 '≋', # TRIPLE TILDE
'apos':                 "'", # APOSTROPHE
'approx':               '≈', # ALMOST EQUAL TO
'approxeq':             '≊', # ALMOST EQUAL OR EQUAL TO
'aring':                'å', # LATIN SMALL LETTER A WITH RING ABOVE
'ascr':                 '𝒶', # MATHEMATICAL SCRIPT SMALL A
'ast':                  '*', # ASTERISK
'asymp':                '≈', # ALMOST EQUAL TO
'asympeq':              '≍', # EQUIVALENT TO
'atilde':               'ã', # LATIN SMALL LETTER A WITH TILDE
'auml':                 'ä', # LATIN SMALL LETTER A WITH DIAERESIS
'awconint':             '∳', # ANTICLOCKWISE CONTOUR INTEGRAL
'awint':                '⨑', # ANTICLOCKWISE INTEGRATION
'b.Delta':              '𝚫', # MATHEMATICAL BOLD CAPITAL DELTA
'b.Gamma':              '𝚪', # MATHEMATICAL BOLD CAPITAL GAMMA
'b.Gammad':             '𝟊', # MATHEMATICAL BOLD CAPITAL DIGAMMA
'b.Lambda':             '𝚲', # MATHEMATICAL BOLD CAPITAL LAMDA
'b.Omega':              '𝛀', # MATHEMATICAL BOLD CAPITAL OMEGA
'b.Phi':                '𝚽', # MATHEMATICAL BOLD CAPITAL PHI
'b.Pi':                 '𝚷', # MATHEMATICAL BOLD CAPITAL PI
'b.Psi':                '𝚿', # MATHEMATICAL BOLD CAPITAL PSI
'b.Sigma':              '𝚺', # MATHEMATICAL BOLD CAPITAL SIGMA
'b.Theta':              '𝚯', # MATHEMATICAL BOLD CAPITAL THETA
'b.Upsi':               '𝚼', # MATHEMATICAL BOLD CAPITAL UPSILON
'b.Xi':                 '𝚵', # MATHEMATICAL BOLD CAPITAL XI
'b.alpha':              '𝛂', # MATHEMATICAL BOLD SMALL ALPHA
'b.beta':               '𝛃', # MATHEMATICAL BOLD SMALL BETA
'b.chi':                '𝛘', # MATHEMATICAL BOLD SMALL CHI
'b.delta':              '𝛅', # MATHEMATICAL BOLD SMALL DELTA
'b.epsi':               '𝛆', # MATHEMATICAL BOLD SMALL EPSILON
'b.epsiv':              '𝛜', # MATHEMATICAL BOLD EPSILON SYMBOL
'b.eta':                '𝛈', # MATHEMATICAL BOLD SMALL ETA
'b.gamma':              '𝛄', # MATHEMATICAL BOLD SMALL GAMMA
'b.gammad':             '𝟋', # MATHEMATICAL BOLD SMALL DIGAMMA
'b.iota':               '𝛊', # MATHEMATICAL BOLD SMALL IOTA
'b.kappa':              '𝛋', # MATHEMATICAL BOLD SMALL KAPPA
'b.kappav':             '𝛞', # MATHEMATICAL BOLD KAPPA SYMBOL
'b.lambda':             '𝛌', # MATHEMATICAL BOLD SMALL LAMDA
'b.mu':                 '𝛍', # MATHEMATICAL BOLD SMALL MU
'b.nu':                 '𝛎', # MATHEMATICAL BOLD SMALL NU
'b.omega':              '𝛚', # MATHEMATICAL BOLD SMALL OMEGA
'b.phi':                '𝛗', # MATHEMATICAL BOLD SMALL PHI
'b.phiv':               '𝛟', # MATHEMATICAL BOLD PHI SYMBOL
'b.pi':                 '𝛑', # MATHEMATICAL BOLD SMALL PI
'b.piv':                '𝛡', # MATHEMATICAL BOLD PI SYMBOL
'b.psi':                '𝛙', # MATHEMATICAL BOLD SMALL PSI
'b.rho':                '𝛒', # MATHEMATICAL BOLD SMALL RHO
'b.rhov':               '𝛠', # MATHEMATICAL BOLD RHO SYMBOL
'b.sigma':              '𝛔', # MATHEMATICAL BOLD SMALL SIGMA
'b.sigmav':             '𝛓', # MATHEMATICAL BOLD SMALL FINAL SIGMA
'b.tau':                '𝛕', # MATHEMATICAL BOLD SMALL TAU
'b.thetas':             '𝛉', # MATHEMATICAL BOLD SMALL THETA
'b.thetav':             '𝛝', # MATHEMATICAL BOLD THETA SYMBOL
'b.upsi':               '𝛖', # MATHEMATICAL BOLD SMALL UPSILON
'b.xi':                 '𝛏', # MATHEMATICAL BOLD SMALL XI
'b.zeta':               '𝛇', # MATHEMATICAL BOLD SMALL ZETA
'bNot':                 '⫭', # REVERSED DOUBLE STROKE NOT SIGN
'backcong':             '≌', # ALL EQUAL TO
'backepsilon':          '϶', # GREEK REVERSED LUNATE EPSILON SYMBOL
'backprime':            '‵', # REVERSED PRIME
'backsim':              '∽', # REVERSED TILDE
'backsimeq':            '⋍', # REVERSED TILDE EQUALS
'barvee':               '⊽', # NOR
'barwed':               '⌅', # PROJECTIVE
'barwedge':             '⌅', # PROJECTIVE
'bbrk':                 '⎵', # BOTTOM SQUARE BRACKET
'bbrktbrk':             '⎶', # BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
'bcong':                '≌', # ALL EQUAL TO
'bcy':                  'б', # CYRILLIC SMALL LETTER BE
'bdquo':                '„', # DOUBLE LOW-9 QUOTATION MARK
'becaus':               '∵', # BECAUSE
'because':              '∵', # BECAUSE
'bemptyv':              '⦰', # REVERSED EMPTY SET
'bepsi':                '϶', # GREEK REVERSED LUNATE EPSILON SYMBOL
'bernou':               'ℬ', # SCRIPT CAPITAL B
'beta':                 'β', # GREEK SMALL LETTER BETA
'beth':                 'ℶ', # BET SYMBOL
'between':              '≬', # BETWEEN
'bfr':                  '𝔟', # MATHEMATICAL FRAKTUR SMALL B
'bgr':                  'β', # GREEK SMALL LETTER BETA
'bigcap':               '⋂', # N-ARY INTERSECTION
'bigcirc':              '◯', # LARGE CIRCLE
'bigcup':               '⋃', # N-ARY UNION
'bigodot':              '⨀', # N-ARY CIRCLED DOT OPERATOR
'bigoplus':             '⨁', # N-ARY CIRCLED PLUS OPERATOR
'bigotimes':            '⨂', # N-ARY CIRCLED TIMES OPERATOR
'bigsqcup':             '⨆', # N-ARY SQUARE UNION OPERATOR
'bigstar':              '★', # BLACK STAR
'bigtriangledown':      '▽', # WHITE DOWN-POINTING TRIANGLE
'bigtriangleup':        '△', # WHITE UP-POINTING TRIANGLE
'biguplus':             '⨄', # N-ARY UNION OPERATOR WITH PLUS
'bigvee':               '⋁', # N-ARY LOGICAL OR
'bigwedge':             '⋀', # N-ARY LOGICAL AND
'bkarow':               '⤍', # RIGHTWARDS DOUBLE DASH ARROW
'blacklozenge':         '⧫', # BLACK LOZENGE
'blacksquare':          '▪', # BLACK SMALL SQUARE
'blacktriangle':        '▴', # BLACK UP-POINTING SMALL TRIANGLE
'blacktriangledown':    '▾', # BLACK DOWN-POINTING SMALL TRIANGLE
'blacktriangleleft':    '◂', # BLACK LEFT-POINTING SMALL TRIANGLE
'blacktriangleright':   '▸', # BLACK RIGHT-POINTING SMALL TRIANGLE
'blank':                '␣', # OPEN BOX
'blk12':                '▒', # MEDIUM SHADE
'blk14':                '░', # LIGHT SHADE
'blk34':                '▓', # DARK SHADE
'block':                '█', # FULL BLOCK
'bne':                  '=⃥', # EQUALS SIGN with reverse slash
'bnequiv':              '≡⃥', # IDENTICAL TO with reverse slash
'bnot':                 '⌐', # REVERSED NOT SIGN
'bopf':                 '𝕓', # MATHEMATICAL DOUBLE-STRUCK SMALL B
'bot':                  '⊥', # UP TACK
'bottom':               '⊥', # UP TACK
'bowtie':               '⋈', # BOWTIE
'boxDL':                '╗', # BOX DRAWINGS DOUBLE DOWN AND LEFT
'boxDR':                '╔', # BOX DRAWINGS DOUBLE DOWN AND RIGHT
'boxDl':                '╖', # BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
'boxDr':                '╓', # BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
'boxH':                 '═', # BOX DRAWINGS DOUBLE HORIZONTAL
'boxHD':                '╦', # BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
'boxHU':                '╩', # BOX DRAWINGS DOUBLE UP AND HORIZONTAL
'boxHd':                '╤', # BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
'boxHu':                '╧', # BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
'boxUL':                '╝', # BOX DRAWINGS DOUBLE UP AND LEFT
'boxUR':                '╚', # BOX DRAWINGS DOUBLE UP AND RIGHT
'boxUl':                '╜', # BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
'boxUr':                '╙', # BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
'boxV':                 '║', # BOX DRAWINGS DOUBLE VERTICAL
'boxVH':                '╬', # BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
'boxVL':                '╣', # BOX DRAWINGS DOUBLE VERTICAL AND LEFT
'boxVR':                '╠', # BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
'boxVh':                '╫', # BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
'boxVl':                '╢', # BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
'boxVr':                '╟', # BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
'boxbox':               '⧉', # TWO JOINED SQUARES
'boxdL':                '╕', # BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
'boxdR':                '╒', # BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
'boxdl':                '┐', # BOX DRAWINGS LIGHT DOWN AND LEFT
'boxdr':                '┌', # BOX DRAWINGS LIGHT DOWN AND RIGHT
'boxh':                 '─', # BOX DRAWINGS LIGHT HORIZONTAL
'boxhD':                '╥', # BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
'boxhU':                '╨', # BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
'boxhd':                '┬', # BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
'boxhu':                '┴', # BOX DRAWINGS LIGHT UP AND HORIZONTAL
'boxminus':             '⊟', # SQUARED MINUS
'boxplus':              '⊞', # SQUARED PLUS
'boxtimes':             '⊠', # SQUARED TIMES
'boxuL':                '╛', # BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
'boxuR':                '╘', # BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
'boxul':                '┘', # BOX DRAWINGS LIGHT UP AND LEFT
'boxur':                '└', # BOX DRAWINGS LIGHT UP AND RIGHT
'boxv':                 '│', # BOX DRAWINGS LIGHT VERTICAL
'boxvH':                '╪', # BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
'boxvL':                '╡', # BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
'boxvR':                '╞', # BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
'boxvh':                '┼', # BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
'boxvl':                '┤', # BOX DRAWINGS LIGHT VERTICAL AND LEFT
'boxvr':                '├', # BOX DRAWINGS LIGHT VERTICAL AND RIGHT
'bprime':               '‵', # REVERSED PRIME
'breve':                '˘', # BREVE
'brvbar':               '¦', # BROKEN BAR
'bscr':                 '𝒷', # MATHEMATICAL SCRIPT SMALL B
'bsemi':                '⁏', # REVERSED SEMICOLON
'bsim':                 '∽', # REVERSED TILDE
'bsime':                '⋍', # REVERSED TILDE EQUALS
'bsol':                 '\\', # REVERSE SOLIDUS
'bsolb':                '⧅', # SQUARED FALLING DIAGONAL SLASH
'bsolhsub':             '⟈', # REVERSE SOLIDUS PRECEDING SUBSET
'bull':                 '•', # BULLET
'bullet':               '•', # BULLET
'bump':                 '≎', # GEOMETRICALLY EQUIVALENT TO
'bumpE':                '⪮', # EQUALS SIGN WITH BUMPY ABOVE
'bumpe':                '≏', # DIFFERENCE BETWEEN
'bumpeq':               '≏', # DIFFERENCE BETWEEN
'cacute':               'ć', # LATIN SMALL LETTER C WITH ACUTE
'cap':                  '∩', # INTERSECTION
'capand':               '⩄', # INTERSECTION WITH LOGICAL AND
'capbrcup':             '⩉', # INTERSECTION ABOVE BAR ABOVE UNION
'capcap':               '⩋', # INTERSECTION BESIDE AND JOINED WITH INTERSECTION
'capcup':               '⩇', # INTERSECTION ABOVE UNION
'capdot':               '⩀', # INTERSECTION WITH DOT
'caps':                 '∩︀', # INTERSECTION with serifs
'caret':                '⁁', # CARET INSERTION POINT
'caron':                'ˇ', # CARON
'ccaps':                '⩍', # CLOSED INTERSECTION WITH SERIFS
'ccaron':               'č', # LATIN SMALL LETTER C WITH CARON
'ccedil':               'ç', # LATIN SMALL LETTER C WITH CEDILLA
'ccirc':                'ĉ', # LATIN SMALL LETTER C WITH CIRCUMFLEX
'ccups':                '⩌', # CLOSED UNION WITH SERIFS
'ccupssm':              '⩐', # CLOSED UNION WITH SERIFS AND SMASH PRODUCT
'cdot':                 'ċ', # LATIN SMALL LETTER C WITH DOT ABOVE
'cedil':                '¸', # CEDILLA
'cemptyv':              '⦲', # EMPTY SET WITH SMALL CIRCLE ABOVE
'cent':                 '¢', # CENT SIGN
'centerdot':            '·', # MIDDLE DOT
'cfr':                  '𝔠', # MATHEMATICAL FRAKTUR SMALL C
'chcy':                 'ч', # CYRILLIC SMALL LETTER CHE
'check':                '✓', # CHECK MARK
'checkmark':            '✓', # CHECK MARK
'chi':                  'χ', # GREEK SMALL LETTER CHI
'cir':                  '○', # WHITE CIRCLE
'cirE':                 '⧃', # CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT
'circ':                 'ˆ', # MODIFIER LETTER CIRCUMFLEX ACCENT
'circeq':               '≗', # RING EQUAL TO
'circlearrowleft':      '↺', # ANTICLOCKWISE OPEN CIRCLE ARROW
'circlearrowright':     '↻', # CLOCKWISE OPEN CIRCLE ARROW
'circledR':             '®', # REGISTERED SIGN
'circledS':             'Ⓢ', # CIRCLED LATIN CAPITAL LETTER S
'circledast':           '⊛', # CIRCLED ASTERISK OPERATOR
'circledcirc':          '⊚', # CIRCLED RING OPERATOR
'circleddash':          '⊝', # CIRCLED DASH
'cire':                 '≗', # RING EQUAL TO
'cirfnint':             '⨐', # CIRCULATION FUNCTION
'cirmid':               '⫯', # VERTICAL LINE WITH CIRCLE ABOVE
'cirscir':              '⧂', # CIRCLE WITH SMALL CIRCLE TO THE RIGHT
'clubs':                '♣', # BLACK CLUB SUIT
'clubsuit':             '♣', # BLACK CLUB SUIT
'colon':                ':', # COLON
'colone':               '≔', # COLON EQUALS
'coloneq':              '≔', # COLON EQUALS
'comma':                ',', # COMMA
'commat':               '@', # COMMERCIAL AT
'comp':                 '∁', # COMPLEMENT
'compfn':               '∘', # RING OPERATOR
'complement':           '∁', # COMPLEMENT
'complexes':            'ℂ', # DOUBLE-STRUCK CAPITAL C
'cong':                 '≅', # APPROXIMATELY EQUAL TO
'congdot':              '⩭', # CONGRUENT WITH DOT ABOVE
'conint':               '∮', # CONTOUR INTEGRAL
'copf':                 '𝕔', # MATHEMATICAL DOUBLE-STRUCK SMALL C
'coprod':               '∐', # N-ARY COPRODUCT
'copy':                 '©', # COPYRIGHT SIGN
'copysr':               '℗', # SOUND RECORDING COPYRIGHT
'crarr':                '↵', # DOWNWARDS ARROW WITH CORNER LEFTWARDS
'cross':                '✗', # BALLOT X
'cscr':                 '𝒸', # MATHEMATICAL SCRIPT SMALL C
'csub':                 '⫏', # CLOSED SUBSET
'csube':                '⫑', # CLOSED SUBSET OR EQUAL TO
'csup':                 '⫐', # CLOSED SUPERSET
'csupe':                '⫒', # CLOSED SUPERSET OR EQUAL TO
'ctdot':                '⋯', # MIDLINE HORIZONTAL ELLIPSIS
'cudarrl':              '⤸', # RIGHT-SIDE ARC CLOCKWISE ARROW
'cudarrr':              '⤵', # ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS
'cuepr':                '⋞', # EQUAL TO OR PRECEDES
'cuesc':                '⋟', # EQUAL TO OR SUCCEEDS
'cularr':               '↶', # ANTICLOCKWISE TOP SEMICIRCLE ARROW
'cularrp':              '⤽', # TOP ARC ANTICLOCKWISE ARROW WITH PLUS
'cup':                  '∪', # UNION
'cupbrcap':             '⩈', # UNION ABOVE BAR ABOVE INTERSECTION
'cupcap':               '⩆', # UNION ABOVE INTERSECTION
'cupcup':               '⩊', # UNION BESIDE AND JOINED WITH UNION
'cupdot':               '⊍', # MULTISET MULTIPLICATION
'cupor':                '⩅', # UNION WITH LOGICAL OR
'cups':                 '∪︀', # UNION with serifs
'curarr':               '↷', # CLOCKWISE TOP SEMICIRCLE ARROW
'curarrm':              '⤼', # TOP ARC CLOCKWISE ARROW WITH MINUS
'curlyeqprec':          '⋞', # EQUAL TO OR PRECEDES
'curlyeqsucc':          '⋟', # EQUAL TO OR SUCCEEDS
'curlyvee':             '⋎', # CURLY LOGICAL OR
'curlywedge':           '⋏', # CURLY LOGICAL AND
'curren':               '¤', # CURRENCY SIGN
'curvearrowleft':       '↶', # ANTICLOCKWISE TOP SEMICIRCLE ARROW
'curvearrowright':      '↷', # CLOCKWISE TOP SEMICIRCLE ARROW
'cuvee':                '⋎', # CURLY LOGICAL OR
'cuwed':                '⋏', # CURLY LOGICAL AND
'cwconint':             '∲', # CLOCKWISE CONTOUR INTEGRAL
'cwint':                '∱', # CLOCKWISE INTEGRAL
'cylcty':               '⌭', # CYLINDRICITY
'dArr':                 '⇓', # DOWNWARDS DOUBLE ARROW
'dHar':                 '⥥', # DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
'dagger':               '†', # DAGGER
'daleth':               'ℸ', # DALET SYMBOL
'darr':                 '↓', # DOWNWARDS ARROW
'dash':                 '‐', # HYPHEN
'dashv':                '⊣', # LEFT TACK
'dbkarow':              '⤏', # RIGHTWARDS TRIPLE DASH ARROW
'dblac':                '˝', # DOUBLE ACUTE ACCENT
'dcaron':               'ď', # LATIN SMALL LETTER D WITH CARON
'dcy':                  'д', # CYRILLIC SMALL LETTER DE
'dd':                   'ⅆ', # DOUBLE-STRUCK ITALIC SMALL D
'ddagger':              '‡', # DOUBLE DAGGER
'ddarr':                '⇊', # DOWNWARDS PAIRED ARROWS
'ddotseq':              '⩷', # EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
'deg':                  '°', # DEGREE SIGN
'delta':                'δ', # GREEK SMALL LETTER DELTA
'demptyv':              '⦱', # EMPTY SET WITH OVERBAR
'dfisht':               '⥿', # DOWN FISH TAIL
'dfr':                  '𝔡', # MATHEMATICAL FRAKTUR SMALL D
'dgr':                  'δ', # GREEK SMALL LETTER DELTA
'dharl':                '⇃', # DOWNWARDS HARPOON WITH BARB LEFTWARDS
'dharr':                '⇂', # DOWNWARDS HARPOON WITH BARB RIGHTWARDS
'diam':                 '⋄', # DIAMOND OPERATOR
'diamond':              '⋄', # DIAMOND OPERATOR
'diamondsuit':          '♦', # BLACK DIAMOND SUIT
'diams':                '♦', # BLACK DIAMOND SUIT
'die':                  '¨', # DIAERESIS
'digamma':              'ϝ', # GREEK SMALL LETTER DIGAMMA
'disin':                '⋲', # ELEMENT OF WITH LONG HORIZONTAL STROKE
'div':                  '÷', # DIVISION SIGN
'divide':               '÷', # DIVISION SIGN
'divideontimes':        '⋇', # DIVISION TIMES
'divonx':               '⋇', # DIVISION TIMES
'djcy':                 'ђ', # CYRILLIC SMALL LETTER DJE
'dlcorn':               '⌞', # BOTTOM LEFT CORNER
'dlcrop':               '⌍', # BOTTOM LEFT CROP
'dollar':               '$', # DOLLAR SIGN
'dopf':                 '𝕕', # MATHEMATICAL DOUBLE-STRUCK SMALL D
'dot':                  '˙', # DOT ABOVE
'doteq':                '≐', # APPROACHES THE LIMIT
'doteqdot':             '≑', # GEOMETRICALLY EQUAL TO
'dotminus':             '∸', # DOT MINUS
'dotplus':              '∔', # DOT PLUS
'dotsquare':            '⊡', # SQUARED DOT OPERATOR
'doublebarwedge':       '⌆', # PERSPECTIVE
'downarrow':            '↓', # DOWNWARDS ARROW
'downdownarrows':       '⇊', # DOWNWARDS PAIRED ARROWS
'downharpoonleft':      '⇃', # DOWNWARDS HARPOON WITH BARB LEFTWARDS
'downharpoonright':     '⇂', # DOWNWARDS HARPOON WITH BARB RIGHTWARDS
'drbkarow':             '⤐', # RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
'drcorn':               '⌟', # BOTTOM RIGHT CORNER
'drcrop':               '⌌', # BOTTOM RIGHT CROP
'dscr':                 '𝒹', # MATHEMATICAL SCRIPT SMALL D
'dscy':                 'ѕ', # CYRILLIC SMALL LETTER DZE
'dsol':                 '⧶', # SOLIDUS WITH OVERBAR
'dstrok':               'đ', # LATIN SMALL LETTER D WITH STROKE
'dtdot':                '⋱', # DOWN RIGHT DIAGONAL ELLIPSIS
'dtri':                 '▿', # WHITE DOWN-POINTING SMALL TRIANGLE
'dtrif':                '▾', # BLACK DOWN-POINTING SMALL TRIANGLE
'duarr':                '⇵', # DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
'duhar':                '⥯', # DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
'dwangle':              '⦦', # OBLIQUE ANGLE OPENING UP
'dzcy':                 'џ', # CYRILLIC SMALL LETTER DZHE
'dzigrarr':             '⟿', # LONG RIGHTWARDS SQUIGGLE ARROW
'eDDot':                '⩷', # EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
'eDot':                 '≑', # GEOMETRICALLY EQUAL TO
'eacgr':                'έ', # GREEK SMALL LETTER EPSILON WITH TONOS
'eacute':               'é', # LATIN SMALL LETTER E WITH ACUTE
'easter':               '⩮', # EQUALS WITH ASTERISK
'ecaron':               'ě', # LATIN SMALL LETTER E WITH CARON
'ecir':                 '≖', # RING IN EQUAL TO
'ecirc':                'ê', # LATIN SMALL LETTER E WITH CIRCUMFLEX
'ecolon':               '≕', # EQUALS COLON
'ecy':                  'э', # CYRILLIC SMALL LETTER E
'edot':                 'ė', # LATIN SMALL LETTER E WITH DOT ABOVE
'ee':                   'ⅇ', # DOUBLE-STRUCK ITALIC SMALL E
'eeacgr':               'ή', # GREEK SMALL LETTER ETA WITH TONOS
'eegr':                 'η', # GREEK SMALL LETTER ETA
'efDot':                '≒', # APPROXIMATELY EQUAL TO OR THE IMAGE OF
'efr':                  '𝔢', # MATHEMATICAL FRAKTUR SMALL E
'eg':                   '⪚', # DOUBLE-LINE EQUAL TO OR GREATER-THAN
'egr':                  'ε', # GREEK SMALL LETTER EPSILON
'egrave':               'è', # LATIN SMALL LETTER E WITH GRAVE
'egs':                  '⪖', # SLANTED EQUAL TO OR GREATER-THAN
'egsdot':               '⪘', # SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
'el':                   '⪙', # DOUBLE-LINE EQUAL TO OR LESS-THAN
'elinters':             '⏧', # ELECTRICAL INTERSECTION
'ell':                  'ℓ', # SCRIPT SMALL L
'els':                  '⪕', # SLANTED EQUAL TO OR LESS-THAN
'elsdot':               '⪗', # SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
'emacr':                'ē', # LATIN SMALL LETTER E WITH MACRON
'empty':                '∅', # EMPTY SET
'emptyset':             '∅', # EMPTY SET
'emptyv':               '∅', # EMPTY SET
'emsp':                 ' ', # EM SPACE
'emsp13':               ' ', # THREE-PER-EM SPACE
'emsp14':               ' ', # FOUR-PER-EM SPACE
'eng':                  'ŋ', # LATIN SMALL LETTER ENG
'ensp':                 ' ', # EN SPACE
'eogon':                'ę', # LATIN SMALL LETTER E WITH OGONEK
'eopf':                 '𝕖', # MATHEMATICAL DOUBLE-STRUCK SMALL E
'epar':                 '⋕', # EQUAL AND PARALLEL TO
'eparsl':               '⧣', # EQUALS SIGN AND SLANTED PARALLEL
'eplus':                '⩱', # EQUALS SIGN ABOVE PLUS SIGN
'epsi':                 'ε', # GREEK SMALL LETTER EPSILON
'epsilon':              'ε', # GREEK SMALL LETTER EPSILON
'epsiv':                'ϵ', # GREEK LUNATE EPSILON SYMBOL
'eqcirc':               '≖', # RING IN EQUAL TO
'eqcolon':              '≕', # EQUALS COLON
'eqsim':                '≂', # MINUS TILDE
'eqslantgtr':           '⪖', # SLANTED EQUAL TO OR GREATER-THAN
'eqslantless':          '⪕', # SLANTED EQUAL TO OR LESS-THAN
'equals':               '=', # EQUALS SIGN
'equest':               '≟', # QUESTIONED EQUAL TO
'equiv':                '≡', # IDENTICAL TO
'equivDD':              '⩸', # EQUIVALENT WITH FOUR DOTS ABOVE
'eqvparsl':             '⧥', # IDENTICAL TO AND SLANTED PARALLEL
'erDot':                '≓', # IMAGE OF OR APPROXIMATELY EQUAL TO
'erarr':                '⥱', # EQUALS SIGN ABOVE RIGHTWARDS ARROW
'escr':                 'ℯ', # SCRIPT SMALL E
'esdot':                '≐', # APPROACHES THE LIMIT
'esim':                 '≂', # MINUS TILDE
'eta':                  'η', # GREEK SMALL LETTER ETA
'eth':                  'ð', # LATIN SMALL LETTER ETH
'euml':                 'ë', # LATIN SMALL LETTER E WITH DIAERESIS
'euro':                 '€', # EURO SIGN
'excl':                 '!', # EXCLAMATION MARK
'exist':                '∃', # THERE EXISTS
'expectation':          'ℰ', # SCRIPT CAPITAL E
'exponentiale':         'ⅇ', # DOUBLE-STRUCK ITALIC SMALL E
'fallingdotseq':        '≒', # APPROXIMATELY EQUAL TO OR THE IMAGE OF
'fcy':                  'ф', # CYRILLIC SMALL LETTER EF
'female':               '♀', # FEMALE SIGN
'ffilig':               'ﬃ', # LATIN SMALL LIGATURE FFI
'fflig':                'ﬀ', # LATIN SMALL LIGATURE FF
'ffllig':               'ﬄ', # LATIN SMALL LIGATURE FFL
'ffr':                  '𝔣', # MATHEMATICAL FRAKTUR SMALL F
'filig':                'ﬁ', # LATIN SMALL LIGATURE FI
'fjlig':                'fj', # fj ligature
'flat':                 '♭', # MUSIC FLAT SIGN
'fllig':                'ﬂ', # LATIN SMALL LIGATURE FL
'fltns':                '▱', # WHITE PARALLELOGRAM
'fnof':                 'ƒ', # LATIN SMALL LETTER F WITH HOOK
'fopf':                 '𝕗', # MATHEMATICAL DOUBLE-STRUCK SMALL F
'forall':               '∀', # FOR ALL
'fork':                 '⋔', # PITCHFORK
'forkv':                '⫙', # ELEMENT OF OPENING DOWNWARDS
'fpartint':             '⨍', # FINITE PART INTEGRAL
'frac12':               '½', # VULGAR FRACTION ONE HALF
'frac13':               '⅓', # VULGAR FRACTION ONE THIRD
'frac14':               '¼', # VULGAR FRACTION ONE QUARTER
'frac15':               '⅕', # VULGAR FRACTION ONE FIFTH
'frac16':               '⅙', # VULGAR FRACTION ONE SIXTH
'frac18':               '⅛', # VULGAR FRACTION ONE EIGHTH
'frac23':               '⅔', # VULGAR FRACTION TWO THIRDS
'frac25':               '⅖', # VULGAR FRACTION TWO FIFTHS
'frac34':               '¾', # VULGAR FRACTION THREE QUARTERS
'frac35':               '⅗', # VULGAR FRACTION THREE FIFTHS
'frac38':               '⅜', # VULGAR FRACTION THREE EIGHTHS
'frac45':               '⅘', # VULGAR FRACTION FOUR FIFTHS
'frac56':               '⅚', # VULGAR FRACTION FIVE SIXTHS
'frac58':               '⅝', # VULGAR FRACTION FIVE EIGHTHS
'frac78':               '⅞', # VULGAR FRACTION SEVEN EIGHTHS
'frasl':                '⁄', # FRACTION SLASH
'frown':                '⌢', # FROWN
'fscr':                 '𝒻', # MATHEMATICAL SCRIPT SMALL F
'gE':                   '≧', # GREATER-THAN OVER EQUAL TO
'gEl':                  '⪌', # GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
'gacute':               'ǵ', # LATIN SMALL LETTER G WITH ACUTE
'gamma':                'γ', # GREEK SMALL LETTER GAMMA
'gammad':               'ϝ', # GREEK SMALL LETTER DIGAMMA
'gap':                  '⪆', # GREATER-THAN OR APPROXIMATE
'gbreve':               'ğ', # LATIN SMALL LETTER G WITH BREVE
'gcirc':                'ĝ', # LATIN SMALL LETTER G WITH CIRCUMFLEX
'gcy':                  'г', # CYRILLIC SMALL LETTER GHE
'gdot':                 'ġ', # LATIN SMALL LETTER G WITH DOT ABOVE
'ge':                   '≥', # GREATER-THAN OR EQUAL TO
'gel':                  '⋛', # GREATER-THAN EQUAL TO OR LESS-THAN
'geq':                  '≥', # GREATER-THAN OR EQUAL TO
'geqq':                 '≧', # GREATER-THAN OVER EQUAL TO
'geqslant':             '⩾', # GREATER-THAN OR SLANTED EQUAL TO
'ges':                  '⩾', # GREATER-THAN OR SLANTED EQUAL TO
'gescc':                '⪩', # GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
'gesdot':               '⪀', # GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
'gesdoto':              '⪂', # GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
'gesdotol':             '⪄', # GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
'gesl':                 '⋛︀', # GREATER-THAN slanted EQUAL TO OR LESS-THAN
'gesles':               '⪔', # GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
'gfr':                  '𝔤', # MATHEMATICAL FRAKTUR SMALL G
'gg':                   '≫', # MUCH GREATER-THAN
'ggg':                  '⋙', # VERY MUCH GREATER-THAN
'ggr':                  'γ', # GREEK SMALL LETTER GAMMA
'gimel':                'ℷ', # GIMEL SYMBOL
'gjcy':                 'ѓ', # CYRILLIC SMALL LETTER GJE
'gl':                   '≷', # GREATER-THAN OR LESS-THAN
'glE':                  '⪒', # GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
'gla':                  '⪥', # GREATER-THAN BESIDE LESS-THAN
'glj':                  '⪤', # GREATER-THAN OVERLAPPING LESS-THAN
'gnE':                  '≩', # GREATER-THAN BUT NOT EQUAL TO
'gnap':                 '⪊', # GREATER-THAN AND NOT APPROXIMATE
'gnapprox':             '⪊', # GREATER-THAN AND NOT APPROXIMATE
'gne':                  '⪈', # GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
'gneq':                 '⪈', # GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
'gneqq':                '≩', # GREATER-THAN BUT NOT EQUAL TO
'gnsim':                '⋧', # GREATER-THAN BUT NOT EQUIVALENT TO
'gopf':                 '𝕘', # MATHEMATICAL DOUBLE-STRUCK SMALL G
'grave':                '`', # GRAVE ACCENT
'gscr':                 'ℊ', # SCRIPT SMALL G
'gsim':                 '≳', # GREATER-THAN OR EQUIVALENT TO
'gsime':                '⪎', # GREATER-THAN ABOVE SIMILAR OR EQUAL
'gsiml':                '⪐', # GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
'gt':                   '>', # GREATER-THAN SIGN
'gtcc':                 '⪧', # GREATER-THAN CLOSED BY CURVE
'gtcir':                '⩺', # GREATER-THAN WITH CIRCLE INSIDE
'gtdot':                '⋗', # GREATER-THAN WITH DOT
'gtlPar':               '⦕', # DOUBLE LEFT ARC GREATER-THAN BRACKET
'gtquest':              '⩼', # GREATER-THAN WITH QUESTION MARK ABOVE
'gtrapprox':            '⪆', # GREATER-THAN OR APPROXIMATE
'gtrarr':               '⥸', # GREATER-THAN ABOVE RIGHTWARDS ARROW
'gtrdot':               '⋗', # GREATER-THAN WITH DOT
'gtreqless':            '⋛', # GREATER-THAN EQUAL TO OR LESS-THAN
'gtreqqless':           '⪌', # GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
'gtrless':              '≷', # GREATER-THAN OR LESS-THAN
'gtrsim':               '≳', # GREATER-THAN OR EQUIVALENT TO
'gvertneqq':            '≩︀', # GREATER-THAN BUT NOT EQUAL TO - with vertical stroke
'gvnE':                 '≩︀', # GREATER-THAN BUT NOT EQUAL TO - with vertical stroke
'hArr':                 '⇔', # LEFT RIGHT DOUBLE ARROW
'hairsp':               ' ', # HAIR SPACE
'half':                 '½', # VULGAR FRACTION ONE HALF
'hamilt':               'ℋ', # SCRIPT CAPITAL H
'hardcy':               'ъ', # CYRILLIC SMALL LETTER HARD SIGN
'harr':                 '↔', # LEFT RIGHT ARROW
'harrcir':              '⥈', # LEFT RIGHT ARROW THROUGH SMALL CIRCLE
'harrw':                '↭', # LEFT RIGHT WAVE ARROW
'hbar':                 'ℏ', # PLANCK CONSTANT OVER TWO PI
'hcirc':                'ĥ', # LATIN SMALL LETTER H WITH CIRCUMFLEX
'hearts':               '♥', # BLACK HEART SUIT
'heartsuit':            '♥', # BLACK HEART SUIT
'hellip':               '…', # HORIZONTAL ELLIPSIS
'hercon':               '⊹', # HERMITIAN CONJUGATE MATRIX
'hfr':                  '𝔥', # MATHEMATICAL FRAKTUR SMALL H
'hksearow':             '⤥', # SOUTH EAST ARROW WITH HOOK
'hkswarow':             '⤦', # SOUTH WEST ARROW WITH HOOK
'hoarr':                '⇿', # LEFT RIGHT OPEN-HEADED ARROW
'homtht':               '∻', # HOMOTHETIC
'hookleftarrow':        '↩', # LEFTWARDS ARROW WITH HOOK
'hookrightarrow':       '↪', # RIGHTWARDS ARROW WITH HOOK
'hopf':                 '𝕙', # MATHEMATICAL DOUBLE-STRUCK SMALL H
'horbar':               '―', # HORIZONTAL BAR
'hscr':                 '𝒽', # MATHEMATICAL SCRIPT SMALL H
'hslash':               'ℏ', # PLANCK CONSTANT OVER TWO PI
'hstrok':               'ħ', # LATIN SMALL LETTER H WITH STROKE
'hybull':               '⁃', # HYPHEN BULLET
'hyphen':               '‐', # HYPHEN
'iacgr':                'ί', # GREEK SMALL LETTER IOTA WITH TONOS
'iacute':               'í', # LATIN SMALL LETTER I WITH ACUTE
'ic':                   '⁣', # INVISIBLE SEPARATOR
'icirc':                'î', # LATIN SMALL LETTER I WITH CIRCUMFLEX
'icy':                  'и', # CYRILLIC SMALL LETTER I
'idiagr':               'ΐ', # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
'idigr':                'ϊ', # GREEK SMALL LETTER IOTA WITH DIALYTIKA
'iecy':                 'е', # CYRILLIC SMALL LETTER IE
'iexcl':                '¡', # INVERTED EXCLAMATION MARK
'iff':                  '⇔', # LEFT RIGHT DOUBLE ARROW
'ifr':                  '𝔦', # MATHEMATICAL FRAKTUR SMALL I
'igr':                  'ι', # GREEK SMALL LETTER IOTA
'igrave':               'ì', # LATIN SMALL LETTER I WITH GRAVE
'ii':                   'ⅈ', # DOUBLE-STRUCK ITALIC SMALL I
'iiiint':               '⨌', # QUADRUPLE INTEGRAL OPERATOR
'iiint':                '∭', # TRIPLE INTEGRAL
'iinfin':               '⧜', # INCOMPLETE INFINITY
'iiota':                '℩', # TURNED GREEK SMALL LETTER IOTA
'ijlig':                'ĳ', # LATIN SMALL LIGATURE IJ
'imacr':                'ī', # LATIN SMALL LETTER I WITH MACRON
'image':                'ℑ', # BLACK-LETTER CAPITAL I
'imagline':             'ℐ', # SCRIPT CAPITAL I
'imagpart':             'ℑ', # BLACK-LETTER CAPITAL I
'imath':                'ı', # LATIN SMALL LETTER DOTLESS I
'imof':                 '⊷', # IMAGE OF
'imped':                'Ƶ', # LATIN CAPITAL LETTER Z WITH STROKE
'in':                   '∈', # ELEMENT OF
'incare':               '℅', # CARE OF
'infin':                '∞', # INFINITY
'infintie':             '⧝', # TIE OVER INFINITY
'inodot':               'ı', # LATIN SMALL LETTER DOTLESS I
'int':                  '∫', # INTEGRAL
'intcal':               '⊺', # INTERCALATE
'integers':             'ℤ', # DOUBLE-STRUCK CAPITAL Z
'intercal':             '⊺', # INTERCALATE
'intlarhk':             '⨗', # INTEGRAL WITH LEFTWARDS ARROW WITH HOOK
'intprod':              '⨼', # INTERIOR PRODUCT
'iocy':                 'ё', # CYRILLIC SMALL LETTER IO
'iogon':                'į', # LATIN SMALL LETTER I WITH OGONEK
'iopf':                 '𝕚', # MATHEMATICAL DOUBLE-STRUCK SMALL I
'iota':                 'ι', # GREEK SMALL LETTER IOTA
'iprod':                '⨼', # INTERIOR PRODUCT
'iquest':               '¿', # INVERTED QUESTION MARK
'iscr':                 '𝒾', # MATHEMATICAL SCRIPT SMALL I
'isin':                 '∈', # ELEMENT OF
'isinE':                '⋹', # ELEMENT OF WITH TWO HORIZONTAL STROKES
'isindot':              '⋵', # ELEMENT OF WITH DOT ABOVE
'isins':                '⋴', # SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
'isinsv':               '⋳', # ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
'isinv':                '∈', # ELEMENT OF
'it':                   '⁢', # INVISIBLE TIMES
'itilde':               'ĩ', # LATIN SMALL LETTER I WITH TILDE
'iukcy':                'і', # CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
'iuml':                 'ï', # LATIN SMALL LETTER I WITH DIAERESIS
'jcirc':                'ĵ', # LATIN SMALL LETTER J WITH CIRCUMFLEX
'jcy':                  'й', # CYRILLIC SMALL LETTER SHORT I
'jfr':                  '𝔧', # MATHEMATICAL FRAKTUR SMALL J
'jmath':                'ȷ', # LATIN SMALL LETTER DOTLESS J
'jopf':                 '𝕛', # MATHEMATICAL DOUBLE-STRUCK SMALL J
'jscr':                 '𝒿', # MATHEMATICAL SCRIPT SMALL J
'jsercy':               'ј', # CYRILLIC SMALL LETTER JE
'jukcy':                'є', # CYRILLIC SMALL LETTER UKRAINIAN IE
'kappa':                'κ', # GREEK SMALL LETTER KAPPA
'kappav':               'ϰ', # GREEK KAPPA SYMBOL
'kcedil':               'ķ', # LATIN SMALL LETTER K WITH CEDILLA
'kcy':                  'к', # CYRILLIC SMALL LETTER KA
'kfr':                  '𝔨', # MATHEMATICAL FRAKTUR SMALL K
'kgr':                  'κ', # GREEK SMALL LETTER KAPPA
'kgreen':               'ĸ', # LATIN SMALL LETTER KRA
'khcy':                 'х', # CYRILLIC SMALL LETTER HA
'khgr':                 'χ', # GREEK SMALL LETTER CHI
'kjcy':                 'ќ', # CYRILLIC SMALL LETTER KJE
'kopf':                 '𝕜', # MATHEMATICAL DOUBLE-STRUCK SMALL K
'kscr':                 '𝓀', # MATHEMATICAL SCRIPT SMALL K
'lAarr':                '⇚', # LEFTWARDS TRIPLE ARROW
'lArr':                 '⇐', # LEFTWARDS DOUBLE ARROW
'lAtail':               '⤛', # LEFTWARDS DOUBLE ARROW-TAIL
'lBarr':                '⤎', # LEFTWARDS TRIPLE DASH ARROW
'lE':                   '≦', # LESS-THAN OVER EQUAL TO
'lEg':                  '⪋', # LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
'lHar':                 '⥢', # LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
'lacute':               'ĺ', # LATIN SMALL LETTER L WITH ACUTE
'laemptyv':             '⦴', # EMPTY SET WITH LEFT ARROW ABOVE
'lagran':               'ℒ', # SCRIPT CAPITAL L
'lambda':               'λ', # GREEK SMALL LETTER LAMDA
'lang':                 '⟨', # MATHEMATICAL LEFT ANGLE BRACKET
'langd':                '⦑', # LEFT ANGLE BRACKET WITH DOT
'langle':               '⟨', # MATHEMATICAL LEFT ANGLE BRACKET
'lap':                  '⪅', # LESS-THAN OR APPROXIMATE
'laquo':                '«', # LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
'larr':                 '←', # LEFTWARDS ARROW
'larrb':                '⇤', # LEFTWARDS ARROW TO BAR
'larrbfs':              '⤟', # LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
'larrfs':               '⤝', # LEFTWARDS ARROW TO BLACK DIAMOND
'larrhk':               '↩', # LEFTWARDS ARROW WITH HOOK
'larrlp':               '↫', # LEFTWARDS ARROW WITH LOOP
'larrpl':               '⤹', # LEFT-SIDE ARC ANTICLOCKWISE ARROW
'larrsim':              '⥳', # LEFTWARDS ARROW ABOVE TILDE OPERATOR
'larrtl':               '↢', # LEFTWARDS ARROW WITH TAIL
'lat':                  '⪫', # LARGER THAN
'latail':               '⤙', # LEFTWARDS ARROW-TAIL
'late':                 '⪭', # LARGER THAN OR EQUAL TO
'lates':                '⪭︀', # LARGER THAN OR slanted EQUAL
'lbarr':                '⤌', # LEFTWARDS DOUBLE DASH ARROW
'lbbrk':                '❲', # LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
'lbrace':               '{', # LEFT CURLY BRACKET
'lbrack':               '[', # LEFT SQUARE BRACKET
'lbrke':                '⦋', # LEFT SQUARE BRACKET WITH UNDERBAR
'lbrksld':              '⦏', # LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
'lbrkslu':              '⦍', # LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
'lcaron':               'ľ', # LATIN SMALL LETTER L WITH CARON
'lcedil':               'ļ', # LATIN SMALL LETTER L WITH CEDILLA
'lceil':                '⌈', # LEFT CEILING
'lcub':                 '{', # LEFT CURLY BRACKET
'lcy':                  'л', # CYRILLIC SMALL LETTER EL
'ldca':                 '⤶', # ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS
'ldquo':                '“', # LEFT DOUBLE QUOTATION MARK
'ldquor':               '„', # DOUBLE LOW-9 QUOTATION MARK
'ldrdhar':              '⥧', # LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
'ldrushar':             '⥋', # LEFT BARB DOWN RIGHT BARB UP HARPOON
'ldsh':                 '↲', # DOWNWARDS ARROW WITH TIP LEFTWARDS
'le':                   '≤', # LESS-THAN OR EQUAL TO
'leftarrow':            '←', # LEFTWARDS ARROW
'leftarrowtail':        '↢', # LEFTWARDS ARROW WITH TAIL
'leftharpoondown':      '↽', # LEFTWARDS HARPOON WITH BARB DOWNWARDS
'leftharpoonup':        '↼', # LEFTWARDS HARPOON WITH BARB UPWARDS
'leftleftarrows':       '⇇', # LEFTWARDS PAIRED ARROWS
'leftrightarrow':       '↔', # LEFT RIGHT ARROW
'leftrightarrows':      '⇆', # LEFTWARDS ARROW OVER RIGHTWARDS ARROW
'leftrightharpoons':    '⇋', # LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
'leftrightsquigarrow':  '↭', # LEFT RIGHT WAVE ARROW
'leftthreetimes':       '⋋', # LEFT SEMIDIRECT PRODUCT
'leg':                  '⋚', # LESS-THAN EQUAL TO OR GREATER-THAN
'leq':                  '≤', # LESS-THAN OR EQUAL TO
'leqq':                 '≦', # LESS-THAN OVER EQUAL TO
'leqslant':             '⩽', # LESS-THAN OR SLANTED EQUAL TO
'les':                  '⩽', # LESS-THAN OR SLANTED EQUAL TO
'lescc':                '⪨', # LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
'lesdot':               '⩿', # LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
'lesdoto':              '⪁', # LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
'lesdotor':             '⪃', # LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
'lesg':                 '⋚︀', # LESS-THAN slanted EQUAL TO OR GREATER-THAN
'lesges':               '⪓', # LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
'lessapprox':           '⪅', # LESS-THAN OR APPROXIMATE
'lessdot':              '⋖', # LESS-THAN WITH DOT
'lesseqgtr':            '⋚', # LESS-THAN EQUAL TO OR GREATER-THAN
'lesseqqgtr':           '⪋', # LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
'lessgtr':              '≶', # LESS-THAN OR GREATER-THAN
'lesssim':              '≲', # LESS-THAN OR EQUIVALENT TO
'lfisht':               '⥼', # LEFT FISH TAIL
'lfloor':               '⌊', # LEFT FLOOR
'lfr':                  '𝔩', # MATHEMATICAL FRAKTUR SMALL L
'lg':                   '≶', # LESS-THAN OR GREATER-THAN
'lgE':                  '⪑', # LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
'lgr':                  'λ', # GREEK SMALL LETTER LAMDA
'lhard':                '↽', # LEFTWARDS HARPOON WITH BARB DOWNWARDS
'lharu':                '↼', # LEFTWARDS HARPOON WITH BARB UPWARDS
'lharul':               '⥪', # LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
'lhblk':                '▄', # LOWER HALF BLOCK
'ljcy':                 'љ', # CYRILLIC SMALL LETTER LJE
'll':                   '≪', # MUCH LESS-THAN
'llarr':                '⇇', # LEFTWARDS PAIRED ARROWS
'llcorner':             '⌞', # BOTTOM LEFT CORNER
'llhard':               '⥫', # LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
'lltri':                '◺', # LOWER LEFT TRIANGLE
'lmidot':               'ŀ', # LATIN SMALL LETTER L WITH MIDDLE DOT
'lmoust':               '⎰', # UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
'lmoustache':           '⎰', # UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
'lnE':                  '≨', # LESS-THAN BUT NOT EQUAL TO
'lnap':                 '⪉', # LESS-THAN AND NOT APPROXIMATE
'lnapprox':             '⪉', # LESS-THAN AND NOT APPROXIMATE
'lne':                  '⪇', # LESS-THAN AND SINGLE-LINE NOT EQUAL TO
'lneq':                 '⪇', # LESS-THAN AND SINGLE-LINE NOT EQUAL TO
'lneqq':                '≨', # LESS-THAN BUT NOT EQUAL TO
'lnsim':                '⋦', # LESS-THAN BUT NOT EQUIVALENT TO
'loang':                '⟬', # MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
'loarr':                '⇽', # LEFTWARDS OPEN-HEADED ARROW
'lobrk':                '⟦', # MATHEMATICAL LEFT WHITE SQUARE BRACKET
'longleftarrow':        '⟵', # LONG LEFTWARDS ARROW
'longleftrightarrow':   '⟷', # LONG LEFT RIGHT ARROW
'longmapsto':           '⟼', # LONG RIGHTWARDS ARROW FROM BAR
'longrightarrow':       '⟶', # LONG RIGHTWARDS ARROW
'looparrowleft':        '↫', # LEFTWARDS ARROW WITH LOOP
'looparrowright':       '↬', # RIGHTWARDS ARROW WITH LOOP
'lopar':                '⦅', # LEFT WHITE PARENTHESIS
'lopf':                 '𝕝', # MATHEMATICAL DOUBLE-STRUCK SMALL L
'loplus':               '⨭', # PLUS SIGN IN LEFT HALF CIRCLE
'lotimes':              '⨴', # MULTIPLICATION SIGN IN LEFT HALF CIRCLE
'lowast':               '∗', # ASTERISK OPERATOR
'lowbar':               '_', # LOW LINE
'loz':                  '◊', # LOZENGE
'lozenge':              '◊', # LOZENGE
'lozf':                 '⧫', # BLACK LOZENGE
'lpar':                 '(', # LEFT PARENTHESIS
'lparlt':               '⦓', # LEFT ARC LESS-THAN BRACKET
'lrarr':                '⇆', # LEFTWARDS ARROW OVER RIGHTWARDS ARROW
'lrcorner':             '⌟', # BOTTOM RIGHT CORNER
'lrhar':                '⇋', # LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
'lrhard':               '⥭', # RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
'lrm':                  '‎', # LEFT-TO-RIGHT MARK
'lrtri':                '⊿', # RIGHT TRIANGLE
'lsaquo':               '‹', # SINGLE LEFT-POINTING ANGLE QUOTATION MARK
'lscr':                 '𝓁', # MATHEMATICAL SCRIPT SMALL L
'lsh':                  '↰', # UPWARDS ARROW WITH TIP LEFTWARDS
'lsim':                 '≲', # LESS-THAN OR EQUIVALENT TO
'lsime':                '⪍', # LESS-THAN ABOVE SIMILAR OR EQUAL
'lsimg':                '⪏', # LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
'lsqb':                 '[', # LEFT SQUARE BRACKET
'lsquo':                '‘', # LEFT SINGLE QUOTATION MARK
'lsquor':               '‚', # SINGLE LOW-9 QUOTATION MARK
'lstrok':               'ł', # LATIN SMALL LETTER L WITH STROKE
'lt':                   '<', # LESS-THAN SIGN
'ltcc':                 '⪦', # LESS-THAN CLOSED BY CURVE
'ltcir':                '⩹', # LESS-THAN WITH CIRCLE INSIDE
'ltdot':                '⋖', # LESS-THAN WITH DOT
'lthree':               '⋋', # LEFT SEMIDIRECT PRODUCT
'ltimes':               '⋉', # LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
'ltlarr':               '⥶', # LESS-THAN ABOVE LEFTWARDS ARROW
'ltquest':              '⩻', # LESS-THAN WITH QUESTION MARK ABOVE
'ltrPar':               '⦖', # DOUBLE RIGHT ARC LESS-THAN BRACKET
'ltri':                 '◃', # WHITE LEFT-POINTING SMALL TRIANGLE
'ltrie':                '⊴', # NORMAL SUBGROUP OF OR EQUAL TO
'ltrif':                '◂', # BLACK LEFT-POINTING SMALL TRIANGLE
'lurdshar':             '⥊', # LEFT BARB UP RIGHT BARB DOWN HARPOON
'luruhar':              '⥦', # LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
'lvertneqq':            '≨︀', # LESS-THAN BUT NOT EQUAL TO - with vertical stroke
'lvnE':                 '≨︀', # LESS-THAN BUT NOT EQUAL TO - with vertical stroke
'mDDot':                '∺', # GEOMETRIC PROPORTION
'macr':                 '¯', # MACRON
'male':                 '♂', # MALE SIGN
'malt':                 '✠', # MALTESE CROSS
'maltese':              '✠', # MALTESE CROSS
'map':                  '↦', # RIGHTWARDS ARROW FROM BAR
'mapsto':               '↦', # RIGHTWARDS ARROW FROM BAR
'mapstodown':           '↧', # DOWNWARDS ARROW FROM BAR
'mapstoleft':           '↤', # LEFTWARDS ARROW FROM BAR
'mapstoup':             '↥', # UPWARDS ARROW FROM BAR
'marker':               '▮', # BLACK VERTICAL RECTANGLE
'mcomma':               '⨩', # MINUS SIGN WITH COMMA ABOVE
'mcy':                  'м', # CYRILLIC SMALL LETTER EM
'mdash':                '—', # EM DASH
'measuredangle':        '∡', # MEASURED ANGLE
'mfr':                  '𝔪', # MATHEMATICAL FRAKTUR SMALL M
'mgr':                  'μ', # GREEK SMALL LETTER MU
'mho':                  '℧', # INVERTED OHM SIGN
'micro':                'µ', # MICRO SIGN
'mid':                  '∣', # DIVIDES
'midast':               '*', # ASTERISK
'midcir':               '⫰', # VERTICAL LINE WITH CIRCLE BELOW
'middot':               '·', # MIDDLE DOT
'minus':                '−', # MINUS SIGN
'minusb':               '⊟', # SQUARED MINUS
'minusd':               '∸', # DOT MINUS
'minusdu':              '⨪', # MINUS SIGN WITH DOT BELOW
'mlcp':                 '⫛', # TRANSVERSAL INTERSECTION
'mldr':                 '…', # HORIZONTAL ELLIPSIS
'mnplus':               '∓', # MINUS-OR-PLUS SIGN
'models':               '⊧', # MODELS
'mopf':                 '𝕞', # MATHEMATICAL DOUBLE-STRUCK SMALL M
'mp':                   '∓', # MINUS-OR-PLUS SIGN
'mscr':                 '𝓂', # MATHEMATICAL SCRIPT SMALL M
'mstpos':               '∾', # INVERTED LAZY S
'mu':                   'μ', # GREEK SMALL LETTER MU
'multimap':             '⊸', # MULTIMAP
'mumap':                '⊸', # MULTIMAP
'nGg':                  '⋙̸', # VERY MUCH GREATER-THAN with slash
'nGt':                  '≫⃒', # MUCH GREATER THAN with vertical line
'nGtv':                 '≫̸', # MUCH GREATER THAN with slash
'nLeftarrow':           '⇍', # LEFTWARDS DOUBLE ARROW WITH STROKE
'nLeftrightarrow':      '⇎', # LEFT RIGHT DOUBLE ARROW WITH STROKE
'nLl':                  '⋘̸', # VERY MUCH LESS-THAN with slash
'nLt':                  '≪⃒', # MUCH LESS THAN with vertical line
'nLtv':                 '≪̸', # MUCH LESS THAN with slash
'nRightarrow':          '⇏', # RIGHTWARDS DOUBLE ARROW WITH STROKE
'nVDash':               '⊯', # NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
'nVdash':               '⊮', # DOES NOT FORCE
'nabla':                '∇', # NABLA
'nacute':               'ń', # LATIN SMALL LETTER N WITH ACUTE
'nang':                 '∠⃒', # ANGLE with vertical line
'nap':                  '≉', # NOT ALMOST EQUAL TO
'napE':                 '⩰̸', # APPROXIMATELY EQUAL OR EQUAL TO with slash
'napid':                '≋̸', # TRIPLE TILDE with slash
'napos':                'ŉ', # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
'napprox':              '≉', # NOT ALMOST EQUAL TO
'natur':                '♮', # MUSIC NATURAL SIGN
'natural':              '♮', # MUSIC NATURAL SIGN
'naturals':             'ℕ', # DOUBLE-STRUCK CAPITAL N
'nbsp':                 ' ', # NO-BREAK SPACE
'nbump':                '≎̸', # GEOMETRICALLY EQUIVALENT TO with slash
'nbumpe':               '≏̸', # DIFFERENCE BETWEEN with slash
'ncap':                 '⩃', # INTERSECTION WITH OVERBAR
'ncaron':               'ň', # LATIN SMALL LETTER N WITH CARON
'ncedil':               'ņ', # LATIN SMALL LETTER N WITH CEDILLA
'ncong':                '≇', # NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
'ncongdot':             '⩭̸', # CONGRUENT WITH DOT ABOVE with slash
'ncup':                 '⩂', # UNION WITH OVERBAR
'ncy':                  'н', # CYRILLIC SMALL LETTER EN
'ndash':                '–', # EN DASH
'ne':                   '≠', # NOT EQUAL TO
'neArr':                '⇗', # NORTH EAST DOUBLE ARROW
'nearhk':               '⤤', # NORTH EAST ARROW WITH HOOK
'nearr':                '↗', # NORTH EAST ARROW
'nearrow':              '↗', # NORTH EAST ARROW
'nedot':                '≐̸', # APPROACHES THE LIMIT with slash
'nequiv':               '≢', # NOT IDENTICAL TO
'nesear':               '⤨', # NORTH EAST ARROW AND SOUTH EAST ARROW
'nesim':                '≂̸', # MINUS TILDE with slash
'nexist':               '∄', # THERE DOES NOT EXIST
'nexists':              '∄', # THERE DOES NOT EXIST
'nfr':                  '𝔫', # MATHEMATICAL FRAKTUR SMALL N
'ngE':                  '≧̸', # GREATER-THAN OVER EQUAL TO with slash
'nge':                  '≱', # NEITHER GREATER-THAN NOR EQUAL TO
'ngeq':                 '≱', # NEITHER GREATER-THAN NOR EQUAL TO
'ngeqq':                '≧̸', # GREATER-THAN OVER EQUAL TO with slash
'ngeqslant':            '⩾̸', # GREATER-THAN OR SLANTED EQUAL TO with slash
'nges':                 '⩾̸', # GREATER-THAN OR SLANTED EQUAL TO with slash
'ngr':                  'ν', # GREEK SMALL LETTER NU
'ngsim':                '≵', # NEITHER GREATER-THAN NOR EQUIVALENT TO
'ngt':                  '≯', # NOT GREATER-THAN
'ngtr':                 '≯', # NOT GREATER-THAN
'nhArr':                '⇎', # LEFT RIGHT DOUBLE ARROW WITH STROKE
'nharr':                '↮', # LEFT RIGHT ARROW WITH STROKE
'nhpar':                '⫲', # PARALLEL WITH HORIZONTAL STROKE
'ni':                   '∋', # CONTAINS AS MEMBER
'nis':                  '⋼', # SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
'nisd':                 '⋺', # CONTAINS WITH LONG HORIZONTAL STROKE
'niv':                  '∋', # CONTAINS AS MEMBER
'njcy':                 'њ', # CYRILLIC SMALL LETTER NJE
'nlArr':                '⇍', # LEFTWARDS DOUBLE ARROW WITH STROKE
'nlE':                  '≦̸', # LESS-THAN OVER EQUAL TO with slash
'nlarr':                '↚', # LEFTWARDS ARROW WITH STROKE
'nldr':                 '‥', # TWO DOT LEADER
'nle':                  '≰', # NEITHER LESS-THAN NOR EQUAL TO
'nleftarrow':           '↚', # LEFTWARDS ARROW WITH STROKE
'nleftrightarrow':      '↮', # LEFT RIGHT ARROW WITH STROKE
'nleq':                 '≰', # NEITHER LESS-THAN NOR EQUAL TO
'nleqq':                '≦̸', # LESS-THAN OVER EQUAL TO with slash
'nleqslant':            '⩽̸', # LESS-THAN OR SLANTED EQUAL TO with slash
'nles':                 '⩽̸', # LESS-THAN OR SLANTED EQUAL TO with slash
'nless':                '≮', # NOT LESS-THAN
'nlsim':                '≴', # NEITHER LESS-THAN NOR EQUIVALENT TO
'nlt':                  '≮', # NOT LESS-THAN
'nltri':                '⋪', # NOT NORMAL SUBGROUP OF
'nltrie':               '⋬', # NOT NORMAL SUBGROUP OF OR EQUAL TO
'nmid':                 '∤', # DOES NOT DIVIDE
'nopf':                 '𝕟', # MATHEMATICAL DOUBLE-STRUCK SMALL N
'not':                  '¬', # NOT SIGN
'notin':                '∉', # NOT AN ELEMENT OF
'notinE':               '⋹̸', # ELEMENT OF WITH TWO HORIZONTAL STROKES with slash
'notindot':             '⋵̸', # ELEMENT OF WITH DOT ABOVE with slash
'notinva':              '∉', # NOT AN ELEMENT OF
'notinvb':              '⋷', # SMALL ELEMENT OF WITH OVERBAR
'notinvc':              '⋶', # ELEMENT OF WITH OVERBAR
'notni':                '∌', # DOES NOT CONTAIN AS MEMBER
'notniva':              '∌', # DOES NOT CONTAIN AS MEMBER
'notnivb':              '⋾', # SMALL CONTAINS WITH OVERBAR
'notnivc':              '⋽', # CONTAINS WITH OVERBAR
'npar':                 '∦', # NOT PARALLEL TO
'nparallel':            '∦', # NOT PARALLEL TO
'nparsl':               '⫽⃥', # DOUBLE SOLIDUS OPERATOR with reverse slash
'npart':                '∂̸', # PARTIAL DIFFERENTIAL with slash
'npolint':              '⨔', # LINE INTEGRATION NOT INCLUDING THE POLE
'npr':                  '⊀', # DOES NOT PRECEDE
'nprcue':               '⋠', # DOES NOT PRECEDE OR EQUAL
'npre':                 '⪯̸', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash
'nprec':                '⊀', # DOES NOT PRECEDE
'npreceq':              '⪯̸', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash
'nrArr':                '⇏', # RIGHTWARDS DOUBLE ARROW WITH STROKE
'nrarr':                '↛', # RIGHTWARDS ARROW WITH STROKE
'nrarrc':               '⤳̸', # WAVE ARROW POINTING DIRECTLY RIGHT with slash
'nrarrw':               '↝̸', # RIGHTWARDS WAVE ARROW with slash
'nrightarrow':          '↛', # RIGHTWARDS ARROW WITH STROKE
'nrtri':                '⋫', # DOES NOT CONTAIN AS NORMAL SUBGROUP
'nrtrie':               '⋭', # DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
'nsc':                  '⊁', # DOES NOT SUCCEED
'nsccue':               '⋡', # DOES NOT SUCCEED OR EQUAL
'nsce':                 '⪰̸', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash
'nscr':                 '𝓃', # MATHEMATICAL SCRIPT SMALL N
'nshortmid':            '∤', # DOES NOT DIVIDE
'nshortparallel':       '∦', # NOT PARALLEL TO
'nsim':                 '≁', # NOT TILDE
'nsime':                '≄', # NOT ASYMPTOTICALLY EQUAL TO
'nsimeq':               '≄', # NOT ASYMPTOTICALLY EQUAL TO
'nsmid':                '∤', # DOES NOT DIVIDE
'nspar':                '∦', # NOT PARALLEL TO
'nsqsube':              '⋢', # NOT SQUARE IMAGE OF OR EQUAL TO
'nsqsupe':              '⋣', # NOT SQUARE ORIGINAL OF OR EQUAL TO
'nsub':                 '⊄', # NOT A SUBSET OF
'nsubE':                '⫅̸', # SUBSET OF ABOVE EQUALS SIGN with slash
'nsube':                '⊈', # NEITHER A SUBSET OF NOR EQUAL TO
'nsubset':              '⊂⃒', # SUBSET OF with vertical line
'nsubseteq':            '⊈', # NEITHER A SUBSET OF NOR EQUAL TO
'nsubseteqq':           '⫅̸', # SUBSET OF ABOVE EQUALS SIGN with slash
'nsucc':                '⊁', # DOES NOT SUCCEED
'nsucceq':              '⪰̸', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash
'nsup':                 '⊅', # NOT A SUPERSET OF
'nsupE':                '⫆̸', # SUPERSET OF ABOVE EQUALS SIGN with slash
'nsupe':                '⊉', # NEITHER A SUPERSET OF NOR EQUAL TO
'nsupset':              '⊃⃒', # SUPERSET OF with vertical line
'nsupseteq':            '⊉', # NEITHER A SUPERSET OF NOR EQUAL TO
'nsupseteqq':           '⫆̸', # SUPERSET OF ABOVE EQUALS SIGN with slash
'ntgl':                 '≹', # NEITHER GREATER-THAN NOR LESS-THAN
'ntilde':               'ñ', # LATIN SMALL LETTER N WITH TILDE
'ntlg':                 '≸', # NEITHER LESS-THAN NOR GREATER-THAN
'ntriangleleft':        '⋪', # NOT NORMAL SUBGROUP OF
'ntrianglelefteq':      '⋬', # NOT NORMAL SUBGROUP OF OR EQUAL TO
'ntriangleright':       '⋫', # DOES NOT CONTAIN AS NORMAL SUBGROUP
'ntrianglerighteq':     '⋭', # DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
'nu':                   'ν', # GREEK SMALL LETTER NU
'num':                  '#', # NUMBER SIGN
'numero':               '№', # NUMERO SIGN
'numsp':                ' ', # FIGURE SPACE
'nvDash':               '⊭', # NOT TRUE
'nvHarr':               '⤄', # LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
'nvap':                 '≍⃒', # EQUIVALENT TO with vertical line
'nvdash':               '⊬', # DOES NOT PROVE
'nvge':                 '≥⃒', # GREATER-THAN OR EQUAL TO with vertical line
'nvgt':                 '>⃒', # GREATER-THAN SIGN with vertical line
'nvinfin':              '⧞', # INFINITY NEGATED WITH VERTICAL BAR
'nvlArr':               '⤂', # LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
'nvle':                 '≤⃒', # LESS-THAN OR EQUAL TO with vertical line
'nvlt':                 '<⃒', # LESS-THAN SIGN with vertical line
'nvltrie':              '⊴⃒', # NORMAL SUBGROUP OF OR EQUAL TO with vertical line
'nvrArr':               '⤃', # RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
'nvrtrie':              '⊵⃒', # CONTAINS AS NORMAL SUBGROUP OR EQUAL TO with vertical line
'nvsim':                '∼⃒', # TILDE OPERATOR with vertical line
'nwArr':                '⇖', # NORTH WEST DOUBLE ARROW
'nwarhk':               '⤣', # NORTH WEST ARROW WITH HOOK
'nwarr':                '↖', # NORTH WEST ARROW
'nwarrow':              '↖', # NORTH WEST ARROW
'nwnear':               '⤧', # NORTH WEST ARROW AND NORTH EAST ARROW
'oS':                   'Ⓢ', # CIRCLED LATIN CAPITAL LETTER S
'oacgr':                'ό', # GREEK SMALL LETTER OMICRON WITH TONOS
'oacute':               'ó', # LATIN SMALL LETTER O WITH ACUTE
'oast':                 '⊛', # CIRCLED ASTERISK OPERATOR
'ocir':                 '⊚', # CIRCLED RING OPERATOR
'ocirc':                'ô', # LATIN SMALL LETTER O WITH CIRCUMFLEX
'ocy':                  'о', # CYRILLIC SMALL LETTER O
'odash':                '⊝', # CIRCLED DASH
'odblac':               'ő', # LATIN SMALL LETTER O WITH DOUBLE ACUTE
'odiv':                 '⨸', # CIRCLED DIVISION SIGN
'odot':                 '⊙', # CIRCLED DOT OPERATOR
'odsold':               '⦼', # CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
'oelig':                'œ', # LATIN SMALL LIGATURE OE
'ofcir':                '⦿', # CIRCLED BULLET
'ofr':                  '𝔬', # MATHEMATICAL FRAKTUR SMALL O
'ogon':                 '˛', # OGONEK
'ogr':                  'ο', # GREEK SMALL LETTER OMICRON
'ograve':               'ò', # LATIN SMALL LETTER O WITH GRAVE
'ogt':                  '⧁', # CIRCLED GREATER-THAN
'ohacgr':               'ώ', # GREEK SMALL LETTER OMEGA WITH TONOS
'ohbar':                '⦵', # CIRCLE WITH HORIZONTAL BAR
'ohgr':                 'ω', # GREEK SMALL LETTER OMEGA
'ohm':                  'Ω', # GREEK CAPITAL LETTER OMEGA
'oint':                 '∮', # CONTOUR INTEGRAL
'olarr':                '↺', # ANTICLOCKWISE OPEN CIRCLE ARROW
'olcir':                '⦾', # CIRCLED WHITE BULLET
'olcross':              '⦻', # CIRCLE WITH SUPERIMPOSED X
'oline':                '‾', # OVERLINE
'olt':                  '⧀', # CIRCLED LESS-THAN
'omacr':                'ō', # LATIN SMALL LETTER O WITH MACRON
'omega':                'ω', # GREEK SMALL LETTER OMEGA
'omicron':              'ο', # GREEK SMALL LETTER OMICRON
'omid':                 '⦶', # CIRCLED VERTICAL BAR
'ominus':               '⊖', # CIRCLED MINUS
'oopf':                 '𝕠', # MATHEMATICAL DOUBLE-STRUCK SMALL O
'opar':                 '⦷', # CIRCLED PARALLEL
'operp':                '⦹', # CIRCLED PERPENDICULAR
'oplus':                '⊕', # CIRCLED PLUS
'or':                   '∨', # LOGICAL OR
'orarr':                '↻', # CLOCKWISE OPEN CIRCLE ARROW
'ord':                  '⩝', # LOGICAL OR WITH HORIZONTAL DASH
'order':                'ℴ', # SCRIPT SMALL O
'orderof':              'ℴ', # SCRIPT SMALL O
'ordf':                 'ª', # FEMININE ORDINAL INDICATOR
'ordm':                 'º', # MASCULINE ORDINAL INDICATOR
'origof':               '⊶', # ORIGINAL OF
'oror':                 '⩖', # TWO INTERSECTING LOGICAL OR
'orslope':              '⩗', # SLOPING LARGE OR
'orv':                  '⩛', # LOGICAL OR WITH MIDDLE STEM
'oscr':                 'ℴ', # SCRIPT SMALL O
'oslash':               'ø', # LATIN SMALL LETTER O WITH STROKE
'osol':                 '⊘', # CIRCLED DIVISION SLASH
'otilde':               'õ', # LATIN SMALL LETTER O WITH TILDE
'otimes':               '⊗', # CIRCLED TIMES
'otimesas':             '⨶', # CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
'ouml':                 'ö', # LATIN SMALL LETTER O WITH DIAERESIS
'ovbar':                '⌽', # APL FUNCTIONAL SYMBOL CIRCLE STILE
'par':                  '∥', # PARALLEL TO
'para':                 '¶', # PILCROW SIGN
'parallel':             '∥', # PARALLEL TO
'parsim':               '⫳', # PARALLEL WITH TILDE OPERATOR
'parsl':                '⫽', # DOUBLE SOLIDUS OPERATOR
'part':                 '∂', # PARTIAL DIFFERENTIAL
'pcy':                  'п', # CYRILLIC SMALL LETTER PE
'percnt':               '%', # PERCENT SIGN
'period':               '.', # FULL STOP
'permil':               '‰', # PER MILLE SIGN
'perp':                 '⊥', # UP TACK
'pertenk':              '‱', # PER TEN THOUSAND SIGN
'pfr':                  '𝔭', # MATHEMATICAL FRAKTUR SMALL P
'pgr':                  'π', # GREEK SMALL LETTER PI
'phgr':                 'φ', # GREEK SMALL LETTER PHI
'phi':                  'φ', # GREEK SMALL LETTER PHI
'phiv':                 'ϕ', # GREEK PHI SYMBOL
'phmmat':               'ℳ', # SCRIPT CAPITAL M
'phone':                '☎', # BLACK TELEPHONE
'pi':                   'π', # GREEK SMALL LETTER PI
'pitchfork':            '⋔', # PITCHFORK
'piv':                  'ϖ', # GREEK PI SYMBOL
'planck':               'ℏ', # PLANCK CONSTANT OVER TWO PI
'planckh':              'ℎ', # PLANCK CONSTANT
'plankv':               'ℏ', # PLANCK CONSTANT OVER TWO PI
'plus':                 '+', # PLUS SIGN
'plusacir':             '⨣', # PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
'plusb':                '⊞', # SQUARED PLUS
'pluscir':              '⨢', # PLUS SIGN WITH SMALL CIRCLE ABOVE
'plusdo':               '∔', # DOT PLUS
'plusdu':               '⨥', # PLUS SIGN WITH DOT BELOW
'pluse':                '⩲', # PLUS SIGN ABOVE EQUALS SIGN
'plusmn':               '±', # PLUS-MINUS SIGN
'plussim':              '⨦', # PLUS SIGN WITH TILDE BELOW
'plustwo':              '⨧', # PLUS SIGN WITH SUBSCRIPT TWO
'pm':                   '±', # PLUS-MINUS SIGN
'pointint':             '⨕', # INTEGRAL AROUND A POINT OPERATOR
'popf':                 '𝕡', # MATHEMATICAL DOUBLE-STRUCK SMALL P
'pound':                '£', # POUND SIGN
'pr':                   '≺', # PRECEDES
'prE':                  '⪳', # PRECEDES ABOVE EQUALS SIGN
'prap':                 '⪷', # PRECEDES ABOVE ALMOST EQUAL TO
'prcue':                '≼', # PRECEDES OR EQUAL TO
'pre':                  '⪯', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
'prec':                 '≺', # PRECEDES
'precapprox':           '⪷', # PRECEDES ABOVE ALMOST EQUAL TO
'preccurlyeq':          '≼', # PRECEDES OR EQUAL TO
'preceq':               '⪯', # PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
'precnapprox':          '⪹', # PRECEDES ABOVE NOT ALMOST EQUAL TO
'precneqq':             '⪵', # PRECEDES ABOVE NOT EQUAL TO
'precnsim':             '⋨', # PRECEDES BUT NOT EQUIVALENT TO
'precsim':              '≾', # PRECEDES OR EQUIVALENT TO
'prime':                '′', # PRIME
'primes':               'ℙ', # DOUBLE-STRUCK CAPITAL P
'prnE':                 '⪵', # PRECEDES ABOVE NOT EQUAL TO
'prnap':                '⪹', # PRECEDES ABOVE NOT ALMOST EQUAL TO
'prnsim':               '⋨', # PRECEDES BUT NOT EQUIVALENT TO
'prod':                 '∏', # N-ARY PRODUCT
'profalar':             '⌮', # ALL AROUND-PROFILE
'profline':             '⌒', # ARC
'profsurf':             '⌓', # SEGMENT
'prop':                 '∝', # PROPORTIONAL TO
'propto':               '∝', # PROPORTIONAL TO
'prsim':                '≾', # PRECEDES OR EQUIVALENT TO
'prurel':               '⊰', # PRECEDES UNDER RELATION
'pscr':                 '𝓅', # MATHEMATICAL SCRIPT SMALL P
'psgr':                 'ψ', # GREEK SMALL LETTER PSI
'psi':                  'ψ', # GREEK SMALL LETTER PSI
'puncsp':               ' ', # PUNCTUATION SPACE
'qfr':                  '𝔮', # MATHEMATICAL FRAKTUR SMALL Q
'qint':                 '⨌', # QUADRUPLE INTEGRAL OPERATOR
'qopf':                 '𝕢', # MATHEMATICAL DOUBLE-STRUCK SMALL Q
'qprime':               '⁗', # QUADRUPLE PRIME
'qscr':                 '𝓆', # MATHEMATICAL SCRIPT SMALL Q
'quaternions':          'ℍ', # DOUBLE-STRUCK CAPITAL H
'quatint':              '⨖', # QUATERNION INTEGRAL OPERATOR
'quest':                '?', # QUESTION MARK
'questeq':              '≟', # QUESTIONED EQUAL TO
'quot':                 '"', # QUOTATION MARK
'rAarr':                '⇛', # RIGHTWARDS TRIPLE ARROW
'rArr':                 '⇒', # RIGHTWARDS DOUBLE ARROW
'rAtail':               '⤜', # RIGHTWARDS DOUBLE ARROW-TAIL
'rBarr':                '⤏', # RIGHTWARDS TRIPLE DASH ARROW
'rHar':                 '⥤', # RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
'race':                 '∽̱', # REVERSED TILDE with underline
'racute':               'ŕ', # LATIN SMALL LETTER R WITH ACUTE
'radic':                '√', # SQUARE ROOT
'raemptyv':             '⦳', # EMPTY SET WITH RIGHT ARROW ABOVE
'rang':                 '⟩', # MATHEMATICAL RIGHT ANGLE BRACKET
'rangd':                '⦒', # RIGHT ANGLE BRACKET WITH DOT
'range':                '⦥', # REVERSED ANGLE WITH UNDERBAR
'rangle':               '⟩', # MATHEMATICAL RIGHT ANGLE BRACKET
'raquo':                '»', # RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
'rarr':                 '→', # RIGHTWARDS ARROW
'rarrap':               '⥵', # RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO
'rarrb':                '⇥', # RIGHTWARDS ARROW TO BAR
'rarrbfs':              '⤠', # RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
'rarrc':                '⤳', # WAVE ARROW POINTING DIRECTLY RIGHT
'rarrfs':               '⤞', # RIGHTWARDS ARROW TO BLACK DIAMOND
'rarrhk':               '↪', # RIGHTWARDS ARROW WITH HOOK
'rarrlp':               '↬', # RIGHTWARDS ARROW WITH LOOP
'rarrpl':               '⥅', # RIGHTWARDS ARROW WITH PLUS BELOW
'rarrsim':              '⥴', # RIGHTWARDS ARROW ABOVE TILDE OPERATOR
'rarrtl':               '↣', # RIGHTWARDS ARROW WITH TAIL
'rarrw':                '↝', # RIGHTWARDS WAVE ARROW
'ratail':               '⤚', # RIGHTWARDS ARROW-TAIL
'ratio':                '∶', # RATIO
'rationals':            'ℚ', # DOUBLE-STRUCK CAPITAL Q
'rbarr':                '⤍', # RIGHTWARDS DOUBLE DASH ARROW
'rbbrk':                '❳', # LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
'rbrace':               '}', # RIGHT CURLY BRACKET
'rbrack':               ']', # RIGHT SQUARE BRACKET
'rbrke':                '⦌', # RIGHT SQUARE BRACKET WITH UNDERBAR
'rbrksld':              '⦎', # RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
'rbrkslu':              '⦐', # RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
'rcaron':               'ř', # LATIN SMALL LETTER R WITH CARON
'rcedil':               'ŗ', # LATIN SMALL LETTER R WITH CEDILLA
'rceil':                '⌉', # RIGHT CEILING
'rcub':                 '}', # RIGHT CURLY BRACKET
'rcy':                  'р', # CYRILLIC SMALL LETTER ER
'rdca':                 '⤷', # ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS
'rdldhar':              '⥩', # RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
'rdquo':                '”', # RIGHT DOUBLE QUOTATION MARK
'rdquor':               '”', # RIGHT DOUBLE QUOTATION MARK
'rdsh':                 '↳', # DOWNWARDS ARROW WITH TIP RIGHTWARDS
'real':                 'ℜ', # BLACK-LETTER CAPITAL R
'realine':              'ℛ', # SCRIPT CAPITAL R
'realpart':             'ℜ', # BLACK-LETTER CAPITAL R
'reals':                'ℝ', # DOUBLE-STRUCK CAPITAL R
'rect':                 '▭', # WHITE RECTANGLE
'reg':                  '®', # REGISTERED SIGN
'rfisht':               '⥽', # RIGHT FISH TAIL
'rfloor':               '⌋', # RIGHT FLOOR
'rfr':                  '𝔯', # MATHEMATICAL FRAKTUR SMALL R
'rgr':                  'ρ', # GREEK SMALL LETTER RHO
'rhard':                '⇁', # RIGHTWARDS HARPOON WITH BARB DOWNWARDS
'rharu':                '⇀', # RIGHTWARDS HARPOON WITH BARB UPWARDS
'rharul':               '⥬', # RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
'rho':                  'ρ', # GREEK SMALL LETTER RHO
'rhov':                 'ϱ', # GREEK RHO SYMBOL
'rightarrow':           '→', # RIGHTWARDS ARROW
'rightarrowtail':       '↣', # RIGHTWARDS ARROW WITH TAIL
'rightharpoondown':     '⇁', # RIGHTWARDS HARPOON WITH BARB DOWNWARDS
'rightharpoonup':       '⇀', # RIGHTWARDS HARPOON WITH BARB UPWARDS
'rightleftarrows':      '⇄', # RIGHTWARDS ARROW OVER LEFTWARDS ARROW
'rightleftharpoons':    '⇌', # RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
'rightrightarrows':     '⇉', # RIGHTWARDS PAIRED ARROWS
'rightsquigarrow':      '↝', # RIGHTWARDS WAVE ARROW
'rightthreetimes':      '⋌', # RIGHT SEMIDIRECT PRODUCT
'ring':                 '˚', # RING ABOVE
'risingdotseq':         '≓', # IMAGE OF OR APPROXIMATELY EQUAL TO
'rlarr':                '⇄', # RIGHTWARDS ARROW OVER LEFTWARDS ARROW
'rlhar':                '⇌', # RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
'rlm':                  '‏', # RIGHT-TO-LEFT MARK
'rmoust':               '⎱', # UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
'rmoustache':           '⎱', # UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
'rnmid':                '⫮', # DOES NOT DIVIDE WITH REVERSED NEGATION SLASH
'roang':                '⟭', # MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
'roarr':                '⇾', # RIGHTWARDS OPEN-HEADED ARROW
'robrk':                '⟧', # MATHEMATICAL RIGHT WHITE SQUARE BRACKET
'ropar':                '⦆', # RIGHT WHITE PARENTHESIS
'ropf':                 '𝕣', # MATHEMATICAL DOUBLE-STRUCK SMALL R
'roplus':               '⨮', # PLUS SIGN IN RIGHT HALF CIRCLE
'rotimes':              '⨵', # MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
'rpar':                 ')', # RIGHT PARENTHESIS
'rpargt':               '⦔', # RIGHT ARC GREATER-THAN BRACKET
'rppolint':             '⨒', # LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
'rrarr':                '⇉', # RIGHTWARDS PAIRED ARROWS
'rsaquo':               '›', # SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
'rscr':                 '𝓇', # MATHEMATICAL SCRIPT SMALL R
'rsh':                  '↱', # UPWARDS ARROW WITH TIP RIGHTWARDS
'rsqb':                 ']', # RIGHT SQUARE BRACKET
'rsquo':                '’', # RIGHT SINGLE QUOTATION MARK
'rsquor':               '’', # RIGHT SINGLE QUOTATION MARK
'rthree':               '⋌', # RIGHT SEMIDIRECT PRODUCT
'rtimes':               '⋊', # RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
'rtri':                 '▹', # WHITE RIGHT-POINTING SMALL TRIANGLE
'rtrie':                '⊵', # CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
'rtrif':                '▸', # BLACK RIGHT-POINTING SMALL TRIANGLE
'rtriltri':             '⧎', # RIGHT TRIANGLE ABOVE LEFT TRIANGLE
'ruluhar':              '⥨', # RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
'rx':                   '℞', # PRESCRIPTION TAKE
'sacute':               'ś', # LATIN SMALL LETTER S WITH ACUTE
'sbquo':                '‚', # SINGLE LOW-9 QUOTATION MARK
'sc':                   '≻', # SUCCEEDS
'scE':                  '⪴', # SUCCEEDS ABOVE EQUALS SIGN
'scap':                 '⪸', # SUCCEEDS ABOVE ALMOST EQUAL TO
'scaron':               'š', # LATIN SMALL LETTER S WITH CARON
'sccue':                '≽', # SUCCEEDS OR EQUAL TO
'sce':                  '⪰', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
'scedil':               'ş', # LATIN SMALL LETTER S WITH CEDILLA
'scirc':                'ŝ', # LATIN SMALL LETTER S WITH CIRCUMFLEX
'scnE':                 '⪶', # SUCCEEDS ABOVE NOT EQUAL TO
'scnap':                '⪺', # SUCCEEDS ABOVE NOT ALMOST EQUAL TO
'scnsim':               '⋩', # SUCCEEDS BUT NOT EQUIVALENT TO
'scpolint':             '⨓', # LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
'scsim':                '≿', # SUCCEEDS OR EQUIVALENT TO
'scy':                  'с', # CYRILLIC SMALL LETTER ES
'sdot':                 '⋅', # DOT OPERATOR
'sdotb':                '⊡', # SQUARED DOT OPERATOR
'sdote':                '⩦', # EQUALS SIGN WITH DOT BELOW
'seArr':                '⇘', # SOUTH EAST DOUBLE ARROW
'searhk':               '⤥', # SOUTH EAST ARROW WITH HOOK
'searr':                '↘', # SOUTH EAST ARROW
'searrow':              '↘', # SOUTH EAST ARROW
'sect':                 '§', # SECTION SIGN
'semi':                 ';', # SEMICOLON
'seswar':               '⤩', # SOUTH EAST ARROW AND SOUTH WEST ARROW
'setminus':             '∖', # SET MINUS
'setmn':                '∖', # SET MINUS
'sext':                 '✶', # SIX POINTED BLACK STAR
'sfgr':                 'ς', # GREEK SMALL LETTER FINAL SIGMA
'sfr':                  '𝔰', # MATHEMATICAL FRAKTUR SMALL S
'sfrown':               '⌢', # FROWN
'sgr':                  'σ', # GREEK SMALL LETTER SIGMA
'sharp':                '♯', # MUSIC SHARP SIGN
'shchcy':               'щ', # CYRILLIC SMALL LETTER SHCHA
'shcy':                 'ш', # CYRILLIC SMALL LETTER SHA
'shortmid':             '∣', # DIVIDES
'shortparallel':        '∥', # PARALLEL TO
'shy':                  '­', # SOFT HYPHEN
'sigma':                'σ', # GREEK SMALL LETTER SIGMA
'sigmaf':               'ς', # GREEK SMALL LETTER FINAL SIGMA
'sigmav':               'ς', # GREEK SMALL LETTER FINAL SIGMA
'sim':                  '∼', # TILDE OPERATOR
'simdot':               '⩪', # TILDE OPERATOR WITH DOT ABOVE
'sime':                 '≃', # ASYMPTOTICALLY EQUAL TO
'simeq':                '≃', # ASYMPTOTICALLY EQUAL TO
'simg':                 '⪞', # SIMILAR OR GREATER-THAN
'simgE':                '⪠', # SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
'siml':                 '⪝', # SIMILAR OR LESS-THAN
'simlE':                '⪟', # SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
'simne':                '≆', # APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
'simplus':              '⨤', # PLUS SIGN WITH TILDE ABOVE
'simrarr':              '⥲', # TILDE OPERATOR ABOVE RIGHTWARDS ARROW
'slarr':                '←', # LEFTWARDS ARROW
'smallsetminus':        '∖', # SET MINUS
'smashp':               '⨳', # SMASH PRODUCT
'smeparsl':             '⧤', # EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
'smid':                 '∣', # DIVIDES
'smile':                '⌣', # SMILE
'smt':                  '⪪', # SMALLER THAN
'smte':                 '⪬', # SMALLER THAN OR EQUAL TO
'smtes':                '⪬︀', # SMALLER THAN OR slanted EQUAL
'softcy':               'ь', # CYRILLIC SMALL LETTER SOFT SIGN
'sol':                  '/', # SOLIDUS
'solb':                 '⧄', # SQUARED RISING DIAGONAL SLASH
'solbar':               '⌿', # APL FUNCTIONAL SYMBOL SLASH BAR
'sopf':                 '𝕤', # MATHEMATICAL DOUBLE-STRUCK SMALL S
'spades':               '♠', # BLACK SPADE SUIT
'spadesuit':            '♠', # BLACK SPADE SUIT
'spar':                 '∥', # PARALLEL TO
'sqcap':                '⊓', # SQUARE CAP
'sqcaps':               '⊓︀', # SQUARE CAP with serifs
'sqcup':                '⊔', # SQUARE CUP
'sqcups':               '⊔︀', # SQUARE CUP with serifs
'sqsub':                '⊏', # SQUARE IMAGE OF
'sqsube':               '⊑', # SQUARE IMAGE OF OR EQUAL TO
'sqsubset':             '⊏', # SQUARE IMAGE OF
'sqsubseteq':           '⊑', # SQUARE IMAGE OF OR EQUAL TO
'sqsup':                '⊐', # SQUARE ORIGINAL OF
'sqsupe':               '⊒', # SQUARE ORIGINAL OF OR EQUAL TO
'sqsupset':             '⊐', # SQUARE ORIGINAL OF
'sqsupseteq':           '⊒', # SQUARE ORIGINAL OF OR EQUAL TO
'squ':                  '□', # WHITE SQUARE
'square':               '□', # WHITE SQUARE
'squarf':               '▪', # BLACK SMALL SQUARE
'squf':                 '▪', # BLACK SMALL SQUARE
'srarr':                '→', # RIGHTWARDS ARROW
'sscr':                 '𝓈', # MATHEMATICAL SCRIPT SMALL S
'ssetmn':               '∖', # SET MINUS
'ssmile':               '⌣', # SMILE
'sstarf':               '⋆', # STAR OPERATOR
'star':                 '☆', # WHITE STAR
'starf':                '★', # BLACK STAR
'straightepsilon':      'ϵ', # GREEK LUNATE EPSILON SYMBOL
'straightphi':          'ϕ', # GREEK PHI SYMBOL
'strns':                '¯', # MACRON
'sub':                  '⊂', # SUBSET OF
'subE':                 '⫅', # SUBSET OF ABOVE EQUALS SIGN
'subdot':               '⪽', # SUBSET WITH DOT
'sube':                 '⊆', # SUBSET OF OR EQUAL TO
'subedot':              '⫃', # SUBSET OF OR EQUAL TO WITH DOT ABOVE
'submult':              '⫁', # SUBSET WITH MULTIPLICATION SIGN BELOW
'subnE':                '⫋', # SUBSET OF ABOVE NOT EQUAL TO
'subne':                '⊊', # SUBSET OF WITH NOT EQUAL TO
'subplus':              '⪿', # SUBSET WITH PLUS SIGN BELOW
'subrarr':              '⥹', # SUBSET ABOVE RIGHTWARDS ARROW
'subset':               '⊂', # SUBSET OF
'subseteq':             '⊆', # SUBSET OF OR EQUAL TO
'subseteqq':            '⫅', # SUBSET OF ABOVE EQUALS SIGN
'subsetneq':            '⊊', # SUBSET OF WITH NOT EQUAL TO
'subsetneqq':           '⫋', # SUBSET OF ABOVE NOT EQUAL TO
'subsim':               '⫇', # SUBSET OF ABOVE TILDE OPERATOR
'subsub':               '⫕', # SUBSET ABOVE SUBSET
'subsup':               '⫓', # SUBSET ABOVE SUPERSET
'succ':                 '≻', # SUCCEEDS
'succapprox':           '⪸', # SUCCEEDS ABOVE ALMOST EQUAL TO
'succcurlyeq':          '≽', # SUCCEEDS OR EQUAL TO
'succeq':               '⪰', # SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
'succnapprox':          '⪺', # SUCCEEDS ABOVE NOT ALMOST EQUAL TO
'succneqq':             '⪶', # SUCCEEDS ABOVE NOT EQUAL TO
'succnsim':             '⋩', # SUCCEEDS BUT NOT EQUIVALENT TO
'succsim':              '≿', # SUCCEEDS OR EQUIVALENT TO
'sum':                  '∑', # N-ARY SUMMATION
'sung':                 '♪', # EIGHTH NOTE
'sup':                  '⊃', # SUPERSET OF
'sup1':                 '¹', # SUPERSCRIPT ONE
'sup2':                 '²', # SUPERSCRIPT TWO
'sup3':                 '³', # SUPERSCRIPT THREE
'supE':                 '⫆', # SUPERSET OF ABOVE EQUALS SIGN
'supdot':               '⪾', # SUPERSET WITH DOT
'supdsub':              '⫘', # SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
'supe':                 '⊇', # SUPERSET OF OR EQUAL TO
'supedot':              '⫄', # SUPERSET OF OR EQUAL TO WITH DOT ABOVE
'suphsol':              '⟉', # SUPERSET PRECEDING SOLIDUS
'suphsub':              '⫗', # SUPERSET BESIDE SUBSET
'suplarr':              '⥻', # SUPERSET ABOVE LEFTWARDS ARROW
'supmult':              '⫂', # SUPERSET WITH MULTIPLICATION SIGN BELOW
'supnE':                '⫌', # SUPERSET OF ABOVE NOT EQUAL TO
'supne':                '⊋', # SUPERSET OF WITH NOT EQUAL TO
'supplus':              '⫀', # SUPERSET WITH PLUS SIGN BELOW
'supset':               '⊃', # SUPERSET OF
'supseteq':             '⊇', # SUPERSET OF OR EQUAL TO
'supseteqq':            '⫆', # SUPERSET OF ABOVE EQUALS SIGN
'supsetneq':            '⊋', # SUPERSET OF WITH NOT EQUAL TO
'supsetneqq':           '⫌', # SUPERSET OF ABOVE NOT EQUAL TO
'supsim':               '⫈', # SUPERSET OF ABOVE TILDE OPERATOR
'supsub':               '⫔', # SUPERSET ABOVE SUBSET
'supsup':               '⫖', # SUPERSET ABOVE SUPERSET
'swArr':                '⇙', # SOUTH WEST DOUBLE ARROW
'swarhk':               '⤦', # SOUTH WEST ARROW WITH HOOK
'swarr':                '↙', # SOUTH WEST ARROW
'swarrow':              '↙', # SOUTH WEST ARROW
'swnwar':               '⤪', # SOUTH WEST ARROW AND NORTH WEST ARROW
'szlig':                'ß', # LATIN SMALL LETTER SHARP S
'target':               '⌖', # POSITION INDICATOR
'tau':                  'τ', # GREEK SMALL LETTER TAU
'tbrk':                 '⎴', # TOP SQUARE BRACKET
'tcaron':               'ť', # LATIN SMALL LETTER T WITH CARON
'tcedil':               'ţ', # LATIN SMALL LETTER T WITH CEDILLA
'tcy':                  'т', # CYRILLIC SMALL LETTER TE
'tdot':                 '\u20DB', # COMBINING THREE DOTS ABOVE
'telrec':               '⌕', # TELEPHONE RECORDER
'tfr':                  '𝔱', # MATHEMATICAL FRAKTUR SMALL T
'tgr':                  'τ', # GREEK SMALL LETTER TAU
'there4':               '∴', # THEREFORE
'therefore':            '∴', # THEREFORE
'theta':                'θ', # GREEK SMALL LETTER THETA
'thetasym':             'ϑ', # GREEK THETA SYMBOL
'thetav':               'ϑ', # GREEK THETA SYMBOL
'thgr':                 'θ', # GREEK SMALL LETTER THETA
'thickapprox':          '≈', # ALMOST EQUAL TO
'thicksim':             '∼', # TILDE OPERATOR
'thinsp':               ' ', # THIN SPACE
'thkap':                '≈', # ALMOST EQUAL TO
'thksim':               '∼', # TILDE OPERATOR
'thorn':                'þ', # LATIN SMALL LETTER THORN
'tilde':                '˜', # SMALL TILDE
'times':                '×', # MULTIPLICATION SIGN
'timesb':               '⊠', # SQUARED TIMES
'timesbar':             '⨱', # MULTIPLICATION SIGN WITH UNDERBAR
'timesd':               '⨰', # MULTIPLICATION SIGN WITH DOT ABOVE
'tint':                 '∭', # TRIPLE INTEGRAL
'toea':                 '⤨', # NORTH EAST ARROW AND SOUTH EAST ARROW
'top':                  '⊤', # DOWN TACK
'topbot':               '⌶', # APL FUNCTIONAL SYMBOL I-BEAM
'topcir':               '⫱', # DOWN TACK WITH CIRCLE BELOW
'topf':                 '𝕥', # MATHEMATICAL DOUBLE-STRUCK SMALL T
'topfork':              '⫚', # PITCHFORK WITH TEE TOP
'tosa':                 '⤩', # SOUTH EAST ARROW AND SOUTH WEST ARROW
'tprime':               '‴', # TRIPLE PRIME
'trade':                '™', # TRADE MARK SIGN
'triangle':             '▵', # WHITE UP-POINTING SMALL TRIANGLE
'triangledown':         '▿', # WHITE DOWN-POINTING SMALL TRIANGLE
'triangleleft':         '◃', # WHITE LEFT-POINTING SMALL TRIANGLE
'trianglelefteq':       '⊴', # NORMAL SUBGROUP OF OR EQUAL TO
'triangleq':            '≜', # DELTA EQUAL TO
'triangleright':        '▹', # WHITE RIGHT-POINTING SMALL TRIANGLE
'trianglerighteq':      '⊵', # CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
'tridot':               '◬', # WHITE UP-POINTING TRIANGLE WITH DOT
'trie':                 '≜', # DELTA EQUAL TO
'triminus':             '⨺', # MINUS SIGN IN TRIANGLE
'triplus':              '⨹', # PLUS SIGN IN TRIANGLE
'trisb':                '⧍', # TRIANGLE WITH SERIFS AT BOTTOM
'tritime':              '⨻', # MULTIPLICATION SIGN IN TRIANGLE
'trpezium':             '⏢', # WHITE TRAPEZIUM
'tscr':                 '𝓉', # MATHEMATICAL SCRIPT SMALL T
'tscy':                 'ц', # CYRILLIC SMALL LETTER TSE
'tshcy':                'ћ', # CYRILLIC SMALL LETTER TSHE
'tstrok':               'ŧ', # LATIN SMALL LETTER T WITH STROKE
'twixt':                '≬', # BETWEEN
'twoheadleftarrow':     '↞', # LEFTWARDS TWO HEADED ARROW
'twoheadrightarrow':    '↠', # RIGHTWARDS TWO HEADED ARROW
'uArr':                 '⇑', # UPWARDS DOUBLE ARROW
'uHar':                 '⥣', # UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
'uacgr':                'ύ', # GREEK SMALL LETTER UPSILON WITH TONOS
'uacute':               'ú', # LATIN SMALL LETTER U WITH ACUTE
'uarr':                 '↑', # UPWARDS ARROW
'ubrcy':                'ў', # CYRILLIC SMALL LETTER SHORT U
'ubreve':               'ŭ', # LATIN SMALL LETTER U WITH BREVE
'ucirc':                'û', # LATIN SMALL LETTER U WITH CIRCUMFLEX
'ucy':                  'у', # CYRILLIC SMALL LETTER U
'udarr':                '⇅', # UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
'udblac':               'ű', # LATIN SMALL LETTER U WITH DOUBLE ACUTE
'udhar':                '⥮', # UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
'udiagr':               'ΰ', # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
'udigr':                'ϋ', # GREEK SMALL LETTER UPSILON WITH DIALYTIKA
'ufisht':               '⥾', # UP FISH TAIL
'ufr':                  '𝔲', # MATHEMATICAL FRAKTUR SMALL U
'ugr':                  'υ', # GREEK SMALL LETTER UPSILON
'ugrave':               'ù', # LATIN SMALL LETTER U WITH GRAVE
'uharl':                '↿', # UPWARDS HARPOON WITH BARB LEFTWARDS
'uharr':                '↾', # UPWARDS HARPOON WITH BARB RIGHTWARDS
'uhblk':                '▀', # UPPER HALF BLOCK
'ulcorn':               '⌜', # TOP LEFT CORNER
'ulcorner':             '⌜', # TOP LEFT CORNER
'ulcrop':               '⌏', # TOP LEFT CROP
'ultri':                '◸', # UPPER LEFT TRIANGLE
'umacr':                'ū', # LATIN SMALL LETTER U WITH MACRON
'uml':                  '¨', # DIAERESIS
'uogon':                'ų', # LATIN SMALL LETTER U WITH OGONEK
'uopf':                 '𝕦', # MATHEMATICAL DOUBLE-STRUCK SMALL U
'uparrow':              '↑', # UPWARDS ARROW
'updownarrow':          '↕', # UP DOWN ARROW
'upharpoonleft':        '↿', # UPWARDS HARPOON WITH BARB LEFTWARDS
'upharpoonright':       '↾', # UPWARDS HARPOON WITH BARB RIGHTWARDS
'uplus':                '⊎', # MULTISET UNION
'upsi':                 'υ', # GREEK SMALL LETTER UPSILON
'upsih':                'ϒ', # GREEK UPSILON WITH HOOK SYMBOL
'upsilon':              'υ', # GREEK SMALL LETTER UPSILON
'upuparrows':           '⇈', # UPWARDS PAIRED ARROWS
'urcorn':               '⌝', # TOP RIGHT CORNER
'urcorner':             '⌝', # TOP RIGHT CORNER
'urcrop':               '⌎', # TOP RIGHT CROP
'uring':                'ů', # LATIN SMALL LETTER U WITH RING ABOVE
'urtri':                '◹', # UPPER RIGHT TRIANGLE
'uscr':                 '𝓊', # MATHEMATICAL SCRIPT SMALL U
'utdot':                '⋰', # UP RIGHT DIAGONAL ELLIPSIS
'utilde':               'ũ', # LATIN SMALL LETTER U WITH TILDE
'utri':                 '▵', # WHITE UP-POINTING SMALL TRIANGLE
'utrif':                '▴', # BLACK UP-POINTING SMALL TRIANGLE
'uuarr':                '⇈', # UPWARDS PAIRED ARROWS
'uuml':                 'ü', # LATIN SMALL LETTER U WITH DIAERESIS
'uwangle':              '⦧', # OBLIQUE ANGLE OPENING DOWN
'vArr':                 '⇕', # UP DOWN DOUBLE ARROW
'vBar':                 '⫨', # SHORT UP TACK WITH UNDERBAR
'vBarv':                '⫩', # SHORT UP TACK ABOVE SHORT DOWN TACK
'vDash':                '⊨', # TRUE
'vangrt':               '⦜', # RIGHT ANGLE VARIANT WITH SQUARE
'varepsilon':           'ϵ', # GREEK LUNATE EPSILON SYMBOL
'varkappa':             'ϰ', # GREEK KAPPA SYMBOL
'varnothing':           '∅', # EMPTY SET
'varphi':               'ϕ', # GREEK PHI SYMBOL
'varpi':                'ϖ', # GREEK PI SYMBOL
'varpropto':            '∝', # PROPORTIONAL TO
'varr':                 '↕', # UP DOWN ARROW
'varrho':               'ϱ', # GREEK RHO SYMBOL
'varsigma':             'ς', # GREEK SMALL LETTER FINAL SIGMA
'varsubsetneq':         '⊊︀', # SUBSET OF WITH NOT EQUAL TO - variant with stroke through bottom members
'varsubsetneqq':        '⫋︀', # SUBSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members
'varsupsetneq':         '⊋︀', # SUPERSET OF WITH NOT EQUAL TO - variant with stroke through bottom members
'varsupsetneqq':        '⫌︀', # SUPERSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members
'vartheta':             'ϑ', # GREEK THETA SYMBOL
'vartriangleleft':      '⊲', # NORMAL SUBGROUP OF
'vartriangleright':     '⊳', # CONTAINS AS NORMAL SUBGROUP
'vcy':                  'в', # CYRILLIC SMALL LETTER VE
'vdash':                '⊢', # RIGHT TACK
'vee':                  '∨', # LOGICAL OR
'veebar':               '⊻', # XOR
'veeeq':                '≚', # EQUIANGULAR TO
'vellip':               '⋮', # VERTICAL ELLIPSIS
'verbar':               '|', # VERTICAL LINE
'vert':                 '|', # VERTICAL LINE
'vfr':                  '𝔳', # MATHEMATICAL FRAKTUR SMALL V
'vltri':                '⊲', # NORMAL SUBGROUP OF
'vnsub':                '⊂⃒', # SUBSET OF with vertical line
'vnsup':                '⊃⃒', # SUPERSET OF with vertical line
'vopf':                 '𝕧', # MATHEMATICAL DOUBLE-STRUCK SMALL V
'vprop':                '∝', # PROPORTIONAL TO
'vrtri':                '⊳', # CONTAINS AS NORMAL SUBGROUP
'vscr':                 '𝓋', # MATHEMATICAL SCRIPT SMALL V
'vsubnE':               '⫋︀', # SUBSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members
'vsubne':               '⊊︀', # SUBSET OF WITH NOT EQUAL TO - variant with stroke through bottom members
'vsupnE':               '⫌︀', # SUPERSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members
'vsupne':               '⊋︀', # SUPERSET OF WITH NOT EQUAL TO - variant with stroke through bottom members
'vzigzag':              '⦚', # VERTICAL ZIGZAG LINE
'wcirc':                'ŵ', # LATIN SMALL LETTER W WITH CIRCUMFLEX
'wedbar':               '⩟', # LOGICAL AND WITH UNDERBAR
'wedge':                '∧', # LOGICAL AND
'wedgeq':               '≙', # ESTIMATES
'weierp':               '℘', # SCRIPT CAPITAL P
'wfr':                  '𝔴', # MATHEMATICAL FRAKTUR SMALL W
'wopf':                 '𝕨', # MATHEMATICAL DOUBLE-STRUCK SMALL W
'wp':                   '℘', # SCRIPT CAPITAL P
'wr':                   '≀', # WREATH PRODUCT
'wreath':               '≀', # WREATH PRODUCT
'wscr':                 '𝓌', # MATHEMATICAL SCRIPT SMALL W
'xcap':                 '⋂', # N-ARY INTERSECTION
'xcirc':                '◯', # LARGE CIRCLE
'xcup':                 '⋃', # N-ARY UNION
'xdtri':                '▽', # WHITE DOWN-POINTING TRIANGLE
'xfr':                  '𝔵', # MATHEMATICAL FRAKTUR SMALL X
'xgr':                  'ξ', # GREEK SMALL LETTER XI
'xhArr':                '⟺', # LONG LEFT RIGHT DOUBLE ARROW
'xharr':                '⟷', # LONG LEFT RIGHT ARROW
'xi':                   'ξ', # GREEK SMALL LETTER XI
'xlArr':                '⟸', # LONG LEFTWARDS DOUBLE ARROW
'xlarr':                '⟵', # LONG LEFTWARDS ARROW
'xmap':                 '⟼', # LONG RIGHTWARDS ARROW FROM BAR
'xnis':                 '⋻', # CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
'xodot':                '⨀', # N-ARY CIRCLED DOT OPERATOR
'xopf':                 '𝕩', # MATHEMATICAL DOUBLE-STRUCK SMALL X
'xoplus':               '⨁', # N-ARY CIRCLED PLUS OPERATOR
'xotime':               '⨂', # N-ARY CIRCLED TIMES OPERATOR
'xrArr':                '⟹', # LONG RIGHTWARDS DOUBLE ARROW
'xrarr':                '⟶', # LONG RIGHTWARDS ARROW
'xscr':                 '𝓍', # MATHEMATICAL SCRIPT SMALL X
'xsqcup':               '⨆', # N-ARY SQUARE UNION OPERATOR
'xuplus':               '⨄', # N-ARY UNION OPERATOR WITH PLUS
'xutri':                '△', # WHITE UP-POINTING TRIANGLE
'xvee':                 '⋁', # N-ARY LOGICAL OR
'xwedge':               '⋀', # N-ARY LOGICAL AND
'yacute':               'ý', # LATIN SMALL LETTER Y WITH ACUTE
'yacy':                 'я', # CYRILLIC SMALL LETTER YA
'ycirc':                'ŷ', # LATIN SMALL LETTER Y WITH CIRCUMFLEX
'ycy':                  'ы', # CYRILLIC SMALL LETTER YERU
'yen':                  '¥', # YEN SIGN
'yfr':                  '𝔶', # MATHEMATICAL FRAKTUR SMALL Y
'yicy':                 'ї', # CYRILLIC SMALL LETTER YI
'yopf':                 '𝕪', # MATHEMATICAL DOUBLE-STRUCK SMALL Y
'yscr':                 '𝓎', # MATHEMATICAL SCRIPT SMALL Y
'yucy':                 'ю', # CYRILLIC SMALL LETTER YU
'yuml':                 'ÿ', # LATIN SMALL LETTER Y WITH DIAERESIS
'zacute':               'ź', # LATIN SMALL LETTER Z WITH ACUTE
'zcaron':               'ž', # LATIN SMALL LETTER Z WITH CARON
'zcy':                  'з', # CYRILLIC SMALL LETTER ZE
'zdot':                 'ż', # LATIN SMALL LETTER Z WITH DOT ABOVE
'zeetrf':               'ℨ', # BLACK-LETTER CAPITAL Z
'zeta':                 'ζ', # GREEK SMALL LETTER ZETA
'zfr':                  '𝔷', # MATHEMATICAL FRAKTUR SMALL Z
'zgr':                  'ζ', # GREEK SMALL LETTER ZETA
'zhcy':                 'ж', # CYRILLIC SMALL LETTER ZHE
'zigrarr':              '⇝', # RIGHTWARDS SQUIGGLE ARROW
'zopf':                 '𝕫', # MATHEMATICAL DOUBLE-STRUCK SMALL Z
'zscr':                 '𝓏', # MATHEMATICAL SCRIPT SMALL Z
'zwj':                  '‍', # ZERO WIDTH JOINER
'zwnj':                 '‌', # ZERO WIDTH NON-JOINER
}

