import re
import time

class DumbMonitor:
    """
    This is the base class that is inherited by all of the
    children that need to return and have data read from the system
    """

    data = None
    def read(self):
        return self.data;

class Uptime(DumbMonitor):
    """This class lets you retrieve teh uptime for the current
    system. Most of the code is taken from thesmithfam.org"""

    def __init__(self):
        uptime = open('/proc/uptime').readline().split()

        seconds = float(uptime[0])
        self.data = seconds

class Load(DumbMonitor):
    """This class gives you the ability to retrieve
    the information as such as the load average for
    the past minute, 5 minutes and 15 mins."""

    def __init__(self):
        load_average = open('/proc/loadavg', 'r').readline().strip().split()
        
        average_minute, average_five_minutes, average_fifteen_minutes = \
            map(float, load_average[:3])

        self.data = {
            '1min': average_minute, 
            '5mins': average_five_minutes, 
            '15mins': average_fifteen_minutes
        }

class Memory(DumbMonitor):
    """This class gives you the ability to retrieve 
    the amount of memory and various information about
    the memory usage on your computer"""

    def __init__(self):
        parser = re.compile(r'^(?P<key>\S*):\s*(?P<value>\d*)\s*kB')

        result = dict()
        for line in open('/proc/meminfo'):
            match = parser.match(line)
            if not match:
                continue

            key, value = match.groups(['key', 'value'])
            result[key] = int(value)

        self.data = result

class Cpu(DumbMonitor):
    """This class gives you the ability to retrieve
    the amount of cpu usage for the aggregation of CPUs
    This code comes from http://www.boduch.ca/2009/02/python-cpu-usage.html   
    """
    def __init__(self, interval=0.1, percentage=True):
        self.interval = interval
        self.percentage = percentage
        self.data = self.compute()
      
    def get_time(self):
        stat_file = file("/proc/stat", "r")
        time_list = stat_file.readline().split(" ")[2:6]
        stat_file.close()

        for i in range(len(time_list))  :
            time_list[i] = int(time_list[i])
        return time_list
  
    def delta_time(self):
        x = self.get_time()
        time.sleep(self.interval)
        y = self.get_time()
        for i in range(len(x)):
            y[i] -= x[i]
        return y

    def compute(self):
        t = self.delta_time()
        try:
            if self.percentage and t > 0:
                result=100-(t[len(t)-1]*100.00/sum(t))
            else:
                result=sum(t)
        except:
            result=0

        return result  
