import sys
from setuptools import setup, find_packages


if sys.version_info < (3, 0, 0):
    print('ERROR: dvdje requires Python >= 3.0')
    exit(1)


def readme():
    with open('README.rst', encoding="utf-8") as f:
        return f.read()


setup(
    name = "dvdje",
    version = "20131030-1",
    author = "Scott Garrett",
    author_email = "mail@exovenom.net",
    description = "DV Dream Journal Exporter. Exports dream journals from Dream Views in original BBCode format.",
    long_description = readme(),
    license = "GPL3",
    keywords = "dv dreamviews dj export",
    url = "http://pypi.python.org/pypi/dvdje",
    classifiers = [
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Other Audience',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content :: News/Diary',
        'Topic :: Office/Business :: News/Diary',
        'Topic :: Utilities'
    ],

    packages = find_packages(),
    entry_points = {
        'console_scripts': ['dvdje = dvdje.main:main']
    },
)
