#!/usr/bin/env python
#coding:utf-8

# Constants partly taken from sxdf.py by Stani Michiels(Stani) and
# Remigiusz Fiedler(migius)
# Purpose: package constants
# module belongs to package: dxfwrite
# Created: 09.02.2010
# Copyright (C) 2010, Manfred Moitzi
# License: MIT License

__author__ = "mozman <mozman@gmx.at>"

# Valid for: STYLE, LTYPE, APPID, DIMSTYLE, LAYER, LTYPE, STYLE, UCS, VIEW, VPORT
# Standard flag values (bit-coded values):
# 16 = If set, table entry is externally dependent on an xref
# 32 = If both this bit and bit 16 are set, the externally dependent xref
# has been successfully resolved
# 64 = If set, the table entry was referenced by at least one entity in the
# drawing the last time the drawing was edited. (This flag is for the
# benefit of AutoCAD
# commands. It can be ignored by most programs
# that read DXF files and need not be set by programs that write DXF
# files)

STD_FLAGS_DEPENDENT_XREF = 16
STD_FLAGS_DEPENDENT_XREF_RESOLVED = 32
STD_FLAGS_REFERENCED = 64

# text style flags - Section TABLES Table STYLE

# Standard flag values (bit-coded values):
# 1 = If set, this entry describes a shape
# 4 = Vertical text
STD_FLAGS_IS_SHAPE = 1
STD_FLAGS_VERTICAL_TEXT = 4

# Text generation flags (mirror):
# 2 = Text is backward (mirrored in X)
# 4 = Text is upside down (mirrored in Y)
MIRROR_X = 2
MIRROR_Y = 4

# layer flags - Section TABLES Table LAYER

# Standard flags (bit-coded values):
# 1 = Layer is frozen; otherwise layer is thawed
# 2 = Layer is frozen by default in new viewports
# 4 = Layer is locked
STD_FLAGS_LAYER_FROZEN = 1
STD_FLAGS_LAYER_FROZEN_BY_DEFAULT = 2
STD_FLAGS_LAYER_LOCKED = 4
LAYER_FROZEN = STD_FLAGS_LAYER_FROZEN
LAYER_FROZEN_BY_DEFAULT = STD_FLAGS_LAYER_FROZEN_BY_DEFAULT
LAYER_LOCKED = STD_FLAGS_LAYER_LOCKED

# view flags - Section TABLES Table VIEW
# Standard flag values (bit-coded values):
STD_FLAGS_PAPER_SPACE = 1
PAPER_SPACE = STD_FLAGS_PAPER_SPACE

# Orthographic type of UCS GROUPCODE 79:
UCS_NOT_ORTHOGRAPHIC = 0
UCS_TOP =  1
UCS_BOTTOM = 2
UCS_FRONT = 3
UCS_BACK = 4
UCS_LEFT = 5
UCS_RIGHT = 6

#---color values
BYBLOCK=0
BYLAYER=256

#---block-type flags (bit coded values, may be combined):
# Entity: BLOCK
# 70 flags
BLK_ANONYMOUS = 1                # This is an anonymous block generated by hatching, associative dimensioning, other internal operations, or an application
BLK_NON_CONSTANT_ATTRIBUTES = 2  # This block has non-constant attribute definitions (this bit is not set if the block has any attribute definitions that are constant, or has no attribute definitions at all)
BLK_XREF = 4                     # This block is an external reference (xref)
BLK_XREF_OVERLAY = 8             # This block is an xref overlay
BLK_EXTERNAL = 16                # This block is externally dependent
BLK_RESOLVED = 32                # This is a resolved external reference, or dependent of an external reference (ignored on input)
BLK_REFERENCED = 64              # This definition is a referenced external reference (ignored on input)

#---text flags
# horizontal
LEFT = 0
CENTER = 1
RIGHT = 2
ALIGNED = 3 # if vertical alignment = 0
BASELINE_MIDDLE = 4 # if vertical alignment = 0
FIT = 5     # if vertical alignment = 0

# vertical
BASELINE = 0
BOTTOM = 1
MIDDLE = 2
TOP = 3

# Entities: ATTDEF, ATTRIB
# 70 flags
ATTRIB_IS_INVISIBLE = 1 # does not display
ATTRIB_IS_CONST = 2
ATTRIB_REQUIRE_VERIFICATION = 4
ATTRIB_IS_PRESET = 8 # no prompt on insert

# Entities: 3DFACE
# 70 flags
FACE3D_FIRST_EDGE_IS_INVISIBLE = 1
FACE3D_SECOND_EDGE_IS_INVISIBLE = 2
FACE3D_THIRD_EDGE_IS_INVISIBLE = 4
FACE3D_FOURTH_EDGE_IS_INVISIBLE = 8

# Entities: VPORT, VIEW
# 71 view_mode
VMODE_TURNED_OFF = 0
VMODE_PERSPECTIVE_VIEW_ACTIVE = 1
VMODE_FRONT_CLIPPING_ON = 2
VMODE_BACK_CLIPPING_ON = 4
VMODE_UCS_FOLLOW_MODE_ON = 8
VMODE_FRONT_CLIP_NOT_AT_EYE = 16

# Entity: Polyline, Polymesh
# 70 flags
POLYLINE_CLOSED = 1
POLYLINE_MESH_CLOSED_M_DIRECTION = POLYLINE_CLOSED
POLYLINE_CURVE_FIT_VERTICES_ADDED = 2
POLYLINE_SPLINE_FIT_VERTICES_ADDED = 4
POLYLINE_3D_POLYLINE = 8
POLYLINE_3D_POLYMESH = 16
POLYLINE_MESH_CLOSED_N_DIRECTION = 32
POLYLINE_POLYFACE = 64
POLYLINE_GENERATE_LINETYPE_PATTERN =128

# Entity: Polymesh
# 75 surface smooth type
POLYMESH_NO_SMOOTH = 0
POLYMESH_QUADRIC_BSPLINE = 5
POLYMESH_CUBIC_BSPLINE = 6
POLYMESH_BEZIER_SURFACE = 8

#Entity: Vertex
# 70 flags
VTX_EXTRA_VERTEX_CREATED = 1 ## Extra vertex created by curve-fitting
VTX_CURVE_FIT_TANGENT = 2    ## Curve-fit tangent defined for this vertex.
## A curve-fit tangent direction of 0 may be omitted from the DXF output, but is
## significant if this bit is set.
## 4 = unused, never set in dxf files
VTX_SPLINE_VERTEX_CREATED = 8 ##Spline vertex created by spline-fitting
VTX_SPLINE_FRAME_CONTROL_POINT = 16
VTX_3D_POLYLINE_VERTEX = 32
VTX_3D_POLYGON_MESH_VERTEX = 64
VTX_3D_POLYFACE_MESH_VERTEX = 128
