import unittest
from itertools import izip

import dynts
from dynts import dsl

class TestDsl(unittest.TestCase):
    names = ['eur','1eur','eu3r','eur4567']
    
    def testName(self):
        for name in self.names:
            res = dynts.parse(name)
            self.assertTrue(isinstance(res,dsl.Symbol))
            self.assertEqual(name.upper(),str(res))
        
    def testBinaryOperation(self):
        res = dynts.parse('2*GOOG')
        self.assertEqual(len(res.children),2)
        names = res.symbols()
        self.assertEqual(len(names),1)
        self.assertEqual(names[0],str(res.right))
        #ts = dynts.evaluate(res)
        #self.assertEqual(ts.count(),1)
    
    def testAdditionOperation(self):
        res = dynts.parse('YHOO+GOOG')
        self.assertEqual(len(res.children),2)
        names = res.symbols()
        self.assertEqual(len(names),2)
        self.assertEqual(names[0],str(res.left))
        self.assertEqual(names[1],str(res.right))
        
    def testTwoTimeSeries(self):
        '''Get a timeseries and a function and check for consistency'''
        res = dynts.parse('gs:yahoo,min(gs:yahoo,window=30)')
        self.assertEqual(res.symbols(),['GS:YAHOO'])
        self.assertEqual(len(res),2)
        self.assertEqual(str(res[0]),'GS:YAHOO')
        self.assertEqual(str(res[1]),'min(GS:YAHOO,window=30)')
        
    def testDataProvider(self):
        result = dynts.evaluate('2*GOOG,GOOG')
        self.assertEqual(len(result.data),1)
        self.assertEqual(result.expression,dynts.parse('2*GOOG,GOOG'))
        data = result.ts()
        self.assertTrue(dynts.istimeseries(data))
        self.assertEqual(data.count(),2)
        ts1 = data.serie(0)
        ts2 = data.serie(1)
        for v1,v2 in izip(ts1,ts2):
            self.assertAlmostEqual(v1,2.*v2)
        

        
