#!/usr/bin/env python2

from eagle import *


def change_entry_label_nonexistent( app, button ):
    if not yesno( "This will raise an exception and close the application.\n"
                  "Continue?" ):
        return
    # use get_widget() to get access to widget not its contents.
    # This is needed with DataWidgets
    v = app.get_widget_by_id( button.id[ 1 : ] )
    v.set_label( "Make it crash" )
# change_entry_label_nonexistent()

def change_entry_label_placeholder( app, button ):
    # use get_widget() to get access to widget not its contents.
    # This is needed with DataWidgets
    v = app.get_widget_by_id( button.id[ 1 : ] )
    v.set_label( "New Label" )
# change_entry_label_placeholder()

def change_bt_label( app, button ):
    button.set_label( "New Label" )
# change_bt_label()


App( title="Test use of widgets without associate labels",
     center=(
    Group( id="ge",
           label="Entry",
           children=(  Entry( id="e0",
                              label="With",
                              value="Label" ),
                       Entry( id="e1",
                              label=None,
                              value="Without label" ),
                       Entry( id="e2",
                              label="",
                              value="With label placeholder" ),
                       Button( id="be1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="be2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gp",
           label="Password",
           children=(  Password( id="p0",
                                 label="With",
                                 value="Label" ),
                       Password( id="p1",
                                 label=None,
                                 value="Without label" ),
                       Password( id="p2",
                                 label="",
                                 value="With label placeholder" ),
                       Button( id="bp1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bp2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gs",
           label="Spin",
           children=(  Spin( id="s0",
                             label="With",
                             value=1.0 ),
                       Spin( id="s1",
                             label=None,
                             value=0.0 ),
                       Spin( id="s2",
                             label="",
                             value=0.5 ),
                       Button( id="bs1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bs2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gis",
           label="IntSpin",
           children=(  IntSpin( id="is0",
                                label="With",
                                value=1 ),
                       IntSpin( id="is1",
                                label=None,
                                value=-1 ),
                       IntSpin( id="is2",
                                label="",
                                value=0 ),
                       Button( id="bis1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bis2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="guis",
           label="UIntSpin",
           children=(  UIntSpin( id="uis0",
                                 label="With",
                                 value=1 ),
                       UIntSpin( id="uis1",
                                 label=None,
                                 value=2 ),
                       UIntSpin( id="uis2",
                                 label="",
                                 value=3 ),
                       Button( id="buis1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="buis2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gc",
           label="Color",
           children=(  Color( id="c0",
                              label="With",
                              color="#ffffff" ),
                       Color( id="c1",
                              label=None,
                              color="#000000" ),
                       Color( id="c2",
                              label="",
                              color="#666666" ),
                       Button( id="bc1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bc2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gf",
           label="Font",
           children=(  Font( id="f0",
                             label="With",
                             font="serif 12" ),
                       Font( id="f1",
                             label=None,
                             font="sans 15" ),
                       Font( id="f2",
                             label="",
                             font="monospace 10" ),
                       Button( id="bf1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bf2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gsel",
           label="Selection",
           children=(  Selection( id="sl0",
                                  label="With",
                                  options=( "a", "b", "c" ),
                                  active="a" ),
                       Selection( id="sl1",
                                  label=None,
                                  options=( "a", "b", "c" ),
                                  active="b" ),
                       Selection( id="sl2",
                                  label="",
                                  options=( "a", "b", "c" ),
                                  active="c" ),
                       Button( id="bsl1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bsl2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gpb",
           label="Progress",
           children=(  Progress( id="pb0",
                                 label="With",
                                 value=1.0 ),
                       Progress( id="pb1",
                                 label=None,
                                 value=0.0 ),
                       Progress( id="pb2",
                                 label="",
                                 value=0.5 ),
                       Button( id="bpb1",
                               label="crash changing non-existent label",
                               callback=change_entry_label_nonexistent ),
                       Button( id="bpb2",
                               label="change placeholder",
                               callback=change_entry_label_placeholder ),
                       )
           ),
    Group( id="gcb",
           label="CheckBox",
           children=( CheckBox( id="cb", label="Old" ),
                      Button( id="bcb",
                              label="change label",
                              callback=change_entry_label_placeholder ),
                      ),
           ),
    Group( id="gg",
           label="Group",
           children=( Button( id="bgg",
                              label="change label",
                              callback=change_entry_label_placeholder ),
                      ),
           ),
    Group( id="gt",
           label="Table",
           children=( Table( id="t", label="Table", items=( ( "a", 1 ), ) ),
                      Button( id="bt",
                              label="change label",
                              callback=change_entry_label_placeholder ),
                      ),
           ),
    )
    )

run()
