"""
Default Layers
==============

Provides a function which returns a list of the common layers found in an EAGLE file.

"""

from eaglepy.eagle import Layer

def get_layers():
    """
    Get a list of common layers found in an EAGLE file.
    
    :returns: A list of layers.
    
    """
    layers = []
    layers.append(Layer(1, "Top", 4, 1, True, True))
    layers.append(Layer(16, "Bottom", 1, 1, True, True))
    layers.append(Layer(17, "Pads", 2, 1, True, True))
    layers.append(Layer(18, "Vias", 2, 1, True, True))
    layers.append(Layer(19, "Unrouted", 6, 1, True, True))
    layers.append(Layer(20, "Dimension", 15, 1, True, True))
    layers.append(Layer(21, "tPlace", 7, 1, True, True))
    layers.append(Layer(22, "bPlace", 7, 1, True, True))
    layers.append(Layer(23, "tOrigins", 15, 1, True, True))
    layers.append(Layer(24, "bOrigins", 15, 1, True, True))
    layers.append(Layer(25, "tNames", 7, 1, True, True))
    layers.append(Layer(26, "bNames", 7, 1, True, True))
    layers.append(Layer(27, "tValues", 7, 1, True, True))
    layers.append(Layer(28, "bValues", 7, 1, True, True))
    layers.append(Layer(29, "tStop", 7, 3, False, True))
    layers.append(Layer(30, "bStop", 7, 6, False, True))
    layers.append(Layer(31, "tCream", 7, 4, False, True))
    layers.append(Layer(32, "bCream", 7, 5, False, True))
    layers.append(Layer(33, "tFinish", 6, 3, False, True))
    layers.append(Layer(34, "bFinish", 6, 6, False, True))
    layers.append(Layer(35, "tGlue", 7, 4, False, True))
    layers.append(Layer(36, "bGlue", 7, 5, False, True))
    layers.append(Layer(37, "tTest", 7, 1, False, True))
    layers.append(Layer(38, "bTest", 7, 1, False, True))
    layers.append(Layer(39, "tKeepout", 4, 11, True, True))
    layers.append(Layer(40, "bKeepout", 1, 11, True, True))
    layers.append(Layer(41, "tRestrict", 4, 10, True, True))
    layers.append(Layer(42, "bRestrict", 1, 10, True, True))
    layers.append(Layer(43, "vRestrict", 2, 10, True, True))
    layers.append(Layer(44, "Drills", 7, 1, False, True))
    layers.append(Layer(45, "Holes", 7, 1, True, True))
    layers.append(Layer(46, "Milling", 3, 1, False, True))
    layers.append(Layer(47, "Measures", 7, 1, False, True))
    layers.append(Layer(48, "Document", 7, 1, True, True))
    layers.append(Layer(49, "Reference", 7, 1, True, True))
    layers.append(Layer(50, "dxf", 7, 1, False, False))
    layers.append(Layer(51, "tDocu", 7, 1, True, True))
    layers.append(Layer(52, "bDocu", 7, 1, True, True))
    layers.append(Layer(53, "tGND_GNDA", 7, 9, False, False))
    layers.append(Layer(54, "bGND_GNDA", 1, 9, False, False))
    layers.append(Layer(56, "wert", 7, 1, False, False))
    layers.append(Layer(91, "Nets", 2, 1, True, True))
    layers.append(Layer(92, "Busses", 1, 1, True, True))
    layers.append(Layer(93, "Pins", 2, 1, True, True))
    layers.append(Layer(94, "Symbols", 4, 1, True, True))
    layers.append(Layer(95, "Names", 7, 1, True, True))
    layers.append(Layer(96, "Values", 7, 1, True, True))
    layers.append(Layer(97, "Info", 7, 1, True, True))
    layers.append(Layer(98, "Guide", 6, 1, True, True))
    layers.append(Layer(100, "Muster", 7, 1, False, False))
    layers.append(Layer(101, "Patch_Top", 12, 4, True, True))
    layers.append(Layer(102, "Vscore", 7, 1, True, True))
    layers.append(Layer(103, "tMap", 7, 1, True, True))
    layers.append(Layer(104, "Name", 16, 1, True, True))
    layers.append(Layer(105, "tPlate", 7, 1, True, True))
    layers.append(Layer(106, "bPlate", 7, 1, True, True))
    layers.append(Layer(107, "Crop", 7, 1, True, True))
    layers.append(Layer(108, "tplace-old", 10, 1, True, True))
    layers.append(Layer(109, "ref-old", 11, 1, True, True))
    layers.append(Layer(116, "Patch_BOT", 9, 4, True, True))
    layers.append(Layer(121, "_tsilk", 7, 1, True, True))
    layers.append(Layer(122, "_bsilk", 7, 1, True, True))
    layers.append(Layer(125, "_tNames", 7, 1, True, True))
    layers.append(Layer(144, "Drill_legend", 7, 1, True, True))
    layers.append(Layer(151, "HeatSink", 7, 1, True, True))
    layers.append(Layer(199, "Contour", 7, 1, True, True))
    layers.append(Layer(200, "200bmp", 1, 10, True, True))
    layers.append(Layer(201, "201bmp", 2, 10, True, True))
    layers.append(Layer(202, "202bmp", 3, 10, True, True))
    layers.append(Layer(203, "203bmp", 4, 10, True, True))
    layers.append(Layer(204, "204bmp", 5, 10, True, True))
    layers.append(Layer(205, "205bmp", 6, 10, True, True))
    layers.append(Layer(206, "206bmp", 7, 10, True, True))
    layers.append(Layer(207, "207bmp", 8, 10, True, True))
    layers.append(Layer(208, "208bmp", 9, 10, True, True))
    layers.append(Layer(209, "209bmp", 7, 1, True, True))
    layers.append(Layer(210, "210bmp", 7, 1, True, True))
    layers.append(Layer(211, "211bmp", 7, 1, True, True))
    layers.append(Layer(212, "212bmp", 7, 1, True, True))
    layers.append(Layer(213, "213bmp", 7, 1, True, True))
    layers.append(Layer(214, "214bmp", 7, 1, True, True))
    layers.append(Layer(215, "215bmp", 7, 1, True, True))
    layers.append(Layer(216, "216bmp", 7, 1, True, True))
    layers.append(Layer(217, "217bmp", 18, 1, False, False))
    layers.append(Layer(218, "218bmp", 19, 1, False, False))
    layers.append(Layer(219, "219bmp", 20, 1, False, False))
    layers.append(Layer(220, "220bmp", 21, 1, False, False))
    layers.append(Layer(221, "221bmp", 22, 1, False, False))
    layers.append(Layer(222, "222bmp", 23, 1, False, False))
    layers.append(Layer(223, "223bmp", 24, 1, False, False))
    layers.append(Layer(224, "224bmp", 25, 1, False, False))
    layers.append(Layer(250, "Descript", 3, 1, False, False))
    layers.append(Layer(251, "SMDround", 12, 11, False, False))
    layers.append(Layer(254, "cooling", 7, 1, True, True))
    return layers