import sys
from datetime import datetime
from xml.dom import minidom
from time import gmtime, strftime

def tz():
    return int(strftime("%z", gmtime())) / 100

now = datetime.now()

class daypart():
    twilight = None


class morning(daypart):
    sunrise = None

    def __init__(self, xml):
        self.sunrise = value(child(xml, 'sunrise'))
        t = child(xml, 'twilight')
        self.twilight = twilight.from_xml(t)

class evening(daypart):
    sunset = None

    def __init__(self, xml):
        self.sunset = value(child(xml, 'sunset'))
        t = child(xml, 'twilight')
        self.twilight = twilight.from_xml(t)

class twilight():
    civil = None
    nautical = None
    astronomical = None

    def __init__(self, civil=None, nautical=None, astronomical=None):
        self.civil = civil
        self.nautical = nautical
        self.astronomical = astronomical

    @staticmethod
    def from_xml(xml_element):
        civil = value(child(xml_element, 'civil'))
        nautical = value(child(xml_element, 'nautical'))
        astronomical = value(child(xml_element, 'astronomical'))
        return twilight(civil, nautical, astronomical)


def child(xml_element, name):
    return xml_element.getElementsByTagName(name)[0]


def value(xml_element):
    return xml_element.childNodes[0].nodeValue


def get(url):
    if sys.version_info.major == 2:
        import urllib
        return urllib.urlopen(url).read()


class sun():
    latitude = None
    longitude = None
    timezone = None
    day = None
    month = None
    dst = None
    sunrise = None
    sunset = None
    morning = None
    evening = None
    url = None

    def __init__(self, latitude, longitude, timezone=tz(), month=now.month, day=now.day):
        self.latitude = latitude
        self.longitude = longitude
        self.timezone = timezone
        self.day = day
        self.month = month
        self.url = "http://www.earthtools.org/sun/%(latitude)s/%(longitude)s/%(day)s/%(month)s/%(timezone)s/0" % \
        {
                "latitude": self.latitude,
                "longitude": self.longitude,
                "timezone": self.timezone,
                "day": self.day,
                "month": self.month
        }
        xmldoc = minidom.parseString(get(self.url))
        self.morning = morning(child(xmldoc, 'morning'))
        self.evening = evening(child(xmldoc, 'evening'))
        self.sunrise = self.morning.sunrise
        self.sunset = self.evening.sunset

        def sunset(self, xml_element):
            return child('sunrise').nodeValue