from datetime import datetime
from xml.dom import minidom
from time import strptime, timezone as tz
from twilight import twilight
from morning import morning
from evening import evening
from xml_utils import tree
from url import get

now = datetime.now()

class sun():
    latitude = None
    longitude = None
    timezone = None
    datetime = None
    dst = None
    morning = None
    evening = None
    url = None

    @property
    def month(self):
        return self.datetime.month

    @property
    def day(self):
        return self.datetime.day

    @property
    def sunrise(self):
        return self.morning.sunrise

    @property
    def sunset(self):
        return self.evening.sunset

    def str2date(self, value):
        t = strptime(value, '%H:%M:%S')
        return datetime(self.datetime.year, self.month, self.day, t.tm_hour, t.tm_min, t.tm_sec)

    def __init__(self, latitude, longitude, timezone=-tz / 3600, month=now.month, day=now.day):
        self.latitude = latitude
        self.longitude = longitude
        if not isinstance(timezone, int):
            raise ValueError("(%s) timezone not int" % timezone)
        self.timezone = timezone
        self.datetime = datetime(datetime.now().year, month, day)
        self.url = "http://www.earthtools.org/sun/%(latitude)s/%(longitude)s/%(day)s/%(month)s/%(timezone)s/0" % \
        {
                "latitude": self.latitude,
                "longitude": self.longitude,
                "timezone": self.timezone,
                "day": self.day,
                "month": self.month
        }
        sun = tree(minidom.parseString(get(self.url))).sun
        if float(sun.location.latitude) == 0:
            raise ValueError("invalid latitude")
        if float(sun.location.longitude) == 0:
            raise ValueError("invalid longitude")
        if int(sun.date.day) == 0:
            raise ValueError("invalid day")
        if int(sun.date.month) == 0:
            raise ValueError("invalid month")
        m = sun.morning
        e = sun.evening
        self.morning = morning(
            sunrise=self.str2date(m.sunrise),
            twilight=twilight(
                self.str2date(m.twilight.civil),
                self.str2date(m.twilight.nautical),
                self.str2date(m.twilight.astronomical)
            )
        )
        self.evening = evening(
            sunset=self.str2date(e.sunset),
            twilight=twilight(
                self.str2date(e.twilight.civil),
                self.str2date(e.twilight.nautical),
                self.str2date(e.twilight.astronomical)
            )
        )

#print sun(55.120010,33.233448).sunrise