import unittest
from datetime import datetime
from time import timezone as tz
from earthtools import sun

class TestSun (unittest.TestCase):
    latitude = None
    longitude = None
    month = None
    day = None
    tz = None

    def setUp(self):
        self.latitude = 55.120010
        self.longitude = 33.233448
        self.month = datetime.now().month
        self.day = datetime.now().day
        self.tz = -tz / 3600

    def get(self):
        self.sun = sun(self.latitude, self.longitude, self.tz, self.month, self.day)
        self.morning = self.sun.morning
        self.evening = self.sun.evening

    def test_latitude(self):
        self.get()
        self.latitude = 0
        self.assertRaises(ValueError, self.get)

    def test_longitude(self):
        self.longitude = 0
        self.assertRaises(ValueError, self.get)

    def test_day(self):
        self.day = 0
        self.assertRaises(ValueError, self.get)

    def test_month(self):
        self.month = 0
        self.assertRaises(ValueError, self.get)

    def test_values(self):
        self.get()
        self.values_IsNotNone()
        self.values_datetime()

    def values_IsNotNone(self):
        self.assertIsNotNone(self.sun.sunrise)
        self.assertIsNotNone(self.morning.sunrise)
        self.assertIsNotNone(self.morning.twilight.civil)
        self.assertIsNotNone(self.morning.twilight.nautical)
        self.assertIsNotNone(self.morning.twilight.astronomical)
        self.assertIsNotNone(self.sun.sunset)
        self.assertIsNotNone(self.evening.sunset)
        self.assertIsNotNone(self.evening.twilight.civil)
        self.assertIsNotNone(self.evening.twilight.nautical)
        self.assertIsNotNone(self.evening.twilight.astronomical)

    def values_datetime(self):
        self.assertIsInstance(self.sun.sunrise, datetime)
        self.assertIsInstance(self.morning.sunrise, datetime)
        self.assertIsInstance(self.morning.twilight.civil, datetime)
        self.assertIsInstance(self.morning.twilight.nautical, datetime)
        self.assertIsInstance(self.morning.twilight.astronomical, datetime)
        self.assertIsInstance(self.sun.sunset, datetime)
        self.assertIsInstance(self.evening.sunset, datetime)
        self.assertIsInstance(self.evening.twilight.civil, datetime)
        self.assertIsInstance(self.evening.twilight.nautical, datetime)
        self.assertIsInstance(self.evening.twilight.astronomical, datetime)


if __name__ == "__main__":
    unittest.main()