import os
from os.path import abspath, dirname, join
import unittest
from datetime import datetime
from time import timezone
from earthtools import sun

class TestSun (unittest.TestCase):
    latitude = None
    longitude = None
    month = None
    day = None
    tz = None

    def setUp(self):
        self.latitude = 55.120010
        self.longitude = 33.233448
        self.month = datetime.now().month
        self.day = datetime.now().day
        self.tz = -timezone / 3600

    def test_url(self):
        latitude=55.120010
        longitude=33.233448
        self.assertRaises(TypeError,sun.url)
        self.assertRaises(TypeError,sun.url,latitude)
        now=datetime.now()
        tz=-timezone / 3600
        self.assertEqual(
            sun.url(latitude,longitude),
            sun.url(latitude=latitude,longitude=longitude),
            "http://www.earthtools.org/sun/%s/%s/%s/%s/%s/0" % \
            (latitude,longitude,now.day,now.month,tz)
        )
        self.assertEqual(
            sun.url(latitude,longitude,now.day),
            sun.url(latitude=latitude,longitude=longitude,day=now.day),
            "http://www.earthtools.org/sun/%s/%s/%s/%s/%s/0" % \
            (latitude,longitude,now.day,now.month,tz)
        )
        self.assertEqual(
            sun.url(latitude,longitude,now.day,now.month),
            "http://www.earthtools.org/sun/%s/%s/%s/%s/%s/0" % \
            (latitude,longitude,now.day,now.month,tz)
        )
        self.assertEqual(
            sun.url(latitude,longitude,now.day,now.month,tz),
            "http://www.earthtools.org/sun/%s/%s/%s/%s/%s/0" % \
            (latitude,longitude,now.day,now.month,tz)
        )
        for badvalue in [
            dict(day=0),
            dict(day=32),
            dict(month=0),
            dict(month=13)
        ]:
            d=dict(latitude=latitude,longitude=longitude)
            d.update(badvalue)
            self.assertRaises(TypeError,
                sun.url,**d
            )

    def test_xml(self):
        now=datetime.now()
        # latitude longitude required
        self.assertRaises(TypeError,sun.xml)
        self.assertRaises(TypeError,sun.xml)
        
        xml = sun.download(sun.url(self.latitude, self.longitude))
        self.assertEqual(xml.latitude,self.latitude)
        self.assertEqual(xml.longitude,self.longitude)
        # default arguments
        self.assertEqual(xml.day,now.day)
        self.assertEqual(xml.month,now.month)

    def test_save(self):
        textxml=join(dirname(abspath(__file__)),'test.xml')
        textxml2=textxml+"2"
        xml=sun.load(textxml)
        xml.save(textxml2)
        self.assertEqual(True,os.path.exists(textxml2))
        os.unlink(textxml2)

if __name__ == "__main__":
    unittest.main()