import unittest
from datetime import datetime
from earthtools.twilight import cls as twilight

class Test_twilight(unittest.TestCase):
    def test(self):
        twilight()
        now=datetime.now()
        twilight(now,now,now)
        twilight(civil=now,nautical=now,astronomical=now)
        self.assertEqual(twilight(civil=now).civil,now)
        self.assertEqual(twilight(nautical=now).nautical,now)
        self.assertEqual(twilight(astronomical=now).astronomical,now)
        self.assertRaises(TypeError,twilight,1)
        self.assertRaises(TypeError,twilight,1,2)
        self.assertRaises(TypeError,twilight,1,2,3)

if __name__ == "__main__":
    unittest.main()