from datetime import datetime
import daypart

class cls(daypart.cls):
    _sunset = None

    def __init__(self, sunset=None, twilight=None):
        if sunset:
            self.sunset = sunset
        if twilight:
            self.twilight = twilight

    @property
    def sunset(self):
        return self._sunset

    @sunset.setter
    def sunset(self, v):
        if not v or not isinstance(v,datetime):
            raise TypeError("invalid sunset. datetime expected")
        else:
            self._sunset=v

    def __str__(self):
        return "sunset %s,twilight=%s" % \
        (str(self.sunset)[11:],self.twilight)