from datetime import datetime
import daypart

class cls(daypart.cls):
    _sunrise = None

    def __init__(self, sunrise=None, twilight=None):
        if sunrise:
            self.sunrise = sunrise
        if twilight:
            self.twilight = twilight

    @property
    def sunrise(self):
        return self._sunrise

    @sunrise.setter
    def sunrise(self, v):
        if not v or not isinstance(v,datetime):
            raise TypeError("invalid sunrise. datetime expected")
        else:
            self._sunrise=v

    def __str__(self):
        return "sunrise %s,twilight=%s" % \
        (str(self.sunrise)[11:],self.twilight)