import os
from datetime import datetime
from time import strptime, timezone as tz
import twilight
import morning
import evening
from requests import get
from lxml.etree import fromstring

now = datetime.now()

def url(latitude,longitude,day=now.day,month=now.month,timezone=-tz / 3600):
    if not str(day).isdigit() or not 1<=int(day)<=31: 
        raise TypeError("Invalid day")
    if not str(month).isdigit() or not 1<=int(month)<=12: 
        raise TypeError("Invalid month")
    return "http://www.earthtools.org/sun/%(latitude)s/%(longitude)s/%(day)s/%(month)s/%(timezone)s/0" % \
    {
        "latitude": latitude,
        "longitude": longitude,
        "day": int(day),
        "month": int(month),
        "timezone": timezone
    }

class xml:
    source=None
    latitude = None
    longitude = None
    timezone = None
    datetime = None
    dst = None
    morning = None
    evening = None
    url = None

    @property
    def month(self):
        return self.datetime.month

    @property
    def day(self):
        return self.datetime.day

    @property
    def sunrise(self):
        return self.morning.sunrise

    @property
    def sunset(self):
        return self.evening.sunset

    def str2date(self, value):
        t = strptime(value, '%H:%M:%S')
        return datetime(self.datetime.year, self.month, self.day, t.tm_hour, t.tm_min, t.tm_sec)

    def __init__(self, source):
        self.source=source
        t=fromstring(source.encode("utf-8"))
        self.latitude=float(t.xpath("location/latitude")[0].text)
        self.longitude=float(t.xpath("location/longitude")[0].text)
        day=int(t.xpath("date/day")[0].text)
        month=int(t.xpath("date/month")[0].text)
        self.dst=t.xpath("date/dst")[0].text
        self.datetime = datetime(datetime.now().year, month, day)
        if float(self.latitude) == 0:
            raise ValueError("invalid latitude")
        if float(self.longitude) == 0:
            raise ValueError("invalid longitude")
        m = t.xpath("morning")[0]
        e = t.xpath("evening")[0]
        self.morning = morning.cls(
            sunrise=self.str2date(t.xpath("morning/sunrise")[0].text),
            twilight=twilight.cls(
                self.str2date(m.xpath("twilight/civil")[0].text),
                self.str2date(m.xpath("twilight/nautical")[0].text),
                self.str2date(m.xpath("twilight/astronomical")[0].text)
            )
        )
        self.evening = evening.cls(
            sunset=self.str2date(t.xpath("evening/sunset")[0].text),
            twilight=twilight.cls(
                self.str2date(e.xpath("twilight/civil")[0].text),
                self.str2date(e.xpath("twilight/nautical")[0].text),
                self.str2date(e.xpath("twilight/astronomical")[0].text)
            )
        )

    def save(self,filename):
        open(os.path.expanduser(filename),"w").write(self.source)

def download(url):
    return xml(get(url).text)

def load(filename):
    return xml(open(os.path.expanduser(filename)).read())