from datetime import datetime

class cls(object):
    _civil = None
    _nautical = None
    _astronomical = None

    def __init__(self, civil=None, nautical=None, astronomical=None):
        if civil:
            self.civil = civil
        if nautical:
            self.nautical = nautical
        if astronomical:
            self.astronomical = astronomical

    @property
    def civil(self):
        return self._civil

    @civil.setter
    def civil(self, v):
        if not v or not isinstance(v,datetime):
            raise TypeError("invalid twilight. datetime expected")
        else:
            self._civil=v

    @property
    def nautical(self):
        return self._nautical

    @nautical.setter
    def nautical(self, v):
        if not v or not isinstance(v,datetime):
            raise TypeError("invalid twilight. datetime expected")
        else:
            self._nautical=v

    @property
    def astronomical(self):
        return self._astronomical

    @astronomical.setter
    def astronomical(self, v):
        if not v or not isinstance(v,datetime):
            raise TypeError("invalid twilight. datetime expected")
        else:
            self._astronomical=v

    def __str__(self):
        return "civil %s,nautical %s,astronomical %s" % \
        (str(self.civil)[11:],str(self.nautical)[11:],str(self.astronomical)[11:])