# -*- python -*-
#
#  This file is part of easydev software
#
#  Copyright (c) 2011-2012 - EBI
#
#  File author(s): Thomas Cokelaer <cokelaer@ebi.ac.uk>
#
#  Distributed under the GPLv3 License.
#  See accompanying file LICENSE.txt or copy at
#      http://www.gnu.org/licenses/gpl-3.0.html
#
#  website: http://www.ebi.ac.uk/~cokelaer/easydev
#
##############################################################################
# $:Id $
"""tool kits for all cinapps applications."""
import os
import subprocess
import tempfile
from os.path import join as pj
import glob
import time

def shellcmd(cmd, show=True, verbose=False):
    """An alias to run system commands.

    Based on subprocess.

    :param cmd: the command to call
    :param show: print the command
    :param verbose: print the output

    :return: the output
    """
    if show:
        print(cmd)
    try:
        ret = subprocess.Popen([cmd], stdout=subprocess.PIPE, 
            stderr=subprocess.PIPE, shell=True)
        ret.wait()

        output = ret.stdout.read().strip()
        error = ret.stderr.read().strip()

        if len(error)>0:
            raise Exception(error)

        if verbose == True:
            print output

        return output
    except Exception, e:
        #if verbose: print e
        raise Exception("Error:: Command (%s) failed. Error message is %s" % (cmd, e))


