#!/usr/bin/env python
#  -*- mode: python; indent-tabs-mode: nil; -*- coding: utf-8 -*-

from __future__ import unicode_literals

unicode_to_iso_8859_1 = {
    'Đ': 'D', # LATIN CAPITAL LETTER D WITH STROKE
    'đ': 'd', # LATIN SMALL LETTER D WITH STROKE
    'Ħ': 'H', # LATIN CAPITAL LETTER H WITH STROKE
    'ħ': 'h', # LATIN SMALL LETTER H WITH STROKE
    'Ŀ': 'L', # LATIN CAPITAL LETTER L WITH MIDDLE DOT
    'ŀ': 'l', # LATIN SMALL LETTER L WITH MIDDLE DOT
    'Ł': 'L', # LATIN CAPITAL LETTER L WITH STROKE
    'ł': 'l', # LATIN SMALL LETTER L WITH STROKE
    'ŉ': 'n', # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    'Œ': 'OE', # LATIN CAPITAL LIGATURE OE
    'œ': 'oe', # LATIN SMALL LIGATURE OE
    'Ŧ': 'T', # LATIN CAPITAL LETTER T WITH STROKE
    'ŧ': 't', # LATIN SMALL LETTER T WITH STROKE
    'ƀ': 'b', # LATIN SMALL LETTER B WITH STROKE
    'Ɓ': 'B', # LATIN CAPITAL LETTER B WITH HOOK
    'Ƃ': 'B', # LATIN CAPITAL LETTER B WITH TOPBAR
    'ƃ': 'b', # LATIN SMALL LETTER B WITH TOPBAR
    'Ɔ': 'O', # LATIN CAPITAL LETTER OPEN O
    'Ƈ': 'C', # LATIN CAPITAL LETTER C WITH HOOK
    'ƈ': 'c', # LATIN SMALL LETTER C WITH HOOK
    'Ɗ': 'D', # LATIN CAPITAL LETTER D WITH HOOK
    'Ƌ': 'D', # LATIN CAPITAL LETTER D WITH TOPBAR
    'ƌ': 'd', # LATIN SMALL LETTER D WITH TOPBAR
    'Ƒ': 'F', # LATIN CAPITAL LETTER F WITH HOOK
    'ƒ': 'f', # LATIN SMALL LETTER F WITH HOOK
    'Ɠ': 'G', # LATIN CAPITAL LETTER G WITH HOOK
    'Ɨ': 'I', # LATIN CAPITAL LETTER I WITH STROKE
    'Ƙ': 'K', # LATIN CAPITAL LETTER K WITH HOOK
    'ƙ': 'k', # LATIN SMALL LETTER K WITH HOOK
    'ƚ': 'l', # LATIN SMALL LETTER L WITH BAR
    'Ɲ': 'N', # LATIN CAPITAL LETTER N WITH LEFT HOOK
    'ƞ': 'n', # LATIN SMALL LETTER N WITH LONG RIGHT LEG
    'Ɵ': 'O', # LATIN CAPITAL LETTER O WITH MIDDLE TILDE
    'Ƥ': 'P', # LATIN CAPITAL LETTER P WITH HOOK
    'ƥ': 'p', # LATIN SMALL LETTER P WITH HOOK
    'ƫ': 't', # LATIN SMALL LETTER T WITH PALATAL HOOK
    'Ƭ': 'T', # LATIN CAPITAL LETTER T WITH HOOK
    'ƭ': 't', # LATIN SMALL LETTER T WITH HOOK
    'Ʈ': 'T', # LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
    'Ʋ': 'V', # LATIN CAPITAL LETTER V WITH HOOK
    'Ƴ': 'Y', # LATIN CAPITAL LETTER Y WITH HOOK
    'ƴ': 'y', # LATIN SMALL LETTER Y WITH HOOK
    'Ƶ': 'Z', # LATIN CAPITAL LETTER Z WITH STROKE
    'ƶ': 'z', # LATIN SMALL LETTER Z WITH STROKE
    'ǈ': 'L', # LATIN CAPITAL LETTER L WITH SMALL LETTER J
    'ǋ': 'N', # LATIN CAPITAL LETTER N WITH SMALL LETTER J
    'Ǣ': 'AE', # LATIN CAPITAL LETTER AE WITH MACRON
    'ǣ': 'ae', # LATIN SMALL LETTER AE WITH MACRON
    'Ǥ': 'G', # LATIN CAPITAL LETTER G WITH STROKE
    'ǥ': 'g', # LATIN SMALL LETTER G WITH STROKE
    'ǲ': 'D', # LATIN CAPITAL LETTER D WITH SMALL LETTER Z
    'Ǽ': 'AE', # LATIN CAPITAL LETTER AE WITH ACUTE
    'ǽ': 'ae', # LATIN SMALL LETTER AE WITH ACUTE
    'Ǿ': 'O', # LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    'ǿ': 'o', # LATIN SMALL LETTER O WITH STROKE AND ACUTE
    'Ƞ': 'N', # LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
    'ȡ': 'd', # LATIN SMALL LETTER D WITH CURL
    'Ȥ': 'Z', # LATIN CAPITAL LETTER Z WITH HOOK
    'ȥ': 'z', # LATIN SMALL LETTER Z WITH HOOK
    'ȴ': 'l', # LATIN SMALL LETTER L WITH CURL
    'ȵ': 'n', # LATIN SMALL LETTER N WITH CURL
    'ȶ': 't', # LATIN SMALL LETTER T WITH CURL
    'ɓ': 'b', # LATIN SMALL LETTER B WITH HOOK
    'ɕ': 'c', # LATIN SMALL LETTER C WITH CURL
    'ɖ': 'd', # LATIN SMALL LETTER D WITH TAIL
    'ɗ': 'd', # LATIN SMALL LETTER D WITH HOOK
    'ɠ': 'g', # LATIN SMALL LETTER G WITH HOOK
    'ɦ': 'h', # LATIN SMALL LETTER H WITH HOOK
    'ɨ': 'i', # LATIN SMALL LETTER I WITH STROKE
    'ɫ': 'l', # LATIN SMALL LETTER L WITH MIDDLE TILDE
    'ɬ': 'l', # LATIN SMALL LETTER L WITH BELT
    'ɭ': 'l', # LATIN SMALL LETTER L WITH RETROFLEX HOOK
    'ɱ': 'm', # LATIN SMALL LETTER M WITH HOOK
    'ɲ': 'n', # LATIN SMALL LETTER N WITH LEFT HOOK
    'ɳ': 'n', # LATIN SMALL LETTER N WITH RETROFLEX HOOK
    'ɼ': 'r', # LATIN SMALL LETTER R WITH LONG LEG
    'ɽ': 'r', # LATIN SMALL LETTER R WITH TAIL
    'ɾ': 'r', # LATIN SMALL LETTER R WITH FISHHOOK
    'ʂ': 's', # LATIN SMALL LETTER S WITH HOOK
    'ʈ': 't', # LATIN SMALL LETTER T WITH RETROFLEX HOOK
    'ʉ': '', # LATIN SMALL LETTER U BAR
    'ʋ': 'v', # LATIN SMALL LETTER V WITH HOOK
    'ʐ': 'z', # LATIN SMALL LETTER Z WITH RETROFLEX HOOK
    'ʑ': 'z', # LATIN SMALL LETTER Z WITH CURL
    'ʜ': 'H', # LATIN LETTER SMALL CAPITAL H
    'ʝ': 'j', # LATIN SMALL LETTER J WITH CROSSED-TAIL
    'ʠ': 'q', # LATIN SMALL LETTER Q WITH HOOK
    'ʮ': 'h', # LATIN SMALL LETTER TURNED H WITH FISHHOOK
    'ʯ': 'h', # LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
    'Ѝ': 'I', # CYRILLIC CAPITAL LETTER I WITH GRAVE
    'ѝ': 'i', # CYRILLIC SMALL LETTER I WITH GRAVE
    'Ӑ': 'A', # CYRILLIC CAPITAL LETTER A WITH BREVE
    'ӑ': 'a', # CYRILLIC SMALL LETTER A WITH BREVE
    'Ӓ': 'A', # CYRILLIC CAPITAL LETTER A WITH DIAERESIS
    'ӓ': 'a', # CYRILLIC SMALL LETTER A WITH DIAERESIS
    'Ӣ': 'I', # CYRILLIC CAPITAL LETTER I WITH MACRON
    'ӣ': 'i', # CYRILLIC SMALL LETTER I WITH MACRON
    'Ӥ': 'I', # CYRILLIC CAPITAL LETTER I WITH DIAERESIS
    'ӥ': 'i', # CYRILLIC SMALL LETTER I WITH DIAERESIS
    'Ӧ': 'O', # CYRILLIC CAPITAL LETTER O WITH DIAERESIS
    'ӧ': 'o', # CYRILLIC SMALL LETTER O WITH DIAERESIS
    'Ӭ': 'E', # CYRILLIC CAPITAL LETTER E WITH DIAERESIS
    'ӭ': 'e', # CYRILLIC SMALL LETTER E WITH DIAERESIS
    'Ӯ': '', # CYRILLIC CAPITAL LETTER U WITH MACRON
    'ӯ': '', # CYRILLIC SMALL LETTER U WITH MACRON
    'Ӱ': '', # CYRILLIC CAPITAL LETTER U WITH DIAERESIS
    'ӱ': '', # CYRILLIC SMALL LETTER U WITH DIAERESIS
    'Ӳ': '', # CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
    'ӳ': '', # CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
    'ẚ': 'a', # LATIN SMALL LETTER A WITH RIGHT HALF RING
    '‐': '-', # HYPHEN
    '–': '-', # EN DASH
    '—': '--', # EM DASH
    '‖': '||', # DOUBLE VERTICAL LINE
    '‗': '_', # DOUBLE LOW LINE
    '‘': '\'', # LEFT SINGLE QUOTATION MARK
    '’': '\'', # RIGHT SINGLE QUOTATION MARK
    '‚': '\'', # SINGLE LOW-9 QUOTATION MARK
    '‛': '\'', # SINGLE HIGH-REVERSED-9 QUOTATION MARK
    '“': '"', # LEFT DOUBLE QUOTATION MARK
    '”': '"', # RIGHT DOUBLE QUOTATION MARK
    '„': '"', # DOUBLE LOW-9 QUOTATION MARK
    '‟': '"', # DOUBLE HIGH-REVERSED-9 QUOTATION MARK
    '⁅': '[', # LEFT SQUARE BRACKET WITH QUILL
    '⁆': ']', # RIGHT SQUARE BRACKET WITH QUILL
}


iso_8859_1_to_ascii = {
    '¡': 'i', # INVERTED EXCLAMATION MARK
    '¢': 'c', # CENT SIGN
    '£': 'L', # POUND SIGN
    '¥': 'Y', # YEN SIGN
    '¦': '|', # BROKEN BAR
    '§': 'Sec.', # SECTION SIGN
    '¨': '"', # DIAERESIS
    '©': '(C)', # COPYRIGHT SIGN
    '«': '"', # LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    '­': '-', # SOFT HYPHEN
    '®': '(R)', # REGISTERED SIGN
    '¯': '-', # MACRON
    '°': ' deg.', # DEGREE SIGN
    '±': '+-', # PLUS-MINUS SIGN
    '²': '^2', # SUPERSCRIPT TWO
    '³': '^3', # SUPERSCRIPT THREE
    '´': '\'', # ACUTE ACCENT
    'µ': ' m', # MICRO SIGN
    '·': '.', # MIDDLE DOT
    '»': '"', # RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    '¼': '1/4', # VULGAR FRACTION ONE QUARTER
    '½': '1/2', # VULGAR FRACTION ONE HALF
    '¾': '3/4', # VULGAR FRACTION THREE QUARTERS
    '¿': '?', # INVERTED QUESTION MARK
    'Ä': 'Ae', # LATIN CAPITAL LETTER A WITH DIAERESIS
    'Æ': 'AE', # LATIN CAPITAL LETTER AE
    'Ð': 'Eth', # LATIN CAPITAL LETTER ETH
    'Ö': 'Oe', # LATIN CAPITAL LETTER O WITH DIAERESIS
    '×': 'x', # MULTIPLICATION SIGN
    'Ø': 'O', # LATIN CAPITAL LETTER O WITH STROKE
    'Ü': 'Ue', # LATIN CAPITAL LETTER U WITH DIAERESIS
    'ß': 'ss', # LATIN SMALL LETTER SHARP S
    'ä': 'ae', # LATIN SMALL LETTER A WITH DIAERESIS
    'æ': 'ae', # LATIN SMALL LETTER AE
    'ð': 'eth', # LATIN SMALL LETTER ETH
    # 'ñ': 'ny', # LATIN SMALL LETTER N WITH TILDE
    'ö': 'oe', # LATIN SMALL LETTER O WITH DIAERESIS
    '÷': '/', # DIVISION SIGN
    'ø': 'o', # LATIN SMALL LETTER O WITH STROKE
    'ü': 'ue', # LATIN SMALL LETTER U WITH DIAERESIS
}
