#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals
from grako.parsing import graken, Parser
from grako.exceptions import *  # noqa


__version__ = '2014.06.26.22.00.54.03'

__all__ = [
    'elispParser',
    'elispSemanticParser',
    'elispSemantics',
    'main'
]


class elispParser(Parser):
    def __init__(self, whitespace=None, **kwargs):
        super(elispParser, self).__init__(whitespace=whitespace, **kwargs)

    @graken()
    def _file_(self):

        def block1():
            self._expression_()
        self._closure(block1)
        self.ast['@'] = self.last_node
        self._check_eof()

    @graken()
    def _expression_(self):
        with self._choice():
            with self._option():
                self._list_()
            with self._option():
                self._vector_()
            with self._option():
                self._integer_()
            with self._option():
                self._float_()
            with self._option():
                self._symbol_()
            with self._option():
                self._string_()
            self._error('no available options')

    @graken()
    def _integer_(self):
        self._pattern(r'[+-]?[0-9]+\.?')
        with self._ifnot():
            self._symbol_()

    @graken()
    def _float_(self):
        with self._choice():
            with self._option():
                self._pattern(r'[+-]?[0-9]*\.[0-9]+e[0-9]+')
            with self._option():
                self._pattern(r'[+-]?[0-9]+e[0-9]+')
            with self._option():
                self._pattern(r'[+-]?[0-9]*\.[0-9]+')
            self._error('expecting one of: [+-]?[0-9]*\\.[0-9]+ [+-]?[0-9]*\\.[0-9]+e[0-9]+ [+-]?[0-9]+e[0-9]+')

    @graken()
    def _symbol_(self):
        self._pattern(r'([-+=*/_~!@$%^&:<>{}?A-Za-z0-9]+|\\.)+')

    @graken()
    def _list_(self):
        with self._choice():
            with self._option():
                self._proper_list_()
            with self._option():
                self._improper_list_()
            self._error('no available options')

    @graken()
    def _proper_list_(self):
        self._token('(')

        def block1():
            self._expression_()
        self._closure(block1)
        self.ast._append('@', self.last_node)
        self._token(')')

    @graken()
    def _improper_list_(self):
        self._token('(')
        with self._group():

            def block1():
                self._expression_()
            self._positive_closure(block1)

            self._token('.')
            self._expression_()
        self.ast['@'] = self.last_node
        self._token(')')

    @graken()
    def _string_(self):
        self._token('"')
        self._pattern(r'([^"]|\n)*|(\\(.|\n))')
        self.ast['@'] = self.last_node
        self._token('"')

    @graken()
    def _vector_(self):
        self._token('[')

        def block1():
            self._expression_()
        self._closure(block1)
        self.ast._append('@', self.last_node)
        self._token(']')


class elispSemantics(object):
    def file(self, ast):
        return ast

    def expression(self, ast):
        return ast

    def integer(self, ast):
        return ast

    def float(self, ast):
        return ast

    def symbol(self, ast):
        return ast

    def list(self, ast):
        return ast

    def proper_list(self, ast):
        return ast

    def improper_list(self, ast):
        return ast

    def string(self, ast):
        return ast

    def vector(self, ast):
        return ast


def main(filename, startrule, trace=False, whitespace=None):
    import json
    with open(filename) as f:
        text = f.read()
    parser = elispParser(parseinfo=False)
    ast = parser.parse(
        text,
        startrule,
        filename=filename,
        trace=trace,
        whitespace=whitespace)
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()

if __name__ == '__main__':
    import argparse
    import string
    import sys

    class ListRules(argparse.Action):
        def __call__(self, parser, namespace, values, option_string):
            print('Rules:')
            for r in elispParser.rule_list():
                print(r)
            print()
            sys.exit(0)

    parser = argparse.ArgumentParser(description="Simple parser for elisp.")
    parser.add_argument('-l', '--list', action=ListRules, nargs=0,
                        help="list all rules and exit")
    parser.add_argument('-t', '--trace', action='store_true',
                        help="output trace information")
    parser.add_argument('-w', '--whitespace', type=str, default=string.whitespace,
                        help="whitespace specification")
    parser.add_argument('file', metavar="FILE", help="the input file to parse")
    parser.add_argument('startrule', metavar="STARTRULE",
                        help="the start rule for parsing")
    args = parser.parse_args()

    main(args.file, args.startrule, trace=args.trace, whitespace=args.whitespace)

