#!/usr/bin/env python
# To use:
#       python setup.py build
#       python setup.py install
#       python setup.py install --prefix=...
#       python setup.py bdist --format=wininst
#       python setup.py bdist --format=rpm
#       python setup.py sdist --formats=gztar,zip


import sys

if not hasattr(sys, 'version_info') or sys.version_info < (2,2,0,'alpha',0):
    raise SystemExit, "Python 2.2 or later required to build ellipt2d!"


from distutils.core import setup, Extension

setup (name = "ellipt2d",
       extra_path = 'ellipt2d',
       version = "1.9",
       url="http://ellipt2d.sourceforge.net",
       author="Alexander Pletzer and John C Mollis",
       author_email="alexander@gokliya.net",
       py_modules = ["ellipt2d","ellipt2dF", "cellipt2d", "cellipt2dF",
                     "cell", "node", "geqdsk", 
                     "DirichletBound", "NeumannBound","RobinBound", 
                     "colormap", "spla", "utils",
                     "reg2tri","Ireg2tri", "Triangulate", "triangle",
                     "sparse","tkplot", "vector", "superlu",
                     "csparse","ctkplot", "cvector", "csuperlu",
                     "Demos/gui", "Demos/wire", "Demos/demo_dino",
                     "Demos/simple", "Demos/demo_Rbc",
                     "Demos/demo_RegRb", "Demos/demo_Simple"
                     ],
       #data_files=[("Demos", ["Demos/ellipt2d.net", "Demos/cellipt2d.net"],)],
       ext_modules = [Extension("interp",["interp/interpmodule.c",],
                                ),
                      Extension("triang",["triangle/triangle.c",
                                          "triangle/triangmodule.c",],
                                define_macros=[("TRILIBRARY",1),
                                               ("NO_TIMER",1)]
                                ),
                      Extension("triangulate",
                                          ["triangle/triangle.c",
                                          "triangle/triangulatemodule.c"],
                                define_macros=[("TRILIBRARY",1),
                                               ("NO_TIMER",1)]
                                ),
                      Extension("dspla", ["pyla/dsplamodule.c"],
                                ),
                      Extension("dsupralu",[
					"superlu/heap_relax_snode.c",
                                        "superlu/dcolumn_bmod.c",
                                        "superlu/dcolumn_dfs.c",
                                        "superlu/dcomplex.c",
                                        "superlu/scomplex.c",
                                        "superlu/dcopy_to_ucol.c",
                                        "superlu/dgscon.c",
                                        "superlu/dgsequ.c",
                                        "superlu/dgsrfs.c",
                                        "superlu/dgssv.c",
                                        "superlu/dgssvx.c",
                                        "superlu/dgstrf.c",
                                        "superlu/dgstrs.c",
                                        "superlu/dlacon.c",
                                        "superlu/dlamch.c",
                                        "superlu/dlangs.c",
                                        "superlu/dlaqgs.c",
                                        "superlu/dmemory.c",
                                        "superlu/colamd.c",
                                        "superlu/dpanel_bmod.c",
                                        "superlu/dpanel_dfs.c",
                                        "superlu/dpivotL.c",
                                        "superlu/dpivotgrowth.c",
                                        "superlu/dpruneL.c",
                                        "superlu/dreadhb.c",
                                        "superlu/dsnode_bmod.c",
                                        "superlu/dsnode_dfs.c",
                                        "superlu/dsp_blas2.c",
                                        "superlu/dsp_blas3.c",
                                        "superlu/superlu_timer.c",
                                        "superlu/dutil.c",
                                        "superlu/dzsum1.c",
                                        "superlu/get_perm_c.c",
                                        "superlu/icmax1.c",
                                        "superlu/izmax1.c",
                                        "superlu/lsame.c",
                                        "superlu/memory.c",
                                        "superlu/mmd.c",
                                        "superlu/relax_snode.c",
                                        "superlu/sp_coletree.c",
                                        "superlu/sp_ienv.c",
                                        "superlu/sp_preorder.c",
                                        "superlu/util.c",
                                        "superlu/xerbla.c",
                                        "superlu/dsupralu_meth.c",
                                        "superlu/dsupralumodule.c",
                                        "superlu/dblas.c"
                                        ],
                                define_macros=[("NO_TIMER",1)]
                                ),
                      Extension("zsupralu",[
					"superlu/heap_relax_snode.c",
                                        "superlu/colamd.c",
                                        "superlu/dcomplex.c",
                                        "superlu/scomplex.c",
                                        "superlu/get_perm_c.c",
                                        "superlu/icmax1.c",
                                        "superlu/izmax1.c",
                                        "superlu/lsame.c",
                                        "superlu/memory.c",
                                        "superlu/mmd.c",
                                        "superlu/dlamch.c",
                                        "superlu/dzsum1.c",
                                        "superlu/relax_snode.c",
                                        "superlu/sp_coletree.c",
                                        "superlu/sp_ienv.c",
                                        "superlu/sp_preorder.c",
                                        "superlu/superlu_timer.c",
                                        "superlu/util.c",
                                        "superlu/xerbla.c",
                                        "superlu/zcolumn_bmod.c",
                                        "superlu/zcolumn_dfs.c",
                                        "superlu/zcopy_to_ucol.c",
                                        "superlu/zgscon.c",
                                        "superlu/zgsequ.c",
                                        "superlu/zgsrfs.c",
                                        "superlu/zgssv.c",
                                        "superlu/zgssvx.c",
                                        "superlu/zgstrf.c",
                                        "superlu/zgstrs.c",
                                        "superlu/zlacon.c",
                                        "superlu/zlangs.c",
                                        "superlu/zlaqgs.c",
                                        "superlu/zmemory.c",
                                        "superlu/zpanel_bmod.c",
                                        "superlu/zpanel_dfs.c",
                                        "superlu/zpivotL.c",
                                        "superlu/zpivotgrowth.c",
                                        "superlu/zpruneL.c",
                                        "superlu/zreadhb.c",
                                        "superlu/zsnode_bmod.c",
                                        "superlu/zsnode_dfs.c",
                                        "superlu/zsp_blas2.c",
                                        "superlu/zsp_blas3.c",
                                        "superlu/zutil.c",
                                        "superlu/zsupralu_meth.c",
                                        "superlu/zsupralumodule.c",
                                        "superlu/zblas.c"
                                        ],
                                define_macros=[("NO_TIMER",1)]
                                ),                      
                      
                      ]
       )
