#------------------------------------------------------------------------------
#  Copyright (c) 2012, Enthought, Inc.
#  All rights reserved.
#
# Special thanks to Steven Silvester for contributing this module!
#------------------------------------------------------------------------------
# NOTE: There shall be no imports from traitsui in this module. Doing so
# will create an import dependency on traitsui for the rest of Enaml!
from traits.api import HasTraits, Instance

from .control import Control


class TraitsItem(Control):
    """ A control which can be used to embded a traits ui view.

    """
    #: The traits model being displayed. If no other view is given, the
    #: view will be retrieved by calling `model.edit_traits()`.
    model = Instance(HasTraits)

    #: An optional traits ui View definition to use in lieu of the
    #: default view generated by the model.
    view = Instance('traitsui.api.View')

    #: An optional traits ui Handler definition to use in lieu of the
    #: default handler generated by the model.
    handler = Instance('traitsui.api.Handler')

    #: TraitsItem widgets expand freely in height and width by default.
    hug_width = 'ignore'
    hug_height = 'ignore'

    #--------------------------------------------------------------------------
    # Initialization
    #--------------------------------------------------------------------------
    def snapshot(self):
        """ Get the snapshot dictionary for the TraitsItem widget.

        """
        snap = super(TraitsItem, self).snapshot()
        snap['model'] = self.model
        snap['view'] = self.view
        snap['handler'] = self.handler
        return snap

    def bind(self):
        """ Bind the change handlers for the control.

        """
        super(TraitsItem, self).bind()
        self.publish_attributes('model', 'view', 'handler')

