#!python
# coding=utf-8

metadata_codes = []
metadata_codes += [1215, 1216, 1217, 1218, 1219, 1220, 1401, 1402, 1403, 1404, 1406, 1411, 1412, 1413]  # Instrument and platform pitch/roll/orientation
metadata_codes += [9991, 9992, 9993, 9994]  # x/y/z/t axes
metadata_codes += [1202, 1203, 1207, 1208]  # ADCP records/pings
metadata_codes += [4000, 4001, 4002, 4003, 4004, 4005, 4006, 4009]  # Rotor speed
metadata_codes += [106, 107, 113, 114, 115]  # Battery voltage

location_codes = [500, 501, 502, 510, 511, 512]
time_codes     = [600, 601, 620, 621, 622, 623, 624, 625, 626, 627, 9994]
generic_codes  = [0, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 1908]  # 'Undefined', 'unknown', or the generic 'variable#' EPIC codes
voltage_codes  = [4010, 4012]  # Transmission Volts

epic_map = {
    None : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UNDEFINED
    0    : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # :Undefined                :generic:units:format:Undefined Variable,
    1    : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure', units='dbar', convert=lambda x: x, cf_units='dbar', cell_methods=None),  # P  :PRESSURE (DB)            :depth:dbar:f10.1:,
    2    : dict(standard_name='depth', long_name='Depth', units='m', convert=lambda x: x/10., cf_units='m', cell_methods=None),  # D  :DEPTH (CM)               :depth:cm: :,
    3    : dict(standard_name='depth', long_name='Depth', units='m', convert=lambda x: x, cf_units='m', cell_methods=None),  # D  :DEPTH (M)                :depth:m:f10.1:,
    4    : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure', units='Pa', convert=lambda x: x/10000., cf_units='dbar', cell_methods=None),  # P  :PRESSURE (PASCALS)       :depth:Pa: :,
    5    : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PD :PRESSURE DIFFERENCE (DB) :depth:dbar: :,
    6    : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ISO:ISOTHERM DEPTH (M)       :depth:m: :,
    7    : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL :SEA LEVEL ANOMALY (M)    :depth:m: :,
    8    : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MLD:MIXED LAYER DEPTH (M)    :depth:m: :Program MIXDEP,
    9    : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure', units='mbar', convert=lambda x: x/100., cf_units='dbar', cell_methods=None),  # P  :SEA LEVEL PRESSURE (MB)  :depth:mbar: :For Ferret,
    10   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DYN:DYNAMIC METERS           :dynhgt:dyn-m:f10.4:,
    11   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DYN:DYM HT (SUBSAMPLED DATA) :dynhgt: : :,
    12   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # dDN:DYNn-DYNs                :dynhgt: :f10.5:Diff of North and South Dyn Ht.,
    13   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DYN:DYNAMIC HEIGHT (DYN CM)  :dynhgt:dyn-cm: :,
    14   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # dD:dDYN1-dDYN2 (DYN M)      :dynhgt:dyn-m: :Delta-Dyn (ctd1-ctd2) for geost vel calc,
    15   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # d1 :DYN1 (DYN M)             :dynhgt:dyn-m: :Dyn1 (ctd1) for geost vel calc,
    16   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # d2 :DYN2 (DYN M)             :dynhgt:dyn-m: :Dyn2 (ctd2) for geost vel calc,
    17   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZPG:ZONAL PRESSURE GRAD      : : : :Calculated for specific areas,
    18   : dict(standard_name='sea_surface_height', long_name='Sea Surface Height', units='m', convert=lambda x: x, cf_units='m', cell_methods=None),  # hght:height (m)              :height:m:f10.2:,
    20   : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T  :TEMPERATURE (C)          :temp:C:f10.2:IPTS-1968 standard,
    21   : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # AT :AIR TEMPERATURE (C)      :atemp:C: :,
    22   : dict(standard_name='sea_water_temperature', long_name='Water Temperature (reversing therm)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T0 :THERM TEMPERATURE (C)    :temp:C: :Reversing therm. 1E35 indicates no therm.,
    23   : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods='time: minimum'),  # AT :AIR TEMPERATURE MIN (C)  :atemp:C: :,
    24   : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods='time: maximum'),  # AT :AIR TEMPERATURE MAX (C)  :atemp:C: :,
    25   : dict(standard_name='sea_surface_temperature', long_name='Surface Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T  :SST (C)                  :temp:C: :,
    26   : dict(standard_name='sea_water_temperature', long_name='Water Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods='time: minimum'),  # T  :SST MIN (C)              :temp:C: :,
    27   : dict(standard_name='sea_water_temperature', long_name='Water Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods='time: maximum'),  # T  :SST MAX (C)              :temp:C: :,
    28   : dict(standard_name='sea_water_temperature', long_name='Water Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T  :TEMPERATURE (C)          :temp:C:f10.2 :ITS-1990 Standard,
    29   : dict(standard_name='sea_water_temperature', long_name='Water Temperature (depth integrated)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # IT :TEMP INTEGRAL            :temp:C: :Depth integrated temperature,
    30   : dict(standard_name='air_potential_temperature', long_name='Potential Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # PT :POTENTIAL TEMP (C)       :potemp: : :PT = Potential Temperature,
    31   : dict(standard_name='air_potential_temperature', long_name='Potential Temperature (with 4000m reference level)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # P4 :POTENTIAL TEMP 4000 (C)  :potemp: : :Potential temp with 4000m reference level,
    32   : dict(standard_name='sea_water_temperature', long_name='Water Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T  :TEMPERATURE (C)          :temp:C:f10.4:unknown standard,
    33   : dict(standard_name='sea_water_temperature', long_name='Water Temperature (corrected for mooring motion)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T  :CORRECTED TEMPERATURE (C):temp:C:f10.4:corrected for mooring motion,
    34   : dict(standard_name='sea_water_temperature', long_name='Water Temperature (ITS-1968 Standard)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T2 :Secondary Temperature    :temp:C:f10.2:IPTS-1968 standard,
    35   : dict(standard_name='sea_water_temperature', long_name='Water Temperature (ITS-1990 Standard)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # T2 :Secondary Temperature    :temp:C:f10.2:ITS-1990 Standard,
    36   : dict(standard_name='sea_surface_temperature', long_name='Surface Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # DST:d(SST)/dt                :dsst/dt:C/day: :,
    38   : dict(standard_name='air_potential_temperature', long_name='Potential Temperature (ITS-90)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K'),  # PT :POTENTIAL TEMP (C)       :potemp: : :Potential Temperature (ITS-90, cell_methods=None),
    40   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S  :SALINITY (PPT)           :sal:PPT:f10.2:From SALIN1,
    41   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S  :SALINITY (PSU)           :sal:PSU: :Practical Salinity Units,
    42   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S  :SALINITY (PSU)           :sal:PSU: :Practical Salinity Units,
    43   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity (from Salinometer)', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S0 :BOTTLE SALINITY (PSU)    :sal:PSU: :From Salinometer. 1E35 indicates no sample.,
    44   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S3 :Alternate Salinity       :sal: : :Practical Salinity Units,
    45   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # S4 :Alternate Salinity       :sal: : :Practical Salinity Units,
    48   : dict(standard_name='sea_water_electrical_conductivity', long_name='Specific Conductance (conductivity with temperature compensated to 25°C)', units='mS/cm', convert=lambda x: x/10., cf_units='S/m', cell_methods=None),  # SpC :Specific Conductance    :con:mS/cm:f10.3:temperature compensated to 25C,
    49   : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # S  :SALINITY                 :sal: :f10.2:calculated for XBT's from mean T-S curve, M McCarty,
    50   : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity', units='mmho/cm', convert=lambda x: x/10., cf_units='S/m', cell_methods=None),  # C  :CONDUCTIVITY             :con:mmho/cm: :,
    51   : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity', units='S/m', convert=lambda x: x, cf_units='S/m', cell_methods=None),  # C  :CONDUCTIVITY             :con:S/m:f10.3:,
    52   : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity (seabird cell raw)', units=None, convert=lambda x: x, cf_units='S/m', cell_methods=None),  # rcon:RAW CONDUCTIVITY (SEABIRD):cond:counts:i10:Seabird cell raw conductivity,
    53   : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity (vacm raw)', units=None, convert=lambda x: x, cf_units='S/m' , cell_methods=None),  # rcon:RAW CONDUCTIVITY (VACM) :cond:counts:i10:vacm raw conductivity,
    54   : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity (secondary)', units='mmho/cm', convert=lambda x: x/10., cf_units='S/m', cell_methods=None),  # C2  :Secondary Conductivity  :con:mmho/cm: :,
    55   : dict(standard_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water', long_name='Beam Attenuation', units='1/m', convert=lambda x: x, cf_units='1/m', cell_methods=None),  # ATTN:ATTENUATION             :attn:m-1:f7.5:added for r2d2 ctd data
    56   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NEP:BACKSCATTER INTENSITY    :nephylometer:v:f10.6: added for Dave Pashinski,
    60   : dict(standard_name='mass_concentration_of_oxygen_in_sea_water', long_name='Dissolved Oxygen (mass concentration)', units='ml/L', convert=lambda x: x, cf_units='ml/L', cell_methods=None),  # O  :OXYGEN (ML/L)            :ox:ml/l:f10.2:Dissolved oxygen calculated from CTD values,  LOOK: Can't convert ml/L (ppt) to CF units, so we are leaving the original units
    61   : dict(standard_name='mass_concentration_of_oxygen_in_sea_water', long_name='Dissolved Oxygen (mass concentration)', units='ml/L', convert=lambda x: x, cf_units='ml/L', cell_methods=None),  # BO :BOTTLE OXYGEN (ML/L)     :ox:ml/l: :DO determined by titration. 1E35 ->no sample,  LOOK: Can't convert ml/L (ppt) to CF units, so we are leaving the original units
    62   : dict(standard_name='volume_fraction_of_oxygen_in_sea_water', long_name='Dissolved Oxygen (saturation)', units='percent', convert=lambda x: x, cf_units='percent', cell_methods=None),  # OST:OXYGEN, %SAT             :ox:%: :,
    64   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOU:APPARENT O2 UTILIZATION  :ox:ml/l: :,
    65   : dict(standard_name='mole_concentration_of_dissolved_molecular_oxygen_in_sea_water', long_name='Dissolved Oxygen (mole contentration)', units='µmol/kg', convert=lambda x: x, cf_units='µmol/kg', cell_methods=None),  # O  :OXYGEN (UMOL/KG)         :ox:umol/kg:f10.2:Dissolved oxygen calculated from CTD values,  LOOK: Can't convert ml/L (ppt) to CF units (kg/m^3), so we are leaving the original units
    66   : dict(standard_name='mole_concentration_of_dissolved_molecular_oxygen_in_sea_water', long_name='Dissolved Oxygen (mole concentration)', units='µmol/kg', convert=lambda x: x, cf_units='µmol/kg', cell_methods=None),  # BO :BOTTLE OXYGEN (UMOL/KG)  :ox:umol/kg: :DO determined by titration. 1E35 ->no sample,  LOOK: Can't convert ml/L (ppt) to CF units (kg/m^3), so we are leaving the original units
    70   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # ST :SIGMA-T (KG/M**3)        :den:kg m-3:f10.2:,
    71   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # STH:SIGMA-THETA (KG/M**3)    :potden:kg m-3 :f10.2:,
    72   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water (ref to 2000m)', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # S2 :SIGMA 2 (KG/M**3)        :potden2:kg m-3:f10.2:sigma-theta ref to 2000m,
    73   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water (ref to 3000m)', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # S3 :SIGMA 3 (KG/M**3)        :potden3:kg m-3:f10.2:sigma-theta ref to 3000m,
    74   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water (ref to 4000m)', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # S4 :SIGMA 4 (KG/M**3)        :potden4:kg m-3:f10.2:sigma-theta ref to 4000m,
    75   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water (ref to 5000m)', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # S5 :SIGMA 5 (KG/M**3)        :potden5:kg m-3:f10.2:sigma-theta ref to 5000m,
    76   : dict(standard_name='sea_water_sigma_theta', long_name='Sigma-theta of sea water (ref to 1000m)', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3', cell_methods=None),  # S1 :SIGMA 1 (KG/M**3)        :potden1:kg m-3:f10.2:sigma-theta ref to 1000m,
    77   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # GN :GAMMA N (KG/M**3)        :gamma_n:kg m-3:f10.2:Neutral Density,
    80   : dict(standard_name='speed_of_sound_in_sea_water', long_name='Speed of Sound', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # SV :SOUND VELOCITY (M/S)     : :m s-1: :,
    81   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # FAC:SND SPD CORR. FACTOR     :factor: :f10.3:corr. BASS currents for actual sound speed,
    84   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # RHO:DENSITY (KG/M**3)        :den:kg m-3:f10.2:,
    85   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SPV:SPECIFIC VOLUME          : : : :,
    86   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SVA:SP VOL ANOM, 1E-8 M**3/KG: :m3 kg-1: :,
    90   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BV :BVF (CPH)                : : : :Brunt Vaisala Frequency,
    91   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BV2:BVF SQUARED (CPH**2)     : : : :Brunt Vaisala Frequency squared (N*ABS(N)),
    92   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # R  :RADIUS OF DEFORM         : : : :Integral bvf*dz/pi*f,
    93   : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # RI :RICHARDSONS NUMBER       : : : :,
    100  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SN :SCAN NUMBER              : : : :,
    101  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # FS :FRAME SYNC               : : : :FOR TOPS,
    102  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CL :PTG CLOCK WORD           : : : :,
    103  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTL:NISKIN BOTTLE NUMBER     : : : :For Bottle files,
    104  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # IQ :WOCE QUALITY NUMBER      : : : :See WOCE Document,
    105  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NAV:NUMBER POINTS IN AVERAGE : : : :,
    106  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BAT:BATTERY VOLTAGE          :bat:volts:f6.2:,
    107  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TRN:TRANSMISSOMETER VOLTAGE 7: : : :for P18 CTD data set,
    110  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OXC:OXYGEN CURRENT           : : : :,
    111  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OXT:OXYGEN TEMPERATURE       : : : :,
    112  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DOC:dOXC/dt                  : : : :Time rate of change of Oxygen current,
    113  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BAT1:BATTERY VOLTAGE 1       :bat:volts:f10.3:,
    114  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BAT2:BATTERY VOLTAGE 2       :bat:volts:f10.3:,
    115  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BAT3:BATTERY VOLTAGE 3       :bat:volts:f10.3:,
    120  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # T' :GRADIENT DT/DZ           : : : :Program CTDGRD2,
    121  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DZT:GRADIENT DZ/DT           : : : :Program CTDGRD3,
    122  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # T'X:GRADIENT DT/DX           : : : :X is longitude,
    123  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # T'Y:GRADIENT DT/DY           : : : :Y is latitude,
    124  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UTX:U * dT/dx                : : : :X is longitude,
    125  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DZT:GRADIENT DZ/DT           : : : :Program CTDGRD3,
    126  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ADT:AD TEMP GRAD,DEG-C/DB    : : : :,
    130  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HTC:HEAT CONTENT (JOU/M**2)  : :J m-2: :,
    131  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SpH:SPECIFIC HEAT, J/KG-DEG-C: :J kg-1 C-1: :,
    132  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Qs :SHORTWAVE RADIATION      : :cal day-1 cm-2: :,
    133  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Qs :SHORTWAVE RADIATION      : :W m-2: :,
    134  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HQ :LOCAL HEATING            : : : :,
    135  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ql :LONGWAVE RADIATION       : :cal day-1 cm-2: :,
    136  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ql :LONGWAVE RADIATION       : :W m-2: :,
    137  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # QH :LATENT HEAT              : :W m-2: :,
    138  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # QB :SENSIBLE HEAT            : :W m-2: :,
    140  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # QI :PENETRATIVE RADIA (PING) : : : :,
    141  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # QT :QT=QS-QB-QE (PING)       : : : :,
    142  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # QN :NET HEATING              : :W m-2: :,
    143  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VMF:VERTICAL+MERID HEAT FLUX : :W m-2: :,
    144  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZMA:ZONAL+MERID HEAT ADVECT  : :W m-2: :,
    145  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VHF:VERTICAL HEAT FLUX       : :W m-2: :,
    146  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MHF:MERIDIONAL HEAT FLUX     : :W m-2: :,
    147  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZHA:ZONAL HEAT ADVECTION     : :W m-2: :,
    148  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MHA:MERIDIONAL HEAT ADVECTION: :W m-2: :,
    150  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # FR :FREON                    : : : :,
    152  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3:NITRATE (MG AT/L)        :NO3:mg at/l: :,
    154  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2:NITRITE (MG AT/L)        :NO2:mg at/l: :,
    156  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PO4:PHOSPHATE (MG AT/L)      :PO4:mg at/l: :,
    157  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ptl:TOTAL PHOSPHORUS         : :mg at/l: :J. Reid data,
    158  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SI :SILICATE (MG AT/L)       :SiO4:mg at/l: :mg at/l,
    159  : dict(standard_name='sea_water_ph_reported_on_total_scale', long_name='pH', units='', convert=lambda x: x, cf_units='1', cell_methods=None),  # pH :pH                       : : : :J. Reid data,
    170  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SPC:SPICE                    :spc : : :From Phyllis Stabeno (CTD data),
    181  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SI :SiO4                     :SiO4:mg at/l: :J.Murray,
    182  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3:NITRATE (micromoles/l)   :NO3:uM/l: :From Jim Murray,
    183  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3w:Nitrate in Water        :NO3:umol/L: :,
    184  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2:NITRITE (micromoles/l)   :NO2:uM/l: :From Jim Murray,
    185  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NN :Nitrate + Nitrite        :NO2+NO3:umoles/l: :Total nutrients,
    186  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PO4:PHOSPHATE (micromoles/l) :PO4:uM/l: :From Jim Murray,
    187  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UR :UREA (micromoles/l)      :UR:uM/l: :From Jim Murray,
    188  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SI :SILICATE (micromoles/l)  :SiO4:uM/l: :From Jim Murray,
    189  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4:AMMONIUM (micromoles/L)  :NH4:umol/L: :,
    200  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DIS:VERTICAL DISPLACEMENT    : : : :From mean CTD profile,
    205  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL :Sea Level                : :mm: :,
    206  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL_h:SEA LEVEL (hourly)      :SLh:m:f7.3:hourly insitu sea level values,
    207  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL_d:SEA LEVEL (daily)       :SLd:m:f7.3:daily insitu sea level values,
    208  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL_m:SEA LEVEL (monthly)     :SLm:m:f7.3:monthly insitu sea level values,
    210  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SL :GEOSAT SEA LEVEL (M)     : :m: :Mean value over grid block,
    220  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AZ :AZIMUTH                  :az:degrees:f8.2:measure of ice floe rotation,
    221  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VAR:VARIANCE                 :var:cm s-1: :sqrt(u**2 + v**2) (current variance),
    250  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # GHR:GLOBAL HORIZNTL RADIATION:ghr:kJ s-2 d-1:f8.2:global horizontal radiation,
    251  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PAR:PHOTOSYN ACTIVE RADIATION:par:M ph m-2 d-1:f5.2 :photosynthetically active radiation,
    252  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # GHR:GLOBAL HORIZNTL RADIATION:ghr:W m-2:f8.2:global horizontal radiation,
    282  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3:NITRATE (micromoles/kg)  :NO3:uM/kg: :From Jim Murray,
    284  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2:NITRITE (micromoles/kg)  :NO2:uM/kg: :From Jim Murray,
    285  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NN :Nitrate + Nitrite + Ammonium:NO2+NO3+NH4:uM/kg: :Total nitrogen,
    286  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PO4:PHOSPHATE (micromoles/kg):PO4:uM/kg: :From Jim Murray,
    287  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UR :UREA (micromoles/kg)     :UR:uM/kg: :From Jim Murray,
    288  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SI :SILICATE (micromoles/kg) :SiO4:uM/kg: :From Jim Murray,
    289  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4:AMMONIUM (micromoles/kg) :NH4:umol/kg: :,
    300  : dict(standard_name='sea_water_speed', long_name='Current speed', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods=None),  # CS :CURRENT SPEED (CM/S)      :vspd:cm s-1:f8.2:oceanographic (going to),
    301  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BS :DRIFTER BUOY SPEED (M/S) : :m s-1: :calculated from lat,lon,
    302  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BS :Drifter Buoy Speed (cm/s): :cm s-1: :calculated from lat,lon,
    310  : dict(standard_name='direction_of_sea_water_velocity', long_name='Current direction', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # CD :CURRENT DIRECTION (T)     :vdir:degrees:f8.2:oceanographic (going to, using true north,
    311  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BD :DRIFTER BUOY DIRECTION   : :degrees: :oceanographic (going to,
    316  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BU :Drifter Buoy u (cm/s)    :u:cm s-1: :calculated from lat,lon,
    317  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BV :Drifter Buoy v (cm/s)    :v:cm s-1: :calculated from lat,lon,
    318  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BU :DRIFTER BUOY U (M/S)     :u:m s-1: :calculated from lat,lon,
    319  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BV :DRIFTER BUOY V (M/S)     :v:m s-1: :calculated from lat,lon,
    320  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :measured w/r true N,
    321  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :measured w/r true N,
    322  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :relative w/r true N,
    323  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :relative w/r true N,
    324  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :instrument w/r true N,
    325  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :instrument w/r true N,
    326  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :tracked w/r true N,
    327  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :tracked w/r true N,
    328  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # W  :VERTICAL VELOCITY (CM/S) :w:cm s-1: :tracked TOPS,
    329  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # W  :VERTICAL VELOCITY (CM/S) :w:cm s-1:f8.2:,
    330  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :measured w/r magnetic N,
    331  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :measured w/r magnetic N,
    332  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :relative w/r magnetic N,
    333  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :relative w/r magnetic N,
    334  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :instrument w/r magnetic N,
    335  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :instrument w/r magnetic N,
    336  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U  :ZONAL CURRENT (CM/S)     :u:cm s-1: :tracked w/r magnetic N,
    337  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V  :MERIDIONAL CURRENT (CM/S):v:cm s-1: :tracked w/r magnetic N,
    340  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ug :GEOSTROPHIC ZONAL (CM/S) : :cm s-1: :geostrophic,
    341  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Vg :GEOSTR MERIDIONAL (CM/S) : :cm s-1: :geostrophic,
    342  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Umg:Umodel-Ugeost (cm/s)     : :cm s-1: :,
    344  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ut :TRACK NORMAL GEOST (CM/S):un:cm s-1: :geostrophic vel normal to track,
    350  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HX :COMPASS HX               : : : :,
    351  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HY :COMPASS HY               : : : :,
    360  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AX :ACCELERATION AX          : : : :,
    361  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AY :ACCELERATION AY          : : : :,
    362  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AU :ACCELERATION AU          : : : :,
    363  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AV :ACCELERATION AV          : : : :,
    370  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # X  :X POSITION IN NET        : : : :tracked TOPS position,
    371  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Y  :Y POSITION IN NET        : : : :tracked TOPS position,
    372  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Z  :Z POSITION IN NET        : : : :tracked TOPS position,
    375  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U1 :U Tidal Amplitude (CM/S) species1:u1:cm s-1: :measured w/r true N,
    376  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V1 :V Tidal Amplitude (CM/S) species1:v1:cm s-1: :measured w/r true N,
    377  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U2 :U Tidal Amplitude (CM/S) species2:u2:cm s-1: :measured w/r true N,
    378  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V2 :V Tidal Amplitude (CM/S) species2:v2:cm s-1: :measured w/r true N,
    380  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZT :ZONAL TRANSPORT, M**2/SEC: :m2 s-1: :total transport per unit width,
    381  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MT :MERIDIONAL TRANSPRT,M^2/S:U:m2 s-1: :total transport per unit width,
    382  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZT+:ZONAL TRANSPORT (+)      :V:m2 s-1: :positive zonal transport per unit width,
    383  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MT+:MERIDIONAL TRANSPORT (+) : :m2 s-1: :positive meridional transport per unit width,
    384  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZT-:ZONAL TRANSPORT (-)      : :m2 s-1: :negative zonal transport per unit width,
    385  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MT-:MERIDIONAL TRANSPORT (-) : :m2 s-1: :negative meridional transport per unit width,
    386  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZT :ZONAL TRANSPORT, M**3/SEC:U:m3 s-1: :volume transport,
    387  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MT :MERIDIONAL TRANSPRT,M^3/S:V:m3 s-1: :volume transport,
    388  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TR :TRK NORMAL TRNSPRT, M^3/S: :m3 s-1: :volume transport normal to track,
    390  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZU :ZONAL TRANSPORT UPPER LIM: :m2 s-1: :transport per unit width,
    391  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MU :MERIDIONAL TRNS UPPER LIM: :m2 s-1: :transport per unit width,
    392  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZL :ZONAL TRANSPORT LOWER LIM: :m2 s-1: :transport per unit width,
    393  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ML :MERIDIONAL TRNS LOWER LIM: :m2 s-1: :transport per unit width,
    394  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ZCW:ZONAL CURRENT WIDTH      : : : :,
    395  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MCW:MERIDIONAL CURRENT WIDTH : : : :,
    396  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Dx :ZONAL MOORING LINE DRAG  : : : :,
    397  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Dy :MERIDIANAL MOOR LINE DRAG: : : :,
    398  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DRG:DRAG ON MOORING LINE     : : : :,
    400  : dict(standard_name='wind_speed', long_name='Wind Speed', units='cm/s', convert=lambda x: x/100., cf_units='m/s', cell_methods=None),  # WS :WIND SPEED (CM/S)        : :cm s-1: :,
    401  : dict(standard_name='wind_speed', long_name='Wind Speed', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # WS :WIND SPEED (M/S)         : :m s-1: :,
    402  : dict(standard_name='wind_speed_of_gust', long_name='Wind Gust', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # WG :WIND GUST (M/S)          : :m s-1: :greatest speed in interval (drifters),
    403  : dict(standard_name='wind_speed', long_name='Wind Speed', units='knots;', convert=lambda x: x*0.514444444, cf_units='m/s', cell_methods=None),  # WS :Wind Speed               : :knots:F6.2:Wind Speed,
    404  : dict(standard_name='wind_speed', long_name='Wind Speed', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # WS :Wind Speed               : :m s-1: :,
    405  : dict(standard_name='wind_speed', long_name='Wind Speed (relative to ship)', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # RWS:Wind Speed (rel. to ship): :m s-1: :Relative Wind Speed,
    410  : dict(standard_name='wind_from_direction', long_name='Wind Direction', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # WD :WIND DIRECTION           : :degrees: :     0-360 degrees,
    411  : dict(standard_name='wind_from_direction', long_name='Wind Direction', units='degree', convert=lambda x: (x + 360.) % 360., cf_units='degree', cell_methods=None),  # WD :WIND DIRECTION           : :degrees: :     -180 to 180 degrees,
    412  : dict(standard_name='wind_from_direction', long_name='Wind Direction (from to TN)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # WD :Wind Direction (from)    : :degrees_T:F6.2:Wind Direction (from),
    413  : dict(standard_name='wind_to_direction', long_name='Wind Direction (toward TN)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # WD :Wind Direction (toward)  : :degrees_T:F6.2:Wind Direction (toward),
    414  : dict(standard_name='wind_from_direction', long_name='Wind Direction (relative to bow)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # RWD:Wind Dir. (rel. to bow)  : :degrees: :Relative Wind Direction,
    420  : dict(standard_name='eastward_wind', long_name='Eastward Wind (U)', units='cm/s', convert=lambda x: x/100., cf_units='m/s', cell_methods=None),  # WU :WIND U (CM/S)            :u:cm s-1: :oceanographic sense (going to),
    421  : dict(standard_name='northward_wind', long_name='Northward Wind (V)', units='cm/s', convert=lambda x: x/100., cf_units='m/s', cell_methods=None),  # WV :WIND V (CM/S)            :v:cm s-1: :oceanographic sense (going to),
    422  : dict(standard_name='eastward_wind', long_name='Eastward Wind (U)', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # WU :WIND U (M/S)             :u:m s-1: :oceanographic sense (going to),
    423  : dict(standard_name='northward_wind', long_name='Northward Wind (V)', units='m/s', convert=lambda x: x, cf_units='m/s', cell_methods=None),  # WV :WIND V (M/S)             :v:m s-1: :oceanographic sense (going to),
    430  : dict(standard_name='eastward_wind', long_name='Eastward Wind (U)', units='cm/s', convert=lambda x: x/100., cf_units='m/s', cell_methods=None),  # WU :Zonal Wind               :u:m s-1: :positive toward east,
    431  : dict(standard_name='northward_wind', long_name='Northward Wind (V)', units='cm/s', convert=lambda x: x/100., cf_units='m/s', cell_methods=None),  # WV :Meridional Wind          :v:m s-1: :positive toward north,
    440  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # T-X:ZONAL WIND STRESS        :u:dyne cm-2: :Zonal Wind Stress,
    441  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # T-Y:MERIDIONAL WIND STRESS   :v:dyne cm-2: :Meridional Wind Stress,
    442  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PTx:ZONAL PSEUDO WIND STRESS : :m2 s-2: :Zonal pseudo wind stress,
    443  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PTy:MERID PSEUDO WIND STRESS : :m2 s-2: :Meridional pseudo wind stress,
    444  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Txy:TOTAL PSEUDO WIND STRESS : :m2 s-2: :sqrt(PTx**2 + PTy**2)  (Prog WNDSTR),
    446  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Tx:ZONAL WIND STRESS        : : : :Zonal true wind stress,
    447  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ty:MERID WIND STRESS        : : : :Meridional true wind stress,
    448  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Txy:TOTAL WIND STRESS        : : : :sqrt(Tx**2 + Ty**2) (Prog WNDSTR),
    449  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # GP :Geopotential             :GP:m2/s2:f10.2 :geopotential energy,
    450  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WW :WIND WORK                : :m3 s-3: :Wind work,
    460  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U'X:GRADIENT DU/DX           : :1E-5 s-1: :X is longitude,
    461  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V'X:GRADIENT DV/DX           : :1E-5 s-1: :X is longitude,
    462  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U'Y:GRADIENT DU/DY           : :1E-5 s-1: :Y is latitude,
    463  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V'Y:GRADIENT DV/DY           : :1E-5 s-1: :Y is latitude,
    464  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U'Z:GRADIENT DU/DZ           : :s-1: :Z is depth,
    465  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V'Z:GRADIENT DV/DZ           : :s-1: :Z is depth,
    466  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Shr:Current Shear            : :s-1: :SQRT(U'Z^2+V'Z^2),
    480  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OLR:OLR                      : :W/M**2: :Outgoing long wave radiation,
    485  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # RN :RAIN                     : :MM: :Rainfall derived from OLR,
    500  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:LATITUDE                 :lat:degree_north:f10.4:EPIC-- N is positive, S is negative,
    501  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:LONGITUDE                :lon:degree_west:f10.4:Classic EPIC-- W is pos, eg, 165W=165, 170E=190,
    502  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:LONGITUDE                :lon:degree_east:f10.4:New EPIC-- E is pos, eg, 165E=165, 170W=190,
    510  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:PROJECTED LATITUDE       :lat:degree_north:f10.4:N is positive, S is negative,
    511  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:PROJECTED LONGITUDE      :lon:degree_west:f10.4:W is positive,
    512  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:PROJECTED LONGITUDE      :lon:degree_east:f10.4:E is positive,
    513  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # XS :Section Distance         :dist:km:f8.2:Positive toward end of section,
    514  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # YS :Transverse Distance      :dist:km:f8.2:Positive counterclockwise from section,
    520  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # S  :Distance                 :dist:km:f8.2:,
    521  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AD :Alongshore Distance      :dist:km:f8.2:,
    522  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OD :Offshore Distance        :dist:km:f8.2:,
    600  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:TIME (EPIC)              :time: :f10.0:EPIC Time series time hhmm as real number,
    601  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:TIME                     :time: : :units since YYYY-MM-dd hh:mm:ss,
    620  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DAT:DATE (EPIC)              :time: :f10.0:EPIC Time series date yymmdd as real number,
    621  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DAT:MMDD.HHMM                :time: : :Date,Time without year (mmdd.hhmm, real no),
    622  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:GREENWICH DAYS           :time: : :Days from the start of the century,
    623  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:GEOSAT DAYS              :time: : :Days after 85/01/01,
    624  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:EPIC SYSTEM TIME         :time: : :2 integers, jul day, millisec since midnight,
    625  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:SECONDS SINCE START      :time:s: :integer, delta seconds,
    626  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:DAYS SINCE START         :time:d: :real, delta seconds,
    627  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TIM:Julian Days              :time: : :Real number, decimal part gives time of day,
    628  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DUR:Sample Duration          : :min: :,
    650  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # H  :LAYER THICKNESS          :H:m: :Mick Spillane's model,
    651  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # n  :LAYER NUMBER             :n: : :Mick Spillane's model,
    700  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SD :STANDARD DEVIATION       : : : :,
    710  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # N  :NUMBER OF POINTS         : : : :,
    721  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PG :PERCENT GOOD PINGS       : : : :Acoustic Doppler,
    722  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # EV :ERROR VELOCITY           : : : :RD Acoustic Doppler,
    723  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AMP:AMPLITUDE                : : : :RD Acoustic Doppler,
    810  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SDD:STAND. DEV. (DYN.HT)     : : : :,
    820  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SDT:STAND. DEV. (TEMP)       : : : :,
    840  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SDS:STAND. DEV. (SAL)        : : : :,
    841  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SD+:SAL+STAND. DEV.          : : : :,
    842  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SD-:SAL-STAND. DEV.          : : : :,
    843  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # S+2:SAL+2 STAND. DEV.        : : : :,
    844  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # S-2:SAL-2 STAND. DEV.        : : : :,
    850  : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (standard deviation)', units='mbar', convert=lambda x: x/100., cf_units='dbar', cell_methods='time: standard_deviation'),  # SDP:STAND. DEV. (PRESS)     :pres:mbar:f10.5:std. deviation of burst pressures,
    851  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SED:STAND. ERR. (DYN.HT)     : : : :,
    852  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SET:STAND. ERR. (TEMP)       : : : :,
    853  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SES:STAND. ERR. (SAL)        : : : :,
    854  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SEP:STAND. ERR. (PRESS)      : : : :,
    900  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fvt:Fluorometer Volts        : :Volts: :,
    901  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fvt:Fluorometer Volts(CTD)   : :Volts: :,
    902  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Irr:Irradiance(CTD)          : :uEin cm-2 s-1: :,
    903  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll', units='mg/m^3', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # F  :Fluorometer (CTD)        : :mg m-3: :J.Murray 5/13/92,
    904  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Tr :Transmissometry (CTD)    : :%: :J.Murray 5/13/92,
    905  : dict(standard_name='downwelling_photosynthetic_photon_flux_in_sea_water', long_name='Photosynthetic Active Radiation (PAR)', units='µE m-2 s-1', convert=lambda x: x, cf_units='mol m-2 s-1', cell_methods=None),  # PAR:Photosynthetic Active Radiation:par:uEin m-2 s-1: :J.Murray 5/13/92,
    906  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (fluorometric)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Fch:Chlorophyll A            : :ugrams/l: :(fluorometric) J.Murray 5/9/94,
    907  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fph:Phaeopigments      : :ugrams/l: :(fluorometric) J.Murray 5/9/94,
    908  : dict(standard_name='downwelling_photosynthetic_photon_flux_in_sea_water', long_name='Photosynthetic Active Radiation (PAR)', units='µE cm-2 s-1', convert=lambda x: x/100000., cf_units='mol m-2 s-1', cell_methods=None),  # PAR:Photosynthetic Active Radiation:par:uEin cm-2 s-1: :S.Salo 7/1/98,
    910  : dict(standard_name='relative_humidity', long_name='Relative Humidity', units='percent', convert=lambda x: x, cf_units='percent', cell_methods=None),  # RH :RELATIVE HUMIDITY (%)    :rh:%: :PERCENT,
    911  : dict(standard_name='relative_humidity', long_name='Relative Humidity', units='percent', convert=lambda x: x, cf_units='percent', cell_methods='time: minimum'),  # RH :RELATIVE HUMIDITY MIN (%):rh:%: :,
    912  : dict(standard_name='relative_humidity', long_name='Relative Humidity', units='percent', convert=lambda x: x, cf_units='percent', cell_methods='time: maximum'),  # RH :RELATIVE HUMIDITY MAX (%):rh:%: :,
    913  : dict(standard_name='specific_humidity', long_name='Specific Humidity', units='g/kg', convert=lambda x: x, cf_units='g/kg', cell_methods=None),  # SH :SPECIFIC HUMIDITY (G/KG) : :g kg-1: :For Ferret,
    915  : dict(standard_name='air_pressure', long_name='Air Pressure', units='mbar', convert=lambda x: x*100., cf_units='Pa', cell_methods=None),  # BP :BAROMETRIC PRESSURE (MB) : :mbar: :,
    916  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PAR:Photosynthetically Active Radiation:par:V:f5.2:PAR (instrument units,
    917  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PAR:Photosynthetically Active Radiation:par:umol photons m-2 s-1:F7.1:,
    918  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SPAR:Surface Photosynthetically Active Radiation:par:uEin m-2  s-1:F7.1:SBE CTD,
    920  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CC :CLOUD COVER (OKTAS)      : : : :OKTAS,
    921  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CT :Cloud Type Code          : : : :,
    922  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VIS:Visibility Code          : : : :,
    923  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WC :Weather Code             : : : :,
    924  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SC :Seastate Code            : : : :,
    925  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # D  :Water Depth              :depth:m:f10.1:,
    931  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Chv:Chlorophyll-a Volts(CTD) : :Volts: :,
    932  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (CTD)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Chlorophyll-a(CTD)       : :ugrams/l: :,
    933  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Chl:Chlorophyll              : :ug/L: :,
    935  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VA3:ChlAM Voltage            : :volts: :WetLabs A-3,
    936  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AA3:Chlorophyll-a Absorption : :m-1: : WetLabs A-3,
    937  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # CA3:Chlorophyll-a Conc       : :ugrams/l: :WetLabs A-3,
    938  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll', units='mg/m^3', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # CPHL:Chlorophyll             : :mg/m3: :Chlorophyll from WOD2001,
    941  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DB :Dry Bulb Temp            : :degree C: :,
    942  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WB :Wet Bulb Temp            : :degree C: :,
    951  : dict(standard_name='dew_point_temperature', long_name='Dew Point', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # DP :Dew Point                : :degree C: :,
    961  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Rn :Rainfall                 : :10-2 in: :,
    962  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Rr :Rain Rate                : :mm/hr: :,
    963  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Rn :Rainfall                 : :mm: :Rainfall from raingauge station,
    971  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rFv:raw fluorometer Volts(CTD)   : :Volts: :,
    972  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rCv:raw chl-a Volts(CTD)     : :Volts: :,
    973  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll (fluorometric)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # fWS:wetStar fluorometer chl  : :ug/L: :Wetlabs wetstar fluorometer chlorophyll,
    974  : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll (fluorometric)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # fSP:SeaPoint fluorometer chl : :ug/L: :Sea Point fluorometer chlorophyll,
    975  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VWS:wetStar Voltage          : :volts: :Wetlabs wetstar fluorometer,
    976  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VSP:SeaPoint Voltage         : :volts: :SeaPoint fluorometer,
    977  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rIrr:raw Irradiance           : :volts: :,
    978  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rBack:raw Backscattering       : :volts: :,
    980  : dict(standard_name='sea_water_turbidity', long_name='Turbidity', units='FNU', convert=lambda x: x, cf_units='NTU', cell_methods=None),  # Trb :Turbidity(FNU)          :turb:FNU:f10.2:formazin nephelometric units,
    981  : dict(standard_name='mass_concentration_of_sediment_in_sea_water', long_name='Sedimentc concentration', units='g/l', convert=lambda x: x, cf_units='kg/m^3' , cell_methods=None),  # Sed:Sediment concentration   :sed:g/l:f10.2:sediment concentration,
    982  : dict(standard_name='mass_concentration_of_sediment_in_sea_water', long_name='Sedimentc concentration', units='kg/m^3', convert=lambda x: x, cf_units='kg/m^3' , cell_methods=None),  # Sed:Sediment concentration   :sed:kg/m3:f10.4:sediment concentration, kg per cubic meter,
    990  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BUG:Plankton Concentration   : :number/l: : individuals per liter,
    991  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SmCNpl:Copepod Nauplii (< 150 micrometers) Conc.:CopNpl:number/l:  :oncentration of Copepod Nauplii (< 150 micrometers),
    992  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LgCNpl:Copepod Nauplii (>= 150 micrometers) Conc.:CopNpl:number/l: : Concentration of Copepod Nauplii (>= 150 micrometers),
    993  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TCNpl:Copepod Nauplii Concentration:CopNpl:number/l: :Copepod Nauplii Concentration,
    994  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DV:Zooplankton Disp. Vol.    : :ml/m**3:f5.2:Zooplankton Displacement Volume Conc.,
    995  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DW:Zooplankton Dry Wt./Vol.  : :mg/m**3:f5.1:Zooplankton Dry Weight Conc.,
    996  : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DWA:Zooplankton Dry Wt./Area : :mg/m**2:f5.1:Zooplankton Dry Weight Areal Conc.,
    1141 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # YDF:MERID DIFFUS HEAT FLUX   : :W m-2: :ping 12/10/90,
    1142 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MHF:MERID ADVECT HEAT FLUX   : :W m-2: :ping 12/10/90,
    1143 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VE :VERTICAL ENTRAINMENT     : :W m-2: :ping 12/10/90,
    1144 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Qt :HEAT CONTENT CHANGE      : :W m-2: :ping 12/11/90,
    1145 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Qt*:QT*=QNET+QU+QW+QZ        : :W m-2: :ping 12/11/90,
    1200 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Tim :Ensemble Length          :ens_length:s: :ADCP Ensemble Length,
    1201 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Werr:Error Velocity           :w:cm/s:F8.1:ADCP Error Velocity,
    1202 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AGC :Avg. Echo Intensity (AGC):AGC:counts:F5.1:ADCP Beam Averaged AGC,
    1203 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGd :Percent Good Pings       : : : :ADCP Percent Good Pings,
    1204 : dict(standard_name='upward_sea_water_velocity', long_name='Upward (w) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods=None),  # w   :Vertical Velocity        :w:cm/s: :Vertical Velocity,  LOOK: Is this 'upwards' positive?  I'm assuming so...
    1205 : dict(standard_name='eastward_sea_water_velocity', long_name='Eastward (u) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods=None),  # u   :Eastward Velocity        :u:cm/s: :Eastward Velocity,
    1206 : dict(standard_name='northward_sea_water_velocity', long_name='Northward (v) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods=None),  # v   :Northward Velocity       :v:cm/s: :Northward Velocity,
    1207 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Rec :Records                  : : : :ADCP Records,
    1208 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Png :Pings                    : : : :ADCP Pings,
    1209 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # EISD:Echo Intensity (AGC) Std. Dev.:AGC:counts:F5.1:ADCP AGC (1202) Std Dev,
    1210 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BIT :ADCP BIT Status          : : : :ADCP Built-in Test Status,
    1211 : dict(standard_name='sea_water_temperature', long_name='Water Temperature (at ADCP Transducer)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K' , cell_methods=None),  # Tx  :ADCP Transducer Temp.    :temp:deg. C:F10.2:ADCP Transducer Temp,
    1214 : dict(standard_name='height', long_name='Height', units='m', convert=lambda x: x, cf_units='m', cell_methods=None),  # Hght:INST Height              :hght:m:F10.4:Height of instrument,  LOOK: Is this height above the sea floor or some other reference point?  Platform maybe?
    1215 : dict(standard_name='platform_orientation', long_name='Instrument Heading', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # Hdg :INST Heading             :hdg:degrees:F10.2:ADCP heading,  LOOK: Is the EPIC code the orientation of the instrument, or the direction it is heading (its course)
    1216 : dict(standard_name='platform_pitch_angle', long_name='Instrument Pitch', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # Ptch:INST Pitch               :ptch:degrees:F10.2:ADCP pitch,
    1217 : dict(standard_name='platform_roll_angle', long_name='Instrument Roll', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # Roll:INST Roll                :roll:degrees:F10.2:ADCP roll,
    1218 : dict(standard_name='platform_orientation', long_name='ADCP Heading - Standard Deviation', units='degree', convert=lambda x: x, cf_units='degree', cell_methods='time: standard_deviation'),  # HSD :Heading Std. Dev.        :hdg:degrees: :ADCP Hdg. Std. Dev.,  LOOK: Is the EPIC code the orientation of the instrument, or the direction it is heading (its course)
    1219 : dict(standard_name='platform_pitch_angle', long_name="ADCP Pitch - Standard Deviation", units='degree', convert=lambda x: x, cf_units='degree', cell_methods='time: standard_deviation'),  # PSD :Pitch Std. Dev.          :ptch:degrees: :ADCP Pitch Std. Dev.,
    1220 : dict(standard_name='platform_roll_angle', long_name='ADCP Roll - Standard Deviation', units='degree', convert=lambda x: x, cf_units='degree', cell_methods='time: standard_deviation'),  # RSD :Roll Std. Dev.           :roll:degrees: :ADCP Roll Std. Dev.,
    1221 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AGC1:Echo Intensity (AGC) Beam 1:AGC:counts: :ADCP Beam 1 AGC,
    1222 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AGC2:Echo Intensity (AGC) Beam 2:AGC:counts: :ADCP Beam 2 AGC,
    1223 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AGC3:Echo Intensity (AGC) Beam 3:AGC:counts: :ADCP Beam 3 AGC,
    1224 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AGC4:Echo Intensity (AGC) Beam 4:AGC:counts: :ADCP Beam 4 AGC,
    1231 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv  :Mean Backscattering Strength:Sv:dB: :ADCP Mn Bksctr, ref to last bin,
    1232 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv  :Mean Backscattering Strength:Sv:dB: :ADCP Mn Bksctr, ref to noise cal,
    1233 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv1 :Backscattering Strength Beam 1:Sv:dB: :ADCP Bksctr., ref to noise cal,
    1234 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv2 :Backscattering Strength Beam 2:Sv:dB: :ADCP Bksctr., ref to noise cal,
    1235 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv3 :Backscattering Strength Beam 3:Sv:dB: :ADCP Bksctr., ref to noise cal,
    1236 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Sv4 :Backscattering Strength Beam 4:Sv:dB: :ADCP Bksctr., ref to noise cal,
    1237 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SvSD:Backscattering Strength Std. Dev:Sv:dB: :ADCP Bksctr. Std. Dev.,
    1241 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGd1:Percent Good Beam 1         : : : :ADCP Percent Good Beam 1,
    1242 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGd2:Percent Good Beam 2         : : : :ADCP Percent Good Beam 2,
    1243 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGd3:Percent Good Beam 3         : : : :ADCP Percent Good Beam 3,
    1244 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGd4:Percent Good Beam 4         : : : :ADCP Percent Good Beam 4,
    1245 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PG4B:Percent 4-Beam Solns. Good  : : : :ADCP Percent 4-Beam Solns. Good,
    1246 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PG3B:Percent 3-Beam Solns. Good  : : : :ADCP Percent 3-Beam Solns. Good,
    1247 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PGWe:Percent Error Vel. Good     : : : :ADCP Percent Error Vel. Good,
    1251 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # St1 :Status Beam 1               : : : :ADCP Beam 1 Status,
    1252 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # St2 :Status Beam 2               : : : :ADCP Beam 2 Status,
    1253 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # St3 :Status Beam 3               : : : :ADCP Beam 3 Status,
    1254 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # St4 :Status Beam 4               : : : :ADCP Beam 4 Status,
    1255 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # StBn:Bin Status                  : : : :ADCP Bin Status,
    1260 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTWe:BT Error Velocity           :w:cm/s: :ADCP Btm. Trk. Error Velocity,
    1261 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTu :BT Eastward Velocity        :u:cm/s: :ADCP Btm. Trk. Eastward Velocity,
    1262 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTv :BT Northward Velocity       :v:cm/s: :ADCP Btm. Trk. Northward Velocity,
    1263 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTw :BT Vertical Velocity        :w:cm/s: :ADCP Btm. Trk. Vertical Velocity,
    1264 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTR1:BT Range Beam 1             : :m: :ADCP Btm. Trk. Range Beam1,
    1265 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTR2:BT Range Beam 2             : :m: :ADCP Btm. Trk. Range Beam2,
    1266 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTR3:BT Range Beam 3             : :m: :ADCP Btm. Trk. Range Beam3,
    1267 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTR4:BT Range Beam 4             : :m: :ADCP Btm. Trk. Range Beam4,
    1268 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTRa:BT Average Range            : :m: :ADCP Btm. Trk. Range Average,
    1269 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTSD:BT Range Std. Dev.          : :m: :ADCP Btm. Trk. Range St Dev,
    1270 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTP1:BT Percent Good Beam 1      : : : :ADCP Btm. Trk. Beam 1 % Good Pings,
    1271 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTP2:BT Percent Good Beam 2      : : : :ADCP Btm. Trk. Beam 2 % Good Pings,
    1272 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTP3:BT Percent Good Beam 3      : : : :ADCP Btm. Trk. Beam 3 % Good Pings,
    1273 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTP4:BT Percent Good Beam 4      : : : :ADCP Btm. Trk. Beam 4 % Good Pings,
    1275 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Un  :Track Normal Velocity       :un:cm/s: :ADCP Vel. normal to track,
    1276 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Vt  :Track Tangential Velocity   :vt:cm/s: :ADCP Vel. tangential to track,
    1277 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vel1:Beam 1 velocity (mm/s)    : :mm s-1:f10.2:ADCP velocity along beam 1,
    1278 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vel2:Beam 2 velocity (mm/s)    : :mm s-1:f10.2:ADCP velocity along beam 2,
    1279 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vel3:Beam 3 velocity (mm/s)    : :mm s-1:f10.2:ADCP velocity along beam 3,
    1280 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vel4:Beam 4 velocity (mm/s)    : :mm s-1:f10.2:ADCP velocity along beam 4,
    1281 : dict(standard_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water', long_name='Beam 1 Attenuation', units='1/m', convert=lambda x: x, cf_units='1/m', cell_methods=None),  # att1:Beam 1 attenuation        : :counts:i10:ADCP attenuation of beam 1,
    1282 : dict(standard_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water', long_name='Beam 2 Attenuation', units='1/m', convert=lambda x: x, cf_units='1/m', cell_methods=None),  # att2:Beam 2 attenuation        : :counts:i10:ADCP attenuation of beam 2,
    1283 : dict(standard_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water', long_name='Beam 3 Attenuation', units='1/m', convert=lambda x: x, cf_units='1/m', cell_methods=None),  # att3:Beam 3 attenuation        : :counts:i10:ADCP attenuation of beam 3,
    1284 : dict(standard_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water', long_name='Beam 4 Attenuation', units='1/m', convert=lambda x: x, cf_units='1/m', cell_methods=None),  # att4:Beam 4 attenuation        : :counts:i10:ADCP attenuation of beam 4,
    1285 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # cor1:Beam 1 correlation        : :counts:i10:ADCP correlation of beam 1,
    1286 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # cor2:Beam 2 correlation        : :counts:i10:ADCP correlation of beam 2,
    1287 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # cor3:Beam 3 correlation        : :counts:i10:ADCP correlation of beam 3,
    1288 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # cor4:Beam 4 correlation        : :counts:i10:ADCP correlation of beam 4,
    1290 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # xmtc:ADCP transmit current     :xmitc:amps:f10.3:,
    1291 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # xmtv:ADCP transmit voltage     :xmitv:volts:f10.3:,
    1292 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # dac :ADCP DAC output           :dac:counts:i10:,
    1293 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vdc :ADCP VDC voltage          :vdc:volts:f10.3:,
    1294 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (at Transducer Head)', units='decapascal', convert=lambda x: x/1000., cf_units='dbar', cell_methods=None),  # P:ADCP Pressure:pres:deca-pascals:F15.2:ADCP Pressure at Transducer Head,
    1295 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (variance at Transducer Head)', units='decapascal', convert=lambda x: x/1000., cf_units='dbar', cell_methods='time: variance'),  # PVAR:ADCP Pressure Variance:pvar:deca-pascals:F15.2:ADCP Pressure Variance at Transducer Head,
    1301 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure', units='PSIA', convert=lambda x: x*0.6894757293, cf_units='dbar', cell_methods=None),  # BPR  :BOTTOM PRESSURE            : :PSIA: :Pounds Per Square Inch Absolute,
    1371 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # U48:U Amplitude (CM/S) 48hrs :u48:cm s-1: :measured w/r true N,
    1372 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V48:V Amplitude (CM/S) 48hrs :v48:cm s-1: :measured w/r true N,
    1380 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Res :MTR resistance          :res:ohm:f10.2:Instrument resistance,
    1401 : dict(standard_name='platform_orientation', long_name='Compass Heading (magnetic north)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # hdg :AMP compass heading     :comp:degrees:f10.2:compass heading,
    1402 : dict(standard_name='platform_orientation', long_name='Vane Heading (magnetic north)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # van :AMP vane                :vane:degrees:f10.2:vane reading,
    1403 : dict(standard_name='platform_orientation', long_name='Instrument Heading (vane)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # van :VANE ANGLE              :vane:degrees:f10.1:current orientation to instrument,
    1404 : dict(standard_name='platform_orientation', long_name='Instrument Heading (magnetic north)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # comp:COMPASS (m)             :comp:degreeM:f10.1:instrument orientation to magnetic north,
    1406 : dict(standard_name='platform_orientation', long_name='Instrument Heading (BASS pods)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # comp:ORIENTATION (BASS)      :comp:degrees:f10.3:orientation of BASS pods,
    1407 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # comp:RAW COMPASS VOLTS (MIDAS):comp:counts:i10:MIDAS raw compass voltage,
    1408 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rcomp:ENCODED COMPASS        :comp:128.lvl.binary:i10:vacm grey code compass,
    1409 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rvane:ENCODED VANE           :vane:128.lvl.binary:i10:vacm grey code vane,
    1411 : dict(standard_name='platform_orientation', long_name='Instrument Heading (magnetic north)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # bear:bearing (m)      :dir:degreeM:f8.2:instantaneous dir., magnetic north (oceanographic),
    1412 : dict(standard_name='platform_orientation', long_name='Instrument Heading (true north)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # bear:bearing (t)      :dir:degreeT:f8.2:instantaneous dir., true north (oceanographic),
    1413 : dict(standard_name='platform_orientation', long_name='Instrument Heading (rotated)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # bear:bearing (r)      :dir:degrees:f8.2:instantaneous dir., rotated (oceanographic),
    1414 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vdir:vector direction (m):vdir:degreeM:f8.2:averaged dir., magnetic north (oceanographic),
    1415 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vdir:vector direction (t):vdir:degreeT:f8.2:averaged dir., true north (oceanographic),
    1416 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # vdir:vector direction (r):vdir:degrees:f8.2:averaged dir., rotated (oceanographic),
    1500 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:START LATITUDE           :start_lat:degree_north:f10.4:N positive S negative,
    1501 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:START LONGITUDE          :start_lon:degree_west:f10.4:W positive 165W=165,
    1502 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:START LONGITUDE          :start_lon:degree_east:f10.4:E positive 165W=195,
    1510 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:END LATITUDE             :end_lat:degree_north:f10.4:N positive S negative,
    1511 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:END LONGITUDE            :end_lon:degree_west:f10.4:W positive 165W=165,
    1512 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:END LONGITUDE            :end_lon:degree_east:f10.4:E positive 165W=195,
    1601 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # IQ:WEPOCS QUALITY ID         :iq: : :Billy Kessler's WEPOCS CTD,
    1701 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # F11:CFC-11 (PMOL/KG)         :f11:pmol/kg:f10.6:trichloroflouoromethane,
    1702 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # F12:CFC-12 (PMOL/KG)         :f12:pmol/kg:f10.6:dichlorofluoromethane,
    1711 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PF11:PCFC-11                 :pf11: :f5.2:CFC-11 equilibrium partial-pressure,
    1712 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PF12:PCFC-12                 :pf12: :f5.2:CFC-12 equilibrium partial-pressure,
    1721 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PF11AGE:Pf11age              :pf11age:years:f8.3:cfc11 partial pressure age,
    1722 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PF12AGE:Pf12age              :pf12age:years:f8.3:cfc12 partial pressure age,
    1723 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PFRATAGE:Pfratage            :pfratage:years:f8.3:cfcratio partial pressure age,
    1731 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # F11CORR:CORRECTED CFC-11     :f11corr:pmol/kg:f10.6:corrected trichloroflouoromethane,
    1732 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # F12CORR:CORRECTED CFC-12     :f12corr:pmol/kg:f10.6:corrected dichlorofluoromethane,
    1751 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TCO2:TOTAL CO2 (micromoles/kg):dic:uM/kg:f6.1:Dissolved Organic Carbon (micromoles/kg),
    1752 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NTCO2:NORMALIZED TCO2 (uM/kg):ndic:uM/kg:f6.1:Normalized Dissolved Organic Carbon (micromoles/kg),
    1753 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DIC:DISS. INORG. CARBON (umol/kg):dic:umol/kg:f6.1:Dissolved Inorganic Carbon (micromoles/kg) fr, cell_methods=Noneom Dick Feely,
    1754 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TALK:TOTAL ALKALINITY (uM/kg):alk:uM/kg:f6.1:Total Alkalinity from Dick Feely,
    1755 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PCO2:PARTIAL CO2 PRESSURE (microATM):pco2:uATM:f6.4:Partial CO2 Pressure from Dick Feely,
    1756 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TALK:Total Alkalinity        :alk:meq/l: :Total alkalinity from WOD2001,
    1800 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Teq :Equilibrator Temperature: :degree C:f10.2:,
    1801 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CH4a:CH4air                  :ch4:ppb: :,
    1802 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CH4w:CH4water                :ch4:nmol/L: :,
    1803 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CH4e:CH4equilibrator         :ch4:ppb: :,
    1804 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COa :COair                   :co:ppb: :,
    1805 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COw :COwater                 :co:nmol/L: :,
    1806 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COe :COequilibrator          :co:ppb: :,
    1807 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # O3  :Ozone                   :o3:ppb: :,
    1808 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DMSa:DMSair                  :dms:ppt: :,
    1809 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DMSw:DMSwater                :dms:nmol/L: :,
    1810 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Rn  :Radon                   : :mBq m-3: :,
    1811 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # pC4a:pCH4air                 :ch4:micro-atm: :,
    1812 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # pC4w:pCH4water               :ch4:micro-atm: :,
    1814 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # pCOa:pCOair                  :co:micro-atm: :,
    1815 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # pCOw:pCOwater                :co:micro-atm: :,
    1816 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SO2 :Atmospheric Sulfur Dioxide:so2:ppb: :,
    1851 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CN  :Total Particles Dp>12nm : :cm-3: :condensation nuclei,
    1852 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UFCN:Total Particles Dp>3nm  : :cm-3: :ultrafine condensation nuclei,
    1853 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CN  :Total Particles Dp>13nm : :cm-3: :condensation nuclei,
    1861 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASB :Aerosol Scat Blue       : :Mm-1: :,
    1862 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASG :Aerosol Scat Green      : :Mm-1: :,
    1863 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASR :Aerosol Scat Red        : :Mm-1: :,
    1864 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ABSB:Aerosol Back Scat Blue  : :Mm-1: :,
    1865 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ABSG:Aerosol Back Scat Green : :Mm-1: :,
    1866 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ABSR:Aerosol Back Scat Red   : :Mm-1: :,
    1867 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SASB:Submicron AeroScat Blue : :Mm-1: :,
    1868 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SASG:Submicron AeroScat Green: :Mm-1: :,
    1869 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SASR:Submicron AeroScat Red  : :Mm-1: :,
    1870 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SBSB:Submicron Aero BkScat Blue : :Mm-1: :,
    1871 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SBSG:Submicron Aero BkScat Green: :Mm-1: :,
    1872 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SBSR:Submicron Aero BkScat Red  : :Mm-1: :,
    1873 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAb :Aerosol Absorbance          : :Mm-1: :,
    1874 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SAAb:Submicron Aerosol Absorbance: :Mm-1: :,
    1875 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASST :Aerosol Scat Nephelometer Temp    : :degC: :,
    1876 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASSRH:Aerosol Scat Nephelometer RH      : :%: :,
    1877 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASSP :Aerosol Scat Nephelometer Pressure: :mbar: :,
    1879 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AODAMS:AOD measurement airmass: :atmosphere : :,
    1880 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AODMZA:AOD measurement zenith angle: :degrees: :,
    1881 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD1 :Aerosol Optical Depth Ch-1 : : : :,
    1882 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD2 :Aerosol Optical Depth Ch-2 : : : :,
    1883 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD3 :Aerosol Optical Depth Ch-3 : : : :,
    1884 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD4 :Aerosol Optical Depth Ch-4 : : : :,
    1885 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD5 :Aerosol Optical Depth Ch-5 : : : :,
    1886 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD6 :Aerosol Optical Depth Ch-6 : : : :,
    1887 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD7 :Aerosol Optical Depth Ch-7 : : : :,
    1888 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD8 :Aerosol Optical Depth Ch-8 : : : :,
    1889 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD9 :Aerosol Optical Depth Ch-9 : : : :,
    1890 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AOD10:Aerosol Optical Depth Ch-10: : : :,
    1891 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAb1:Aerosol Absorbance at wavelength 1: :Mm-1:  :,
    1892 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAb2:Aerosol Absorbance at wavelength 2: :Mm-1:  :,
    1893 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAb3:Aerosol Absorbance at wavelength 3: :Mm-1:  :,
    1894 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SAAb1:Submicron Aerosol Absorbance at wavelength 1: :Mm-1:  :,
    1895 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SAAb2:Submicron Aerosol Absorbance at wavelength 2: :Mm-1:  :,
    1896 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SAAb3:Submicron Aerosol Absorbance at wavelength 3: :Mm-1:  :,
    1900 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V00:VARIABLE 0               : : : :,
    1901 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V01:VARIABLE 1               : : : :,
    1902 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V02:VARIABLE 2               : : : :,
    1903 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V03:VARIABLE 3               : : : :,
    1904 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V04:VARIABLE 4               : : : :,
    1905 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V05:VARIABLE 5               : : : :,
    1906 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V06:VARIABLE 6               : : : :,
    1907 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V07:VARIABLE 7               : : : :,
    1908 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # V08:VARIABLE 8               : : : :,
    1920 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Na    :Soluble Submicron Aerosol Sodium                 : :ug/m^3: :,
    1921 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Na    :Soluble Supermicron Aerosol Sodium               : :ug/m^3: :,
    1922 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Na    :Soluble Sub10micron Aerosol Sodium               : :ug/m^3: :,
    1923 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4   :Soluble Submicron Aerosol Ammonium               : :ug/m^3: :,
    1924 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4   :Soluble Supermicron Aerosol Ammonium             : :ug/m^3: :,
    1925 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4   :Soluble Sub10micron Aerosol Ammonium             : :ug/m^3: :,
    1926 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # K     :Soluble Submicron Aerosol Potassium              : :ug/m^3: :,
    1927 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # K     :Soluble Supermicron Aerosol Potassium            : :ug/m^3: :,
    1928 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # K     :Soluble Sub10micron Aerosol Potassium            : :ug/m^3: :,
    1929 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Mg    :Soluble Submicron Aerosol Magnesium              : :ug/m^3: :,
    1930 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Mg    :Soluble Supermicron Aerosol Magnesium            : :ug/m^3: :,
    1931 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Mg    :Soluble Sub10micron Aerosol Magnesium            : :ug/m^3: :,
    1932 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Soluble Submicron Aerosol Calcium                : :ug/m^3: :,
    1933 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Soluble Supermicron Aerosol Calcium              : :ug/m^3: :,
    1934 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Soluble Sub10micron Aerosol Calcium              : :ug/m^3: :,
    1935 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssK  :Soluble Submicron Aerosol non-Seasalt Potassium  : :ug/m^3: :,
    1936 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssK  :Soluble Supermicron Aerosol non-Seasalt Potassium: :ug/m^3: :,
    1937 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssK  :Soluble Sub10micron Aerosol non-Seasalt Potassium: :ug/m^3: :,
    1938 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssMg :Soluble Submicron Aerosol non-Seasalt Magnesium  : :ug/m^3: :,
    1939 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssMg :Soluble Supermicron Aerosol non-Seasalt Magnesium: :ug/m^3: :,
    1940 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssMg :Soluble Sub10micron Aerosol non-Seasalt Magnesium: :ug/m^3: :,
    1941 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssCa :Soluble Submicron Aerosol non-Seasalt Calcium    : :ug/m^3: :,
    1942 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssCa :Soluble Supermicron Aerosol non-Seasalt Calcium  : :ug/m^3: :,
    1943 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssCa :Soluble Sub10micron Aerosol non-Seasalt Calcium  : :ug/m^3: :,
    1944 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Cl    :Soluble Submicron Aerosol Chloride               : :ug/m^3: :,
    1945 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Cl    :Soluble Supermicron Aerosol Chloride             : :ug/m^3: :,
    1946 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Cl    :Soluble Sub10micron Aerosol Chloride             : :ug/m^3: :,
    1947 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3   :Soluble Submicron Aerosol Nitrate                : :ug/m^3: :,
    1948 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3   :Soluble Supermicron Aerosol Nitrate              : :ug/m^3: :,
    1949 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3   :Soluble Sub10micron Aerosol Nitrate              : :ug/m^3: :,
    1950 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SO4   :Soluble Submicron Aerosol Sulfate                : :ug/m^3: :,
    1951 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SO4   :Soluble Supermicron Aerosol Sulfate              : :ug/m^3: :,
    1952 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SO4   :Soluble Sub10micron Aerosol Sulfate              : :ug/m^3: :,
    1953 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssSO4:Soluble Submicron Aerosol non-Seasalt Sulfate    : :ug/m^3: :,
    1954 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssSO4:Soluble Supermicron Aerosol non-Seasalt Sulfate  : :ug/m^3: :,
    1955 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # nssSO4:Soluble Sub10micron Aerosol non-Seasalt Sulfate  : :ug/m^3: :,
    1956 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MSA   :Soluble Submicron Aerosol Methane Sulfonic Acid  : :ug/m^3: :,
    1957 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MSA   :Soluble Supermicron Aerosol Methane Sulfonic Acid: :ug/m^3: :,
    1958 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MSA   :Soluble Sub10micron Aerosol Methane Sulfonic Acid: :ug/m^3: :,
    1959 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OC    :Submicron Aerosol Organic Carbon                 : :ug/m^3: :,
    1960 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OC    :Supermicron Aerosol Organic Carbon               : :ug/m^3: :,
    1961 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OC    :Sub10micron Aerosol Organic Carbon               : :ug/m^3: :,
    1962 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BC    :Submicron Aerosol Black Carbon                   : :ug/m^3: :,
    1963 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BC    :Supermicron Aerosol Black Carbon                 : :ug/m^3: :,
    1964 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BC    :Sub10micron Aerosol Black Carbon                 : :ug/m^3: :,
    1965 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mass  :Submicron Aerosol mass                           : :ug/m^3: :,
    1966 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mass  :Supermicron Aerosol mass                         : :ug/m^3: :,
    1967 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mass  :Sub10micron Aerosol mass                         : :ug/m^3: :,
    1968 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Al    :Submicron Aerosol Aluminum                       : :ug/m^3: :,
    1969 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Al    :Supermicron Aerosol Aluminum                     : :ug/m^3: :,
    1970 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Al    :Sub10micron Aerosol Aluminum                     : :ug/m^3: :,
    1971 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fe    :Submicron Aerosol Iron                           : :ug/m^3: :,
    1972 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fe    :Supermicron Aerosol Iron                         : :ug/m^3: :,
    1973 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fe    :Sub10micron Aerosol Iron                         : :ug/m^3: :,
    1974 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Si    :Submicron Aerosol Silicon                        : :ug/m^3: :,
    1975 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Si    :Supermicron Aerosol Silicon                      : :ug/m^3: :,
    1976 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Si    :Sub10micron Aerosol Silicon                      : :ug/m^3: :,
    1977 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Submicron Aerosol Calcium                        : :ug/m^3: :,
    1978 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Supermicron Aerosol Calcium                      : :ug/m^3: :,
    1979 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ca    :Sub10micron Aerosol Calcium                      : :ug/m^3: :,
    1980 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ti    :Submicron Aerosol Titanium                       : :ug/m^3: :,
    1981 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ti    :Supermicron Aerosol Titanium                     : :ug/m^3: :,
    1982 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Ti    :Sub10micron Aerosol Titanium                     : :ug/m^3: :,
    1983 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # IOM   :Submicron Aerosol Inorganic Oxidized Material    : :ug/m^3: :,
    1984 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # IOM   :Supermicron Aerosol Inorganic Oxidized Material  : :ug/m^3: :,
    1985 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # IOM   :Sub10micron Aerosol Inorganic Oxidized Material  : :ug/m^3: :,
    1986 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Oxlate:Soluble Submicron Aerosol Oxalate                : :ug/m^3: :,
    1987 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Oxlate:Soluble Supermicron Aerosol Oxalate              : :ug/m^3: :,
    1988 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Oxlate:Soluble Sub10micron Aerosol Oxalate              : :ug/m^3: :,
    1989 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Br    :Soluble Submicron Aerosol Bromide                : :ug/m^3: :,
    1990 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Br    :Soluble Supermicron Aerosol Bromide              : :ug/m^3: :,
    1991 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Br    :Soluble Sub10micron Aerosol Bromide              : :ug/m^3: :,
    1992 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SO4   :Non-Refractory Aerosol Sulfate: :ug/m^3: :,
    1993 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OC    :Non-Refractory Aerosol Organic Carbon: :ug/m^3: :,
    1994 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO3   :Non-Refractory Aerosol Nitrate: :ug/m^3: :,
    1995 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NH4   :Non-Refractory Aerosol Ammonium: :ug/m^3: :,
    1996 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # POM   :Non-Refactory Particulate Organic Matter: :ug/m^3: :,
    1997 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WSOC :Submicron Aerosol Water Soluble Organic Carbon : :ug/m^3: :,
    1998 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WSOC :Supermicron Aerosol Water Soluble Organic Carbon : :ug/m^3::,
    1999 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WSOC :Sub10micron Aerosol Water Soluble Organic Carbon : :ug/m^3::,
    2000 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAbAE1:Aerosol light Absorbtion Angstrom Exponent for defined Aerosol at wavelength 1: :Mm-1:  :,
    2001 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAbAE2:Aerosol light Absorbtion Angstrom Exponent for defined Aerosol at wavelength 2: :Mm-1:  :,
    2002 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AAbAE3:Aerosol light Absorbtion Angstrom Exponent for defined Aerosol at wavelength 3: :Mm-1:  :,
    2003 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AScAE1:Aerosol light Scattering Angstrom Exponent for defined Aerosol at wavelength 1: :Mm-1:  :,
    2004 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AScAE2:Aerosol light Scattering Angstrom Exponent for defined Aerosol at wavelength 2: :Mm-1:  :,
    2005 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # AScAE3:Aerosol light Scattering Angstrom Exponent for defined Aerosol at wavelength 3: :Mm-1:  :,
    2006 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASSA1:Aerosol Single Albedo for defined Aerosol at wavelength 1: :Mm-1:  :,
    2007 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASSA2:Aerosol Single Albedo for defined Aerosol at wavelength 2: :Mm-1:  :,
    2008 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASSA3:Aerosol Single Albedo for defined Aerosol at wavelength 3: :Mm-1:  :,
    2009 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASfRH1:Aerosol light Scattering f(RH) factor for defined Aerosol and RH range at wavelength 1: :Mm-1:  :,
    2010 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASfRH2:Aerosol light Scattering f(RH) factor for defined Aerosol and RH range at wavelength 2: :Mm-1:  :,
    2011 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ASfRH3:Aerosol light Scattering f(RH) factor for defined Aerosol and RH range at wavelength 3: :Mm-1:  :,
    2907 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fph:Phaeopigments Large Size Fraction: :ugrams/l: :,
    2908 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Fph:Phaeopigments Small Size Fraction: :ugrams/l: :,
    2930 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (factory calibration)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:CTD Chlorophyll-a factory calibration: :ugrams/l: :,
    2931 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (laboratory calibration)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:CTD Chlorophyll-a laboratory calibration: :ugrams/l: :,
    2932 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (CTD upcast with laboratory calibration)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:CTD upcast Chlorophyll-a laboratory calibration: :ugrams/l: :,
    2933 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (Total)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Chlorophyll-a total: :ugrams/l: :,
    2934 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (Large Size Fraction)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Chlorophyll-a Large Size Fraction: :ugrams/l: :,
    2935 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (Small Size Fraction)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Chlorophyll-a Small Size Fraction: :ugrams/l: :,
    2936 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Welschmeyer Chlorophyll-a total: :ugrams/l: :,
    2937 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (Large Size Fraction)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Welschmeyer Chlorophyll-a Large Size Fraction: :ugrams/l: :,
    2938 : dict(standard_name='mass_concentration_of_chlorophyll_in_sea_water', long_name='Chlorophyll-a (Small Size Fraction)', units='µg/L', convert=lambda x: x/1000000., cf_units='kg/m^3', cell_methods=None),  # Cla:Welschmeyer Chlorophyll-a Small Size Fraction: :ugrams/l: :,
    3001 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Tec :ADCP Electronics Temp. :temp:deg. C:F10.2:ADCP Electronics Box Temp.,
    3002 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Vs  :ADCP Voltage          : :v:F10.2:ADCP Supply Voltage,
    3003 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sBP:seas barometric pressure:BP:mbs:f10.2:seas barometric pressure,
    3004 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sWB:seas wet bulb temp:wbT:degree C:f10.2:seas wet bulb temp,
    3005 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sAT:seas air temp:atemp:degree C:f10.2:seas air temp,
    3006 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sWD:seas wind direction:WD:degree:f10.2:seas wind direction,
    3007 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mWB:manual wet bulb temp:wbulb:degree C:f10.2:manual wet bulb temp,
    3008 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mAT:manual air temp:dbulb:degree C:f10.2:manual air temp,
    3009 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mT:manual water temp:temp:degree C:f10.2:manual water temp,
    3010 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # MFdep:Miller Freeman depth:depth:meters:f10.1:depth from Miller Freeman,
    3011 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # lat1:gps1 lat 1 min:lat:degrees:f10.3:gps1 lat 1 min,
    3012 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # lon1:gps1 lon 1 min:long:degrees:f10.3:gps1 lon 1 min,
    3013 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sct:seacat temperature:temp:degree C:f10.2:seacat temperature,
    3014 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # scc:seacat conductivity:cond:mmhos:f10.2:seacat conductivity,
    3015 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # scs:seacat salinity:sal:ppt:f10.2:seacat salinity,
    3016 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # scz:seacat depth:depth:meters:f10.2:seacat depth,
    3017 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Tx  :ADCP Transducer Temp.     :temp:deg. C:F10.2:ADCP Transducer Temp.,
    3018 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # avTD:avg true wind dir:WD:degree:f10.2:avg true wind dir,
    3019 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # avTS:avg true wind speed:WS:m/sec:f10.2:avg true wind speed,
    3020 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # avC:avg conductivity:C:mmhos:f10.2:avg conductivity,
    3021 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # avT:avg temperature:T:degree C:f10.2:avg temperature,
    3022 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # avS:avg salinity:S:ppt:f10.2:avg salinity,
    3023 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rWS:rm young wind speed:WS:knots:f10.2:rm young wind speed,
    3024 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rWD:rm young wind dir:WD:degree:f10.2:rm young wind dir,
    3025 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rAT:rm young air temp:atemp:degree C:f10.2:rm young air temp,
    3026 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ocWD:oc true direction:WD:degree:f10.2:oc true direction,
    3027 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ocWS:oc wind speed:WS:knots:f10.2:oc wind speed,
    3028 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ocWDA:OC Wind Dir Avg:WD:degree:f10.2:OC Wind Dir Avg,
    3029 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ocWSA:OC Wind Spd Avg:WS:knots:f10.2:OC Wind Spd Avg,
    3030 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # light:light intensity:light:volts:f10.2:light intensity,
    3031 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # fluor:fluorometer:fluor:volts:f10.2:fluorometer,
    3032 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # EKdep:EK500 depth:depth:meters:f10.1:depth from MF EK500,
    3033 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # EQdep:EQ50 depth:depth:meters:f10.1:depth from MF EQ50,
    3034 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rWD:RMY true direction:WD:degree:f10.2:oc true direction,
    3035 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rWS:RMY wind speed:WS:knots:f10.2:oc wind speed,
    3036 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SD:gps ship direction:SD:degrees:f10.2:ship direction,
    3037 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SS:gps ship speed:SS:knots:f10.2:ship speed,
    3038 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # su:gps ship u component:su:knots:f10.2:ship east vel,
    3039 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # sv:gps ship v component:sv:knots:f10.2:ship north vel,
    3040 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SD:Ship Heading           :SD:degrees:f10.2:ship heading,
    3050 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # qAT:Qualimetrics Air Temp :atemp:degree C:f10.2:Qualimetrics Air Temp,
    3051 : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # AT :Air Temperature       :atemp:degree C:f10.2: :,
    3052 : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # AT :Air Temperature       :atemp:degree C:f10.2: :,
    3053 : dict(standard_name='air_temperature', long_name='Air Temperature', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # AT :Air Temperature       :atemp:degree C:f10.2: :,
    3055 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # qDP:Qualimetrics Dew Point: :degree C:f10.2: :,
    3056 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DP :Dew Point             : :degree C:f10.2: :,
    3060 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Hdg:Ship Heading       :hdg:degrees_T:F6.2:Ship Heading,
    3061 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Hdg:Gyrocompass Heading:hdg:degrees_T:F6.2:Ship Heading,
    3062 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # Hdg:Ashtech 3DF Heading:hdg:degrees_T:F6.2:Ship Heading,
    3070 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COG:Course Over Ground                     :COG:degrees_T:F6.2:Ship Course Over Ground,
    3071 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COG:Course Over Ground (Trimble P-code GPS):COG:degrees_T:F6.2:Ship Course Over Ground,
    3072 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # COG:Course Over Ground (North Star GPS)    :COG:degrees_T:F6.2:Ship Course Over Ground,
    3080 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SOG:Speed Over Ground                     :SOG:knots:F5.2:Ship Speed Over Ground,
    3081 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SOG:Speed Over Ground (Trimble P-code GPS):SOG:knots:F5.2:Ship Speed Over Ground,
    3082 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SOG:Speed Over Ground (North Star GPS)    :SOG:knots:F5.2:Ship Speed Over Ground,
    3090 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:Latitude (Trimble P-code GPS):lat:degree_north:F8.5:Latitude,
    3091 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LAT:Latitude (North Star GPS)    :lat:degree_north:F8.5:Latitude,
    3095 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:Longitude (Trimble P-code GPS):lon:degree_east:F9.5:Longitude,
    3096 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # LON:Longitude (North Star GPS)    :lon:degree_east:F9.5:Longitude,
    4000 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # upr:UPPER ROTOR SPEED     :rotor:counts:f10.1:basic measurement, vmcm,
    4001 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # upr:UPPER ROTOR SPEED     :rotor:cm/s:f10.3:interval upper rotor speed, Seadata tripod,
    4002 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # lowr:LOWER ROTOR SPEED    :rotor:counts:f10.1:basic measurement, vmcm,
    4003 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # lowr:LOWER ROTOR SPEED    :rotor:cm/s:f10.3:interval lower rotor speed, Seadata tripod,
    4004 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rdif:ROTOR SPEED DIFFERENCE  :rotor:cm/s:f10.3:difference, interval rotor speed, Seadata tripod,
    4005 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rot:ROTOR COUNTS             :rotor:counts:i10:vacm rotor counter,
    4006 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rspd:ROTOR SPEED             :speed:cm s-1:f8.2:scalar speed from rotor counts,
    4007 : dict(standard_name='sea_water_speed', long_name='Current speed', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods=None),  # vspd:VECTOR SPEED            :vspd:cm s-1:f8.2:vector speed from U and V,
    4008 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # cnt:clock counter            :count:counts:i10:clock counter,
    4009 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # stead:STEADINESS             :steadiness: :f10.4:VACM rotor spd normalized by vector spd to measure wave effect,
    4010 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # tran:TRANSMISSION (VOLTS)     :trans:volts:f10.3:basic measurement, transmissometerv,
    4011 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ptrn:PERCENT TRANSMISSION     :trans: :f10.1:normalized by 95% of air transmission,
    4012 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtrn:RAW TRANSMISSOMETER VOLTS:trans:counts:i10:MIDAS raw transmissometer voltage,
    4015 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtltx:RAW TILTX VOLTS          :tilt:counts:i10:MIDAS raw tiltx voltage,
    4016 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtlty:RAW TILTY VOLTS          :tilt:counts:i10:MIDAS raw tilty voltage,
    4017 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # tiltx:TILT IN POD X-Z PLANE    :tilt:degrees:f10.3:orientation of BASS pods,
    4018 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # tilty:TILT IN POD Y_Z PLANE    :tilt:degrees:f10.3:orientation of BASS pods,
    4019 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # tilta:TILT ANGLE               :tilt:degrees:f8.2:averaged instrument tilt FSIacm,
    4020 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (burst pressure minus interval pressure)', units='mbar', convert=lambda x: x/100., cf_units='dbar', cell_methods=None),  # P   :AVERAGE RELATIVE PRESSURE:pres:mbar:f10.5:burst pressure minus interval pressure, Seadata tripod,
    4022 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (interval)', units='mbar', convert=lambda x: x/100., cf_units='dbar', cell_methods=None),  # P   :INTERVAL PRESSURE        :pres:mbar:f10.3:interval pressure measurement, Seadata tripod,
    4023 : dict(standard_name='sea_water_pressure', long_name='Sea Water Pressure (average over burst)', units='mbar', convert=lambda x: x/100., cf_units='dbar', cell_methods=None),  # P   :AVERAGE BURST PRESSURE   :pres:mbar:f10.3:average of burst pressures,
    4026 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (PAROS,COMP,AB):pres:counts:i10:Paroscientific, temp. compensated, A,B calibration,
    4027 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (PAROS,UNCOMP,AB):pres:counts:i10:Paroscientific, not temp. compensated, A,B calibration,
    4028 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (PAROS,COMP,CD):pres:counts:i10:Paroscientific, temp. compensated, C,D calibration,
    4029 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (PAROS,UNCOMP,CD):pres:counts:i10:Paroscientific, not temp. compensated, C,D calibration,
    4030 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (VACM):pres:counts:i10:vacm raw pressure,
    4031 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (MX2):pres:counts:i10:mx-vacm with 2 mx-variables,
    4032 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rpres:RAW PRESSURE (MX4):pres:counts:i10:mx-vacm with 4 mx-variables,
    4041 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtemp:RAW TEMPERATURE (SEABIRD) :temp:counts:i10:Seabird cell raw temperature,
    4042 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtemp:RAW TEMPERATURE (MIDAS THERM) :temp:counts:i10:MIDAS thermister raw temperature,
    4043 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtemp:RAW TEMPERATURE (VACM) :temp:counts:i10:vacm raw temperature,
    4045 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtemp:RAW TEMPERATURE (MX2):temp:counts:i10:mx-vacm with 2 mx-variables,
    4046 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rtemp:RAW TEMPERATURE (MX4):temp:counts:i10:mx-vacm with 4 mx-variables,
    4050 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UVAR:EAST VELOCITY VARIANCE   :uvar:cm2/s2:f10.2:variance of east component, burst BASS data,
    4051 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UVCOV:U-V VELOCITY COVARIANCE :uvcovar:cm2/s2:f10.2:covariance of east and north, burst BASS data,
    4052 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VVAR:NORTH VELOCITY VARIANCE  :vvar:cm2/s2:f10.2:variance of north component, burst BASS data,
    4053 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # UWCOV:U-W VELOCITY COVARIANCE :uwcovar:cm2/s2:f10.2:covariance of east and up, burst BASS data,
    4054 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # VWCOV:V-W VELOCITY COVARIANCE :vwcovar:cm2/s2:f10.2:covariance of north and up, burst BASS data,
    4055 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # WVAR:UP VELOCITY VARIANCE     :wvar:cm2/s2:f10.2:variance of up component, burst BASS data,
    4056 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # peru:ZERO CROSSING PERIOD, U  :period_u:s:f10.2:zero crossing period of east component, burst BASS data,
    4057 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # perv:ZERO CROSSING PERIOD, V  :period_v:s:f10.2:zero crossing period of north component, burst BASS data,
    4060 : dict(standard_name='sea_surface_wave_mean_period', long_name='Average Wave Period', units='s', convert=lambda x: x, cf_units='s', cell_methods=None),  # wp  :average wave period       :wave_period:s:f10.2:,  LOOK: This is not really a CF name.
    4061 : dict(standard_name='sea_surface_wave_significant_height', long_name='Significant Wave Height', units='m', convert=lambda x: x, cf_units='m', cell_methods=None),  # wh  :significant wave height   :wave_height:m:f10.2:,
    4062 : dict(standard_name='sea_surface_wave_from_direction', long_name='Wave Direction (from TN)', units='degree', convert=lambda x: x, cf_units='degree', cell_methods=None),  # wd  :mean wave direction :wave_dir:degrees:f8.2:direction dominant waves are coming from, measured clockwise from true north,
    4063 : dict(standard_name='sea_surface_dominant_wave_period', long_name='Dominant Wave Period', units='s', convert=lambda x: x, cf_units='s', cell_methods=None),  # dwp :dominant wave period     :wave_period:s:f10.2:,   LOOK: This is not really a CF name.
    4064 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # mwh :Maximum Wave Height      :wave_height:m:f10.2:,
    4070 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BASA:BASS COUNTS, AXIS A      :bass:counts:f10.1:basic data of BASS pod,
    4071 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BASB:BASS COUNTS, AXIS B      :bass:counts:f10.1:basic data of BASS pod,
    4072 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BASC:BASS COUNTS, AXIS C      :bass:counts:f10.1:basic data of BASS pod,
    4073 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BASD:BASS COUNTS, AXIS D      :bass:counts:f10.1:basic data of BASS pod,
    4074 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BadBA:BAD BASS COUNT, AXIS A   :badbass:count:f10.1:bad data cycle count, BASS pod,
    4075 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BadBB:BAD BASS COUNT, AXIS B   :badbass:count:f10.1:bad data cycle count, BASS pod,
    4076 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BadBC:BAD BASS COUNT, AXIS C   :badbass:count:f10.1:bad data cycle count, BASS pod,
    4077 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BadBC:BAD BASS COUNT, AXIS D   :badbass:count:f10.1:bad data cycle count, BASS pod,
    4080 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # u   :East(m)                   :u:cm s-1:f8.2:U component (magnetic),
    4081 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # v   :North(m)                  :v:cm s-1:f8.2:V component (magnetic),
    4082 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # u   :East(t)                   :u:cm s-1 :f8.2:U component (true north),
    4083 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # v   :North(t)                  :v:cm s-1:f8.2:V component (true North),
    4084 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # u   :East(r)                   :u:cm s-1 :f8.2:U component (rotated),
    4085 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # v   :North(r)                  :v:cm s-1:f8.2:V component (rotated),
    4086 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # u   :instant East(m)           :u:cm s-1:f8.2:instantaneous east comp (magnetic) FSIacm,
    4087 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # v   :instant North(m)          :v:cm s-1:f8.2:instantaneous north comp (magnetic) FSIacm,
    4088 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # u   :instant East(t)           :u:cm s-1:f8.2:instantaneous east comp (true north) FSIacm,
    4089 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # v   :instant North(t)          :v:cm s-1:f8.2:instantaneous north comp (true north) FSIacm,
    4091 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # w   :instant vertical velocity :w:cm s-1:f8.2:instantaneous vertical velocity FSIacm,
    4095 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # re  :east register             :u:counts:i10:vacm east register,
    4096 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # rn  :north register            :v:counts:i10:vacm north register,
    4097 : dict(standard_name='upward_sea_water_velocity', long_name='Upward (w) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods='time: standard_deviation'),  # USTD:STD Eastward velocity     :ustd:cm s-1:f8.2:standard deviation of east component,
    4098 : dict(standard_name='northward_sea_water_velocity', long_name='Northard (w) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods='time: standard_deviation'),  # VSTD:STD Northward velocity    :vstd:cm s-1:f8.2:standard deviation of north component,
    4099 : dict(standard_name='upward_sea_water_velocity', long_name='Upward (w) velocity', units='cm/s', convert=lambda x: x/10., cf_units='m/s', cell_methods='time: standard_deviation'),  # WSTD:STD Vertical velocity     :wstd:cm s-1:f8.2:standard deviation of upward component,
    4202 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # BTLNBR_FLAG:Bottle Number Flag :flag: : :,
    4203 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CTDPRS:Pressure                :depth:dbar:f9.1:,
    4204 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CTDPRS_FLAG:Pressure Flag      :flag: : :,
    4210 : dict(standard_name='sea_water_temperature', long_name='Water Temperature (CTD)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # CTDTMP :Temperature            :temp:degC:f9.4:,
    4211 : dict(standard_name='sea_water_temperature', long_name='Water Temperature (ITS-90)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # CTDTMP :Temperature, ITS-90    :temp:degC:f9.4:,
    4212 : dict(standard_name='sea_water_temperature', long_name='Water Temperature (IPTS-68)', units='degree_Celsius', convert=lambda x: x+273.15, cf_units='K', cell_methods=None),  # CTDTMP :Temperature, IPTS-68   :temp:degC:f9.4:,
    4213 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CTDTMP_FLAG:Temperature Flag   :flag: : :,
    4214 : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # CTDSAL :CTD Salinity, PSS-78   :sal:PSU:f9.4:,
    4215 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CTDSAL_FLAG:CTD Salinity Flag  :flag: : :,
    4216 : dict(standard_name='sea_water_practical_salinity', long_name='Salinity', units='1e-3', convert=lambda x: x, cf_units='1e-3', cell_methods=None),  # SALNTY :Bottle Salinity, PSS-78:sal:PSU:f9.4:,
    4217 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SALNTY_FLAG:Bottle Salinity Flag:flag: : :,
    4218 : dict(standard_name='sea_water_electrical_conductivity', long_name='Conductivity (CTD)', units='S/m', convert=lambda x: x, cf_units='S/m', cell_methods=None),  # CTDCON:CTD Conductivity        :con:S/m:f10.3:,
    4220 : dict(standard_name='volume_fraction_of_oxygen_in_sea_water', long_name='Dissolved Oxygen (saturation)', units='percent', convert=lambda x: x, cf_units='percent', cell_methods=None),  # CTDOST:CTD OXYGEN, %SAT        :ox:%: :,
    4221 : dict(standard_name='mole_concentration_of_dissolved_molecular_oxygen_in_sea_water', long_name='Dissolved Oxygen (mole contentration)', units='µmol/kg', convert=lambda x: x, cf_units='µmol/kg', cell_methods=None),  # CTDOXY:CTD Oxygen:ox:umol/kg:f9.1:,  LOOK: Can't convert umol/kg to mol-m-3, so we are leaving the original units
    4222 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CTDOXY_FLAG:CTD Oxygen Flag    :flag: : :,
    4223 : dict(standard_name='mole_concentration_of_dissolved_molecular_oxygen_in_sea_water', long_name='Dissolved Oxygen (mole contentration)', units='µmol/kg', convert=lambda x: x, cf_units='µmol/kg', cell_methods=None),  # OXYGEN :Bottle Oxygen:ox:umol/kg:f9.1:,  LOOK: Can't convert umol/kg to mol-m-3, so we are leaving the original units
    4224 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # OXYGEN_FLAG:Bottle Oxygen Flag :flag: : :,
    4225 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SILCAT :Silicate:SiO4          :umol/kg:f9.2:,
    4226 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SILCAT_FLAG:Silicate Flag      :flag: : :,
    4227 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRAT :Nitrate:NO3            :umol/kg:f9.2:,
    4228 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRAT_FLAG:Nitrate Flag       :flag: : :,
    4229 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2+NO3:Nitrate plus Nitrite:NO2+NO3:umol/kg:f9.2:,
    4230 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2+NO3_FLAG:NO2+NO3 Flag      :flag: : :,
    4231 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRIT :Nitrite                :NO2:umol/kg:f9.2:,
    4232 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRIT_FLAG:Nitrite Flag       :flag: : :,
    4233 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PHSPHT :Phosphate              :PO4:umol/kg:f9.2:,
    4234 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PHSPHT_FLAG:Phosphate Flag     :flag: : :,
    4235 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # SILCAT :Silicate               :SiO4   :umol/l   :f9.1:,
    4236 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRAT :Nitrate                :NO3    :umol/l   :f9.1:,
    4237 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NITRIT :Nitrite                :NO2    :umol/l   :f9.2:,
    4238 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PHSPHT :Phosphate              :PO4    :umol/l   :f9.2:,
    4239 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NO2NO3:Nitrate plus Nitrite    :NO2NO3:umol/l:f9.2:,
    4241 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC-11 :Freon-11               :f11:pmol/kg:f9.3:,
    4242 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC-11_FLAG:Freon-11 Flag      :flag: : :,
    4243 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC-12 :Freon-12               :f12:pmol/kg:f9.3:,
    4244 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC-12_FLAG:Freon-12 Flag      :flag: : :,
    4245 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC113 :Freon-113              :f113 :pmol/kg:f9.3:,
    4246 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CFC113_FLAG:Freon-113 Flag     :flag: : :,
    4247 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CCL4 :Carbon Tetrachloride     :ccl4 :pmol/kg:f9.3:,
    4248 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # CCL4_FLAG:Carbon Tetrachloride Flag:flag: : :,
    4251 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TRITUM :Tritium                :tritium:TU :f9.3:,
    4252 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TRITUM_FLAG:Tritium Flag       :flag: : :,
    4253 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HELIUM :Helium                 :helium :nmol/kg:f9.4:,
    4254 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # HELIUM_FLAG:Helium Flag        :flag: : :,
    4255 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NEON   :Neon                   :neon :nmol/kg  :f8.3:,
    4256 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # NEON_FLAG:Neon Flag            :flag: : :,
    4261 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELHE3 :Delta-He3              :delhe3 :%:f9.2:,
    4262 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELHE3_FLAG:Delta-He3 Flag     :flag: : :,
    4263 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELC14 :Delta-C14              :delc14 :0/00:f9.1:,
    4264 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELC14_FLAG:Delta-C14 Flag     :flag: : :,
    4265 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELC13 :Delta-C13              :delc13 :0/00:f9.1:,
    4266 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # DELC13_FLAG:Delta-C13 Flag     :flag: : :,
    4267 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # O18O16 :O18/O16 Ratio          :o18o16 :0/00:f9.2:,
    4268 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # O18O16_FLAG:O18/O16 Ratio Flag :flag: : :,
    4269 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TCARBN :Total Carbon           :tcarbn :umol/kg:f9.1:,
    4270 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # TCARBN_FLAG:Total Carbon Flag  :flag: : :,
    4271 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ALKALI :Alkalinity             :alk:umol/kg:f9.1:,
    4272 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ALKALI_FLAG:Alkalinity Flag    :flag: : :,
    4281 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PCO2 :Partial Pressure of CO2  :pco2 :uatm :f9.1:,
    4282 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PCO2_FLAG:PCO2 Flag            :flag: : :,
    4283 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PH :pH                         :pH : :f9.2:,
    4284 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # PH_FLAG:pH Flag                :flag: : :,
    4291 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ARGOPRS_FLAG :Argo Pressure Flag    :flag: : :,
    4292 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ARGOTMP_FLAG :Argo Temperature Flag :flag: : :,
    4293 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # ARGOSAL_FLAG :Argo Salinity Flag    :flag: : :,
    4301 : dict(standard_name='mole_fraction_of_carbon_dioxide_in_air', long_name='Mole Fraction of CO2 in Air', units='ppm', convert=lambda x: x, cf_units='ppm', cell_methods=None),  # XCO2a:Mole Fraction of CO2 in Air:XCO2:ppm:f9.1:Underway CO2 obs,
    4302 : dict(standard_name='mole_fraction_of_carbon_dioxide_in_sea_water', long_name='Mole Fraction of CO2 in Sea Water', units='ppm', convert=lambda x: x, cf_units='ppm', cell_methods=None),  # XCO2w:Mole Fraction of CO2 in Water:XCO2:ppm:f9.1:Underway CO2 obs,  # LOOK: this doesn't really exist, but most likely should
    4303 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # fCO2a:Fugacity of CO2 in Air:fCO2a:uatm:f9.1:Underway CO2 obs,
    4304 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # fCO2w:Fugacity of CO2 in Water:fCO2w:uatm:f9.1:Underway CO2 obs,
    4305 : dict(standard_name='surface_partial_pressure_of_carbon_dioxide_in_air', long_name='Partial Pressure of CO2 in Air', units='µatm', convert=lambda x: x, cf_units='µatm', cell_methods=None),  # pCO2a:Partial Pressure of CO2 in Air:pCO2a:uatm:f9.1:Underway CO2 obs,
    4306 : dict(standard_name='surface_partial_pressure_of_carbon_dioxide_in_air', long_name='Partial Pressure of CO2 in Water', units='µatm', convert=lambda x: x, cf_units='µatm', cell_methods=None),  # pCO2w:Partial Pressure of CO2 in Water:pCO2w:uatm:f9.1:Underway CO2 obs,
    4307 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # dfCO2:Delta fCO2:dfCO2:uatm:f9.1:Underway CO2 obs,
    4308 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # dpCO2:Delta pCO2:dpCO2:uatm:f9.1:Underway CO2 obs,
    4309 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # EqT:Equilibrator Temperature:degC:f9.3:Underway CO2 obs (ITS-90),
    4311 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # FiltXCO2a:Filtered Mole Fraction of CO2 in Air:XCO2:ppm:f9.1:Underway CO2 obs,
    4312 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # FiltXCO2w:Filtered Mole Fraction of CO2 in Water:XCO2:ppm:f9.1:Underway CO2 obs,
    5000 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # flow:Average Daily River Discharge:flow:m3 s-1:f10.2:,
    9991 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # x:x axis:x: : :x axis,
    9992 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # y:y axis:y: : :y axis,
    9993 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None),  # z:z axis:z: : :z axis,
    9994 : dict(standard_name=None, long_name=None, units=None, convert=lambda x: x, cf_units=None, cell_methods=None)   # t:t axis:t: : :t axis,
}
