import logging
import os
from jinja2 import Environment, FileSystemLoader


def make_templates_path(root):
    return root + os.sep + 'templates'


template_path = [make_templates_path(os.path.dirname(__file__))]  # the system templates
env = Environment(loader=FileSystemLoader(template_path))


def tenv():
    return env


def make_templates_from_plugin_path(plugin_path):
    return make_templates_path(os.sep.join(plugin_path.split(os.sep)[:-1]))


def add_plugin_templates_path(path):
    global env
    tmpl_path = make_templates_from_plugin_path(path)
    if os.path.exists(tmpl_path):
        logging.debug("Templates directory found for this plugin [%s]" % tmpl_path)
        template_path.append(tmpl_path)
        env = Environment(loader=FileSystemLoader(template_path))  # ditch and recreate a new templating environment
        return
    logging.debug("No templates directory found for this plugin [Looking for %s]" % tmpl_path)


def remove_plugin_templates_path(path):
    global env
    tmpl_path = make_templates_from_plugin_path(path)
    if tmpl_path in template_path:
        template_path.pop(template_path.index(tmpl_path))
        env = Environment(loader=FileSystemLoader(template_path))  # ditch and recreate a new templating environment