/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.osalau.OsalauSona;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SonaMall {
    private List<OsalauSona.MARGEND> vajalikudMargendid = null;
    private List<Pattern> tekstikujuKirjeldused = null;

    public SonaMall() {
    }

    public SonaMall(OsalauSona.MARGEND vajalikMargend) {
        this.lisaVajalikMargend(vajalikMargend);
    }

    public SonaMall(Pattern tekstikujuKirjeldus) {
        this.lisaTeksikujuKirjeldus(tekstikujuKirjeldus);
    }

    public boolean vastabMallileAND(OsalauSona sona) throws Exception {
        if (this.vajalikudMargendid != null) {
            for (OsalauSona.MARGEND margend : this.vajalikudMargendid) {
                if (sona.omabMargendit(margend)) continue;
                return false;
            }
        }
        if (this.tekstikujuKirjeldused != null) {
            String tekstikuju = sona.getNormAlgSona();
            if (tekstikuju != null) {
                for (Pattern regexp : this.tekstikujuKirjeldused) {
                    if (regexp.matcher(tekstikuju).matches()) continue;
                    return false;
                }
            } else {
                throw new Exception(" Text form not found for word " + String.valueOf(sona));
            }
        }
        return true;
    }

    public boolean vastabMallileOR(OsalauSona sona) throws Exception {
        if (this.vajalikudMargendid != null) {
            for (OsalauSona.MARGEND margend : this.vajalikudMargendid) {
                if (!sona.omabMargendit(margend)) continue;
                return true;
            }
        }
        if (this.tekstikujuKirjeldused != null) {
            String tekstikuju = sona.getNormAlgSona();
            if (tekstikuju != null) {
                for (Pattern regexp : this.tekstikujuKirjeldused) {
                    if (!regexp.matcher(tekstikuju).matches()) continue;
                    return true;
                }
            } else {
                throw new Exception(" Text form not found for word " + String.valueOf(sona));
            }
        }
        return false;
    }

    public void lisaVajalikMargend(OsalauSona.MARGEND margend) {
        if (this.vajalikudMargendid == null) {
            this.vajalikudMargendid = new ArrayList<OsalauSona.MARGEND>(2);
        }
        this.vajalikudMargendid.add(margend);
    }

    public void lisaTeksikujuKirjeldus(Pattern regexp) {
        if (this.tekstikujuKirjeldused == null) {
            this.tekstikujuKirjeldused = new ArrayList<Pattern>(2);
        }
        this.tekstikujuKirjeldused.add(regexp);
    }
}

