/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.mudel;

import java.util.List;
import java.util.StringTokenizer;

public class MorfAnRida {
    private String lemma;
    private String lopp;
    private String sonaliik;
    private String vormiNimetused;
    private String normaliseeritudLemma;
    private String lemmaIlmaVahemarkideta;
    private static final String[][] SONALIIK = new String[][]{{"_A_", "omaduss\u00f5na - algv\u00f5rre, nii k\u00e4\u00e4nduvad kui k\u00e4\u00e4ndumatud"}, {"_C_", "omaduss\u00f5na - keskv\u00f5rre (adjektiiv - komparatiiv)"}, {"_D_", "m\u00e4\u00e4rs\u00f5na (adverb), nt k\u00f5rvuti"}, {"_G_", "genitiivatribuut (k\u00e4\u00e4ndumatu omaduss\u00f5na)"}, {"_H_", "p\u00e4risnimi"}, {"_I_", "h\u00fc\u00fcds\u00f5na (interjektsioon), nt tere"}, {"_J_", "sides\u00f5na (konjunktsioon)"}, {"_K_", "kaass\u00f5na (pre/postpositsioon), nt kaudu"}, {"_N_", "p\u00f5hiarvs\u00f5na (kardinaalnumeraal), nt kaks"}, {"_O_", "j\u00e4rgarvs\u00f5na (ordinaalnumeraal), nt teine"}, {"_P_", "ases\u00f5na (pronoomen), nt see"}, {"_S_", "nimis\u00f5na (substantiiv), nt asi"}, {"_U_", "omaduss\u00f5na - \u00fcliv\u00f5rre (adjektiiv - superlatiiv), nt pikim"}, {"_V_", "tegus\u00f5na (verb), nt lugema"}, {"_X_", "verbi juurde kuuluv s\u00f5na, eraldi s\u00f5naliigi t\u00e4histus puudub, nt plehku"}, {"_Y_", "l\u00fchend, nt USA"}, {"_Z_", "lausem\u00e4rk"}};
    private static final String[][] NOMKAT_VORMINIMETUS = new String[][]{{"ab", "abessiiv - ilmayltev"}, {"abl", "ablatiiv - alaltytlev"}, {"ad", "adessiiv - alalytlev"}, {"adt", "aditiiv - suunduv (lyhike sisseytlev)"}, {"all", "allatiiv - alaleytlev"}, {"el", "elatiiv - seestytlev"}, {"es", "essiiv - olev"}, {"g", "genitiiv - omastav"}, {"ill", "illatiiv - sisseytlev"}, {"in", "inessiiv - seesytlev"}, {"kom", "komitatiiv - kaasaytlev"}, {"n", "nominatiiv - nimetav"}, {"p", "partitiiv - osastav"}, {"pl", "pluural - mitmus"}, {"sg", "singulaar - ainusus"}, {"ter", "terminatiiv - rajav"}, {"tr", "translatiiv - saav"}};

    public MorfAnRida(String analyysiRida) {
        this.eraldaReastElemendid(analyysiRida);
        this.normaliseeriLemmaNingLeiaVahemarkidetaKuju();
    }

    public MorfAnRida(List<String> keyValuePairs) throws Exception {
        if (keyValuePairs.size() % 2 != 0) {
            throw new Exception(" Unexpected size of input key-value pairs - should be even-size list: " + keyValuePairs.toString());
        }
        for (int i = 0; i < keyValuePairs.size(); i += 2) {
            String attribName = keyValuePairs.get(i);
            String attribValue = keyValuePairs.get(i + 1);
            if (attribName.equalsIgnoreCase("root")) {
                this.lemma = attribValue;
            }
            if (attribName.equalsIgnoreCase("ending")) {
                this.lopp = attribValue;
            }
            if (attribName.equalsIgnoreCase("form")) {
                this.vormiNimetused = attribValue;
            }
            if (!attribName.equalsIgnoreCase("partofspeech")) continue;
            this.sonaliik = "_" + attribValue + "_";
        }
        this.normaliseeriLemmaNingLeiaVahemarkidetaKuju();
    }

    private void eraldaReastElemendid(String analyysiRida) {
        int esimeneKaldkriips = MorfAnRida.leiaEsimeseKaldkriipsuIndex(analyysiRida);
        if (analyysiRida.lastIndexOf("+") > -1) {
            this.lemma = analyysiRida.substring(0, analyysiRida.lastIndexOf("+"));
            this.lopp = analyysiRida.substring(analyysiRida.lastIndexOf("+") + 1, esimeneKaldkriips - 1);
        } else {
            this.lemma = analyysiRida.substring(0, esimeneKaldkriips - 1);
            this.lopp = "0";
        }
        int viimaneAlaJoon = analyysiRida.lastIndexOf("_");
        int viimaneKaldkriips = analyysiRida.lastIndexOf("/");
        this.sonaliik = analyysiRida.substring(viimaneAlaJoon - 2, viimaneAlaJoon + 1);
        this.vormiNimetused = viimaneKaldkriips - 2 - (viimaneAlaJoon + 2) > 0 ? analyysiRida.substring(viimaneAlaJoon + 2, viimaneKaldkriips - 2) : "";
    }

    private static int leiaEsimeseKaldkriipsuIndex(String analyysiRida) {
        int i;
        int symboleidSeni = 0;
        for (i = analyysiRida.length() - 1; i > -1; --i) {
            if (analyysiRida.charAt(i) == '/') {
                ++symboleidSeni;
            }
            if (symboleidSeni == 4) break;
        }
        return i;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void normaliseeriLemmaNingLeiaVahemarkidetaKuju() {
        if (this.lemma != null) {
            this.normaliseeritudLemma = new String(this.lemma);
            StringTokenizer st = new StringTokenizer(this.normaliseeritudLemma, "=+_");
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreElements()) {
                sb.append((String)st.nextElement());
            }
            this.lemmaIlmaVahemarkideta = sb.toString();
        }
    }

    public String getLemmaIlmaVahemarkideta() {
        return this.lemmaIlmaVahemarkideta;
    }

    public String getSonaLiikPikalt() {
        String liikPikalt = "";
        for (String[] sonaliik : SONALIIK) {
            if (!sonaliik[0].equals(this.sonaliik)) continue;
            liikPikalt = sonaliik[1];
        }
        return liikPikalt;
    }

    public String getLopp() {
        return this.lopp;
    }

    public String getSonaliik() {
        return this.sonaliik;
    }

    public boolean isVerb() {
        return this.sonaliik.equals("_V_");
    }

    public String getVormiNimetused() {
        return this.vormiNimetused;
    }

    public String getVormiNimetusedPikalt(String taane) {
        StringBuilder vormiNim = new StringBuilder();
        if (this.vormiNimetused.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.vormiNimetused, ",");
            while (tokenizer.hasMoreElements()) {
                String sone = (String)tokenizer.nextElement();
                if (this.isVerb()) {
                    vormiNim.append(taane);
                    vormiNim.append(sone);
                    vormiNim.append("\n");
                    continue;
                }
                StringTokenizer tokenizer2 = new StringTokenizer(sone, " ");
                while (tokenizer2.hasMoreElements()) {
                    String sone2 = (String)tokenizer2.nextElement();
                    for (String[] nomKatVormiNim : NOMKAT_VORMINIMETUS) {
                        if (!nomKatVormiNim[0].equals(sone2)) continue;
                        vormiNim.append(taane);
                        vormiNim.append(nomKatVormiNim[1]);
                        vormiNim.append(" (");
                        vormiNim.append(nomKatVormiNim[0]);
                        vormiNim.append(")");
                        vormiNim.append("\n");
                    }
                }
            }
        }
        return vormiNim.toString();
    }

    public boolean leiaKasMorfTunnusEsineb(String morfTunnus) {
        if (morfTunnus.startsWith("^")) {
            return !this.leiaKasMorfTunnusEsineb(morfTunnus.replaceAll("\\^", ""));
        }
        if (morfTunnus.startsWith("_")) {
            if (this.sonaliik != null) {
                return this.sonaliik.equals(morfTunnus);
            }
            return false;
        }
        if (this.vormiNimetused != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.vormiNimetused, ",");
            while (tokenizer.hasMoreElements()) {
                String[] vormiTunnused;
                String vormiTunnusedKoond = (String)tokenizer.nextElement();
                for (String tunnus : vormiTunnused = vormiTunnusedKoond.split("(\\s+)")) {
                    if (!tunnus.equals(morfTunnus)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.lemma);
        str.append("+");
        str.append(this.lopp);
        str.append(" ");
        str.append(this.sonaliik);
        str.append(" ");
        str.append(this.vormiNimetused);
        return str.toString();
    }
}

